<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   hvp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '動作';
$string['addedandupdatelibraries'] = '已加入{$a->%new} 個新的H5P元件，並更新{$a->%old} 個舊元件。';
$string['addednewlibraries'] = '已加入{$a->%new} 個新的H5P元件';
$string['addlibraries'] = '新增元件';
$string['ajaxfailed'] = '無法載入資料.';
$string['attribution'] = '姓名標示 4.0';
$string['attributionnc'] = '姓名標示-非商業使用 4.0';
$string['attributionncnd'] = '姓名標示-非商業使用-禁止改作 4.0';
$string['attributionncsa'] = '姓名標示-非商業使用-相同方式分享 4.0';
$string['attributionnd'] = '姓名標示-禁止改作 4.0';
$string['attributionsa'] = '姓名標示-相同方式分享 4.0';
$string['author'] = '作者';
$string['cancellabel'] = '取消';
$string['close'] = '關閉';
$string['confirmdialogbody'] = '請確認您要繼續. 此操作不可回復.';
$string['confirmdialogheader'] = '確認動作';
$string['confirmlabel'] = '確認';
$string['contentchanged'] = '此內容自從您上次使用後已被更新.';
$string['contentstatefrequency'] = '儲存內容狀態的頻率';
$string['contentstatefrequency_help'] = '在幾秒內, 您希望使用者自動儲存他們的進度. 如果您需要更多的請求數量, 可以增加這個數目';
$string['copyright'] = '使用權';
$string['copyrightinfo'] = '版權資訊';
$string['copyrightstring'] = '版權';
$string['copyrighttitle'] = '查看此內容的版權資訊.';
$string['couldnotcopy'] = '無法複製檔案.';
$string['couldnotsave'] = '無法存入檔案.';
$string['create'] = '建立';
$string['currentpage'] = '目前第 $current 頁, 共 $total頁';
$string['disablefileextensioncheck'] = '不檢查檔案副檔名';
$string['disablefileextensioncheckwarning'] = '警告！ 停用檔案副檔名檢查可能有安全上的問題, 因為它允許上傳php檔案. 這可能使攻擊者在您的網站上執行惡意程式碼. 請確定您確切地知道您正要上傳的內容.';
$string['disablefullscreen'] = '停用全螢幕';
$string['displayoptionalwaysshow'] = '總是顯示';
$string['displayoptionauthoroff'] = '由作者控制,預設是關閉(off)';
$string['displayoptionauthoron'] = '由作者控制,預設是開啟(on)';
$string['displayoptionnevershow'] = '不顯示';
$string['displayoptionpermissions'] = '僅當用戶具有匯出H5P的權限時才顯示';
$string['displayoptions'] = '顯示的選項';
$string['download'] = '下載';
$string['downloadtitle'] = '下載內容為H5P的檔案';
$string['editor'] = '編輯器';
$string['embed'] = '嵌入';
$string['embedtitle'] = '查看此內容的嵌入代碼.';
$string['empty'] = '查無結果';
$string['enableabout'] = '關於H5P的按鈕';
$string['enablecopyright'] = '版權的按鈕';
$string['enabledlrscontenttypes'] = '啟用LRS依賴的內容類型';
$string['enabledlrscontenttypes_help'] = '適當地使用依賴於學習記錄存儲的內容類型功能, 例如調查問卷的內容類型.';
$string['enabledownload'] = '下載的按鈕';
$string['enableembed'] = '嵌入的按鈕';
$string['enableframe'] = '顯示功能列和頁框';
$string['enablejavascript'] = '請啟用JavaScript.';
$string['enablesavecontentstate'] = '儲存內容狀態';
$string['enablesavecontentstate_help'] = '自動儲存每個使用者互動內容的當前狀態. 這表示使用者可以在他離線後仍可以存取.';
$string['filenotimage'] = '檔案不是一個圖檔.';
$string['filetypenotallowed'] = '檔案類型不允許.';
$string['finished'] = '完成';
$string['fullscreen'] = '全螢幕';
$string['gpl'] = '一般的公共授權v3';
$string['h5pfile'] = 'H5P的檔案';
$string['h5ptitle'] = '訪問H5P.org以查看更酷的內容.';
$string['hideadvanced'] = '隱藏進階功能';
$string['hvp:addinstance'] = '新增新的H5P活動';
$string['hvp:getcachedassets'] = '取得暫存的H5P內容資產';
$string['hvp:getcontent'] = '在課程中取得/查看H5P檔案內容';
$string['hvp:getexport'] = '在課程中從H5P取得匯出的檔案';
$string['hvp:restrictlibraries'] = '限制H5P程式庫';
$string['hvp:savecontentuserdata'] = '保存H5P內容使用者資料';
$string['hvp:saveresults'] = '儲存H5P內容結果';
$string['hvp:updatelibraries'] = '更新H5P元件的版本';
$string['hvp:userestrictedlibraries'] = '使用限制的H5P元件';
$string['hvp:viewresults'] = '查看H5P內容結果';
$string['installedlibraries'] = '已安裝的元件';
$string['intro'] = '簡介';
$string['invalidaudioformat'] = '無效的音訊檔案格式. 請使用mp3或wav.';
$string['invalidcontentfolder'] = '無效的內容資料夾';
$string['invalidfieldtype'] = '無效的欄位類型.';
$string['invalidfile'] = '不允許的檔案 "{$a->%filename}". 僅允許具有以下副檔名的檔案: {$a->%files-allowed}.';
$string['invalidimageformat'] = '無效的圖片檔案格式.請使用jpg, png或gif.';
$string['invalidlanguagefile'] = '無效的語系檔{$a->%file} 在元件 {$a->%library}中';
$string['invalidlanguagefile2'] = '無效的語系檔{$a->%languageFile}已被包括在{$a->%name}元件中';
$string['invalidlibrary'] = '無效的元件';
$string['invalidlibrarydata'] = '從 {$a->%property}提供的無效資料, 在{$a->%library}';
$string['invalidlibrarydataboolean'] = '從{$a->%property}提供的無效資料, 在 {$a->%library}. 它應該是布林值.';
$string['invalidlibraryname'] = '無效的元件名稱: {$a->%name}';
$string['invalidlibraryoption'] = '{$a->%option}中的不合法選項{$a->%library}';
$string['invalidlibraryproperty'] = '從 {$a->%property}無法讀取它的屬性,  在{$a->%library}';
$string['invalidmainjson'] = '主要的h5p.json有效檔案遺失';
$string['invalidmultiselectoption'] = '多重選擇中選定的選項無效';
$string['invalidparameters'] = '無效參數';
$string['invalidselectoption'] = '選定的選項無效.';
$string['invalidsemanticsjson'] = '無效的semantics.json檔案已包含在元件中{$a->%name}';
$string['invalidsemanticstype'] = 'H5P內部錯誤：在語義中有未知的內容類型“{$ a - > @ type}”. 請刪除內容!';
$string['invalidstring'] = '根據規則表示式(regexp)，所提供的字串不是有效的. (值: "{$a->%value}", 規則表示式: "{$a->%regexp}")';
$string['invalidtoken'] = '無效的安全權杖.';
$string['invalidvideoformat'] = '無效的影片檔案格式. 請使用mp4或webm.';
$string['javascriptloading'] = '等待JavaScript...';
$string['libraries'] = 'H5P元件';
$string['librarydirectoryerror'] = '元件目錄名稱必須與機器名稱或機器名稱-主要版本.次版版相符合(從 library.json). (目錄: {$a->%directoryName} , 機器名稱: {$a->%machineName}, 主要版本: {$a->%majorVersion}, 次版本: {$a->%minorVersion})';
$string['librarylistactions'] = '動作';
$string['librarylistinstancedependencies'] = '實例附屬檔';
$string['librarylistinstances'] = '實例';
$string['librarylistlibrarydependencies'] = '元件相依性';
$string['librarylistrestricted'] = '限制';
$string['librarylisttitle'] = '標題';
$string['license'] = '授權';
$string['loadingdata'] = '載入資料中.';
$string['lookforupdates'] = '尋找 H5P 的更新';
$string['maximumgrade'] = '最高等級';
$string['maximumgradeerror'] = '請輸入有效的正整數作為此活動可用的最大點數';
$string['maxscore'] = '最高分';
$string['missingcontentfolder'] = '有效的內容資料夾遺失';
$string['missingcontentuserdata'] = '錯誤：找不到使用者資料內容';
$string['missingcoreversion'] = '系統不能安裝 <em>{$a->%component}</em> 元件, 它需要一個較新版本的H5P外掛. 這個網站目前執行的版本 {$a->%current},它需要的版本是 {$a->%required} 或更高. 您應該考慮升級, 然後重試.';
$string['missingdependency'] = '遺失相關的 {$a->@dep}, 是{$a->@lib}所需要的.';
$string['missinglibrary'] = '遺失必要的元件{$a->@library}';
$string['missinglibraryfile'] = '檔案 "{$a->%file}" 從 "{$a->%name}" 元件中遺失';
$string['missinglibraryjson'] = '從 {$a->%name} 元件中找不到library.json或有效的json格式檔';
$string['missinglibraryproperty'] = '要求的屬性{$a->%property} 從 {$a->%library}遺失';
$string['missingparameters'] = '參數遺失';
$string['missinguploadpermissions'] = '請注意,元件可能存在於您上傳的檔案中, 但您無法上傳新的元件. 請聯繫您的網站管理員.';
$string['modulename'] = 'H5P互動內容';
$string['modulename_help'] = 'H5P活動模組讓您可以建立互動內容, 例如互動式的影片, 試題集, 拖拉放試題, 多重選擇題, 簡報...等等.

除了是豐富內容的創作工具之外,H5P還允許您匯入及匯出H5P文件,以便有效地重複使用和共享內容。

使用者互動和分數是可以使用xAPI進行追蹤,並能透過Moodle成績簿取得.

你可以透過上傳.h5p檔案來增加互動的H5P內容. 您可以在h5p.org上建立和下載.h5p檔案.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'H5P互動內容';
$string['nextpage'] = '下一頁';
$string['nocontent'] = '無法找到或解析content.json檔案';
$string['nocopyright'] = '此內容沒有版權資訊.';
$string['nodata'] = '沒有符合您查詢條件的資料.';
$string['noextension'] = '您上傳的檔案不是有效的HTML5檔（它沒有.h5p檔案的副檔名）';
$string['noh5ps'] = '本課程沒有可用的互動內容.';
$string['nojson'] = '主要的h5p.json檔案無效';
$string['noparameters'] = '無參數';
$string['noparse'] = '無法解析主要的h5p.json檔案';
$string['nopermissiontorestrict'] = '您沒有權限使用限制的元件';
$string['nopermissiontosavecontentuserdata'] = '您沒有儲存內容使用者資料的權限.';
$string['nopermissiontosaveresult'] = '您沒有儲存此內容結果的權限.';
$string['nopermissiontoupgrade'] = '您沒有權限更新元件';
$string['nopermissiontoviewresult'] = '您沒有查看此內容結果的權限.';
$string['nosuchlibrary'] = '查無此元件';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = '您上傳的檔案不是有效的HTML5檔（我們無法解壓縮）';
$string['noziparchive'] = '您的PHP版本不支援Zip壓縮';
$string['onlyupdate'] = '只更新存在的元件';
$string['options'] = '選項';
$string['pd'] = '公共領域';
$string['pddl'] = '公共網域貢獻和授權';
$string['pdm'] = '公共領域標示';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['previouspage'] = '上一頁';
$string['removeoldlogentries'] = '刪除舊的H5P日誌';
$string['removetmpfiles'] = '刪除舊的H5P暫存檔';
$string['resizescript'] = '如果要動態調整嵌入內容的大小, 請在您的網站上包含此腳本:';
$string['score'] = '分數';
$string['search'] = '搜尋';
$string['settings'] = 'H5P設定';
$string['showadvanced'] = '顯示進階功能';
$string['size'] = '大小';
$string['source'] = '來源';
$string['startingover'] = '您即將開始.';
$string['thumbnail'] = '縮圖';
$string['title'] = '標題';
$string['unabletocreatedir'] = '無法建立目錄.';
$string['unabletogetfieldtype'] = '無法取得欄位類型.';
$string['undisclosed'] = '未揭露';
$string['updatedlibraries'] = '更新了{$a->%old} 個H5P元件。';
$string['updatelibraries'] = '更新所有元件';
$string['upgrade'] = '升級H5P';
$string['upgradebuttonlabel'] = '升級';
$string['upgradedone'] = '您已成功升級{$a}內容實例.';
$string['upgradeerror'] = '處理參數時出錯:';
$string['upgradeerrorcontent'] = '無法升級內容%id:';
$string['upgradeerrordata'] = '無法載入元件的資料%lib.';
$string['upgradeerrorparamsbroken'] = '參數損毀.';
$string['upgradeerrorscript'] = '無法載入升級腳本%lib.';
$string['upgradeheading'] = '升級{$a}內容';
$string['upgradeinprogress'] = '升級到%ver...';
$string['upgradeinvalidtoken'] = '錯誤: 無效的安全權杖!';
$string['upgradelibrarycontent'] = '升級元件內容';
$string['upgradelibrarymissing'] = '錯誤：您的元件已遺失!';
$string['upgrademessage'] = '您即將升級{$a}內容實例. 請選擇升級版本.';
$string['upgradenoavailableupgrades'] = '本元件沒有可用的升級.';
$string['upgradenothingtodo'] = '沒有要升級的內容實例.';
$string['upgradereturn'] = '返回';
$string['upload'] = '上傳';
$string['uploadlibraries'] = '上傳元件';
$string['user'] = '用戶';
$string['welcomecommunity'] = '我們希望您喜歡H5P, 並通過我們的<a {$a->forums}>論壇</a>和聊天室<a {$a->gitter}> Gitter的H5P </a>參與我們不斷壯大的社群';
$string['welcomecontactus'] = '如果您有任何意見, 請不要猶豫<a {$a }>與我們聯絡</a>. 我們非常重視您的意見, 每天都致力於使H5P更好!';
$string['welcomegettingstarted'] = '要開始使用H5P和Moodle前, 請先參閱我們的<a {$a->moodle_tutorial}>課程</a>, 並查看在H5P.org上的<a {$a->example_content}>範例內容</a>以便找尋靈感. <br>為了您的方便, 已安裝了大多數一般的內容類型!';
$string['welcomeheader'] = '歡迎來到H5P的世界!';
$string['year'] = '年';
$string['years'] = '年';
