<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   qtype_musictheory
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'A♭大調';
$string['abminor'] = 'A♭小調';
$string['alto'] = '中音';
$string['altoclef'] = '中音譜號';
$string['anmajor'] = 'A 大調';
$string['anminor'] = 'A 小調';
$string['answerlbl'] = '答案';
$string['asharpminor'] = 'A♯ 小調';
$string['aug10'] = '增10度';
$string['aug11'] = '增11度';
$string['aug12'] = '增12度';
$string['aug13'] = '增13度';
$string['aug2'] = '增2度';
$string['aug3'] = '增3度';
$string['aug4'] = '增4度';
$string['aug5'] = '增5度';
$string['aug6'] = '增6度';
$string['aug6thfr'] = '法式增6度';
$string['aug6thgr'] = '德式增6度';
$string['aug6thit'] = '意式增6度';
$string['aug7'] = '增7度';
$string['aug8'] = '增8度';
$string['aug9'] = '增9度';
$string['augmented'] = '增';
$string['bass'] = '低音';
$string['bassclef'] = '低音譜號';
$string['bbmajor'] = 'B♭大調';
$string['bbminor'] = 'B♭小調';
$string['bnmajor'] = 'B大調';
$string['bnminor'] = 'B小調';
$string['cbmajor'] = 'C♭ 大調';
$string['chordquality'] = '和弦記號';
$string['chordquality-random'] = '可能的和弦記號';
$string['chordquality_write_questionastext'] = '輸入和弦記號的答案';
$string['chordquality_write_questionastext_help'] = '<p>在音符列表中以逗點來分隔音符，不要有空白，使用下列語法:</p><p>[大寫的音名][升降記號
  ("n" = 無升降, "#" = 升, "b" = 降, "x" = 重複升, "bb" = 重複降)]4, ... </p>
 <p>隨意舉例: <b>答案=>Cn4,En4,G#4</b></p>';
$string['chordquality_write_questionasui_help'] = '<p>先在右手邊選擇臨時記號，然後透過在五線譜上點選的方式來輸入音符。若要刪除音符時，再點選一次即可。</p>';
$string['chordroot'] = '和弦根音';
$string['clef'] = '五線譜';
$string['clef-random'] = '可能的五線譜';
$string['cnmajor'] = 'C大調';
$string['cnminor'] = 'C小調';
$string['considerregister'] = '包含音域';
$string['considerregister_help'] = '指定是否要包含音符的音域作為試題的一部份';
$string['correctansweris'] = '正確答案是：';
$string['correctansweris_morethanone'] = '另一可能正確答案是：';
$string['csharpmajor'] = 'C♯大調';
$string['csharpminor'] = 'C♯小調';
$string['dbmajor'] = 'D♭大調';
$string['dim10'] = '減10度';
$string['dim11'] = '減11度';
$string['dim12'] = '減12度';
$string['dim13'] = '減13度';
$string['dim2'] = '減2度';
$string['dim3'] = '減3度';
$string['dim4'] = '減4度';
$string['dim5'] = '減5度';
$string['dim6'] = '減6度';
$string['dim7'] = '減7度';
$string['dim8'] = '減8度';
$string['dim9'] = '減';
$string['diminished'] = '減';
$string['dirasc'] = '由指定的音往上走';
$string['dirdesc'] = '由指定的音往下走';
$string['direction'] = '方向';
$string['displaykeysignature'] = '顯示調號';
$string['dnmajor'] = 'D大調';
$string['dnminor'] = 'D小調';
$string['dsharpminor'] = 'D♯小調';
$string['ebmajor'] = 'E♭ 大調';
$string['ebminor'] = 'E♭ 小調';
$string['emptykeysignature'] = '空白調號';
$string['enmajor'] = '大調';
$string['enminor'] = 'E小調';
$string['fnmajor'] = 'F大調';
$string['fnminor'] = 'F小調';
$string['fsharpmajor'] = 'F♯大調';
$string['fsharpminor'] = 'F♯ 小調';
$string['gbmajor'] = 'G♭大調';
$string['givennoteelementgroup'] = '指定音';
$string['gnmajor'] = 'G大調';
$string['gnminor'] = 'G小調';
$string['grandstaff'] = '鋼琴譜號';
$string['hftype_seclttriad'] = '第二導音(三和弦)';
$string['includealterations_help'] = '指明這試題是否要包含臨時記號';
$string['includestaticnote'] = '包含給定的音符';
$string['interval_write_questionastext'] = '輸入音程答案';
$string['interval_write_questionasui'] = '輸入音程答案';
$string['keyboard_input_questionasui'] = '輸入鍵盤輸入的答案';
$string['keyboard_input_questionasui_help'] = '在鍵盤上點選可以輸入音符，若要刪除音符，再點選一次即可';
$string['keysignature_write_questionastext'] = '輸入調號答案';
$string['keysignature_write_questionasui'] = '輸入調號答案';
$string['keysignature_write_questionasui_help'] = '<p>先在右手邊選擇臨時記號，然後透過在五線譜上點選來輸入音符。要刪除音符時，再點選一次即可。</p>';
$string['lbl_harmonicfunction'] = '和聲功能';
$string['maj10'] = '大10度';
$string['maj13'] = '大13度';
$string['maj2'] = '大2度';
$string['maj3'] = '大3度';
$string['maj6'] = '大6度';
$string['maj7'] = '大7度';
$string['maj9'] = '大9度';
$string['major'] = '大調';
$string['min10'] = '小10度';
$string['min13'] = '小13度';
$string['min2'] = '小2度';
$string['min3'] = '小3度';
$string['min6'] = '小6度';
$string['min7'] = '小7度';
$string['min9'] = '小9度';
$string['minor'] = '小調';
$string['mode-random'] = '可能的模式';
$string['musicqtype'] = '樂理試題類型';
$string['musictheory_gradingstrategy'] = '計分方式';
$string['musictheory_gradingstrategy_help'] = '<p>此計分辦法是用來指定此試題如何計分。</p>
 <p><b>全對或全錯</b>:學生瘩答案將與正確答案相比對，若答對，則給全額的配分，若答錯，則給0分。</p>
 <p><b>每一正確音符給部分分數</b>:
 此辦法是將該題配分依照正確答案的音符數平均劃分，算出每一音符可得分數，然後再核對答案，依據答對音符數量給予分數。</p>';
$string['musictheory_gradingstrategy_scale-write'] = '計分方式';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>此計分辦法是用來指定此試題如何計分。</p>
 <p><b>全對或全錯</b>:學生瘩答案將與正確答案相比對，若答對，則給全額的配分，若答錯，則給0分。</p>
 <p><b>每一正確音符給部分分數</b>:
 此辦法是將該題配分依照正確答案的音符數平均劃分，算出每一音符可得分數，然後再核對答案，依據答對音符數量給予分數。</p>';
$string['musictheory_intervalelementgroup'] = '音程';
$string['musictheory_intervalelementgroup_help'] = '辨識音程類型';
$string['musictheory_intervalelementgroup_random'] = '可能的音程';
$string['nosectonic'] = '[無第二主音]';
$string['notea'] = 'A';
$string['noteb'] = 'B';
$string['notec'] = 'C';
$string['noted'] = 'D';
$string['notee'] = 'E';
$string['notef'] = 'F';
$string['noteg'] = 'G';
$string['notelbl'] = '音符';
$string['note_write_questionastext'] = '輸入音符答案';
$string['note_write_questionasui'] = '輸入音符答案';
$string['note_write_questionasui_help'] = '<p>先在右手邊選擇臨時記號，然後透過在五線譜上點選來輸入音符。要刪除音符時，再點選一次即可。</p>';
$string['per11'] = '完全11度';
$string['per12'] = '完全12度';
$string['per4'] = '完全4度';
$string['per5'] = '完全5度';
$string['per8'] = '完全8度';
$string['perfect'] = '完全';
$string['pluginname'] = '樂理';
$string['pluginnameadding'] = '新增樂理試題';
$string['pluginnameediting'] = '編輯樂理試題';
$string['pluginname_help'] = '這一題型可讓教師使用圖形介面來建立測驗視譜能力的試題';
$string['pluginnamesummary'] = '可以建立數種可測量音樂領域視譜能力的題型';
$string['possiblescalesinresponse'] = '在答案中可能的音階類型';
$string['qtype_chordquality-identify'] = '辨識和弦記號';
$string['qtype_chordquality-identify-random'] = '辨識和弦記號(隨機)';
$string['qtype_chordquality-write'] = '書寫和弦記號';
$string['qtype_chordquality-write-random'] = '書寫和弦記號(隨機)';
$string['qtype_harmonicfunction-identify'] = '辨識和聲功能';
$string['qtype_harmonicfunction-identify-random'] = '辨識和聲功能(隨機)';
$string['qtype_harmonicfunction-write'] = '書寫和聲功能';
$string['qtype_harmonicfunction-write-random'] = '書寫和聲功能(隨機)';
$string['qtype_interval-identify'] = '辨識音程';
$string['qtype_interval-identify-random'] = '辨識音程(隨機)';
$string['qtype_interval-write'] = '寫出音程';
$string['qtype_interval-write-random'] = '寫出音程(隨機)';
$string['qtype_keyboard-input'] = '鍵盤輸入';
$string['qtype_keysignature-identify'] = '辨識調號';
$string['qtype_keysignature-identify-random'] = '辨識調號(隨機)';
$string['qtype_keysignature-write'] = '寫出調號';
$string['qtype_keysignature-write-random'] = '寫出調號(隨機)';
$string['qtype_musictheory_strategy_all_or_nothing'] = '全對或全錯';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = '全對或全錯';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = '全對或全錯';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = '全對或全錯';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = '全對或全錯';
$string['qtype_musictheory_strategy_note_allornothing'] = '全對或全錯';
$string['qtype_musictheory_strategy_scale_creditbynote'] = '依照正確音符數量給分';
$string['qtype_note-identify'] = '辨識音符';
$string['qtype_note-identify-random'] = '辨識音符(隨機)';
$string['qtype_note-write'] = '寫出音符';
$string['qtype_note-write-random'] = '寫出音符(隨機)';
$string['qtype_scale-identify'] = '辨識音階';
$string['qtype_scale-identify-random'] = '辨識音階(隨機)';
$string['qtype_scale-write'] = '寫出音階';
$string['qtype_scale-write-random'] = '寫出音階(隨機)';
$string['qualityaug'] = '增';
$string['qualitydim'] = '減';
$string['qualitymaj'] = '大';
$string['qualitymin'] = '小';
$string['qualityper'] = '完美';
$string['questionoptions'] = '試題選項';
$string['questiontext'] = '試題文字';
$string['questiontext_chordquality_identify'] = '辨識下列和弦的根音及和弦記號';
$string['questiontext_chordquality_write'] = '輸入下列和絃';
$string['questiontext_harmonicfunction_identify'] = '辨識下列和弦分析';
$string['questiontext_harmonicfunction_write'] = '輸入下列和弦分析';
$string['questiontext_interval_identify'] = '辨識下列音程';
$string['questiontext_interval_write_above'] = '在給予的音符<b>之上</b>，輸入下列音程';
$string['questiontext_interval_write_below'] = '在給予的音符<b>之下</b>，輸入下列音程';
$string['questiontext_keyboard_input'] = '在鍵盤上輸入下列音符';
$string['questiontext_keysignature_identify_major'] = '下列調號代表哪一個大調？';
$string['questiontext_keysignature_identify_minor'] = '下列調號代表哪一個小調？';
$string['questiontext_keysignature_write'] = '輸入下列的調號';
$string['questiontext_note_identify'] = '辨識下列音符';
$string['questiontext_note_write'] = '輸入下列的音符';
$string['questiontext_scale_identify'] = '辨識下列音階';
$string['questiontext_scale_write'] = '以爬升方向寫出下列音階';
$string['questiontext_scale_write_melodic'] = '以爬升和下降兩種方式寫出下列音階';
$string['rootposition'] = '[根]';
$string['scaletype'] = '音階類型';
$string['scaletype_harmonic'] = '和聲小調';
$string['scaletype_major'] = '大調';
$string['scaletype_melodic'] = '旋律小調';
$string['scaletype_natural'] = '自然小調';
$string['scaletype-random'] = '可能的音階類型';
$string['scale_write_questionastext'] = '音階答案輸入';
$string['scale_write_questionasui'] = '輸入音階答案';
$string['scale_write_questionasui_help'] = '<p>先在右手邊選擇臨時記號，然後透過在五線譜上點選的方式來輸入音符。若要刪除音符時，再點選一次即可。</p><p>注意，升降記號會影響後續的音符</p>';
$string['selectakey'] = '選擇一鍵';
$string['selectanoption'] = '選擇';
$string['selectaquality'] = '選擇一和弦';
$string['selectasize'] = '選擇一音程';
$string['size10'] = '10度';
$string['size11'] = '11度';
$string['size12'] = '12度';
$string['size13'] = '13度';
$string['size2'] = '2度';
$string['size3'] = '3度';
$string['size4'] = '4度';
$string['size5'] = '5度';
$string['size6'] = '6度';
$string['size7'] = '7度';
$string['size8'] = '8度';
$string['size9'] = '9度';
$string['size-random'] = '可能的音程';
$string['tenor'] = '次中音';
$string['tenorclef'] = '次中音譜號';
$string['tonic'] = '主音';
$string['treble'] = '高音';
$string['trebleclef'] = '高音譜號';
$string['updatemusicqtype'] = '更新選項';
$string['validationerror_chordquality_identify'] = '答案不完整。必須選擇音名、升降符號和和弦特性';
$string['validationerror_empty'] = '還沒有提供答案';
$string['validationerror_harmonicfunction_identify'] = '不完整的答案，所有的下拉選單都必須做選擇。';
$string['validationerror_incompletechordquality'] = '不完整的答案，';
$string['validationerror_incompleteharmonicfunction'] = '不完整的答案，';
$string['validationerror_interval_identify'] = '不完整的答案，';
$string['validationerror_invalidsyntax'] = '答案的語法無效';
$string['validationerror_note_identify'] = '不完整的答案，音名、臨時記號、和音區都要選擇';
$string['validationerror_note_identify_ltr_acc'] = '答案不完整。音名和臨時記號兩者都要選';
$string['validationerror_note_identify_ltr_reg'] = '不完整的答案，音名、和音區都要選擇';
$string['validationerror_notewrite_twonotesingrandstaff'] = '你輸入的兩個音符，請只輸入一個音符';
$string['validationerror_scale_identify'] = '答案不完整。所有的下拉選單都必須做選擇。';
$string['validationerror_scale_incomplete'] = '答案不完整。包含給予的主音，總共需要8個音符。';
$string['validationerror_scale_incomplete_melodic'] = '答案不完整。包含給予的主音，總共需要15個音符。';
$string['validationerror_whitespace'] = '答案的語法無效：請從你的答案中移走所有的空白';
$string['validation_noteoutsidekeyboard'] = '這音符已經超出鋼琴鍵盤範圍';
$string['validation_qualitymismatch'] = '這音程的大小和性質的結合是無效的';
