<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'reader', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   reader
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '動作';
$string['actionblockquizzestext'] = '直至教師移除限制前，您將會被限制不能再參與更多的測驗';
$string['actiondelayquizzestext'] = '直至等待時間已經過去，您將會延遲參與更多的測驗。';
$string['actionemailstudenttext'] = '已傳送電郵給您。';
$string['actionemailteachertext'] = '將會發送電郵至此課程的教師';
$string['activemessages'] = '動態訊息';
$string['activityoverview'] = '點擊此以查看廣泛閱讀活動的資訊';
$string['add'] = '新增';
$string['addbookinstance'] = '新增更多圖書至此課程';
$string['addmoregoals'] = '新增{no}更多目標';
$string['addmorerates'] = '新增{no}更多評分';
$string['addonemorerate'] = '新增{no}更多評分';
$string['add_phpdoc'] = '新增 PHP 文件檔案';
$string['add_phpdocdesc'] = '新增 PHP 文件檔案至php, js 及css檔案';
$string['addquiztoreader'] = '新增課程測驗到閱讀器測驗';
$string['adjoiningcomputers'] = '在相鄰的電腦';
$string['adjustscores'] = '調整分數';
$string['adminarea'] = '管理區';
$string['all'] = '所有';
$string['allbooks'] = '下載／解決所有可用圖書的封面至閱讀器模組';
$string['alldone'] = '已完成所有';
$string['allgroups'] = '所有群組';
$string['alllevels'] = '所有水平';
$string['allowpromotion'] = '允許宣傳';
$string['allparticipants'] = '所有參加者';
$string['allterms'] = '所有學期';
$string['alreadyclosed'] = '抱歉，此活動已不可用。在 {$a}時關閉。';
$string['anywhere'] = '何地';
$string['arrange'] = '安排';
$string['assignpointsbookshavenoquizzes'] = '對沒有測驗的圖書獎勵積分';
$string['atlevel'] = '在水平';
$string['attemptedbooks'] = '下載／解決所有在此網站的已作答圖書的封面';
$string['attempts'] = '嘗試';
$string['attemptsallowedn'] = '允許的作答：{$a}';
$string['attemptscoremanagement'] = '管理作答及分數';
$string['available'] = '可用';
$string['availableitems'] = '可用項目';
$string['averageduration'] = '平均持續時間';
$string['averageduration_help'] = '每個閱讀器測驗作答的平均持續時間';
$string['averagefailed'] = '平均失敗';
$string['averagefailed_help'] = '每個學生的閱讀器測驗平均失敗數目';
$string['averagegrade'] = '平均成績';
$string['averagegrade_help'] = '每個閱讀器測驗的平均成績';
$string['averagepassed'] = '平均合格率';
$string['averagepassed_help'] = '每個閱讀器測驗的平均合格率';
$string['averagepoints'] = '平均分數';
$string['averagepointsallterms'] = '平均分數（所有學期）';
$string['averagepointsallterms_help'] = '所有學期中的每個學生平均獲得的分數';
$string['averagepointsthisterm'] = '平均分數（這個學期）';
$string['averagepointsthisterm_help'] = '這個學期中的每個學生平均獲得的分數';
$string['averagerating'] = '平均評分';
$string['averagetaken'] = '平均參加';
$string['averagetaken_help'] = '每個學生平均參加閱讀器測驗的數目';
$string['averagewords'] = '平均字數';
$string['averagewordsallterms'] = '平均字數（所有學期）';
$string['averagewordsallterms_help'] = '所有學期中的每個學生平均獲得的字數';
$string['averagewordsthisterm'] = '平均字數（這個學期）';
$string['averagewordsthisterm_help'] = '這個學期中的每個學生平均獲得的字數';
$string['awardbookpoints'] = '給予已選學生書本的學分';
$string['awardextrapoints'] = '授予額外分數至已選擇學生';
$string['best'] = '最佳';
$string['blockquizattempts'] = '阻止以後的測驗作答';
$string['book'] = '圖本';
$string['bookadded'] = '已增加圖書：{$a}';
$string['bookcovers'] = '顯示圖書封面';
$string['bookcovers_help'] = '**是**
：在此閱讀器活動中的主頁圖書封面

**否**
：不要在此閱讀器活動中的主頁圖書封面';
$string['bookdifficulty'] = '圖書的難易程度';
$string['bookeditdetails'] = '編輯圖書資料';
$string['bookinstances'] = '使用測驗的子集';
$string['bookinstancesdisabled'] = '閱讀器活動不是做用測驗的子集，所以不而要在book_instances表格的條目';
$string['bookinstances_help'] = '**是**
：此閱讀器活動將會只使用在閱讀器測驗課程中可用的測驗的子集。還有，可以自訂字數的數值及圖書的難易程度。注意，啟用此選項將會導致您的網絡伺服器上增加一些額外的負擔

**否**
：此閱讀器活動將會使用所有在閱讀器測驗課程中可用的測驗，還有只會使用標準閱讀器資料及閱讀水平。';
$string['booklevelmanagement'] = '圖書＆水平管理';
$string['booknotadded'] = '沒有新增的圖書：{$a}';
$string['booknotfound'] = '沒有找到的圖書{$a}';
$string['booknotupdated'] = '沒有更新的圖書：{$a}';
$string['bookquiznumber'] = '圖書測驗數目';
$string['bookrating'] = '圖書評分';
$string['bookrating0'] = '我完全不喜歡這個';
$string['bookrating1'] = '這是普普通通';
$string['bookrating2'] = '這是還好的';
$string['bookrating3'] = '這個很好';
$string['bookratingslevel'] = '顯示每個圖書水平的學生圖書評分';
$string['books'] = '圖書';
$string['booksaddbook'] = '新增圖書';
$string['booksallwith'] = '任何已至少閱讀一次的圖書';
$string['booksavailable'] = '{$a}圖書可用';
$string['booksavailableall'] = '所有可用圖書';
$string['booksavailablewith'] = '已至少閱讀一次的可用圖書';
$string['booksavailablewithout'] = '尚未閱讀的可用圖書';
$string['bookseditcourse'] = '編輯圖書（課程）';
$string['bookseditcourse_help'] = '在此頁面，您可以指明在此課程中可用的圖書閱讀器。您亦可以指明圖書的字數數目及水平。如果沒有指明字數的數值，將會使用在Moodle網站的預設設定。';
$string['bookseditsite'] = '編輯圖書（網站）';
$string['bookseditsite_help'] = '在此頁面，您可以新增，編輯及刪除在Moodle網站中有關圖書閱讀器的資料。如果在Moodle閱讀器主頁中再次下載圖書的資料，在此設定的數值將會被取代。還有，此數值有可能會取代本地及個人課程。';
$string['booksreadinpreviousterms'] = '在上一個學期時閱讀的圖書';
$string['booksreadsincedate'] = '由{$a}開始閱讀圖書';
$string['booksreadsincepromotion'] = '自從宣傳後閱讀的圖書{$a}';
$string['booksreadthisterm'] = '在此學期時閱讀的圖書';
$string['bookswithoutquizzes'] = '沒有測驗的圖書';
$string['bookswithquizzes'] = '有測驗的圖書';
$string['booktitle'] = '圖書標題';
$string['booktype'] = '會包含的圖書';
$string['bookupdated'] = '已更新的圖書： {$a}';
$string['cannotcreatecourse'] = '抱歉，不能進行下載，因為您沒有建立新課程或編輯現時課程的權限。';
$string['cannotdownloadata'] = '抱歉，從閱讀器模組下載資料時出現了問題。';
$string['changeallstoplevelto'] = '變更所有水平上限至';
$string['changeallto'] = '變更所有至';
$string['changecurrentlevel'] = '變更所有現有課程至';
$string['changedifficultyfrom'] = '從變更閱讀水平';
$string['changelevelfrom'] = '從變更水平名稱';
$string['changenumberofsectionsinquiz'] = '重新設定測驗知識庫中的部份數目';
$string['changepointsfrom'] = '從變更分數';
$string['changepublisherfrom'] = '從變更出版者';
$string['changequiz'] = '變更測驗';
$string['changereaderlevel'] = '變更閱讀水平，長度或字數';
$string['changestartlevel'] = '變更所有開始水平至';
$string['cheated'] = '作弊';
$string['cheatedmessage'] = '作弊訊息';
$string['cheatedmessagedefault'] = '很遺憾，但Moodle閱讀器程式發現您可能在測驗時作弊。"作弊"是指您幫助他人完成測驗或您得到他人的幫助您完成測驗。兩方皆會標記為"作弊"。

但電腦有時候亦可能會出錯。如果您誠實地完成測驗，沒有幫助他人或得到他人的幫助，請通知您的教師並可以恢復您的分數。

－－Moodle閱讀器模組 管理員';
$string['cheatedmessage_help'] = '此訊息將會發送到被閱讀器模組判斷為作弊的學生';
$string['cheatsheet'] = '小抄';
$string['checkbox'] = '顯示複選框';
$string['checkbox_help'] = '**是**
:在管理區中的教師報告頁面中顯示複選框


**否**
:不要在管理區中的教師報告頁面中顯示複選框

當管理區已被淘汰時，此設定將會在日後移除。';
$string['checkcheating'] = '檢查作弊';
$string['checkcheating_help'] = '此設定會指定在學生作告閱讀器測驗時是否檢查IP地址。

**關閉**
:不會檢查IP地址


**何地**
:如果兩個學生在接近時間開始測驗並取得合格，他們將會被閱讀器模組判斷為作弊。


**在相鄰的電腦**
:如果兩個學生在接近時間開始測驗和相似的IP地址並取得合格，他們將會被閱讀器模組判斷為作弊。';
$string['check_email'] = '檢查電郵';
$string['check_emaildesc'] = '傳送兩封測驗電郵至訪客學生用戶，一封透過Moodle郵件，另一封則透過PHP郵';
$string['checkonlythiscourse'] = '只檢查此課程';
$string['checksuspiciousactivity'] = '檢查可疑活動的日誌';
$string['chooseaction'] = '選擇動作並點擊"前往"';
$string['clearedmessage'] = '清除訊息';
$string['clearedmessagedefault'] = '我們很高興通知您，已經修復您在上列的測驗的分數。
我們為我們的過失真誠道歉。

－－Moodle閱讀器模組 管理員';
$string['clearedmessage_help'] = '此訊息將會發送到被閱讀器模組判斷為作弊的學生，但及後由教師清除可疑。';
$string['clicktocontinue'] = '點擊此緣繼續';
$string['complete'] = '完成';
$string['completequizattempt'] = '在進行其他新的測驗前，您必須完成"{$a}"的測驗。點擊下列的鏈接以恢復您在此測驗的作答。';
$string['completionpass'] = '需要合格的成績';
$string['completiontotalwords'] = '需要閱讀總數';
$string['completiontotalwords_help'] = '學生必須完成此活動的閱讀總數來取得完成的標記。';
$string['configcheatedmessage'] = '很遺憾，但Moodle閱讀器程式發現您可能在測驗時作弊。"作弊"是指您幫助他人完成測驗或您得到他人的幫助您完成測驗。兩方皆會標記為"作弊"。

但電腦有時候亦可能會出錯。如果您誠實地完成測驗，沒有幫助他人或得到他人的幫助，請通知您的教師並可以恢復您的分數。

－－Moodle閱讀器模組 管理員';
$string['configclearedmessage'] = '我們很高興通知您，已經修復您在上列的測驗的分數。
我們為我們的過失真誠道歉。

－－Moodle閱讀器模組 管理員';
$string['configintro'] = '您在此配置的數值將會界定在您建立新的閱讀器活動時使用的預設數值。
您亦可以配置那一個會視為進階的閱讀器設定';
$string['confirmdeleteattempts'] = '您真的要想要刪除這些作答嗎？';
$string['confirmstartattemptlimit'] = '允許作答的數目：{$a}。您即將開始一個新的作答。您想要繼續進行嗎？';
$string['confirmstartattempttimelimit'] = '此測驗是有時間限制並限制了作答的數目，{$a}次。您即將開始一個新的作答。您想要繼續進行嗎？';
$string['confirmstarttimelimit'] = '此測驗是有時間限制。您確定要開始嗎？';
$string['countactive'] = '活躍學生';
$string['countactive_help'] = '至少參與了一次閱讀器測驗的學生數目';
$string['countfailed'] = '失敗的測驗';
$string['countinactive'] = '非活躍學生';
$string['countinactive_help'] = '尚未參與任何閱讀器測驗的學生數目';
$string['countpassed'] = '合格的測驗';
$string['countrating'] = '評分的數目';
$string['coursespecificquizselection'] = '在模組設置屏幕中的課程指定測驗選擇"是"';
$string['createcoversets_l'] = '由水平＆出版者建立封面集';
$string['createcoversets_t'] = '由水平&amp;出版者建立封面集';
$string['credit'] = '學分';
$string['creditshort'] = 'C';
$string['curlerror'] = '捲曲錯誤：{$a}';
$string['current'] = '現時';
$string['currentlevel'] = '現時水平';
$string['dataallavailable'] = '所有{$a}圖書的資料可用';
$string['dataalldownloaded'] = '已經下載所有{$a}圖書的資料';
$string['datasomeavailable'] = '{$a->all}中的{$a->new}圖書資料可用';
$string['defaultcategoryname'] = '閱讀器測驗';
$string['defaultcoursename'] = '閱讀器測驗';
$string['defaultgoal'] = '預設目標';
$string['defaultgoals'] = '預設目標';
$string['defaultquestioncategoryinfo'] = '{$a->quiz}的{$a->category}題目';
$string['defaultrates'] = '預設評分';
$string['definelogindetails'] = '請界定登入資料：{$a}';
$string['delayineffect'] = '測驗延遲是現時有效';
$string['delayquizattempts'] = '延遲之後的測驗作答';
$string['delete'] = '刪除';
$string['deleteallattempts'] = '刪除所有在閱讀器測驗中的作答';
$string['deleteallattempts_help'] = '根據規則，您不應該刪除閱讀器測驗中的作答。

你只能在完全肯定在此課程中的學生將永不在這Moodle網站中參加閱讀器測驗的情況下才可以刪除作答。

這是因為刪除閱讀器測驗中的作答，代表您允許學生再次參加任何閱讀器測驗。這不是閱讀器模組的評核方法。學生應該只有一次的作答機會。

刪除閱讀器測驗中的作答亦會重設所有學生的閱讀分數至零，這應該不是您或您的學生想要的結果。';
$string['deleteattempts'] = '刪除已選的作答';
$string['deletecategories'] = '刪除分類';
$string['deletecourses'] = '刪除課程';
$string['deletegoals'] = '刪除群組及水平的目標';
$string['deletegoals_help'] = '將會刪除特定群組的預設閱讀目標或閱讀水平';
$string['deletemessages'] = '刪除閱讀器的訊息';
$string['deletemessages_help'] = '所有在此課程的學生主頁中出現的訊息將會刪除';
$string['deleterates'] = '刪除群組及水平的評分';
$string['deleterates_help'] = '將會移除特定群組的閱讀器測驗評分或閱讀水平';
$string['detectcheating'] = '偵測作弊';
$string['difficulty'] = '難易程度';
$string['difficultyshort'] = 'RL';
$string['disallowpromotion'] = '不允許升遷';
$string['displayoptions'] = '顯示選項';
$string['downloadbookswithoutquizzes'] = '下載圖書資料（沒有測驗）';
$string['downloadbookswithquizzes'] = '下載圖書資料發測驗';
$string['downloadedbooks'] = '已下載了以下圖書的資料：';
$string['downloadexcel'] = '下載試算表';
$string['downloadextrapoints'] = '請下載"額外分數"的測驗';
$string['downloadmode'] = '模式';
$string['downloadmode_help'] = '此頁面可以有以下兩種模式：

**正常**
:在正常模式下，只會有尚未下載資料的圖書或已更新資料的圖書可用。不會用已下載最近資料的圖書。


**修理**
:在修理模式下，所有圖書都會開放下載。如果有任何最近已下載的資料，將會由最新下載的資料所取代。使用此模式如果您想要修理不完善的的測驗或不正確的資料。注意即使測驗被取代，但會保存學生的作答。';
$string['downloads'] = '下載';
$string['downloadsettings'] = '下載設定';
$string['duration'] = '時間';
$string['edit'] = '編輯';
$string['editquiztoreader'] = '刪除測驗';
$string['error'] = '錯效：{$a}';
$string['errorsfound'] = '找到的錯誤';
$string['err_regex_float'] = '此設定必須是介符0.0至10.0的小數';
$string['err_regex_integer'] = '此設定必須是介符0至100,000的整數';
$string['event_attempt_added'] = '已增加閱讀器測驗的作答';
$string['event_attempt_added_description'] = '用戶"{$a->userid}"已開始課程模組編號 "{$a->cmid}"的"閱讀器"活動測驗作答';
$string['event_attempt_added_explanation'] = '用戶剛開始閱讀器測驗的作答';
$string['event_attempt_deleted'] = '已刪除閱讀器測驗的作答';
$string['event_attempt_deleted_description'] = '用戶"{$a->userid}"已刪除課程模組編號 "{$a->cmid}"的"閱讀器"活動測驗作答';
$string['event_attempt_deleted_explanation'] = '用戶剛刪除閱讀器測驗的作答';
$string['event_attempt_edited'] = '已編輯閱讀器測驗的作答';
$string['event_attempt_edited_description'] = '用戶"{$a->userid}"已編輯課程模組編號 "{$a->cmid}"的"閱讀器"活動測驗作答';
$string['event_attempt_edited_explanation'] = '用戶剛編輯閱讀器測驗的作答';
$string['event_attempt_submitted'] = '已提交閱讀器測驗的作答';
$string['event_attempt_submitted_description'] = '用戶"{$a->userid}"已提交課程模組編號 "{$a->cmid}"的"閱讀器"活動測驗作答';
$string['event_attempt_submitted_explanation'] = '用戶剛提交閱讀器測驗的作答';
$string['event_base'] = '已偵測閱讀器的活動';
$string['event_base_description'] = '用戶"{$a->userid}"已發起課程模組編號 "{$a->cmid}"中的"閱讀器"活動';
$string['event_base_explanation'] = '閱讀器已偵測了一項活動';
$string['event_book_added'] = '已新增閱讀器圖書';
$string['event_book_added_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動新增了圖書';
$string['event_book_added_explanation'] = '用戶剛新增了有關閱讀器圖書的資料';
$string['event_book_deleted'] = '已刪除了閱讀器圖書';
$string['event_book_deleted_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動刪除了圖書';
$string['event_book_deleted_explanation'] = '用戶剛刪除了有關閱讀器圖書的資料';
$string['event_book_edited'] = '已修改閱讀器圖書';
$string['event_book_edited_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動修改了圖書';
$string['event_book_edited_explanation'] = '用戶剛修改了有關閱讀器圖書的資料';
$string['event_books_downloaded'] = '已下載閱讀器圖書';
$string['event_books_downloaded_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動下載了圖書';
$string['event_books_downloaded_explanation'] = '用戶剛下載了有關閱讀器圖書的資料';
$string['event_cron_run'] = '閱讀器cron運作';
$string['event_cron_run_description'] = '已運作閱讀器cron的工作';
$string['event_cron_run_explanation'] = '剛運作閱讀器cron的工作';
$string['event_downloads_viewed'] = '已查看閱讀器的下載';
$string['event_downloads_viewed_description'] = '用戶"{$a->userid}"已查看了課程模組編號 "{$a->cmid}"中的"閱讀器"有關的資料。';
$string['event_downloads_viewed_explanation'] = '用戶剛查看閱讀器下載的資料';
$string['event_message_added'] = '已新增了閱讀器訊息';
$string['event_message_added_description'] = '用戶"{$a->userid}"已增加了課程模組編號 "{$a->cmid}"中的"閱讀器"活動的訊息。';
$string['event_message_added_explanation'] = '用戶剛新增了訊息至閱讀器活動';
$string['event_message_deleted'] = '已刪除閱讀器的訊息';
$string['event_message_deleted_description'] = '用戶"{$a->userid}"已刪除了課程模組編號 "{$a->cmid}"中的"閱讀器"活動的訊息。';
$string['event_message_deleted_explanation'] = '用戶剛從閱讀器活動中刪除了訊息';
$string['event_message_edited'] = '已編輯閱讀器訊息';
$string['event_message_edited_description'] = '用戶"{$a->userid}"已編輯了課程模組編號 "{$a->cmid}"中的"閱讀器"活動的訊息。';
$string['event_message_edited_explanation'] = '用戶修改了閱讀器活動中的訊息';
$string['event_quiz_added'] = '已增加了閱讀器測驗';
$string['event_quiz_added_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中增加了測驗。';
$string['event_quiz_added_explanation'] = '用戶剛新增了測驗至閱讀器活動';
$string['event_quiz_delay_set'] = '已設定了閱讀器測驗延期';
$string['event_quiz_delay_set_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中設定了測驗延期。';
$string['event_quiz_delay_set_explanation'] = '用戶剛設定了閱讀器測驗延期';
$string['event_quiz_deleted'] = '已刪除了閱讀器測驗';
$string['event_quiz_deleted_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中刪除了測驗。';
$string['event_quiz_deleted_explanation'] = '用戶剛刪除了測驗至閱讀器活動';
$string['event_quiz_edited'] = '已編輯了閱讀器測驗';
$string['event_quiz_edited_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中編輯了測驗。';
$string['event_quiz_edited_explanation'] = '用戶剛編輯了測驗至閱讀器活動';
$string['event_quiz_finished'] = '已完成了閱讀器測驗';
$string['event_quiz_finished_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中完成了測驗。';
$string['event_quiz_finished_explanation'] = '用戶剛完成了測驗至閱讀器活動';
$string['event_quiz_selected'] = '已選擇了閱讀器測驗';
$string['event_quiz_selected_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中選擇了測驗。';
$string['event_quiz_selected_explanation'] = '用戶剛選擇了測驗至閱讀器活動';
$string['event_quiz_started'] = '已開始了閱讀器測驗';
$string['event_quiz_started_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中開始了測驗。';
$string['event_quiz_started_explanation'] = '用戶剛開始了測驗至閱讀器活動';
$string['event_report_bookdetailed_viewed'] = '已查看閱讀器報告：圖書（詳細）';
$string['event_report_bookdetailed_viewed_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中查看了圖書（詳細）報告。';
$string['event_report_bookdetailed_viewed_explanation'] = '用戶剛查看了閱讀器報告：圖書（詳細）。';
$string['event_report_booksummary_viewed'] = '已查看閱讀器報告：圖書（摘要）';
$string['event_report_booksummary_viewed_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中查看了圖書（摘要）報告。';
$string['event_report_booksummary_viewed_explanation'] = '用戶剛查看了閱讀器報告：圖書（摘要）。';
$string['event_report_groups_viewed'] = '已查看閱讀器報告：群組（摘要）';
$string['event_report_groups_viewed_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中查看了群組（摘要）報告。';
$string['event_report_groups_viewed_explanation'] = '用戶剛查看了閱讀器報告：群組（摘要）。';
$string['event_report_userdetailed_viewed'] = '已查看閱讀器報告：用戶（詳細）';
$string['event_report_userdetailed_viewed_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中查看了用戶（詳細）報告。';
$string['event_report_userdetailed_viewed_explanation'] = '用戶剛查看了閱讀器報告：用戶（詳細）。';
$string['event_report_usersummary_viewed'] = '已查看閱讀器報告：用戶（摘要）';
$string['event_report_usersummary_viewed_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中查看了用戶（摘要）報告。';
$string['event_report_usersummary_viewed_explanation'] = '用戶剛查看了閱讀器報告：用戶（摘要）。';
$string['event_tool_run'] = '閱讀器管理工具的運作';
$string['event_tool_run_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中運作了閱讀器管理工具';
$string['event_tool_run_explanation'] = '用戶剛運作了閱讀器工具：{$a}';
$string['event_user_goal_set'] = '已設定閱讀器用戶目標';
$string['event_user_goal_set_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中設定了學生的閱讀器目標';
$string['event_user_goal_set_explanation'] = '用戶剛設定了閱讀活動的閱讀目標';
$string['event_user_level_set'] = '已設定閱讀器用戶水平';
$string['event_user_level_set_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中設定了學生的閱讀器水平';
$string['event_user_level_set_explanation'] = '用戶剛設定了閱讀活動的學生閱讀水平';
$string['event_users_exported'] = '已匯出閱讀器用戶';
$string['event_users_exported_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中已匯出閱讀器用戶的資料';
$string['event_users_exported_explanation'] = '用戶剛匯出閱讀器用戶的資料';
$string['event_users_imported'] = '已匯入閱讀器用戶';
$string['event_users_imported_description'] = '用戶"{$a->userid}"已在課程模組編號 "{$a->cmid}"中的"閱讀器"活動中已匯入閱讀器用戶的資料';
$string['event_users_imported_explanation'] = '用戶剛匯入閱讀器用戶的資料';
$string['export'] = '匯出';
$string['export_reader_tables'] = '匯出閱讀器表格';
$string['export_reader_tablesdesc'] = '匯出閱讀器資料庫的表格。注意已匯出資料沒有包含課程或用戶名稱的資料，只有ID。';
$string['exportstudentrecords'] = '匯出學生的紀錄';
$string['extrapoints'] = '額外分數';
$string['extrapoints0'] = '0.5分';
$string['extrapoints1'] = '1分';
$string['extrapoints2'] = '2分';
$string['extrapoints3'] = '3分';
$string['extrapoints4'] = '4分';
$string['extrapoints5'] = '5分';
$string['extrapoints6'] = '6分';
$string['extrawords'] = '{$a}字數';
$string['failed'] = '失敗';
$string['failedshort'] = 'F';
$string['filename'] = '文件名稱';
$string['fileuploaded'] = '已上載文件';
$string['find_faultyquizzes'] = '搜尋不完善的測驗';
$string['find_faultyquizzesdesc'] = '搜尋沒有正確答案的測驗';
$string['finishreview'] = '完成評論';
$string['fix_bookcovers'] = '修理圖書封面';
$string['fix_bookcoversdesc'] = '偵檢缺少封面圖像的圖書，及嘗試下載封面圖像';
$string['fix_bookinstances'] = '修理圖書例子';
$string['fix_bookinstancesdesc'] = '確保所有圖書在reader_book_instances表格中都有相關的紀錄';
$string['fix_coursesections'] = '修理課程章節';
$string['fix_coursesectionsdesc'] = '整理包含了閱讀器測驗的課程主頁。

* 根據出版者的名稱及難易程度排序章節
* 確保每個章節只有同一出版者的圖書
* 移除空白章節
* 重設課程章節的編碼';
$string['fixingsumgrades'] = '修理閱讀器測驗作答的成績 ...';
$string['fix_installxml'] = 'Fix db/install.xml';
$string['fix_installxmldesc'] = 'Make XML tags in db/install.xml compatible with Moodle <= 2.5

* add NEXT and PREVIOUS attributes to TABLE, FIELD, KEY and INDEX tags
* add SEQUENCE attributes to FIELD tags with TYPE="int"';
$string['fixmissingquizzes'] = '修理缺少的測驗';
$string['fix_missingquizzes'] = '修理缺少的測驗';
$string['fix_missingquizzesdesc'] = '統一重複的閱讀器圖書及測驗。

*合併重複的圖書
*修理共享同一測驗的圖書
*合併重複的測驗
*修理缺少測驗的圖書及作答';
$string['fixmissingquizzesinfo'] = '已暫停了升級，您可以決定是否想要下載及安裝在Moodle網站缺少的閱讀器模組測驗。

如果您選擇"是"，缺少的測驗將會下載及安裝。
如果您選擇"不是"，所有缺少的測驗的圖書將會標記為沒有測驗資料。

注意： 即使您選擇了不是，閱讀器活動的字數將不會受到影響。


您想要下載及安裝在Moodle網站缺少的閱讀器模組測驗？';
$string['fix_questioncategories'] = '修理題目分類';
$string['fix_questioncategoriesdesc'] = '整理閱讀器題目及題目分類。

*取清設置所有有效的主題目ID
*刪除不被任何測驗使用的題目
*移動閱讀器課程題目分類到合適的測驗
*移除所有在分類名稱及說明中的斜線
* 統一排序分類的名稱';
$string['fixslashesinnames'] = '除在圖書名稱中的斜線';
$string['fix_slashesinnames'] = '修理名稱中的斜線';
$string['fix_slashesinnamesdesc'] = '移除所有在閱讀器中圖書名稱及分類名稱中的斜線';
$string['fix_wrongattempts'] = '修理錯誤的作答';
$string['fix_wrongattemptsdesc'] = '偵檢及修理任何在閱讀器中測驗名稱與圖書名稱不相符的作答。';
$string['fixwrongquizid'] = '"{$a->name}" (book id={$a->id}) 有異乎尋常的測驗ID';
$string['fixwrongquizidinfo'] = '已暫停升級，您可以決定聯結那一個測驗到此圖書。

請查看下列的資料及選擇您想要聯結到此圖書的測驗。';
$string['forcedownload'] = '強制下載';
$string['forcedtimedelay'] = '設定強制延期';
$string['forcedtimerate'] = '設定強制閱讀率';
$string['fromthistime'] = '從此時間';
$string['fullreportbybooktitle'] = '圖書標題的完整報告';
$string['fullreportquiztoreader'] = '學生的完整報告';
$string['genre'] = '類型';
$string['getstarted'] = '**準備開始**

*此活動的目標是閱讀大多圖書以建立您的閱書量
*您的閱書量是所有您已閱讀圖書的字數

**選擇圖書**

*您應該選擇一本能輕鬆閱讀，不用字典的圖書
*還有，選擇您有興趣的圖書，令閱讀更為有趣

**參加網上測驗**

*在完成閱讀後，參加網上測驗
*使用此頁的搜尋欄搜尋您想要的測驗，當您找到測驗後，點擊開始的按鈕
*每個測驗將會有數條有關此圖書的題目。每個學生都會有不同的題目
*如果您在此測驗中合格，此書的字數將會加到您的閱書量中。如果您在此測驗中不合格，您的閱書量將不會變動。

* ***您不能重考***，所以請小心地完成測驗';
$string['goal'] = '目標';
$string['groupgoals'] = '特定群組的目標';
$string['grouprates'] = '特定群組的評分';
$string['hidden'] = '隱藏';
$string['ifimagealreadyexists'] = '如果圖像已在圖像文件夾中（名稱）';
$string['ignoredate'] = '學期開始日期';
$string['ignoredate_help'] = '此學期開始日期。

任何在此日期前的Reader測驗作答將不會包括在此學期的閱讀量中。

但是，在前一個的測驗作答並不會完全忽視，將會包含在"所有學期"的報告中。

還有，請注意學生不能重考，包括在上一個學期的測驗，除非教師刪除了以往的作答。';
$string['image'] = '圖像';
$string['imageadded'] = '已增加的圖像：{$a}';
$string['import'] = '匯入';
$string['importreadertables'] = '匯入閱讀器表格';
$string['import_reader_tables'] = '匯入閱讀器表格';
$string['import_reader_tablesdesc'] = '只從閱讀器數據庫中表格重建整個Moodle網站。此工具亦會建立課程、用戶、群組、閱讀器活動及測驗。';
$string['importstudentrecord'] = '匯入學生紀錄';
$string['in1000sofwords'] = '在1000字內';
$string['includepublishers'] = '也搜尋出版者名稱？';
$string['incorrect'] = '－ 不正確';
$string['incorrect2'] = '抱歉，請從您的出版者中取的正確的密碼。點擊"安裝"測驗來下載您其他的章節';
$string['incorrectbooksreadinpreviousterms'] = '查看不合格的測驗';
$string['induration'] = '在';
$string['installedbooks'] = '只下載／修理已安裝到此網站的圖書封面';
$string['install_quizzes'] = '安裝測驗';
$string['isgreaterthan'] = '大過';
$string['islessthan'] = '小於';
$string['itemsdownloaded'] = '已下載{$a} 項目';
$string['keeplocalbookdifficulty'] = '保留本地圖書的難易度設定';
$string['keepoldquizzes'] = '保留舊的測驗';
$string['lastupdatedtime'] = '在此網站的測驗在{$a}時最後更新。您現在想要更新此網站？';
$string['level'] = '水平';
$string['levelcheck'] = '限制閱讀水平';
$string['levelcheck_help'] = '**是**
：學生只能選取接近他們現時閱讀水平的圖書測驗。在"Quizzes at current/previous/next level"的頁面已標明了學生考取測驗的次數。

**不是**
：學生可以選取任何閱讀水平的圖書測驗。';
$string['levelgoal'] = '水平{$a} 目標';
$string['levelgoals'] = '特定水平的目標';
$string['leveli'] = '水平{$a}';
$string['levelrate'] = '水平{$a}評分';
$string['levelrates'] = '特定水平的評分';
$string['levels'] = '水平';
$string['likebook'] = '您喜歡此圖書嗎？';
$string['logoutrequired'] = '您不能繼續，因為您現時登入為{$a}。
要繼續，請點擊下方的"登出"按鍵並以自己的身份再次登入。';
$string['mainpagesettings'] = '主頁設定';
$string['makebookavailable'] = '令圖書可用';
$string['makebookavailableproblem'] = '噢，不能在此課程中令圖書可用：{$a}';
$string['makebookavailablesuccess'] = '圖書現而在此課程可用：{$a}';
$string['makenewquizzesavailable'] = '令新的測驗只有此課程可用';
$string['makenewquizzesavailable2'] = '令新的測驗在此網站的所有課程可用（預設）';
$string['massrename'] = '大量變更';
$string['max'] = '不少於或等於';
$string['maxgrade'] = '最高分數';
$string['maxgrade_help'] = '此閱讀器的最高分數。

已閱讀的字數，閱讀目標的完成度（分數）將會調整後加到成績簿。

一穫來知最高分數是100, 但因為當所有學生都有相同的閱讀目標時，如果此設定與閱讀目標相同，將可以幫助學生了解他們的成績。';
$string['maxquizattemptrate'] = '測驗作答率的上限';
$string['maxquizattemptrate_help'] = '測驗作答率的上限，如果學生在指定期間內，完成多於指定數目的測驗，將會採取特別行動。';
$string['maxquizattemptratetext'] = '請不要考取多過{$a}。如果您考取多過此比率，將會有以下的行動：';
$string['maxquizfailurerate'] = '測驗失敗率的上限';
$string['maxquizfailurerate_help'] = '測驗失敗率的上限，如果在在指定期間內，多於不合格測驗的指定數目，將會採取特別行動。';
$string['maxquizfailureratetext'] = '如果您有多過{$a}的不合格，將會有以下的行動：';
$string['maxtimebetweenquizzes'] = '測驗之間時間上限';
$string['menu'] = '菜單';
$string['mergingtables'] = '合併表格：從{$a->old} 至 {$a->new}';
$string['messagefromyourteacher'] = '從教師中收到的訊息';
$string['migratinglogs'] = '轉航閱讀器的日誌';
$string['min'] = '大過或等於';
$string['minpassgrade'] = '測驗合格的成績';
$string['minpassgrade_help'] = '此閱讀器活動中測驗的最低合格成績，以百分比。

比這個百分比分數低的話，將會標記為不合格。';
$string['minquizattemptrate'] = '最低測驗作答率';
$string['minquizattemptrate_help'] = '最低測驗作答率，如果學生在指定期間內沒有至少考取指定數目的測驗，將會有指定的行動。';
$string['minquizattemptratetext'] = '請至少考取 {$a}。如果您要此比率之下，將會有以下的行動：';
$string['modulename'] = '閱讀器';
$string['modulename_help'] = '閱讀器模組允許教師為學生設定閱讀目標，並允許學生證明他們已經達成指定的閱讀目標。';
$string['modulenameplural'] = '閱讀器';
$string['morenewattempts'] = '{$a}更多新作答...';
$string['movedquizzes'] = '已成功移動{$a}測驗';
$string['move_quizzes'] = '移動測驗';
$string['move_quizzesdesc'] = '從現有課程中移動測驗至主要閱讀器測驗的課程';
$string['needdeletethisattemptstoo'] = '亦需要刪除此作答';
$string['needtocheckupdates'] = '此網站已經({$a}天)沒有檢查測驗。現在檢查嗎？';
$string['newdate'] = '新的日期';
$string['newreaderattempts'] = '新的閱讀器作答';
$string['newreadinggoal'] = '新的目標';
$string['newreadinglevel'] = '新的水平';
$string['newsetting'] = '此設定的新數值';
$string['newtime'] = '新的時間';
$string['nextlevel'] = '下一個水平的測驗';
$string['nextlevel_help'] = '學生在下一個水平的可作答測驗數目，比他們現在的水平高一級的閱讀水平。注意這些測驗不會視為升遷。';
$string['noaction'] = '不要採取任何行動';
$string['nobooksfound'] = '沒有找到任何圖書';
$string['nobooksinlist'] = '沒有在您的閱讀水平中找到任何圖書';
$string['nodownloaditems'] = '沒有可以下載的項目';
$string['noincorrectquizzes'] = '您尚沒有在任何測驗中不合格';
$string['nomoreattempts'] = '沒有更多允許的作答';
$string['no_password'] = '不需要密碼';
$string['noquizzesfound'] = '沒有找到測驗';
$string['noreaders'] = '在此課程沒有找到閱讀器活動';
$string['norecordsmatch'] = '沒有使用現有過濾器及顯示選項來選擇紀錄';
$string['noreview'] = '您不能夠檢閱此測驗';
$string['noreviewshort'] = '不允許';
$string['normalmode'] = '正常';
$string['noscript'] = '必須啟用Javascript以繼續';
$string['nosearchresults'] = '沒有與您搜尋配對的圖書可用';
$string['notavailable'] = '此測驗現時不可用';
$string['nothavepermissioncreateinstance'] = '抱歉，您沒有操作權限';
$string['notifycheating'] = '通知作弊';
$string['notifycheating_help'] = '如果啟用此設定，被判定在Reader測驗中作弊的學生將會收到下列的"作弊訊息"。';
$string['notopenyet'] = '抱歉，此活動尚未啟用，會在{$a}時開啟。';
$string['numattempts'] = '{$a}作答';
$string['numberofextrapoints'] = '額外分數的數目';
$string['off'] = '關閉';
$string['oneattempt'] = '1次 作答';
$string['onlybookswithmorethan'] = '只有圖書多過';
$string['pagesettings'] = '頁面設定';
$string['passed'] = '合格';
$string['passedshort'] = 'P';
$string['passfailattempts'] = '更新已選取作答的合格／不合格';
$string['passworderror'] = '輸入的密碼是不正確的';
$string['passwords_list'] = '密碼清單';
$string['percentactive'] = '活躍百分比';
$string['percentactive_help'] = '至少完成了一次閱讀器測驗的學生的百分比';
$string['percentinactive'] = '不活躍百分比';
$string['percentinactive_help'] = '尚未完成任何閱讀器測驗的學生的百分比';
$string['pleaseaskyourinstructor'] = '如果您認為對您來說是太容易的話，請詢問您的教師以上升您的閱讀水平。';
$string['pleaseclose'] = '已在處理您的要求，您可以關閉此視窗。';
$string['pleaseselectpublisher'] = '請選擇出版者';
$string['pleasespecifyyourclassgroup'] = '請指明您的課堂群組或搜尋指定學生';
$string['pleasewait'] = '請稍等';
$string['pluginadministration'] = '閱讀器管理';
$string['pluginname'] = '閱讀器';
$string['points'] = '分';
$string['pointsex11'] = '長度（Ex. 1.1）';
$string['popup'] = '使用"安全"視窗';
$string['popup_help'] = '如果選擇了"是"，

*測驗只會在學生有已啟用的Javascript瀏覽器情況下開始
*測驗會在全屏的彈出視窗中顯示，將會覆蓋所有其他的視窗，並且沒有導航控制。
*學生將會盡可能阻止使用複製及貼上的功能';
$string['prevlevel'] = '在上一個水平的測驗';
$string['prevlevel_help'] = '學生在在上一個水平的中可以進行的測驗數目，即使比現時水平低一級的水平，注意這些測驗將不會算進升遷中。';
$string['print_cheatsheet'] = '列印小抄';
$string['print_cheatsheetdesc'] = '題示任何閱讀器測驗的答案';
$string['private'] = '私人';
$string['process_addquestion'] = '<b>增加題目至測驗 {$a}.</b><br />';
$string['process_courseadded'] = '<b>已增加課程</b><br />';
$string['promotionnotallowed'] = '您的教師為您已停止了自動升遷。';
$string['promotionsettings'] = '升遷設定';
$string['publisher'] = '出版者';
$string['publishers'] = '出版者';
$string['publisherseries'] = '出版者／系列';
$string['questionscores'] = '顯示題目的分數';
$string['questionscores_help'] = '每道題目的最高分數應該在學生作答測驗時顯示嗎？

**是**
：顯示每道題目的最高分數

**否**
：隱藏每道題目的最高分數';
$string['quizadd'] = '增加閱讀器的測驗';
$string['quizadded'] = '已增加測驗：{$a}';
$string['quizarrange'] = '排列閱讀器的測驗';
$string['quizattemptinprogress'] = '正在進行測驗作答...';
$string['quizclosed'] = '測驗已在 {$a}關閉';
$string['quizcloseson'] = '測驗將會在 {$a}關閉';
$string['quizdelete'] = '刪除閱讀器測驗';
$string['quizfordays'] = '常用限制（日子）';
$string['quizhasnoquestions'] = '測驗沒有題目';
$string['quizmanagement'] = '測驗管理';
$string['quizname'] = '測驗名稱';
$string['quiznotavailable'] = '抱歉，這測驗您目前不可用';
$string['quiznotavailableuntil'] = '這個測驗將不可用直至{$a}';
$string['quizopenedon'] = '測驗已在 {$a}開啟';
$string['quizsetrate'] = '設定閱讀器測驗的比率';
$string['quizshowhide'] = '顯示／隱藏閱讀器測驗';
$string['quiztimelimit'] = '時間限制：{$a}';
$string['quizupdate'] = '更新閱讀器測驗';
$string['quizupdated'] = '已更新測驗：{$a}';
$string['quizupdateswillbeapplied'] = '測驗的更新將會在所有正使用此測驗的課程中應用。';
$string['quizzes'] = '測驗';
$string['quizzesadd'] = '增加測驗';
$string['quizzesadded'] = '已增加測驗';
$string['quizzesarrange'] = '排列測驗';
$string['quizzesdelete'] = '刪除測驗';
$string['quizzesmustbeinstalled'] = '測驗必須安裝分隔了學生用作登入測驗的課程中。此課程將從學生中隱藏，並只會用作儲存測驗，一般會命名為"所有測驗"。您已建立此功能的課程將會在下方顯示。如果您尚未建立課程，請點擊"建立新的課程"。';
$string['quizzespassedtable'] = '通過RL的測驗 －{$a}';
$string['quizzessetrate'] = '設定閱讀率';
$string['quizzesshowhide'] = '顯示／隱藏測驗';
$string['quizzesupdate'] = '更新測驗';
$string['rate'] = '比率';
$string['rateaction'] = '動作';
$string['rateaction_help'] = '如果違反閱讀率限制，將會有以下的動作。下列的動作可用：

**延遲進一步的測驗作答**
：學生將被阻止作答另一個測驗，直到期限期滿。


**阻止進一步的測驗作答**
：學生將被阻止作答另一個測驗，直至教師移除限制。


**發送電郵給學生**
：發送電郵給學生通知違反比率的事。


**發送電郵給教師**
：發送電郵給教師通知學生違反比率的事。';
$string['rategroup'] = '群組';
$string['rategroup_help'] = '應用此比率限制的群組';
$string['rate_help'] = '閱讀比率是指明了在指定期間內作答閱讀器測驗的上限數目，或閱讀器測驗的最少作答次數。';
$string['ratelevel'] = '水平';
$string['ratelevel_help'] = '應用此比率限制的閱讀水平';
$string['ratemanyconsecutively'] = '{$a->attempts}連續測驗';
$string['ratemanyinduration'] = '在{$a->duration}期間的{$a->attempts}測驗';
$string['rateoneinduration'] = '在{$a->duration}期間的{$a->attempts}測驗';
$string['ratetype'] = '類型';
$string['ratetype_help'] = '可指定以下類型的閱讀率：

**最低測驗作答比率**
：學生最小要作答測驗的比率。如果學生沒有在指定期間內繼續作答至指定數目，將採取指定行動。

**最高測驗作答比率**
：學生最多要作答測驗的比率。如果學生嘗試在指定期間內作答超過指定的數目，將採取指定行動。


**最高不及格測驗的比率**
：學生最多可以不合格的比率。如果學生在指定期間內不合格的作答超過指定數目，將採取指定行動。';
$string['ratings'] = '比率';
$string['reader:addinstance'] = '增加新的閱讀器活動';
$string['readerdownload'] = '下載閱讀器圖書（及測驗）';
$string['reader:manageattempts'] = '管理作答';
$string['reader:managebooks'] = '管理圖書';
$string['reader:manageremotesites'] = '管理遙距網站';
$string['reader:managetools'] = '管理工具';
$string['reader:manageusers'] = '管理用戶';
$string['readerquizsettings'] = '閱讀器測驗設定';
$string['readerreports'] = '閱讀器模組的報告';
$string['reader:viewallbooks'] = '查看所有圖書';
$string['reader:viewbooks'] = '查看圖書';
$string['reader:viewreports'] = '查看報告';
$string['reader:viewversion'] = '查看版本';
$string['readinglevel'] = '閱讀水平';
$string['readinglevelshort'] = 'RL{$a}';
$string['readingreportfor'] = '{$a}的閱讀報告';
$string['recommendedreadingrates'] = '推薦閱讀率';
$string['redo_upgrade'] = '重做升級';
$string['redo_upgradedesc'] = '重做閱讀器模組的升級';
$string['remotesitenotaccessible'] = '不能進入遙距下載的網站';
$string['removebook'] = '移除圖書';
$string['removebookerror'] = '沒有移除的圖書：{$a}';
$string['removebook_help'] = '不能刪除有正在作答的圖書。要刪除這些圖書，您必須刪除現時的作答。';
$string['removebookinstance'] = '從此課程中移除已選圖書';
$string['removebooksuccess'] = '已移除的圖書： {$a}';
$string['repairmode'] = '修恢';
$string['reportbookdetailed'] = '圖書（滿）';
$string['reportbookratings'] = '圖書評分';
$string['reportbooksummary'] = '圖書（摘要）';
$string['reportgroupsummary'] = '群組';
$string['reportquiztoreader'] = '學生的摘要報告';
$string['reports'] = '報告';
$string['reportsettings'] = '報告設定';
$string['reportuserdetailed'] = '學生（滿）';
$string['reportusersummary'] = '學生（摘要）';
$string['requirepasswordmessage'] = '您必須知道測驗的密碼才能作答此測驗';
$string['requireqtypeordering'] = '由於缺少了題型的排列，因此不能安裝或更新閱讀器活動模組。請下載題型的排列，並放置在{$a}/題目/類型/排列，之後重新載入此頁面。';
$string['restoreattempts'] = '修復已選的作答';
$string['restoredeletedattempt'] = '修復已刪除的作答';
$string['returntocoursepage'] = '返回課程頁面';
$string['returntoreports'] = '返回至報告';
$string['returntostudentlist'] = '返回學生清單';
$string['review'] = '檢閱';
$string['reviewthisattempt'] = '檢閱您在此作答的回答';
$string['rowsperpage'] = '每頁的列行';
$string['run_readercron'] = '運作閱讀器的cron';
$string['run_readercrondesc'] = '為閱讀器模組運作cron工作';
$string['safebrowsererror'] = '已建立此測驗，所以只能使用"考試安全瀏覽器"來作答。您不能使用此瀏覽器作答。';
$string['safebrowsernotice'] = '已設置此測驗，所以學生只能使用"考試安全瀏覽器"來作答。';
$string['search'] = '搜尋';
$string['searchforabook'] = '搜尋圖書';
$string['search_help'] = '要搜尋指定的圖書，輸入包含在圖書標題的案眼並點擊"前往"按鍵';
$string['sectionname'] = '章節名稱';
$string['sectiontoseparate'] = '增加測驗以分隔出版者及水平的章節，當可以時增加測驗至現有的章節';
$string['sectiontothebottom'] = '在新的章節中的隱藏課程中的底層中增加所有測驗';
$string['sectiontothissection'] = '增加已選的測驗到此章節';
$string['sectiontypedefault'] = '預設的章節：';
$string['sectiontypehidden'] = '隱藏的章節';
$string['sectiontypelast'] = '最後的章節';
$string['sectiontypenew'] = '新的章節';
$string['sectiontypevisible'] = '可見的章節';
$string['seedetailsbelow'] = '請參閱下面的詳細資料';
$string['select'] = '選擇';
$string['selectabook'] = '選擇圖書';
$string['selectalreadyexist'] = '選擇現有的';
$string['select_course'] = '選擇課程';
$string['selectedbookname'] = '選擇圖書名稱';
$string['select_help'] = '在下方的清單點擊您想要的項目';
$string['selectipmask'] = '選擇IP掩碼';
$string['selectlevel'] = '選擇水平';
$string['selectpublisher'] = '選擇出被者';
$string['selectseries'] = '選擇系列';
$string['selectsomeattempts'] = '選擇一個或更多的作答';
$string['selectsomebooks'] = '選擇一本或更多的圖書';
$string['selectsomerows'] = '請在已選的欄中勾選一些選格';
$string['selectsomeusers'] = '選擇一個或更多用戶';
$string['selectthisquiz'] = '選擇此測驗';
$string['sendemailtostudent'] = '發送電郵給學生';
$string['sendemailtoteacher'] = '發送電郵給教師';
$string['sendmessage'] = '發送訊息給已選的學生';
$string['sentemailmoodle'] = '已通過Moodle發送電郵：{$a->email}';
$string['sentemailphp'] = '已通過PHP郵件發送電郵：{$a->email}';
$string['sentmessage'] = '訊息已成功發送給{$a}用戶';
$string['separategroups'] = '分隔群姐';
$string['separatelevels'] = '分隔水平';
$string['servererror'] = '從服務器的消息: {$a}';
$string['serverpassword'] = '閱讀器伺服器的密碼';
$string['serverurl'] = '閱讀器伺服器的網址';
$string['serverusername'] = '閱讀器伺服器的用戶名稱';
$string['setallowpromotion'] = '為已選學生更改升遷設定';
$string['setbookinstances'] = '選擇學生可用的測驗';
$string['setcurrentlevel'] = '為已選學生更改現時水平';
$string['setdifficulty'] = '設定圖書的難易程度';
$string['setgenre'] = '設定類型';
$string['setgoal'] = '設定目標';
$string['setgoals'] = '設定目標';
$string['setgoals_description'] = '在此頁，您可以為在指定閱讀水平的學生設定閱讀目標，或特定的群組。注意，個別學生的報告頁面的設置將覆蓋此頁面上的設置。';
$string['setlevel'] = '設定水平';
$string['setlevels'] = '設定水平';
$string['setlevels_description'] = '在此頁，您可以為在一組學生設定閱讀水平。注意，個別學生的報告頁面的設置將覆蓋此頁面上的設置。';
$string['setmessage'] = '設定訊息';
$string['setmessagetext'] = '訊息文字';
$string['setmessagetime'] = '顯示直至';
$string['setname'] = '設定圖書標題';
$string['setpoints'] = '設定分數數值';
$string['setpromotiontime'] = '更改升遷的日期和時間';
$string['setpublisher'] = '設定出版者';
$string['setrates'] = '設定比率';
$string['setrates_description'] = '在此頁，您可以為在指定閱讀比率的學生設定閱讀目標，或特定的群組。';
$string['setreadinggoal'] = '設定閱讀目標';
$string['setreadinglevel'] = '設定閱讀水平1';
$string['setstartlevel'] = '更改已選學生的開始水平';
$string['setstoplevel'] = '更改已選學生的最高水平';
$string['settings'] = '設定';
$string['setuniformgoalinpoints'] = '以分數設定統一目標';
$string['setuniformgoalinwords'] = '以文字設定統一目標';
$string['setwords'] = '設定字數';
$string['show'] = '題示';
$string['showall'] = '題示所有';
$string['showattempts'] = '題示配對這些條件的作答';
$string['showdeleted'] = '題示已刪除作答';
$string['show_help'] = '在下列清單中點選您想要題示的項目';
$string['showhidden'] = '題示隱藏區塊';
$string['showhide'] = '題示／隱藏';
$string['showhidebook'] = '題示或隱藏';
$string['showhidebooks'] = '更新已選圖書的題示／隱藏設定';
$string['showlevel'] = '題示水平';
$string['showpercentgrades'] = '題示百分比成績';
$string['showpercentgrades_help'] = '**是**
: 在每個閱讀器測驗的作答題示成績 (以百分比)

**否**
: 不要在每個閱讀器測驗的作答題示成績 (以百分比)';
$string['showpoints'] = '只題示分數';
$string['showpointsandwordcount'] = '題示分數及字數';
$string['showprogressbar'] = '題示進度桿';
$string['showprogressbar_help'] = '**是**
: 在閱讀器活動的主頁中顯示字數的進度桿

**否**
: 不要在閱讀器活動的主頁中顯示字數的進度桿';
$string['showreviewlinks'] = '題示檢閱鏈接';
$string['showreviewlinks_help'] = '**是**
: Add links from values on the Reader report pages to quiz review pages showing exactly how each question in an attempt at a Reader quiz was answered.

**否**
: Do NOT add links from the values on the Reader report pages to quiz review pages.

此設定只會影響教師。但學生也會受到影響因為他們不能進入Reader報告頁面。';
$string['showwordcount'] = '只題示字數';
$string['skipline'] = '跳過行：{$a}';
$string['skipped'] = '已跳過';
$string['skipquizdownload'] = '測驗"{$a->quizname}"已存在"{$a->coursename}"中的章節{$a->sectionnum}, "{$a->sectionname}"，並已經跳過';
$string['sofar'] = '至今';
$string['sortfields'] = '分類欄';
$string['sort_strings'] = '分類字符串';
$string['sort_stringsdesc'] = '分類閱讀器模組的字符串';
$string['startbookdetailed'] = '現時沒有此報告可用的資料。';
$string['startbooksummary'] = '現時沒有此報告可用的資料。';
$string['starteditcourse'] = '**準備開始**

在此頁面，您可以編輯及移除此課程可用的閱讀器圖書。您亦可以新增圖書至此課程，只要圖書已經從Moodle網站中下載。';
$string['starteditsite'] = '**準備開始**

在此頁面，您可以編輯及移除此課程可用的閱讀器圖書。要新增圖書至此課程，請使用下載頁面。';
$string['startgroupsummary'] = '現時沒有此報告可用的資料。';
$string['startlevel'] = '開始水平';
$string['startuserdetailed'] = '現時沒有此報告可用的資料。';
$string['startusersummary'] = '現時沒有此報告可用的資料。';
$string['stoplevel'] = '最高水平';
$string['stoplevelforce'] = '應用此數值至全部現有用戶';
$string['stoplevel_help'] = '學生不能自動升級超過這個水平。';
$string['strfattempttime'] = '%Y %b %d (%a) %H:%M';
$string['strfattempttimeshort'] = '%Y %b %d (%a) %H:%M';
$string['studentmanagement'] = '學生管理';
$string['studentslevels'] = '變更學生水平，升遷政策及目標';
$string['studentuserid'] = '學生用戶帳號';
$string['studentusername'] = '學生用戶名稱';
$string['studentview'] = '學生模式';
$string['subnetwrong'] = '這測驗只能在指定位置中存取，而此電腦不在允許的清單中。';
$string['summaryreportbybooktitle'] = '由書名的總結報告';
$string['summaryreportbyclassgroup'] = '由課堂群組總結報告';
$string['takequizfor'] = '為"{$a}"進行測驗';
$string['takethisquiz'] = '進行此測驗';
$string['targetcategory'] = '目標分類';
$string['targetcategory_help'] = '這個課程分類包含了您想要為指定圖書下載測驗的課程。';
$string['targetcourse'] = '目標課程';
$string['targetcourse_help'] = '選擇您想要為指定圖書下載測驗的課程。通常您需要下載閱讀器模組只用作儲存測驗的隱藏課程。

從以下選項中選擇一項課程類型：

**全部**
：在此Moodle網站中的課程清單中選擇

**隱藏**
：在只有您可見，從學生中隱藏的課程清單中選擇。通常你應該選擇此選項。

**可見**
：在只有您及已註冊學生可見的課程清單中選擇。


**現有**
：閱讀器測驗將會下載至現有課程


**新的**
：閱讀器測驗將會下載至新的課程。在文字框中輸入新課程名稱。';
$string['targetsection'] = '目標部分';
$string['targetsection_help'] = '指定課程部分，即是星期或主題，到您想要下載的測驗。
以下類型的部分可用：

**預設部份**
：相對圖書的測驗將會根據"出版者－水平"來分組及設置在部份中。

**隱藏部份**
：測驗將會設置在課程的隱藏部份中。

**可見部份**
：測驗將會設置在課程的已選可見部份中。

**最後部份**
：測驗將會加到課程中的最後部份

**新的部份**
：測驗將會加到新的部份。在文字框中輸入新部份名稱。';
$string['termtype'] = '學期';
$string['therehavebeennonewquizzesorupdates'] = '自從您上次的登入，MoodleReader題庫中沒有新的測驗或更新。';
$string['thisattempt'] = '此作答';
$string['thisblockunavailable'] = '此區塊是學生當前不可用。';
$string['thislevel'] = '在現有水平的測驗';
$string['thislevel_help'] = '學生在現時閱讀水平中最少是通過測驗的數目，以晉升到另一個水平。注意，只有在最近升遷中的合格測驗會算進下一個水平升遷的數目中';
$string['thisterm'] = '此學期';
$string['timefinish'] = '完成時間';
$string['timeleft'] = '剩餘時間';
$string['timestart'] = '開始時間';
$string['to'] = '致';
$string['tools'] = '工具';
$string['totalpoints'] = '總得分';
$string['totalpointsallterms'] = '總得分（所有學期）';
$string['totalpointsgoal'] = '字數／分數目標';
$string['totalpointsgoal_help'] = '學生有望在本學期積累的字數／分數';
$string['totalpointsthisterm'] = '總得分（本學期）';
$string['totalwords'] = '總字數';
$string['totalwordsallterms'] = '總字數（所有學期）';
$string['totalwordsthisterm'] = '總字數（本學期）';
$string['transferfromcourse'] = '從課程中轉移';
$string['type'] = '類型';
$string['type_help'] = '選擇要顯示在下面的列表中書籍類型：

**包含測驗的圖書**
：頁面顯示了可以下載的包含測驗的圖書的清單

**不包含測驗的圖書**
：頁面顯示了圖書的資料，包括難易度及字數，但尚沒有建立任何測驗';
$string['uniqueip'] = '需要唯一的IP';
$string['update'] = '更新';
$string['updatedon'] = '在{$a}已更新';
$string['updatequizzes'] = '已更新測驗';
$string['updates'] = '更新';
$string['updatesavailable'] = '有{$a}可用的更新';
$string['updatinggrades'] = '正更新閱讀器成績';
$string['upgradeoldquizzesinfo'] = '更新已經停止，您可以決定是否在Moodle網站中保留舊版本的閱讀器模組測驗。

如果您選擇"是"，將會保留所有舊的閱讀器測驗。如果您想要保留舊閱讀器測驗中的答案數據，選擇此選項。

如果您選擇了"否"，只會保留每個測驗的最新版本，將會刪除重複的舊版本閱讀器測驗。如果您不需要舊閱讀器測驗中的答案數據或您想要整理閱讀器測驗的頁面，選擇此選項。

注意，即使您選擇了"否"，在閱讀器活動中的字數將不會受到影響。

您想要保留舊版本的閱讀器模組測驗嗎？';
$string['upgradestalefiles'] = '偵察了混合的閱讀器模組版本，不能繼續更新';
$string['upgradestalefilesinfo'] = '已停止Moodle更新進程，因為舊版本的閱讀器模組中的檔案已在"mod/reader"目錄中被檢測。

這可能會導致日後的問題，所以要繼續的話，您必須確保"mod/reader"目錄只有單一版本的閱讀器模組檔案。

清除"mod/reader"目錄的建議方法是：

*移除現有的"mod/reader"目錄，或至少從"mod"目錄中移除
*建立新的"mod/reader"目錄，只包含從標準閱讀器模組的壓縮下載或從GIT知識庫中的檔案。

或者，如果您提供遞歸撰寫權限至下列的"mod/reader"檔案，檔案將會在您恢復更新時自動刪除：

* {$a->dirpath}

阻擋了更新的 "mod/reader"檔案：
{$a->filelist}


如果您想要的話，您亦可以自已刪除上列的檔案。

點擊以下的按鍵以恢復Moodle更新進程';
$string['uploaddatanoquizzes'] = '為沒有測驗的圖書下載資料';
$string['uploadquiztoreader'] = '從閱讀器測驗資料庫中下載測驗';
$string['usecourse'] = '閱讀器測驗課程';
$string['usecourse_help'] = '在Moodle網站中包括了此閱讀器活動的閱讀器測驗的課程。
此課程需要從學生中隱藏。一般來說，包括了從外部閱讀器測驗庫中下載的測驗，例如：moodlereader.net';
$string['usedefaultquizid'] = '總是使用預設的測驗';
$string['userexport'] = '匯出用戶資料';
$string['userimport'] = '匯入用戶資料';
$string['userlevel'] = '用戶水平';
$string['usernamenotfound'] = '沒有找到用戶名稱：{$a}';
$string['users'] = '用戶';
$string['usersallwith'] = '所有已至少作答一次測驗的用戶';
$string['usersenrolledall'] = '所有已註冊的用戶';
$string['usersenrolledwith'] = '所有已至少作答一次測驗的已註冊用戶';
$string['usersenrolledwithout'] = '尚未作答任何測驗的已註冊用戶';
$string['usersetgoals'] = '設定用戶目標';
$string['usersetlevels'] = '設定用戶水平';
$string['usersetmessage'] = '設定給用戶的訊息';
$string['usersexport'] = '匯出資料';
$string['usersimport'] = '匯入資料';
$string['userssetgoals'] = '設定目標';
$string['userssetlevels'] = '設定水平';
$string['userssetmessage'] = '設定訊息';
$string['usertype'] = '包括的用戶';
$string['use_this_course'] = '使用這個課程';
$string['valueoutofrange'] = '數值必須介乎 {$a->min} 及 {$a->max}之間';
$string['viewattempts'] = '查看及刪除作答';
$string['viewlogsuspiciousactivity'] = '查看可疑活動的日誌';
$string['windowclosing'] = '此視窗將會馬上關閉。';
$string['withoutdayfilter'] = '排除日期過濾器';
$string['words'] = '字';
$string['wordscount'] = '字數';
$string['wordsorpoints'] = '顯示字數及分數';
$string['wordsorpoints_help'] = '**只顯示字數**
：在報告頁面中，只顯示作答的字數。

**只顯示分數**
：在報告頁面中，只顯示作答的分數

**顯示字數及字數**
：在報告頁面中，顯示作答的分數及字數。';
$string['youcannottake'] = '您不能夠在閱讀水平 {$a}進行更多的測驗';
$string['youcannotwait'] = '此測驗將會在您允許進行另一個作答前關閉。';
$string['youcantakeaquizafter'] = '您可以在{$a}之後進行測驗';
$string['youcantakeaquiznow'] = '您現在可以進行測驗。';
$string['youcantakeasmanyquizzesasyouwant'] = '您可以在水平{$a}進行您想要次數的測驗。';
$string['youcantakeplural'] = '您可以在閱讀水平{$a->level}進行{$a->count} 更多的測驗。此圖書會算進您的閱讀量，但不會算進您的升遷。';
$string['youcantakesingle'] = '您可以在升遷進行多一個測驗。此圖書會算進您的閱讀量，但不會算進您的升遷。';
$string['youcantakeunlimited'] = '您可以在水平{$a}進行您想要次數的測驗。';
$string['youhavebeenpromoted'] = '恭喜！您已經遞升至水平{$a}';
$string['youmustpassplural'] = '要升遷，您必須在閱讀水平{$a->level}中取得{$a->count} 更多的合格測驗。';
$string['youmustpasssingle'] = '要升遷，您必須在閱讀水平{$a->level}中取得多一個{$a->count} 的合格測驗。';
$string['youmustwait'] = '您必須等候以再次進行此測驗。您將可以在{$a}之後開始作答。';
$string['yourcurrentlevel'] = '您現時的閱讀水平已設定為{$a}';
$string['youwerepromoted'] = '您已在{$a->date} 的 {$a->time}升遷到閱讀水平{$a->level}。';
