<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fusion', language 'zh_tw', branch 'MOODLE_27_STABLE'
 *
 * @package   theme_fusion
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
	<div class="theme_screenshot">

<h2>fusion</h2>
<img src="fusion/pix/screenshot.jpg" />

<h3>布景主題討論區：</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

<h3>布景主題致謝</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

<h3>布景主題文檔</h3>
<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

<h3>錯誤提報：</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">

<h2>關於</h2>
<p>fusion是一個雙欄、可變寬度的Moodle 2.0主題。它支援在每頁網站標題上方顯示自定義功能表。它還有一個基本的設定頁面，可以讓你修改鏈結顏色，在首頁站名上添加標語，和添加頁腳文字。</p>

<h2>父布景主題</h2>
<p>本布景主題基於Moodle核心的Base和Canvas主題構建。如果除了設置裏提供的定制功能以外，您還想做其他修改，我們建議您創建一個新主題，並將本主題、Base和Canvas做為父主題。這樣這三個核心主題中任意一個的更新都能反映到您的布景主題上。</p>

<h2>致謝</h2>
<p>本布景主題最初是由Digital Nature (hello@digitalnature.ro)設計，Patrick Malley (patrick@newschoollearning.com)將其移植到Moodle 2.0。

<h2>授權</h2>
<p>Moodle核心提供的所有布景主題，包括此布景主題的授權協定都是<a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>。
</div>
</div>';
$string['configtitle'] = '融合設定';
$string['customcss'] = '自訂的CSS';
$string['customcssdesc'] = '您在此設定的所有CSS都會被附加到每個頁面中，這樣您就可以方便地訂製此主題。';
$string['footertext'] = '頁腳文字';
$string['footertextdesc'] = '設定角注或頁腳文字';
$string['linkcolor'] = '鏈結顏色';
$string['linkcolordesc'] = '在此設置主題的鏈結顏色';
$string['pluginname'] = 'Fusion';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['tagline'] = '標語';
$string['taglinedesc'] = '要顯示在首頁的網站名稱下方的一段標語。<br />';
