<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'turnitintooltwo', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   turnitintooltwo
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addresubmissiontiidesc'] = '用戶的重新提交已傳送到Turnitin';
$string['addsubmission'] = '新增提交';
$string['addsubmissiondesc'] = '用戶已增加提交';
$string['addsubmissiontiidesc'] = '用戶的提交已傳送到Turnitin';
$string['allowlate'] = '允許在截止日期後的提交';
$string['allownonor'] = '允許任何檔案的類型提交？';
$string['allownonor_help'] = '此設定將會允許提交任何檔案類型。當設定意選項為"是"，遞交在可能的情況下將會檢查其原創性、遞交在可能的情況下將可以下載及在可能的情況下可以使用線上評分（GradeMark）回饋工具。';
$string['allsubmissions'] = '遞交收件箱';
$string['anon'] = '匿名';
$string['anonalert'] = '您的發佈日期早於您的現在時間，如果您選擇儲存，這會永久取消此作業的匿名評核。';
$string['anonblindmarkingnote'] = '注意： 已移除分隔Turnitin匿名評分設定。Turnitin將會使用Moodle的不記名評分設定來決定匿名評分設定';
$string['anonenabled'] = '取消匿名評分';
$string['anytype'] = '任何提交類型';
$string['assigngeterror'] = '不能取得turnitintooltwo資料';
$string['assignmenttitle'] = '新的作業標題';
$string['attachrubric'] = '在此作業附上紅字';
$string['attachrubricnote'] = '注意：學生將可以在提交前查看附件的紅字及內容。';
$string['autorefreshgrades'] = '自動重新載入成績／分數';
$string['autorefreshgrades_help'] = '在默認設定中，在每次呼叫Turnitin後，Moodle整合外掛程式會嘗試自動摘取在Turnitin期間時的變更。您可以使用此選項以關閉此功能，但為了維持兩個系統的同步，您需要經常在Moodle手動刷新成績及原創性分數／';
$string['ced'] = '課程完結日期';
$string['changerubricwarning'] = '變更或分離紅字將會從作業的文稿中移除所有現有的紅字評分，包括已評核的評分卡。將會保留已評核作業的整體分數。';
$string['checkagainstnote'] = '注意： 如果您在以下"對證..."的選項中至少點選一個"是"，將不會生成任何原創性報告。';
$string['checkingupgrade'] = '正檢查可用的更新';
$string['checkupdateavailableerror'] = '不能檢查Moodle直接版面更新';
$string['checkupgrade'] = '檢查可用的更新';
$string['classcreationerror'] = 'Turnitin課程創建失敗';
$string['classupdateerror'] = '不能更新Turnitin課程資料';
$string['close'] = '關閉';
$string['closebutton'] = '關閉';
$string['code'] = '編號';
$string['compareinstitution'] = '將已提交檔案中的文稿對比在此機構中已提交的作業';
$string['config'] = '配置';
$string['configupdated'] = '已更新配置';
$string['configureerror'] = '您必須以管理者身份配置此模組後才可以在課程中使用。請聯絡您的Moodle管理員。';
$string['connecttest'] = '測試Turnitin連接';
$string['connecttestcommerror'] = '不能連接Turnitin。請再次檢查您的API網址設定。';
$string['connecttesterror'] = '連接Turnitin時發生錯誤，錯誤訊息為：<br />';
$string['connecttestsuccess'] = '已成功連接Moodle到Turnitin';
$string['copyassigndata'] = '複製Turnitin作業資料';
$string['copyrightagreement'] = '點選此格代表您確認此提交為個人作品及接受所有有關是次提交可能會發生的侵犯版權的全權責任。';
$string['copyrightagreementerror'] = '請勾選此格來標明您在提交前接受協議。';
$string['course'] = '享程';
$string['coursebrowserassignmentdesc'] = '在下列的表格，您可以最多選擇5份作業來創建在Moodle中的Turnitin複製作業的部份。';
$string['coursebrowserdesc'] = '您可以搜尋Turnitin來重建作為下列課程中Moodle上的課程。';
$string['courseexistsmoodle'] = '此課程現時在Moodle上為：';
$string['coursegeterror'] = '不能取得課程資料';
$string['coursegettiierror'] = '不能從Turnitin中取得課程資料';
$string['courseiderror'] = '課程編號不正確';
$string['coursemisconfigured'] = '課程配置錯誤';
$string['coursemodidincorrect'] = '課程模組編號不正確';
$string['coursemodincorrect'] = '課程模組不正確';
$string['coursestomigrate'] = '您在Turnitin中有{$a}課程需要修復。';
$string['coursetitle'] = '課程標題';
$string['coursetitleerror'] = '您必須提供用作搜尋的課程標題';
$string['createassignmenterror'] = '當嘗試在Turnitin上創建作業時出現了錯誤。';
$string['createcourse'] = '創建新的Moodle課程';
$string['created'] = '已創建';
$string['createmoodleassignments'] = '重建所有在Moodle上已選課程的作業？';
$string['createmoodlecourses'] = '重建課程';
$string['createsubmissionerror'] = '當嘗試在Turnitin上創建提交時出現了錯誤。';
$string['cronsubmittedsuccessfully'] = '遞交：課程{$a->coursename}的作業 {$a->assignmentname} ，{$a->title} (TII ID: {$a->submissionid})已成功提交到Turnitin。';
$string['crontaskmodeactive'] = 'Turnitintooltwo－中止Cron通話，因為現行任務模式';
$string['defaultassignmenttiititle'] = 'Turnitin中的作業';
$string['defaultcoursetiititle'] = 'Turnitin中的課程';
$string['defaultinserterror'] = '當嘗試插入默認設定至數據庫時出現了錯誤。';
$string['defaults'] = '默認設定';
$string['defaultsdesc'] = '當啟用Turnitin中的活動模組時，以下設定為默認設定集';
$string['defaults_desc'] = '下列設定為用作Moodle直接Turnitin作業2新例子的默認設定。';
$string['defaultupdated'] = '已更新Turnitin默認';
$string['defaultupdateerror'] = '當嘗試更新數據庫中默認設定時出現了錯誤。';
$string['deletable'] = '可刪除';
$string['deleteassignmenterror'] = '當在Turnitin刪除此作業時出現了錯誤';
$string['deleteconfirm'] = '您確定要刪除此遞交？此動作將不能撤消。';
$string['deletepart'] = '刪除部份';
$string['deletesubmission'] = '刪除提交';
$string['deletesubmissiondesc'] = '用戶已刪除此提交';
$string['deletesubmissiontiidesc'] = '用戶已在Turnitin中刪除此提交';
$string['diagnosticoptions_0'] = '關閉';
$string['diagnosticoptions_1'] = '標準';
$string['diagnosticoptions_2'] = '調試中';
$string['digitalreceipt'] = '電子回條';
$string['digital_receipt_message'] = '致{$a->firstname} {$a->lastname}，您在<strong>{$a->submission_date}</strong>已成功提交<strong>{$a->course_fullname}</strong>中的<strong>{$a->assignment_name}{$a->assignment_part}</strong>的<strong>{$a->submission_title}</strong> 的檔案。您的提交編號是<strong>{$a->submission_id}</strong>。您的完整電子回條可以在檔案檢視器中的列印／下載的按鈕中檢視和下載。<br /><br />感謝使用Turnitin，<br /><br /> Turnitin團隊';
$string['digital_receipt_subject'] = '這是您的Turnitin電子回條';
$string['disableanonconfirm'] = '選擇此將會永遠取消此作業匿名評分，您確定？';
$string['displaygradesas'] = '成績顯示';
$string['displaygradesasfraction'] = '以分數顯示成績';
$string['displaygradesas_help'] = '此選項會設定成繽的顯示模式，選項為以百分比顯示或以分數顯示，例如，45/60。';
$string['displaygradesaspercent'] = '以百分比顯示成績';
$string['download'] = '下載';
$string['downloadassignment'] = '下載作業至Moodle';
$string['downloadexport'] = '匯出';
$string['downloadgrademarkzip'] = '下車已選的線水評分（GradeMark｝文件';
$string['downloadgradexls'] = '匯出成績（XLS）';
$string['downloadorigfileszip'] = '下載完本';
$string['downloadorigzip'] = '壓縮檔案（原本）';
$string['downloadpdfzip'] = '壓縮檔案（PDF）';
$string['downloadsubmission'] = '下載提交';
$string['draftsubmit'] = '此檔件將會何時提交到Turnitin？';
$string['dtdue'] = '截止日期';
$string['dtpost'] = '發佈日期';
$string['dtstart'] = '開始日期';
$string['duplicatesfound'] = '找到相同Turnitin作業的重複副本，當一份或更多Moodle直接作業通過Turnitin API連接到相同的Turnitin作業，將會有重複的副本。這是已知會導致問題，當用作重複的提交出現在遞交收件箱時。要解決此，您可以刪除重複的作業或重設有重複作業的課程。<br /><br />已找到以下的重複：';
$string['editassignmenterror'] = '當嘗試編輯在Turnitin的作業時出現了錯誤';
$string['emptycreatedfile'] = '您嘗試提交的檔案是空白或損毀';
$string['enableperformancelogs'] = '啟用網絡表現日誌';
$string['enableperformancelogs_desc'] = '如果啟用，每個到Turnitin伺服器的要求將會記錄在{tempdir}/turnitintooltwo/logs';
$string['enablepseudo'] = '啟用學生隱私';
$string['enablepseudo_desc'] = '如果選擇此選項，學生電郵地址將會轉換至相等於冒充的Turnitin API通話。<br /><i>(<b>注意:</b> 此選項將不能轉換當任何Moodle用戶資料已與Turnitin同步)</i>';
$string['enrolling'] = '在Turnitin上的正就讀學生';
$string['erater'] = '啟用e-rater語法檢查';
$string['erater_categories'] = 'e-rater類別';
$string['erater_dictionary'] = 'e-rater字典';
$string['erater_dictionary_en'] = '包括美國及英國的英語字典';
$string['erater_dictionary_engb'] = '英國英語字典';
$string['erater_dictionary_enus'] = '美國的英語字典';
$string['erater_grammar'] = '語法';
$string['erater_handbook'] = 'ETS&複製; 手冊';
$string['erater_handbook_advanced'] = '進階';
$string['erater_handbook_elementary'] = '小學';
$string['erater_handbook_highschool'] = '中學';
$string['erater_handbook_learners'] = '英語學習者';
$string['erater_handbook_middleschool'] = '中學';
$string['erater_mechanics'] = '構成';
$string['eraternoun'] = 'E-rater';
$string['erater_spelling'] = '拼寫';
$string['erater_style'] = '風格';
$string['erater_usage'] = '用法';
$string['errorenrollingall'] = '當註冊所有學生至Turnitin時出現了錯誤。請詢問您的系統管理員。';
$string['errors'] = '錯誤';
$string['errorsdesc'] = '當嘗試上載以下檔案至Turnitin時出現了問題';
$string['eventremoved'] = '此事件已從cron隊列中被移除並不會再次處理';
$string['excludebiblio'] = '排除參考書目';
$string['excludebiblio_help'] = '此設定允許教師選擇在生成原創性報告時檢查配對排除出現在參考書目的文字、參考文獻或學生文稿中的引用。此設定可以取代個人原創性報告。';
$string['excludepercent'] = '百分比';
$string['excludequoted'] = '排除已引用材料';
$string['excludequoted_help'] = '此設定允許教師選擇在生成原創性報告排除檢查時配對出現的引用。此設定可以取代個人原創性報告。';
$string['excludevalue'] = '排除較小的符合處';
$string['excludevalue_help'] = '此設定允許教師選擇在生成原創性報告時檢查配對排除出現的不太長的匹配（由教師判定）。此設定可以取代個人原創性報告。';
$string['excludewords'] = '詞語';
$string['faultcode'] = '錯誤代碼';
$string['filebrowser'] = 'Moodle直接檔案瀏覽器';
$string['filedeleteconfirm'] = '您確定要刪除此檔案？這個動作不能撤消。';
$string['filedoesnotexist'] = '已刪除檔案';
$string['filename'] = '檔案名稱';
$string['files'] = '檔案';
$string['filetosubmit'] = '要提交的檔案';
$string['filetosubmit_help'] = '當提交用作作業一部份的檔案時，在您的電腦上瀏覽使用此格式元素的上載檔案';
$string['fileupload'] = '上載檔案';
$string['genduedate'] = '在截止日期生成報告（在到期日前允許重新提交）';
$string['genimmediately1'] = '即時生成報告（不允許重新提交）';
$string['genimmediately2'] = '即時生成報告（在截止日期前允許重新提交）';
$string['genspeednote'] = '注意：生成重新提交的原創性報告會受到24小時延遲。';
$string['getassignmenterror'] = '不能從Turnitin中取得遷移作業';
$string['grademark'] = '網上評分（GradeMark）';
$string['grademarkzip'] = '選擇網上評分（GradeMark）檔案';
$string['gradenosubmission'] = '用戶可以在沒有提交作業的情況下被評分';
$string['gradingtemplate'] = '成績範本';
$string['helpdesklink'] = '需要Turnitin的協助嗎？';
$string['hidepeermark'] = '隱藏同儕評鑑作業';
$string['hidepeermarkinstructions'] = '隱藏同儕評鑑指引';
$string['hidesummary'] = '隱藏作業摘要';
$string['id'] = 'ID';
$string['inactive'] = '非活躍';
$string['institutionalcheck'] = '與機構資料庫作對比';
$string['institutionalchecksettings'] = '對比<br />機構資料庫';
$string['institutionalrepository'] = '機構資料庫（如適用）';
$string['instructor'] = '教師';
$string['instructorreceipt'] = '提交時通知教師';
$string['instructorreceipt_desc'] = '選擇當已提交作業時是否傳送通知到課程的教師';
$string['integration'] = '整合';
$string['internetcheck'] = '對比互聯網';
$string['internetcheck_help'] = '當生成文稿的原創性報告時，與互聯網資料庫作對比。相似度百分比會下降如果沒有選取此。';
$string['journalcheck'] = '與期刊、<br /> 刊物及成果發表對證';
$string['journalcheck_help'] = '當生成文稿的原創性報告時，與與期刊、刊物及成果發表作對比。相似度百分比會下降如果沒有選取此。';
$string['launchgrademark'] = '網上評分（GradeMark）';
$string['launchpeermarkmanager'] = '啟用同儕評鑑（Peermark）管理員';
$string['launchpeermarkreviews'] = '啟用同儕評鑑（Peermark）反饋';
$string['launchquickmarkmanager'] = '啟用快速評分（Quickmark）管理員';
$string['launchrubricmanager'] = '啟用紅字管理員';
$string['launchrubricview'] = '查看用作評分的紅字';
$string['launchrubricviewshort'] = '評分的紅字';
$string['layoutoptions_0'] = '全屏寬度';
$string['layoutoptions_1'] = 'Moodle的默認 - 導航';
$string['line'] = '線';
$string['linkcourse'] = '連接遊程至現有Moodle課程';
$string['listsubmissions'] = '列舉遞交';
$string['listsubmissionsdesc'] = '用戶已查看課程的遞交清單';
$string['listsubmissionsdesc_student'] = '用戶已查看課程的遞交收件箱';
$string['loadingdv'] = '正載入Turnitin檔案檢視器...';
$string['marksavailable'] = '標記可用';
$string['maxfilesize'] = '檔案容量上限';
$string['maxfilesize_help'] = '此設定判定每個遞交作業的檔案容量上限。此數值的最高值是根據課程中的數值來設定，此數值將會封頂至檔案容量上限40Mb，相等於Turnitin檔案容量上限。';
$string['maxlength'] = '{$a->field}的長度上限是{$a->length}字符';
$string['maxmarks'] = '分數上限';
$string['maxmarkserror'] = '分數上限必須是0至100.';
$string['membercheckerror'] = '當您嘗試檢查已註冊此課程的用戶時出現了錯誤。';
$string['message'] = '訊息';
$string['messagenonsubmitters'] = '通知非提交者';
$string['messageprovider:nonsubmitters'] = 'Turnitin作業非提交者通知';
$string['messageprovider:notify_instructor_of_submission'] = 'Turnitin作業教師電子回條的通知';
$string['messageprovider:submission'] = 'Turnitin作業電子回條的通知';
$string['messagesinbox'] = 'Turnitin訊息收件箱';
$string['migrationassignmentcreated'] = '已建立遷移作業－Id: {$a}';
$string['migrationassignmentcreationerror'] = '不能建立遷移作業 - 課程 {$a}';
$string['migrationassignmenterror1'] = '不能增加新的課程模組至課程{$a}';
$string['migrationassignmenterror2'] = '不能增加新的課程模組至這部份－課程{$a}';
$string['migrationassignmenterror3'] = '不能建立遷移作業的事件－課程{$a}';
$string['migrationassignmentgeterror'] = '不能在Turnitin上取得任何作業';
$string['migrationassignmentpartcreated'] = '已建立遷移作業的部份－Id: {$a}';
$string['migrationcoursecreated'] = '已重建Moodle上的Turnitin課程';
$string['migrationcoursecreatederror'] = '已重建課程{$a} 但儲存鏈接時出現錯誤';
$string['migrationcoursecreateerror'] = '課程{$a}不能在Moodle上建立';
$string['migrationcoursegeterror'] = '不能取得Turnitin中的任何課程';
$string['module'] = '模組';
$string['modulename'] = 'Turnitin作業2';
$string['modulename_help'] = '創建連接Moodle上的活動至Turnitin的作業的Turnitin Moodle直接作業。一旦連接了，活動允許教師進入學生文稿及提供回饋，使用Turnitin檔案瀏覽器的作業工具。';
$string['modulenameplural'] = 'Turnitin作業';
$string['moduleversion'] = '版本';
$string['moodlelinked'] = '已連接到Moodle';
$string['mysubmissions'] = '我的提交';
$string['newcourseenddate'] = '新的課程完結日期';
$string['newenddatedesc'] = '在下方選擇新的課程完結日期，之後將會在Turnitin上更新';
$string['no'] = '否';
$string['nogrades'] = '否，我將會手動刷新原創性分數及成績';
$string['nointegration'] = '沒有整合';
$string['nolimit'] = '沒有限制';
$string['nombstringlibrary'] = '要使用此外掛程式，您需要安裝PHP mbstring擴充在您的伺服器上';
$string['nonenrolledstudent'] = '非註冊學生';
$string['nonmoodleuser'] = '非Moodle用戶';
$string['nonsubmitterserror'] = '請提供電郵的主題及內容';
$string['nonsubmittersformdesc'] = '請在下列地方輸入訊息來傳送給尚未提交此作業的學生';
$string['nonsubmittersformsuccess'] = '己傳送您給非提交者的訊息';
$string['nonsubmittersmessage'] = '訊息';
$string['nonsubmittersmessageerror'] = '請提供此電郵訊息';
$string['nonsubmitterssendtoself'] = '傳送此訊息的副本給我';
$string['nonsubmitterssubject'] = '主題';
$string['nonsubmitterssubjecterror'] = '請提供此電郵主題';
$string['nonsubmitterssubmit'] = '傳發電郵';
$string['noofreviewsrequired'] = '回饋需要的數目';
$string['noreason'] = '沒有指明的原因';
$string['norepository'] = '沒有資輝庫';
$string['norubric'] = '沒有紅字';
$string['noscript'] = 'Turnitin需要Javascript但您的瀏覽器沒有開啟Javascript。請在您的瀏覽器中開啟Javascript以使用Turnitin的完整功能。';
$string['noscriptsummary'] = 'Turnitin需要Javascript但您的瀏覽器沒有開啟Javascript。沒有啟用Javascript的話，您將不能夠進入Turnitin。';
$string['noscriptula'] = '（因為您沒有啟用Javascript，在同意協議後，提交前您將需要手動刷新此頁面）';
$string['nosubmissiondataavailable'] = '沒有其他可用的提交資料';
$string['nosubmissions'] = '尚未有遞交';
$string['notavailableyet'] = '沒有可用';
$string['notorcapable'] = '不可能為此檔案生成原創性報告';
$string['noturnitinassignemnts'] = '沒有Turnitin作業';
$string['notutors'] = '在此Turnitin課程中沒有已註冊的導師';
$string['noxmlwriterlibrary'] = '要使用此外掛程式，您需要在伺服器安裝PHP XMLWritier擴充。';
$string['numberofparts'] = '部份的數目';
$string['numberofparts_help'] = '允許創建多部份作業，學生用戶可以在每個部份提交一份作業。';
$string['objectid'] = 'Turnitin文稿編號';
$string['offlinestatus'] = 'Turnitin已設定為離線。 （變數 $CFG->tiioffline已設定為開啟）';
$string['or'] = '或者';
$string['origfileszip'] = '原始文件';
$string['otherrubric'] = '使用屬於其他教師的紅字';
$string['overallgrade'] = '整體成績';
$string['overallgrade_help'] = '整體成績決定整體作業的最高容許成績，作業的每個部份都分配了最高的分數，並會按比例分配分數以判定整體成績。';
$string['partdberror'] = '當輸入部份{$a} 到數據庫時出現了問題<br />';
$string['partdeleted'] = '作業部份已被刪除';
$string['partdeleteerror'] = '不能刪除作業部份{$a}的資料';
$string['partdeletewarning'] = '您嘗試刪除的作業部份包含了遞交。如果您選擇刪除作業部份，您將會失去這些遞交。您確定要繼續嗎？';
$string['partdueerror'] = '開始日期必須在截止日期前';
$string['partgeterror'] = '不能取得作業部份的資料';
$string['partname'] = '作業部份';
$string['partnameerror'] = '部份名稱不能留空。';
$string['partnametoolarge'] = '部份名稱太長。請限制於40個字符內。';
$string['partposterror'] = '開始日期必須在發佈日期前';
$string['partupdateerror'] = '當更新部份{$a} 到數據庫時出現了問題<br />';
$string['peermark'] = '同儕評鑑';
$string['peermarkassignments'] = '同濟評鑑作業';
$string['pending'] = '待定';
$string['permissiondeniederror'] = '您沒有合適的權限完成要求的指令。';
$string['pluginadministration'] = 'Turnitin 作業2管理';
$string['pluginname'] = 'Turnitin 作業2';
$string['portfolio'] = '檔案';
$string['postdate_warning'] = '請注意當成績是設定為學生可見及學生身份是透露給教師，更改作業日期會可能受影響。';
$string['ppassignmentcreateerror'] = '不能在Turnitin建立此模組，請詢問您的API 日誌以取得更多資料。';
$string['ppassignmentediterror'] = '模組{$a->title} (TII ID: {$a->assignmentid}) 不能在Turnitin上修改, 請詢問您的API 日誌以取得更多資料。';
$string['pp_classcreationerror'] = '不能在Turnitin上建立課堂，請詢問您的API 日誌以取得更多資料。';
$string['pp_createsubmissionerror'] = '當建立遞交時，剽竊外掛程式出現了錯誤';
$string['pp_submission_error'] = 'Turnitin已就您的遞交傳回錯誤訊息：';
$string['pp_updatesubmissionerror'] = '當更新遞交時，剽竊外掛程式出現了錯誤';
$string['print'] = '列印';
$string['proxypassword'] = 'Proxy密碼';
$string['proxypassword_desc'] = '<b>[自訂]</b><br />如果您的代理主機需要認證，請在此輸入您的密碼';
$string['proxyport'] = '代理端口';
$string['proxyport_desc'] = '<b>[自訂]</b><br />如果您的伺服器需要使用代理主機來連接互聯網，請在此輸入您的代理端口。';
$string['proxyurl'] = 'Proxy網址';
$string['proxyurl_desc'] = '<b>[自訂]</b><br />如果您的伺服器需要使用代理主機來連接互聯網，請在此輸入您的Proxy網址。';
$string['proxyuser'] = 'Proxy用戶名稱';
$string['proxyuser_desc'] = '<b>[自訂]</b><br />如果您的代理主機需要認證，請在此輸入您的用戶名稱';
$string['pseudoemailaddress'] = '假電郵地址';
$string['pseudoemaildomain'] = '假電郵域名';
$string['pseudoemaildomain_desc'] = '<b>[自訂]</b><br />假電郵地址的自訂域名 （會設成默認的@tiimoodle.com 如果留空)';
$string['pseudoemailsalt'] = '偽加密鹽';
$string['pseudoemailsalt_desc'] = '<b>[自訂]</b><br />自訂鹽會用作增加已生成的學生假電郵地址的複雜性。<br />(<b>注意:</b> 鹽需要保持不變以維持假電郵地址的一致性)';
$string['pseudofirstname'] = '學生偽名字';
$string['pseudofirstname_desc'] = '<b>[自訂]</b><br />在Turnitin檔案檢視器中顯示的學生名字';
$string['pseudolastname'] = '學生偽姓氏';
$string['pseudolastname_desc'] = '<b>[自訂]</b><br />在Turnitin檔案檢視器中顯示的學生姓氏';
$string['pseudolastnamegen'] = '自動生成姓氏';
$string['pseudolastnamegen_desc'] = '如果設定為是，學生偽姓氏會設定在用戶檔案欄中，此欄繼會自動填充獨特的標識符。';
$string['receiptassignmenttitle'] = '作業標題';
$string['receipt_instructor_copy'] = '遞交標題<strong>{$a->submission_title}</strong> 已創建到<strong>{$a->course_fullname}</strong>課堂中的作業<strong>{$a->assignment_name}{$a->assignment_part}</strong>。<br /><br />遞交編號: <strong>{$a->submission_id}</strong><br />遞交日期: <strong>{$a->submission_date}</strong><br />';
$string['receipt_instructor_copy_subject'] = '已創建遞交到作業';
$string['receiptparagraph'] = '此回條確認Turnitin已收到您的文稿。在下方您可以找到有關您的遞交的回條資料。';
$string['recreatemulticlasses'] = '您選擇的課堂正在重建中，根據您選擇的數目，將可能需要數分鐘。';
$string['recreatemulticlassescomplete'] = '已完成重建課程。已成功創建了{$a->total} 中的{$a->completed} 。';
$string['redirecttoeula'] = '我們正在討向您到最終用戶的許可協議';
$string['refid'] = '參考編號';
$string['relinkusers'] = '重新連接用戶';
$string['replaceassigndata'] = '取化Turinitin作業資料';
$string['reportgenspeed'] = '報告生成速度';
$string['reportgenspeed_help'] = '作菜設定有三個選項：\'即時生成報告（不允許重新提交）\'；\'即時生成報告（在截止日期前允許重新提交）\'； \'在截止日期生成報告（在截止日期前允許重新提交）\'；<br /><br />

\'即時生成報告（不允許重新提交）\'的選項將會在學生提交馬上生成報告，一經提交後將不能再次提交。<br /><br /> 要允許重新提交，選擇\'即時生成報告（在截止日期前允許重新提交）\'，這允許學生在截止日期前繼續提交作業。重新提交的作業可能需要24小時處理原創性報告。<br /><br />\'在截止日期生成報告（在截止日期前允許重新提交）\'的選項只會在截止日期時生成報告，所有提交到作業的文稿將會互相對比以生成原創性報告。';
$string['repositoryoptions_0'] = '啟用教師標準知識庫選項';
$string['repositoryoptions_1'] = '啟用教師擴張知識庫選項';
$string['repositoryoptions_2'] = '提交所有文稿到標準知識庫';
$string['repositoryoptions_3'] = '不要提交任何文稿到知識庫';
$string['restorationheader'] = 'Tutitin課堂恢復';
$string['resubmission'] = '重新提交';
$string['resubmissiongradewarn'] = '重新提交是允許直至截止日期前。當重新提交此文稿，所有成績將會刪除。您想要繼續嗎？';
$string['resubmissiongradewarnaware'] = '請注意當重新提交此文稿，所有成績將會刪除。';
$string['resubmit'] = '重新提交';
$string['resubmitselected'] = '重新提交已選檔案';
$string['resubmitting'] = '正重新提交';
$string['resubmittoturnitin'] = '重新提交至Turnitin';
$string['reveal'] = '透露';
$string['revealdesc'] = '請提供揭露學生姓名的原因。';
$string['revealerror'] = '您必須提供有效的原因以揭露學生姓名。';
$string['revealreason'] = '揭露的原因';
$string['savecourseenddate'] = '儲存新課程的完結日期';
$string['savecourseenddateerror'] = '當您嘗試儲存新課程的完結日期到Turnitin時出現了錯誤';
$string['saveusage'] = '儲存數據轉儲';
$string['searchcourses'] = '搜尋課程';
$string['selectcourse'] = '選擇Moodle課程';
$string['selectcoursecategory'] = '選擇課程分類';
$string['selectoption'] = '選擇選項';
$string['semptytable'] = '沒有找到的結果';
$string['setinstructordefaults'] = '儲存這些數值為作業的默認設定';
$string['setinstructordefaults_help'] = '這些設定將會在您創建任何Moodle直接Turnitin作業的新例子時使用。他們會凌駕系統管理員指定的默認設定並只限於您擁有。';
$string['settings'] = '設定';
$string['settingsinserterror'] = '當嘗試插入設定到數據庫時出現了錯誤。';
$string['settingsupdateerror'] = '當嘗試更新設定到數據庫時出現了錯誤。';
$string['sharedrubric'] = '已與公眾共享';
$string['showpeermark'] = '顯示同儕評鑑的作業';
$string['showpeermarkinstructions'] = '顯示同儕評鑑的說明';
$string['showsummary'] = '顯示作業的摘要';
$string['showusage'] = '顯示數據轉儲';
$string['similarity'] = '相似度';
$string['sinfo'] = '顯示_START_ to _END_ of _TOTAL_條目';
$string['slengthmenu'] = '顯示 _MENU_條目';
$string['snext'] = '下一個';
$string['source'] = '來源';
$string['spapercheck'] = '與已儲存的學生文稿作對比';
$string['spapercheck_help'] = '當處理原創性報告時，與已儲存的學生文稿庫作對比。相似度指數百分比會下降如果您沒有選擇此。';
$string['sprevious'] = '前';
$string['sprocessing'] = '從Turnitin中載入資料';
$string['ssearch'] = '搜尋：';
$string['standardrepository'] = '標澤庫';
$string['startdatenotyearago'] = '開始日期不能在一年之前';
$string['student'] = '學生';
$string['studentdataprivacy'] = '學生資料隱私設定';
$string['studentdataprivacy_desc'] = '可以設置以下的設定以確保學生的個人資料將不會透過API傳送到Turnitin';
$string['studentdisclosure'] = '學生信息披露';
$string['studentdisclosuredefault'] = '所有已上載的文件將會提交到剽竊檢測服務Turnitin.com';
$string['studentdisclosure_help'] = '此文字將會在檔案上載頁面大公開給所有學生';
$string['student_notread'] = '學生尚未查看此文稿';
$string['student_read'] = '學生查看此文稿在：';
$string['studentremoved'] = '學生已在Turnitiin的課程中移除';
$string['studentremovingerror'] = '當從Turnitiin的課程中移除學生時出現了問題';
$string['studentreports'] = '顯示原創性報告給學生';
$string['studentreports_help'] = '允許您顯示Turnitin原創性報告給學生用戶。如果設為是，Turnitin原創性報告將可以顯示給學生用戶';
$string['studentstatus'] = '已提交{$a->modified} (Paper ID: {$a->objectid})';
$string['submissionagreementerror'] = '您必須同意此遞交的協議';
$string['submissionauthor'] = '投交作者';
$string['submissiondate'] = '投交日期';
$string['submissiondeleted'] = '已刪除提交';
$string['submissiondeleteerror'] = '不能刪除提交';
$string['submissionextract'] = '提取提交';
$string['submissionfileerror'] = '您必須附上提交的文件';
$string['submissionfiletypeerror'] = '檔案類型不允許。允許的檔案類型是({$a})';
$string['submissiongeterror'] = '不能取的提交的資料';
$string['submissiongrade'] = '成績';
$string['submissionorig'] = '相似度';
$string['submissionpart'] = '提交部份';
$string['submissionpart_help'] = '選擇是次遞交中的Turnitin作業部份';
$string['submissions'] = '遞交';
$string['submissiontexterror'] = '您必須在遞交中包括文字';
$string['submissiontitle'] = '遞交標題';
$string['submissiontitleerror'] = '您必須在遞交中包括標題';
$string['submissiontitle_help'] = '為您正提交的文稿輸入遞交標題';
$string['submissiontype'] = '遞交類型';
$string['submissiontype_help'] = '<p>指明您在Turnitin中允許的遞交類型。</p>';
$string['submissionupdateerror'] = '不能更新遞交資料';
$string['submissionuploadsuccess'] = '您的遞交已成功上載至Turnitin';
$string['submitnothing'] = '啟用在沒有遞交的情況下的評分';
$string['submitnothingwarning'] = '為尚未提交文件的學生點擊灰色筆來創建評分範本，將會容許您給予學生線上評分回饋。評分範本會佔用提交的位置並學生提交不允許重新提交的作業。<br><br> 您確定要在沒有提交的情況下評分嗎？';
$string['submitondraft'] = '在第一次上載時提交文件';
$string['submitonfinal'] = '當學生傳送來評核時提交文件';
$string['submitpaper'] = '提交文稿';
$string['submitpapersto'] = '儲存學生文稿';
$string['submitpapersto_help'] = '此設定為教師提供選擇文稿是否儲存在Turnitin學生文稿庫的權限。提交文稿至學生文稿庫的好處是學生提交的作業可以與現時及過往班別中的學生文稿作對比。如果您選擇"沒有資料庫"，您的學生文稿將不會儲存在Turnitin學生文稿庫中。';
$string['submitted'] = '已提交';
$string['submittoturnitin'] = '提交至Turnitin';
$string['szerorecords'] = '沒有紀錄可顯示';
$string['task_name'] = 'Turnitin Cron任務';
$string['testingconnection'] = '正測試Turnitin的連接';
$string['textsubmission'] = '文字遞交';
$string['texttosubmit'] = '要提交的文字';
$string['texttosubmit_help'] = '複製及貼上您的文字遞交到此框格中';
$string['tiiaccountconfig'] = 'Turnitin 帳戶配置';
$string['tiiaccountsettings'] = 'Turnitin帳戶設定';
$string['tiiaccountsettings_desc'] = '請確保這個設定配合您Turnitin帳戶的配置，否則您將會在建立作業或學生提交時出現問題';
$string['tiiassignmentgeterror'] = '當嘗試在取我得從Turnitin中出現了錯效';
$string['tiidebugginglogs'] = '調試和日誌記錄';
$string['tiiexplain'] = 'Turnitin是商業產品，您必須有付費訂閱以使用服務。更多資料請到<a href=http://docs.moodle.org/en/Turnitin_administration>http://docs.moodle.org/en/Turnitin_administration</a>';
$string['tiimiscsettings'] = '其他外掛設置';
$string['tii_submission_failure'] = '請詢問您的導師或Moodle管理員以取得更多資料';
$string['tiisubmissiongeterror'] = '當您嘗試從Turnitin中取得遞交時出現了錯誤';
$string['tiisubmissionsgeterror'] = '當您嘗試從Turnitin中取得此作業的遞交時出現了錯誤';
$string['tiiusergeterror'] = '當您嘗試從Turnitin中取得用戶資料時出現了錯誤';
$string['title'] = '標題';
$string['transmatch'] = '翻譯匹配';
$string['transmatch_desc'] = '決定翻譯匹配是否在作業設置屏幕設成可用的設定。<br /><i>(啟用此選項如果您的Turnitin帳號已啟用翻譯匹配)</i>';
$string['turnitin'] = 'Turnitin';
$string['turnitinaccountid'] = 'Turnitin帳戶編號';
$string['turnitinaccountid_desc'] = '<b>[必要]</b><br />輸入您的Turnitin的主帳號ID';
$string['turnitinanon'] = '匿明評分';
$string['turnitinanon_help'] = '您可以設定此數值為"是"來配置您的Turnitin作業使用匿名評分。當已提交後，將不能夠取消匿名評分。';
$string['turnitinapiurl'] = 'Turnitin API 網址';
$string['turnitinapiurl_desc'] = '<b>[必要的]</b><br />選擇Turnitin API 網址';
$string['turnitinconfig'] = 'Turnitin剽竊外掛配置';
$string['turnitindefaults'] = 'Turnitin剽竊外掛默認設定';
$string['turnitindeleteconfirm'] = '刪除文稿的話，將會在您的遞交清單上及收件箱中移除，但不會完全在Turnitin數據庫中移除。您確定要刪除此逆交？這個動作不能撤消。';
$string['turnitindeletionerror'] = 'Turnitin遞交刪除失敗。已航除本地Moodle副本但不能刪除在Turnitin中的遞交。';
$string['turnitindiagnostic'] = '啟用診斷模式';
$string['turnitindiagnostic_desc'] = '<b>[警告]</b><br />啟用診斷模式來只用作追查與Turnitin API的問題。';
$string['turnitinenablepeermark'] = '啟用同儕評鑑作業';
$string['turnitinenablepeermark_desc'] = '選擇是否允許建立同儕評鑑作業<br/><i>(只有在Turnitin帳戶已配置的用戶可用)</i>';
$string['turnitinenrolstudents'] = '註冊所有學生';
$string['turnitingmoptions'] = '線上評分的選項';
$string['turnitinhelpdesk'] = 'Turnitin服務台';
$string['turnitinid'] = 'Turnitin ID';
$string['turnitininboxlayout'] = '作業頁面版面';
$string['turnitininboxlayout_desc'] = '選擇Turnitin作業版面是否應該顯示導航或顯示全寬。';
$string['turnitinloading'] = '正同步資料';
$string['turnitinoroptions'] = '原創性報告的選項';
$string['turnitinpaperid'] = 'Turnitin 文稿ID';
$string['turnitinpart'] = '部份{$a}';
$string['turnitinpluginsettings'] = 'Turnitin剽竊外掛設定';
$string['turnitinppulapost'] = '您的文件尚未提交到Turnitin。請點擊此以接受我們的最終用戶許可協議。';
$string['turnitinppulapre'] = '要提交檔案至Turnitin，您必須先同意我們的最終用戶許可協議。選擇不同意我們的最終用戶許可協議會只提交您的檔案到Moodle。點擊這裡以同意協議。';
$string['turnitinrefreshingsubmissions'] = '正刷新遞交';
$string['turnitinrefreshsubmissions'] = '刷新遞交';
$string['turnitinrepositoryoptions'] = '文件知識庫作業';
$string['turnitinrepositoryoptions_desc'] = '選擇Turnitin作業的知識庫選項。<br /><i>(機構知識庫只有已在其帳戶中啟用的可用。)</i>';
$string['turnitinrepositoryoptions_help'] = '使用此設定來變更作業設置屏幕中的知識庫選項。<br /><i>(機構知識庫只有已在其帳戶中啟用的可用。)</i>';
$string['turnitinsecretkey'] = 'Turnitin的共享密鑰';
$string['turnitinsecretkey_desc'] = '<b>[必要]</b><br />輸入您的Turnitin共享密鑰<br /><i>(由Turnitin管理員設定)</i>';
$string['turnitinsettingshelpwizard'] = '為教師啟用Turnitin服務台';
$string['turnitinsettingshelpwizard_desc'] = '選擇教師是否可以從Moodle中進入Turnitin服務台的嚮導';
$string['turnitinstatus'] = 'Turnitin狀態';
$string['turnitinstudents'] = 'Turnitin學生';
$string['turnitinstudents_desc'] = '下列已選的用戶已在Turnitin課堂中註冊。已註冊的學生可以經Turnitin網站中登入以進入課堂。';
$string['turnitinstudentsremove'] = '您確定要從Turnitin課堂中移除此學生？';
$string['turnitinsubmissionid'] = 'Turnitin 遞交ID';
$string['turnitintoolofflineerror'] = '我們正在經歷一個暫時性的問題。請稍後再試。';
$string['turnitintooltwo'] = 'Turnitin工具';
$string['turnitintooltwo:addinstance'] = '新增Turnitin工具活動';
$string['turnitintooltwo:admin'] = 'Turnitin的管理工具';
$string['turnitintooltwoadministration'] = 'Turnitin作業2 管理';
$string['turnitintooltwoagreement'] = '免責聲明/協議';
$string['turnitintooltwoagreement_default'] = '我確認此提交是我的個人作品及的接受因為這提交可能發生的任何侵權的全部責任。';
$string['turnitintooltwoagreement_desc'] = '<b>[自訂]</b><br />輸入用作提交的同意確認聲明<br />(<b>注意:</b>如果完全留空聲明的話，將不需要在提交時要求學生的同意確認聲明)';
$string['turnitintooltwodeleteerror'] = '不能刪除turnitintooltwo資料';
$string['turnitintooltwogeterror'] = '不能取得turnitintooltwo資料';
$string['turnitintooltwo:grade'] = '評核Turnitin工貝作業';
$string['turnitintooltwointro'] = '摘要';
$string['turnitintooltwoname'] = 'Turnitin作業名稱';
$string['turnitintooltwo:read'] = '閱讀Turnitin工具作業';
$string['turnitintooltworesetdata0'] = '複製Turnitin作業<i>(建立複本, 新Turnitin課堂)</i>';
$string['turnitintooltworesetdata1'] = '取代Turnitin作業<i>(取代作業部份, 重用Turnitin課堂)</i>';
$string['turnitintooltworesetdata2'] = 'Turnitin作業維持不變';
$string['turnitintooltworesetinfo'] = '為此課程中的Turnitin作業選擇以下的選項：';
$string['turnitintooltwo:submit'] = '提交至Turnitin工具作業';
$string['turnitintooltwoupdateerror'] = '不能更新turnitintooltwo資料';
$string['turnitintooltwo:view'] = '查看Turnitin工具作業';
$string['turnitintutors'] = 'Tutnitin 導師';
$string['turnitintutorsadd'] = '新增Tutnitin 導師';
$string['turnitintutorsallenrolled'] = '所有導師已在Turnitin註冊';
$string['turnitintutors_desc'] = '下列已選擇的導師已註冊為此Turnitin課堂的導師。已註冊的導師可以透過Turnitin網站中登入到此課程。';
$string['turnitintutorsremove'] = '您確定要從Turnitin課程中移除此導師？';
$string['turnitinula'] = '您在提交前必須同意最新的Turnitin用戶協議。';
$string['turnitinula_btn'] = '請點擊此以閱讀及同意協議';
$string['turnitinuseanon'] = '使用匿名評分';
$string['turnitinuseanon_desc'] = '選擇評核遞交時是否允許匿名評分。<br /><i>(只適用於已在Turnitin帳戶中已啟用匿名評分的用戶)</i>';
$string['turnitinuseerater'] = '啟用ETS&副本';
$string['turnitinuseerater_desc'] = '選擇是否啟用ETS&副本的語法檢查。<br /><i>(如果ETS&副本已在您的Turnitin帳戶中啟用，才啟用此選項)</i>';
$string['turnitinusegrademark'] = '使用網上評分（GradeMark）';
$string['turnitinusegrademark_desc'] = '選擇是否使用網上評分（GradeMark）評核提交的作業。<br /><i>(只有在已在帳戶中設置網上評分下可用)</i>';
$string['turnitinusegrademark_help'] = '使用此設定來選擇使用Turnitin網上評分（GradeMark）或使用Moodle來評核提交的作業';
$string['turnitinuserepository'] = '啟用機構資料庫';
$string['turnitinuserepository_desc'] = '選擇是否允許使用機構資料庫評核提交的作業。<br /><i>(只有在已在帳戶中啟用了機構資料庫下可用)</i>';
$string['turnitinuserepository_help'] = '使用此設定來啟用在設定作業畫面中的機構資料庫選項。<br /><i>(只有在已在帳戶中啟用了機構資料庫下可用)</i>';
$string['tutoradded'] = '已增加導師到Turnitin的課程';
$string['tutoraddingerror'] = '當增加導師到Turnitin的課程時出現了問題';
$string['tutorremoved'] = '已移除從Turnitin的課程中的導師';
$string['tutorremovingerror'] = '當從Turnitin的課程中移除導師時出現了問題';
$string['tutorstatus'] = '{$a->submitted}/{$a->total} 學生提交, {$a->graded} 提交{$a->gplural} 已評分';
$string['type'] = '遞交類型';
$string['types'] = '遞交類型';
$string['types_help'] = '<p>遞交類型可以分為兩種，複製並貼上及上載檔案。</p>';
$string['unanonymiseerror'] = '當嘗試公開學生姓名時出現了錯誤';
$string['uniquepartname'] = '部份名稱必須是獨一無二的';
$string['unlinkedusers'] = '未連接的用戶';
$string['unlinkrelinkusers'] = '未連接／重新連接的Turnitin用戶';
$string['unlinkusers'] = '未連接的用戶';
$string['updatepart'] = '更新部份';
$string['updatesubmissionerror'] = '當重新提交至Turnitin時出現了錯誤';
$string['upgradeavailable'] = '有可用更新';
$string['upgradenotavailable'] = '沒有可用更新';
$string['uploadingsubtoturnitin'] = '正上載您的提交至Turnitin';
$string['user'] = '用戶';
$string['usercreationerror'] = 'Turnitin用戶創建失敗';
$string['userdeleteerror'] = '不能刪除用戶資料';
$string['userfinderror'] = '當嘗試在Turnitin上搜尋用戶時出現了錯誤';
$string['usergeterror'] = '不能取得用戶資料';
$string['userjoinerror'] = '當嘗試在Turnitin上加入用戶時出現了錯誤';
$string['userremoveerror'] = '當嘗試在Turnitin上移除用戶時出現了錯誤';
$string['userstounlink'] = '要取消連接的用戶';
$string['usersunlinkrelink'] = '要取消連接／重新連接的用戶';
$string['userupdateerror'] = '不能更新用戶資料';
$string['useturnitin'] = '啟用Turnitin';
$string['useturnitin_mod'] = '啟用 {$a}的Turnitin';
$string['usinglatest'] = '您正在使用最新的版本';
$string['viewdigitalreceipt'] = '查看電子回條';
$string['viewreport'] = '查看報告';
$string['viewsubmission'] = '查看提交';
$string['viewsubmissiondesc'] = '用戶已查看提交';
$string['wrongaccountid'] = '連接到Turnitin課程中時出現了錯誤。您已設置的帳戶是{$a->current}。此課程的帳戶則是{$a->backupid}。您只可以修復從相同Trunitin帳戶的課程。';
$string['yes'] = '是';
$string['yesgrades'] = '是，自動刷新原創性分數及成績';
