/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

class NoctisRfbProto {
    final String versionMsg = "RFB 003.003\n";
    static final int ConnFailed = 0;
    static final int NoAuth = 1;
    static final int VncAuth = 2;
    static final int MsLogon = -6;
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    static final int rfbFileTransfer = 7;
    final int SetPixelFormat = 0;
    final int FixColourMapEntries = 1;
    final int SetEncodings = 2;
    final int FramebufferUpdateRequest = 3;
    final int KeyboardEvent = 4;
    final int PointerEvent = 5;
    final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingPointerPos = -232;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    ArrayList remoteDirsList;
    ArrayList remoteFilesList;
    ArrayList a;
    boolean fFTInit = true;
    boolean fFTAllowed = true;
    boolean fAbort = false;
    boolean fFileReceptionError = false;
    boolean fFileReceptionRunning = false;
    boolean inDirectory2;
    FileOutputStream fos;
    FileInputStream fis;
    String sendFileSource;
    String receivePath;
    long fileSize;
    long receiveFileSize;
    long fileChunkCounter;
    static final int sz_rfbFileTransferMsg = 12;
    static final int rfbDirContentRequest = 1;
    static final int rfbDirPacket = 2;
    static final int rfbFileTransferRequest = 3;
    static final int rfbFileHeader = 4;
    static final int rfbFilePacket = 5;
    static final int rfbEndOfFile = 6;
    static final int rfbAbortFileTransfer = 7;
    static final int rfbFileTransferOffer = 8;
    static final int rfbFileAcceptHeader = 9;
    static final int rfbCommand = 10;
    static final int rfbCommandReturn = 11;
    static final int rfbFileChecksums = 12;
    static final int rfbRDirContent = 1;
    static final int rfbRDrivesList = 2;
    static final int rfbADirectory = 1;
    static final int rfbAFile = 2;
    static final int rfbADrivesList = 3;
    static final int rfbADirCreate = 4;
    static final int rfbADirDelete = 5;
    static final int rfbAFileCreate = 6;
    static final int rfbAFileDelete = 7;
    static final int rfbCDirCreate = 1;
    static final int rfbCDirDelete = 2;
    static final int rfbCFileCreate = 3;
    static final int rfbCFileDelete = 4;
    static final int rfbRErrorUnknownCmd = 1;
    static final int rfbRErrorCmd = -1;
    static final int sz_rfbBlockSize = 8192;
    static final int sz_rfbZipDirectoryPrefix = 9;
    String rfbZipDirectoryPrefix = "!UVNCDIR-\u0000";
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    OutputStreamWriter osw;
    SessionRecorder rec;
    boolean inNormalProtocol = false;
    ConfigClientBean config;
    boolean brokenKeyPressed = false;
    boolean wereZlibUpdates = false;
    boolean recordFromBeginning = true;
    boolean zlibWarningShown;
    boolean tightWarningShown;
    int numUpdatesInSession;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    NoctisRfbProto(String string, int n, ConfigClientBean configClientBean) throws IOException {
        this.config = configClientBean;
        this.host = string;
        this.port = n;
        this.sock = new Socket(this.host, this.port);
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
        this.osw = new OutputStreamWriter(this.sock.getOutputStream());
        this.inDirectory2 = false;
        this.a = new ArrayList();
        this.remoteDirsList = new ArrayList();
        this.remoteFilesList = new ArrayList();
        this.sendFileSource = "";
    }

    void close() {
        try {
            this.sock.close();
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void readVersionMsg() throws Exception {
        byte[] byArray = new byte[12];
        this.is.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
    }

    void writeVersionMsg() throws IOException {
        this.os.write("RFB 003.003\n".getBytes());
    }

    int readAuthScheme() throws Exception {
        int n = this.is.readInt();
        switch (n) {
            case 0: {
                int n2 = this.is.readInt();
                byte[] byArray = new byte[n2];
                this.is.readFully(byArray);
                throw new Exception(new String(byArray));
            }
            case -6: 
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new Exception("Unknown authentication scheme from RFB server: " + n);
    }

    void writeClientInit() throws IOException {
        if (this.config.isShareDesktop()) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.config.setShareDesktop(false);
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        this.desktopName = new String(byArray2);
        this.inNormalProtocol = true;
    }

    void startSession(String string) throws IOException {
        this.rec = new SessionRecorder(string);
        this.rec.writeHeader();
        this.rec.write("RFB 003.003\n".getBytes());
        this.rec.writeIntBE(1);
        this.rec.writeShortBE(this.framebufferWidth);
        this.rec.writeShortBE(this.framebufferHeight);
        byte[] byArray = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0};
        this.rec.write(byArray);
        this.rec.writeIntBE(this.desktopName.length());
        this.rec.write(this.desktopName.getBytes());
        this.numUpdatesInSession = 0;
        if (this.wereZlibUpdates) {
            this.recordFromBeginning = false;
        }
        this.zlibWarningShown = false;
        this.tightWarningShown = false;
    }

    void closeSession() throws IOException {
        if (this.rec != null) {
            this.rec.close();
            this.rec = null;
        }
    }

    void setFramebufferSize(int n, int n2) {
        this.framebufferWidth = n;
        this.framebufferHeight = n2;
    }

    int readServerMessageType() throws IOException {
        int n = this.is.readUnsignedByte();
        if (this.rec != null && n == 2) {
            this.rec.writeByte(n);
            if (this.numUpdatesInSession > 0) {
                this.rec.flush();
            }
        }
        return n;
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeByte(0);
            this.rec.writeByte(0);
            this.rec.writeShortBE(this.updateNRects);
        }
        ++this.numUpdatesInSession;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 7) {
            this.wereZlibUpdates = true;
        }
        if (this.rec != null) {
            if (this.numUpdatesInSession > 1) {
                this.rec.flush();
            }
            this.rec.writeShortBE(this.updateRectX);
            this.rec.writeShortBE(this.updateRectY);
            this.rec.writeShortBE(this.updateRectW);
            this.rec.writeShortBE(this.updateRectH);
            if (this.updateRectEncoding == 6 && !this.recordFromBeginning) {
                if (!this.zlibWarningShown) {
                    System.out.println("Warning: Raw encoding will be used instead of Zlib in recorded session.");
                    this.zlibWarningShown = true;
                }
                this.rec.writeIntBE(0);
            } else {
                this.rec.writeIntBE(this.updateRectEncoding);
                if (this.updateRectEncoding == 7 && !this.recordFromBeginning && !this.tightWarningShown) {
                    System.out.println("Warning: Re-compressing Tight-encoded updates for session recording.");
                    this.tightWarningShown = true;
                }
            }
        }
        if (this.updateRectEncoding == -224 || this.updateRectEncoding == -223) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeShortBE(this.copyRectSrcX);
            this.rec.writeShortBE(this.copyRectSrcY);
        }
    }

    String readServerCutText() throws IOException {
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        return new String(byArray2);
    }

    int readCompactLen() throws IOException {
        int[] nArray = new int[3];
        nArray[0] = this.is.readUnsignedByte();
        int n = 1;
        int n2 = nArray[0] & 0x7F;
        if ((nArray[0] & 0x80) != 0) {
            nArray[1] = this.is.readUnsignedByte();
            ++n;
            n2 |= (nArray[1] & 0x7F) << 7;
            if ((nArray[1] & 0x80) != 0) {
                nArray[2] = this.is.readUnsignedByte();
                ++n;
                n2 |= (nArray[2] & 0xFF) << 14;
            }
        }
        if (this.rec != null && this.recordFromBeginning) {
            for (int i = 0; i < n; ++i) {
                this.rec.writeByte(nArray[i]);
            }
        }
        return n2;
    }

    void readRfbFileTransferMsg() throws IOException {
        int n;
        int n2 = this.is.readUnsignedByte();
        int n3 = n = this.is.readUnsignedByte();
        n = this.is.readUnsignedByte();
        n3 |= (n <<= 8);
        if (n2 == 2 || n2 == 2) {
            this.readDriveOrDirectory(n3);
        } else if (n2 == 4) {
            this.receiveFileHeader();
        } else if (n2 == 5) {
            this.receiveFileChunk();
        } else if (n2 == 6) {
            this.endOfReceiveFile(true);
        } else if (n2 == 7) {
            if (this.fFileReceptionRunning) {
                this.endOfReceiveFile(false);
            }
        } else if (n2 == 12) {
            this.ReceiveDestinationFileChecksums();
        } else {
            System.out.println("ContentType: " + n2);
        }
    }

    public void readDriveOrDirectory(int n) throws IOException {
        if (n == 3) {
            this.readFTPMsgDriveList();
        } else if (n == 1 && !this.inDirectory2) {
            this.inDirectory2 = true;
            this.readFTPMsgDirectoryList();
        } else if (n == 1 && this.inDirectory2) {
            this.readFTPMsgDirectoryListContent();
        } else if (n == 0) {
            this.readFTPMsgDirectoryListEndContent();
            this.inDirectory2 = false;
        } else {
            System.out.println("ContentParam: " + n);
        }
    }

    void writeRfbFileTransferMsg(int n, int n2, long l, long l2, String string) throws IOException {
        byte[] byArray = new byte[12];
        byArray[0] = 7;
        byArray[1] = (byte)n;
        byArray[2] = (byte)n2;
        byte by = 0;
        long l3 = 0L;
        ++l2;
        l3 = l & 0xFFFFFFFFFF000000L;
        byArray[4] = by = (byte)(l3 >>> 24);
        l3 = l & 0xFF0000L;
        byArray[5] = by = (byte)(l3 >>> 16);
        l3 = l & 0xFF00L;
        byArray[6] = by = (byte)(l3 >>> 8);
        l3 = l & 0xFFL;
        byArray[7] = by = (byte)l3;
        l3 = l2 & 0xFFFFFFFFFF000000L;
        byArray[8] = by = (byte)(l3 >>> 24);
        l3 = l2 & 0xFF0000L;
        byArray[9] = by = (byte)(l3 >>> 16);
        l3 = l2 & 0xFF00L;
        byArray[10] = by = (byte)(l3 >>> 8);
        l3 = l2 & 0xFFL;
        byArray[11] = by = (byte)l3;
        this.os.write(byArray);
        if (string != null) {
            byte[] byArray2 = string.getBytes();
            byte[] byArray3 = new byte[byArray2.length + 1];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray3[i] = byArray2[i];
            }
            byArray3[byArray3.length - 1] = 0;
            this.os.write(byArray3);
        }
    }

    void offerLocalFile(String string, String string2) {
        try {
            this.sendFileSource = string;
            File file = new File(string);
            long l = file.length();
            int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            int n2 = (int)(l >> 32);
            String string3 = string2 + file.getName();
            this.writeRfbFileTransferMsg(8, 0, n, string3.length(), string3);
            byte[] byArray = new byte[4];
            byte by = 0;
            long l2 = 0L;
            l2 = n2 & 0xFF000000;
            byArray[0] = by = (byte)(l2 >>> 24);
            l2 = n2 & 0xFF0000;
            byArray[1] = by = (byte)(l2 >>> 16);
            l2 = n2 & 0xFF00;
            byArray[2] = by = (byte)(l2 >>> 8);
            l2 = n2 & 0xFF;
            byArray[3] = by = (byte)l2;
            this.os.write(byArray);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void deleteRemoteFile(String string) {
        try {
            String string2 = string;
            this.writeRfbFileTransferMsg(10, 4, 0L, string2.length(), string2);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void createRemoteDirectory(String string) {
        try {
            String string2 = string;
            this.writeRfbFileTransferMsg(10, 1, 0L, string2.length(), string2);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void requestRemoteFile(String string, String string2) {
        try {
            String string3 = string;
            this.receivePath = string2;
            this.writeRfbFileTransferMsg(3, 0, 1L, string3.length(), string3);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void receiveFileHeader() throws IOException {
        long l;
        int n;
        this.fFileReceptionRunning = true;
        this.fFileReceptionError = false;
        int n2 = this.is.readInt();
        int n3 = this.is.readInt();
        String string = "";
        for (n = 0; n < n3; ++n) {
            string = string + (char)this.is.readUnsignedByte();
        }
        n = this.is.readInt();
        this.receiveFileSize = l = ((long)n << 32) + (long)n2;
        this.fileSize = 0L;
        this.fileChunkCounter = 0L;
        String string2 = this.receivePath;
        this.fos = new FileOutputStream(string2);
        this.writeRfbFileTransferMsg(4, 0, 0L, 0L, null);
    }

    void receiveFileChunk() throws IOException {
        int n = this.is.readInt();
        boolean bl = n != 0;
        int n2 = this.is.readInt();
        ++this.fileChunkCounter;
        byte[] byArray = new byte[n2 + 32];
        this.is.readFully(byArray, 0, n2);
        if (bl) {
            int n3 = 9216;
            int n4 = 0;
            byte[] byArray2 = new byte[n3];
            Inflater inflater = new Inflater();
            inflater.setInput(byArray);
            try {
                n4 = inflater.inflate(byArray2);
            }
            catch (DataFormatException dataFormatException) {
                System.err.println(dataFormatException);
            }
            this.fos.write(byArray2, 0, n4);
            this.fileSize += (long)n4;
        } else {
            this.fos.write(byArray, 0, n2);
            this.fileSize += (long)n2;
        }
        if (this.fAbort) {
            this.fAbort = false;
            this.fFileReceptionError = true;
            this.writeRfbFileTransferMsg(7, 0, 0L, 0L, null);
        }
    }

    void endOfReceiveFile(boolean bl) throws IOException {
        int n = this.is.readInt();
        int n2 = this.is.readInt();
        this.fileSize = 0L;
        this.fos.close();
        if (!bl || this.fFileReceptionError) {
            File file = new File(this.receivePath);
            file.delete();
        }
        this.fFileReceptionError = false;
        this.fFileReceptionRunning = false;
    }

    void readServerDirectory(String string) {
        try {
            String string2 = string;
            this.writeRfbFileTransferMsg(1, 1, 0L, string2.length(), string2);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void readFTPMsgDriveList() throws IOException {
        int n;
        String string = "";
        for (n = 0; n < 4; ++n) {
            this.is.readUnsignedByte();
        }
        n = this.is.readInt();
        for (int i = 0; i < n; ++i) {
            char c = (char)this.is.readUnsignedByte();
            if (c == '\u0000') continue;
            string = string + c;
        }
    }

    void readFTPMsgDirectoryList() throws IOException {
        this.is.readInt();
        int n = this.is.readInt();
        if (n == 0) {
            this.inDirectory2 = false;
        } else {
            String string = "";
            for (int i = 0; i < n; ++i) {
                char c = (char)this.is.readUnsignedByte();
                if (c == '\u0000') continue;
                string = string + c;
            }
        }
    }

    void readFTPMsgDirectoryListContent() throws IOException {
        String string = "";
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        this.is.readInt();
        n = this.is.readInt();
        int n2 = this.is.readInt();
        n -= 4;
        long l = this.is.readLong();
        n -= 8;
        long l2 = this.is.readLong();
        n -= 8;
        long l3 = this.is.readLong();
        n -= 8;
        int n3 = this.is.readInt();
        n -= 4;
        int n4 = this.is.readInt();
        n -= 4;
        int n5 = this.is.readInt();
        n -= 4;
        int n6 = this.is.readInt();
        n -= 4;
        char c = (char)this.is.readUnsignedByte();
        --n;
        while (c != '\u0000') {
            string = string + c;
            c = (char)this.is.readUnsignedByte();
            --n;
        }
        char c2 = (char)this.is.readByte();
        --n;
        while (n != 0) {
            string2 = string2 + c2;
            c2 = (char)this.is.readUnsignedByte();
            --n;
        }
        if (n2 == 0x10000000 || n2 == 0x16000000 || n2 == 0x11000000 || n2 == 271056896 || n2 == 824705024 || n2 == 807927808 || n2 == 371720192 || n2 == 369623040) {
            string = " [" + string + "]";
            this.remoteDirsList.add(string);
        } else {
            this.remoteFilesList.add(" " + string);
        }
    }

    void readFTPMsgDirectoryListEndContent() throws IOException {
        int n;
        this.is.readInt();
        int n2 = this.is.readInt();
        this.a.clear();
        for (n = 0; n < this.remoteDirsList.size(); ++n) {
            this.a.add(this.remoteDirsList.get(n));
        }
        for (n = 0; n < this.remoteFilesList.size(); ++n) {
            this.a.add(this.remoteFilesList.get(n));
        }
        this.remoteDirsList.clear();
        this.remoteFilesList.clear();
    }

    void ReceiveDestinationFileChecksums() throws IOException {
        int n = this.is.readInt();
        int n2 = this.is.readInt();
        byte[] byArray = new byte[n2 + 32];
        this.is.readFully(byArray, 0, n2);
    }

    void writeSetPixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl3) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = 0;
        byArray[4] = (byte)n;
        byArray[5] = (byte)n2;
        byArray[6] = (byte)(bl ? 1 : 0);
        byArray[7] = (byte)(bl2 ? 1 : 0);
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n3 & 0xFF);
        byArray[10] = (byte)(n4 >> 8 & 0xFF);
        byArray[11] = (byte)(n4 & 0xFF);
        byArray[12] = (byte)(n5 >> 8 & 0xFF);
        byArray[13] = (byte)(n5 & 0xFF);
        byArray[14] = (byte)n6;
        byArray[15] = (byte)n7;
        byArray[16] = (byte)n8;
        byArray[17] = (byte)(bl3 ? 1 : 0);
        this.os.write(byArray);
    }

    void writeFixColourMapEntries(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        byte[] byArray = new byte[6 + n2 * 6];
        byArray[0] = 1;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(n2 >> 8 & 0xFF);
        byArray[5] = (byte)(n2 & 0xFF);
        for (int i = 0; i < n2; ++i) {
            byArray[6 + i * 6] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 1] = (byte)(nArray[i] & 0xFF);
            byArray[6 + i * 6 + 2] = (byte)(nArray2[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 3] = (byte)(nArray2[i] & 0xFF);
            byArray[6 + i * 6 + 4] = (byte)(nArray3[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 5] = (byte)(nArray3[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    void writeSetEncodings(int[] nArray, int n) throws IOException {
        byte[] byArray = new byte[4 + 4 * n];
        byArray[0] = 2;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        for (int i = 0; i < n; ++i) {
            byArray[4 + 4 * i] = (byte)(nArray[i] >> 24 & 0xFF);
            byArray[5 + 4 * i] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray[6 + 4 * i] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[7 + 4 * i] = (byte)(nArray[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    void writeClientCutText(String string) throws IOException {
        byte[] byArray = new byte[8 + string.length()];
        byArray[0] = 6;
        byArray[4] = (byte)(string.length() >> 24 & 0xFF);
        byArray[5] = (byte)(string.length() >> 16 & 0xFF);
        byArray[6] = (byte)(string.length() >> 8 & 0xFF);
        byArray[7] = (byte)(string.length() & 0xFF);
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        this.os.write(byArray);
    }

    void writeKeyEvent(int n, boolean bl) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(bl ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n & 0xFF);
    }

    void writeModifierKeyEvents(int n) {
        if ((n & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        if ((n & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        this.oldModifiers = n;
    }

    void recordCompressedData(byte[] byArray, int n, int n2) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray, n, n2);
        int n3 = n2 + n2 / 100 + 12;
        byte[] byArray2 = new byte[n3];
        deflater.finish();
        int n4 = deflater.deflate(byArray2);
        this.recordCompactLen(n4);
        this.rec.write(byArray2, 0, n4);
    }

    void recordCompressedData(byte[] byArray) throws IOException {
        this.recordCompressedData(byArray, 0, byArray.length);
    }

    void recordCompactLen(int n) throws IOException {
        byte[] byArray = new byte[3];
        int n2 = 0;
        byArray[n2++] = (byte)(n & 0x7F);
        if (n > 127) {
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] | 0x80);
            byArray[n2++] = (byte)(n >> 7 & 0x7F);
            if (n > 16383) {
                int n4 = n2 - 1;
                byArray[n4] = (byte)(byArray[n4] | 0x80);
                byArray[n2++] = (byte)(n >> 14 & 0xFF);
            }
        }
        this.rec.write(byArray, 0, n2);
    }

    public boolean tryAuthenticate(String string, String string2) throws Exception {
        this.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.serverMajor + "." + this.serverMinor);
        this.writeVersionMsg();
        int n = this.readAuthScheme();
        block0 : switch (n) {
            case 1: {
                System.out.println("No authentication needed");
                return true;
            }
            case 2: {
                int n2;
                byte[] byArray = new byte[16];
                this.is.readFully(byArray);
                if (string2.length() > 8) {
                    string2 = string2.substring(0, 8);
                }
                if ((n2 = string2.indexOf(0)) != -1) {
                    string2 = string2.substring(0, n2);
                }
                byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                System.arraycopy(string2.getBytes(), 0, byArray2, 0, string2.length());
                DesCipher desCipher = new DesCipher(byArray2);
                desCipher.encrypt(byArray, 0, byArray, 0);
                desCipher.encrypt(byArray, 8, byArray, 8);
                this.os.write(byArray);
                int n3 = this.is.readInt();
                switch (n3) {
                    case 0: {
                        System.out.println("VNC authentication succeeded");
                        return true;
                    }
                    case 1: {
                        System.out.println("VNC authentication failed");
                        break block0;
                    }
                    case 2: {
                        throw new Exception("VNC authentication failed - too many tries");
                    }
                }
                throw new Exception("Unknown VNC authentication result " + n3);
            }
            case -6: {
                System.out.println("MS-Logon (DH) detected");
                break;
            }
            default: {
                throw new Exception("Unknown VNC authentication scheme " + n);
            }
        }
        return false;
    }

    void doProtocolInitialisation() throws IOException {
        this.writeClientInit();
        this.readServerInit();
        System.out.println("Desktop name is " + this.desktopName);
        System.out.println("Desktop size is " + this.framebufferWidth + " x " + this.framebufferHeight);
    }
}

