/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

class RfbProto {
    final String versionMsg = "RFB 003.003\n";
    static final int ConnFailed = 0;
    static final int NoAuth = 1;
    static final int VncAuth = 2;
    static final int MsLogon = -6;
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    static final int rfbFileTransfer = 7;
    final int SetPixelFormat = 0;
    final int FixColourMapEntries = 1;
    final int SetEncodings = 2;
    final int FramebufferUpdateRequest = 3;
    final int KeyboardEvent = 4;
    final int PointerEvent = 5;
    final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingPointerPos = -232;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    ArrayList remoteDirsList;
    ArrayList remoteFilesList;
    ArrayList a;
    boolean fFTInit = true;
    boolean fFTAllowed = true;
    boolean fAbort = false;
    boolean fFileReceptionError = false;
    boolean fFileReceptionRunning = false;
    boolean inDirectory2;
    FileOutputStream fos;
    FileInputStream fis;
    String sendFileSource;
    String receivePath;
    long fileSize;
    long receiveFileSize;
    long fileChunkCounter;
    static final int sz_rfbFileTransferMsg = 12;
    static final int rfbDirContentRequest = 1;
    static final int rfbDirPacket = 2;
    static final int rfbFileTransferRequest = 3;
    static final int rfbFileHeader = 4;
    static final int rfbFilePacket = 5;
    static final int rfbEndOfFile = 6;
    static final int rfbAbortFileTransfer = 7;
    static final int rfbFileTransferOffer = 8;
    static final int rfbFileAcceptHeader = 9;
    static final int rfbCommand = 10;
    static final int rfbCommandReturn = 11;
    static final int rfbFileChecksums = 12;
    static final int rfbRDirContent = 1;
    static final int rfbRDrivesList = 2;
    static final int rfbADirectory = 1;
    static final int rfbAFile = 2;
    static final int rfbADrivesList = 3;
    static final int rfbADirCreate = 4;
    static final int rfbADirDelete = 5;
    static final int rfbAFileCreate = 6;
    static final int rfbAFileDelete = 7;
    static final int rfbCDirCreate = 1;
    static final int rfbCDirDelete = 2;
    static final int rfbCFileCreate = 3;
    static final int rfbCFileDelete = 4;
    static final int rfbRErrorUnknownCmd = 1;
    static final int rfbRErrorCmd = -1;
    static final int sz_rfbBlockSize = 8192;
    static final int sz_rfbZipDirectoryPrefix = 9;
    String rfbZipDirectoryPrefix = "!UVNCDIR-\u0000";
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    OutputStreamWriter osw;
    SessionRecorder rec;
    boolean inNormalProtocol = false;
    VncViewer viewer;
    boolean brokenKeyPressed = false;
    boolean wereZlibUpdates = false;
    boolean recordFromBeginning = true;
    boolean zlibWarningShown;
    boolean tightWarningShown;
    int numUpdatesInSession;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    private void sendRelayCommand(OutputStream outputStream, String string) throws IOException {
        outputStream.write(20);
        byte[] byArray = string.getBytes();
        outputStream.write(byArray.length);
        outputStream.write(byArray);
        outputStream.flush();
    }

    RfbProto(String string, int n, VncViewer vncViewer, String string2) throws IOException {
        this.viewer = vncViewer;
        this.host = string;
        this.port = n;
        this.sock = new Socket(this.host, this.port);
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
        this.osw = new OutputStreamWriter(this.sock.getOutputStream());
        this.sendRelayCommand(this.os, string2);
        this.inDirectory2 = false;
        this.a = new ArrayList();
        this.remoteDirsList = new ArrayList();
        this.remoteFilesList = new ArrayList();
        this.sendFileSource = "";
    }

    void close() {
        try {
            this.sock.close();
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void readVersionMsg() throws Exception {
        byte[] byArray = new byte[12];
        this.is.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
    }

    void writeVersionMsg() throws IOException {
        this.os.write("RFB 003.003\n".getBytes());
    }

    int readAuthScheme() throws Exception {
        int n = this.is.readInt();
        switch (n) {
            case 0: {
                int n2 = this.is.readInt();
                byte[] byArray = new byte[n2];
                this.is.readFully(byArray);
                throw new Exception(new String(byArray));
            }
            case -6: 
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new Exception("Unknown authentication scheme from RFB server: " + n);
    }

    void writeClientInit() throws IOException {
        if (this.viewer.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.viewer.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        this.desktopName = new String(byArray2);
        this.inNormalProtocol = true;
    }

    void startSession(String string) throws IOException {
        this.rec = new SessionRecorder(string);
        this.rec.writeHeader();
        this.rec.write("RFB 003.003\n".getBytes());
        this.rec.writeIntBE(1);
        this.rec.writeShortBE(this.framebufferWidth);
        this.rec.writeShortBE(this.framebufferHeight);
        byte[] byArray = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0};
        this.rec.write(byArray);
        this.rec.writeIntBE(this.desktopName.length());
        this.rec.write(this.desktopName.getBytes());
        this.numUpdatesInSession = 0;
        if (this.wereZlibUpdates) {
            this.recordFromBeginning = false;
        }
        this.zlibWarningShown = false;
        this.tightWarningShown = false;
    }

    void closeSession() throws IOException {
        if (this.rec != null) {
            this.rec.close();
            this.rec = null;
        }
    }

    void setFramebufferSize(int n, int n2) {
        this.framebufferWidth = n;
        this.framebufferHeight = n2;
    }

    int readServerMessageType() throws IOException {
        int n = this.is.readUnsignedByte();
        if (this.rec != null && n == 2) {
            this.rec.writeByte(n);
            if (this.numUpdatesInSession > 0) {
                this.rec.flush();
            }
        }
        return n;
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeByte(0);
            this.rec.writeByte(0);
            this.rec.writeShortBE(this.updateNRects);
        }
        ++this.numUpdatesInSession;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 7) {
            this.wereZlibUpdates = true;
        }
        if (this.rec != null) {
            if (this.numUpdatesInSession > 1) {
                this.rec.flush();
            }
            this.rec.writeShortBE(this.updateRectX);
            this.rec.writeShortBE(this.updateRectY);
            this.rec.writeShortBE(this.updateRectW);
            this.rec.writeShortBE(this.updateRectH);
            if (this.updateRectEncoding == 6 && !this.recordFromBeginning) {
                if (!this.zlibWarningShown) {
                    System.out.println("Warning: Raw encoding will be used instead of Zlib in recorded session.");
                    this.zlibWarningShown = true;
                }
                this.rec.writeIntBE(0);
            } else {
                this.rec.writeIntBE(this.updateRectEncoding);
                if (this.updateRectEncoding == 7 && !this.recordFromBeginning && !this.tightWarningShown) {
                    System.out.println("Warning: Re-compressing Tight-encoded updates for session recording.");
                    this.tightWarningShown = true;
                }
            }
        }
        if (this.updateRectEncoding == -224 || this.updateRectEncoding == -223) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeShortBE(this.copyRectSrcX);
            this.rec.writeShortBE(this.copyRectSrcY);
        }
    }

    String readServerCutText() throws IOException {
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        return new String(byArray2);
    }

    int readCompactLen() throws IOException {
        int[] nArray = new int[3];
        nArray[0] = this.is.readUnsignedByte();
        int n = 1;
        int n2 = nArray[0] & 0x7F;
        if ((nArray[0] & 0x80) != 0) {
            nArray[1] = this.is.readUnsignedByte();
            ++n;
            n2 |= (nArray[1] & 0x7F) << 7;
            if ((nArray[1] & 0x80) != 0) {
                nArray[2] = this.is.readUnsignedByte();
                ++n;
                n2 |= (nArray[2] & 0xFF) << 14;
            }
        }
        if (this.rec != null && this.recordFromBeginning) {
            for (int i = 0; i < n; ++i) {
                this.rec.writeByte(nArray[i]);
            }
        }
        return n2;
    }

    void readRfbFileTransferMsg() throws IOException {
        int n;
        int n2 = this.is.readUnsignedByte();
        int n3 = n = this.is.readUnsignedByte();
        n = this.is.readUnsignedByte();
        n3 |= (n <<= 8);
        if (n2 == 2 || n2 == 2) {
            this.readDriveOrDirectory(n3);
        } else if (n2 == 4) {
            this.receiveFileHeader();
        } else if (n2 == 5) {
            this.receiveFileChunk();
        } else if (n2 == 6) {
            this.endOfReceiveFile(true);
        } else if (n2 == 7) {
            if (this.fFileReceptionRunning) {
                this.endOfReceiveFile(false);
            }
        } else if (n2 == 11) {
            this.createDirectoryorDeleteFile(n3);
        } else if (n2 == 9) {
            this.sendFile();
        } else if (n2 == 12) {
            this.ReceiveDestinationFileChecksums();
        } else {
            System.out.println("ContentType: " + n2);
        }
    }

    public void createDirectoryorDeleteFile(int n) throws IOException {
        if (n == 4) {
            this.createRemoteDirectoryFeedback();
        } else if (n == 7) {
            this.deleteRemoteFileFeedback();
        }
    }

    public void readDriveOrDirectory(int n) throws IOException {
        if (n == 3) {
            this.readFTPMsgDriveList();
        } else if (n == 1 && !this.inDirectory2) {
            this.inDirectory2 = true;
            this.readFTPMsgDirectoryList();
        } else if (n == 1 && this.inDirectory2) {
            this.readFTPMsgDirectoryListContent();
        } else if (n == 0) {
            this.readFTPMsgDirectoryListEndContent();
            this.inDirectory2 = false;
        } else {
            System.out.println("ContentParam: " + n);
        }
    }

    void writeRfbFileTransferMsg(int n, int n2, long l, long l2, String string) throws IOException {
        byte[] byArray = new byte[12];
        byArray[0] = 7;
        byArray[1] = (byte)n;
        byArray[2] = (byte)n2;
        byte by = 0;
        long l3 = 0L;
        ++l2;
        l3 = l & 0xFFFFFFFFFF000000L;
        byArray[4] = by = (byte)(l3 >>> 24);
        l3 = l & 0xFF0000L;
        byArray[5] = by = (byte)(l3 >>> 16);
        l3 = l & 0xFF00L;
        byArray[6] = by = (byte)(l3 >>> 8);
        l3 = l & 0xFFL;
        byArray[7] = by = (byte)l3;
        l3 = l2 & 0xFFFFFFFFFF000000L;
        byArray[8] = by = (byte)(l3 >>> 24);
        l3 = l2 & 0xFF0000L;
        byArray[9] = by = (byte)(l3 >>> 16);
        l3 = l2 & 0xFF00L;
        byArray[10] = by = (byte)(l3 >>> 8);
        l3 = l2 & 0xFFL;
        byArray[11] = by = (byte)l3;
        this.os.write(byArray);
        if (string != null) {
            byte[] byArray2 = string.getBytes();
            byte[] byArray3 = new byte[byArray2.length + 1];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray3[i] = byArray2[i];
            }
            byArray3[byArray3.length - 1] = 0;
            this.os.write(byArray3);
        }
    }

    int writeRfbFileTransferMsgForSendFile(int n, int n2, long l, long l2, String string) throws IOException {
        File file = new File(string);
        this.fis = new FileInputStream(file);
        byte[] byArray = new byte[8192];
        int n3 = this.fis.read(byArray);
        long l3 = 0L;
        boolean bl = false;
        boolean bl2 = true;
        Deflater deflater = new Deflater();
        byte[] byArray2 = new byte[9216];
        int n4 = 0;
        while (n3 != -1) {
            l3 += (long)n3;
            deflater.setInput(byArray, 0, n3);
            deflater.finish();
            n4 = deflater.deflate(byArray2);
            deflater.reset();
            if (n4 > n3) {
                bl2 = false;
            }
            this.writeRfbFileTransferMsg(n, n2, bl2 ? 1 : 0, bl2 ? n4 - 1 : n3 - 1, null);
            this.os.write(bl2 ? byArray2 : byArray, 0, bl2 ? n4 : n3);
            n3 = this.fis.read(byArray);
            this.viewer.ftp.jProgressBar.setValue((int)(l3 * 100L / file.length()));
            this.viewer.ftp.connectionStatus.setText(">>> Sending File: " + string + " - Size: " + file.length() + " bytes - Progress: " + l3 * 100L / file.length() + "%");
            if (this.fAbort) {
                this.fAbort = false;
                bl = true;
                break;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Interrupted");
            }
        }
        this.writeRfbFileTransferMsg(bl ? 7 : 6, 0, 0L, 0L, null);
        this.fis.close();
        return bl ? -1 : 1;
    }

    void sendFile() {
        try {
            int n;
            this.viewer.ftp.disableButtons();
            int n2 = this.is.readInt();
            int n3 = this.is.readInt();
            for (n = 0; n < n3; ++n) {
                System.out.print((char)this.is.readUnsignedByte());
            }
            n = this.writeRfbFileTransferMsgForSendFile(5, 0, 0L, 0L, this.sendFileSource);
            this.viewer.ftp.refreshRemoteLocation();
            if (n != 1) {
                this.viewer.ftp.connectionStatus.setText(" > Error - File NOT sent");
                this.viewer.ftp.historyComboBox.insertItemAt(new String(" > Error - File: <" + this.sendFileSource) + "> was not correctly sent (aborted by user or error)", 0);
            } else {
                this.viewer.ftp.connectionStatus.setText(" > File sent");
                this.viewer.ftp.historyComboBox.insertItemAt(new String(" > File: <" + this.sendFileSource) + "> was sent to Remote Machine", 0);
            }
            this.viewer.ftp.historyComboBox.setSelectedIndex(0);
            this.viewer.ftp.enableButtons();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void offerLocalFile(String string, String string2) {
        try {
            this.sendFileSource = string;
            File file = new File(string);
            long l = file.length();
            int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            int n2 = (int)(l >> 32);
            String string3 = string2 + file.getName();
            this.writeRfbFileTransferMsg(8, 0, n, string3.length(), string3);
            byte[] byArray = new byte[4];
            byte by = 0;
            long l2 = 0L;
            l2 = n2 & 0xFF000000;
            byArray[0] = by = (byte)(l2 >>> 24);
            l2 = n2 & 0xFF0000;
            byArray[1] = by = (byte)(l2 >>> 16);
            l2 = n2 & 0xFF00;
            byArray[2] = by = (byte)(l2 >>> 8);
            l2 = n2 & 0xFF;
            byArray[3] = by = (byte)l2;
            this.os.write(byArray);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void deleteRemoteFileFeedback() throws IOException {
        this.is.readInt();
        int n = this.is.readInt();
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + (char)this.is.readUnsignedByte();
        }
        this.viewer.ftp.refreshRemoteLocation();
        this.viewer.ftp.historyComboBox.insertItemAt(new String(" > Deleted File On Remote Machine: " + string.substring(0, string.length() - 1)), 0);
        this.viewer.ftp.historyComboBox.setSelectedIndex(0);
    }

    void deleteRemoteFile(String string) {
        try {
            String string2 = string;
            this.writeRfbFileTransferMsg(10, 4, 0L, string2.length(), string2);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void createRemoteDirectoryFeedback() throws IOException {
        this.is.readInt();
        int n = this.is.readInt();
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + (char)this.is.readUnsignedByte();
        }
        this.viewer.ftp.refreshRemoteLocation();
        this.viewer.ftp.historyComboBox.insertItemAt(new String(" > Created Directory on Remote Machine: " + string.substring(0, string.length() - 1)), 0);
        this.viewer.ftp.historyComboBox.setSelectedIndex(0);
    }

    void createRemoteDirectory(String string) {
        try {
            String string2 = string;
            this.writeRfbFileTransferMsg(10, 1, 0L, string2.length(), string2);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void requestRemoteFile(String string, String string2) {
        try {
            String string3 = string;
            this.receivePath = string2;
            this.writeRfbFileTransferMsg(3, 0, 1L, string3.length(), string3);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void receiveFileHeader() throws IOException {
        long l;
        int n;
        this.fFileReceptionRunning = true;
        this.fFileReceptionError = false;
        this.viewer.ftp.disableButtons();
        int n2 = this.is.readInt();
        int n3 = this.is.readInt();
        String string = "";
        for (n = 0; n < n3; ++n) {
            string = string + (char)this.is.readUnsignedByte();
        }
        n = this.is.readInt();
        this.receiveFileSize = l = ((long)n << 32) + (long)n2;
        this.viewer.ftp.connectionStatus.setText("Received: 0 bytes of " + l + " bytes");
        this.fileSize = 0L;
        this.fileChunkCounter = 0L;
        String string2 = this.receivePath;
        this.fos = new FileOutputStream(string2);
        this.writeRfbFileTransferMsg(4, 0, 0L, 0L, null);
    }

    void receiveFileChunk() throws IOException {
        int n = this.is.readInt();
        boolean bl = n != 0;
        int n2 = this.is.readInt();
        ++this.fileChunkCounter;
        byte[] byArray = new byte[n2 + 32];
        this.is.readFully(byArray, 0, n2);
        if (bl) {
            int n3 = 9216;
            int n4 = 0;
            byte[] byArray2 = new byte[n3];
            Inflater inflater = new Inflater();
            inflater.setInput(byArray);
            try {
                n4 = inflater.inflate(byArray2);
            }
            catch (DataFormatException dataFormatException) {
                System.err.println(dataFormatException);
            }
            this.fos.write(byArray2, 0, n4);
            this.fileSize += (long)n4;
        } else {
            this.fos.write(byArray, 0, n2);
            this.fileSize += (long)n2;
        }
        this.viewer.ftp.jProgressBar.setValue((int)(this.fileSize * 100L / this.receiveFileSize));
        this.viewer.ftp.connectionStatus.setText(">>> Receiving File: " + this.receivePath + " - Size: " + this.receiveFileSize + " bytes - Progress: " + this.fileSize * 100L / this.receiveFileSize + "%");
        if (this.fAbort) {
            this.fAbort = false;
            this.fFileReceptionError = true;
            this.writeRfbFileTransferMsg(7, 0, 0L, 0L, null);
        }
    }

    void endOfReceiveFile(boolean bl) throws IOException {
        int n = this.is.readInt();
        int n2 = this.is.readInt();
        this.fileSize = 0L;
        this.fos.close();
        this.viewer.ftp.refreshLocalLocation();
        if (bl && !this.fFileReceptionError) {
            this.viewer.ftp.connectionStatus.setText(" > File successfully received");
            this.viewer.ftp.historyComboBox.insertItemAt(new String(" > File: <" + this.receivePath + "> received from Remote Machine"), 0);
        } else {
            File file = new File(this.receivePath);
            file.delete();
            this.viewer.ftp.connectionStatus.setText(" > Error - File NOT received");
            this.viewer.ftp.historyComboBox.insertItemAt(new String(" > Error - File: <" + this.receivePath + "> not correctly received from Remote Machine (aborted by user or error)"), 0);
        }
        this.fFileReceptionError = false;
        this.fFileReceptionRunning = false;
        this.viewer.ftp.historyComboBox.setSelectedIndex(0);
        this.viewer.ftp.enableButtons();
    }

    void readServerDirectory(String string) {
        try {
            String string2 = string;
            this.writeRfbFileTransferMsg(1, 1, 0L, string2.length(), string2);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void readFTPMsgDriveList() throws IOException {
        int n;
        String string = "";
        for (n = 0; n < 4; ++n) {
            this.is.readUnsignedByte();
        }
        n = this.is.readInt();
        for (int i = 0; i < n; ++i) {
            char c = (char)this.is.readUnsignedByte();
            if (c == '\u0000') continue;
            string = string + c;
        }
        this.viewer.ftp.printDrives(string);
        this.viewer.ftp.changeLocalDirectory(this.viewer.ftp.getFirstReadableLocalDrive());
        this.viewer.ftp.changeRemoteDrive();
        this.viewer.ftp.refreshRemoteLocation();
    }

    void readFTPMsgDirectoryList() throws IOException {
        this.is.readInt();
        int n = this.is.readInt();
        if (n == 0) {
            this.readFTPMsgDirectorydriveNotReady();
            this.inDirectory2 = false;
        } else {
            String string = "";
            for (int i = 0; i < n; ++i) {
                char c = (char)this.is.readUnsignedByte();
                if (c == '\u0000') continue;
                string = string + c;
            }
        }
    }

    void readFTPMsgDirectoryListContent() throws IOException {
        String string = "";
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        this.is.readInt();
        n = this.is.readInt();
        int n2 = this.is.readInt();
        n -= 4;
        long l = this.is.readLong();
        n -= 8;
        long l2 = this.is.readLong();
        n -= 8;
        long l3 = this.is.readLong();
        n -= 8;
        int n3 = this.is.readInt();
        n -= 4;
        int n4 = this.is.readInt();
        n -= 4;
        int n5 = this.is.readInt();
        n -= 4;
        int n6 = this.is.readInt();
        n -= 4;
        char c = (char)this.is.readUnsignedByte();
        --n;
        while (c != '\u0000') {
            string = string + c;
            c = (char)this.is.readUnsignedByte();
            --n;
        }
        char c2 = (char)this.is.readByte();
        --n;
        while (n != 0) {
            string2 = string2 + c2;
            c2 = (char)this.is.readUnsignedByte();
            --n;
        }
        if (n2 == 0x10000000 || n2 == 0x16000000 || n2 == 0x11000000 || n2 == 271056896 || n2 == 824705024 || n2 == 807927808 || n2 == 371720192 || n2 == 369623040) {
            string = " [" + string + "]";
            this.remoteDirsList.add(string);
        } else {
            this.remoteFilesList.add(" " + string);
        }
    }

    void readFTPMsgDirectoryListEndContent() throws IOException {
        int n;
        this.is.readInt();
        int n2 = this.is.readInt();
        this.a.clear();
        for (n = 0; n < this.remoteDirsList.size(); ++n) {
            this.a.add(this.remoteDirsList.get(n));
        }
        for (n = 0; n < this.remoteFilesList.size(); ++n) {
            this.a.add(this.remoteFilesList.get(n));
        }
        this.remoteDirsList.clear();
        this.remoteFilesList.clear();
        this.viewer.ftp.printDirectory(this.a);
    }

    void readFTPMsgDirectorydriveNotReady() throws IOException {
        System.out.println("Remote Drive unavailable");
        this.viewer.ftp.connectionStatus.setText(" > WARNING - Remote Drive unavailable (possibly restricted access or media not present)");
        this.viewer.ftp.remoteStatus.setText("WARNING: Remote Drive unavailable");
    }

    void readServerDriveList() {
        try {
            this.viewer.rfb.writeRfbFileTransferMsg(1, 2, 0L, 0L, null);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void ReceiveDestinationFileChecksums() throws IOException {
        int n = this.is.readInt();
        int n2 = this.is.readInt();
        byte[] byArray = new byte[n2 + 32];
        this.is.readFully(byArray, 0, n2);
    }

    void writeFramebufferUpdateRequest(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        if (!this.viewer.ftp.isVisible()) {
            byte[] byArray = new byte[]{3, (byte)(bl ? 1 : 0), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
            this.os.write(byArray);
        }
    }

    void writeSetPixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl3) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = 0;
        byArray[4] = (byte)n;
        byArray[5] = (byte)n2;
        byArray[6] = (byte)(bl ? 1 : 0);
        byArray[7] = (byte)(bl2 ? 1 : 0);
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n3 & 0xFF);
        byArray[10] = (byte)(n4 >> 8 & 0xFF);
        byArray[11] = (byte)(n4 & 0xFF);
        byArray[12] = (byte)(n5 >> 8 & 0xFF);
        byArray[13] = (byte)(n5 & 0xFF);
        byArray[14] = (byte)n6;
        byArray[15] = (byte)n7;
        byArray[16] = (byte)n8;
        byArray[17] = (byte)(bl3 ? 1 : 0);
        this.os.write(byArray);
    }

    void writeFixColourMapEntries(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        byte[] byArray = new byte[6 + n2 * 6];
        byArray[0] = 1;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(n2 >> 8 & 0xFF);
        byArray[5] = (byte)(n2 & 0xFF);
        for (int i = 0; i < n2; ++i) {
            byArray[6 + i * 6] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 1] = (byte)(nArray[i] & 0xFF);
            byArray[6 + i * 6 + 2] = (byte)(nArray2[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 3] = (byte)(nArray2[i] & 0xFF);
            byArray[6 + i * 6 + 4] = (byte)(nArray3[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 5] = (byte)(nArray3[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    void writeSetEncodings(int[] nArray, int n) throws IOException {
        byte[] byArray = new byte[4 + 4 * n];
        byArray[0] = 2;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        for (int i = 0; i < n; ++i) {
            byArray[4 + 4 * i] = (byte)(nArray[i] >> 24 & 0xFF);
            byArray[5 + 4 * i] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray[6 + 4 * i] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[7 + 4 * i] = (byte)(nArray[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    void writeClientCutText(String string) throws IOException {
        byte[] byArray = new byte[8 + string.length()];
        byArray[0] = 6;
        byArray[4] = (byte)(string.length() >> 24 & 0xFF);
        byArray[5] = (byte)(string.length() >> 16 & 0xFF);
        byArray[6] = (byte)(string.length() >> 8 & 0xFF);
        byArray[7] = (byte)(string.length() & 0xFF);
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        this.os.write(byArray);
    }

    void writePointerEvent(MouseEvent mouseEvent) throws IOException {
        if (!this.viewer.ftp.isVisible()) {
            int n = mouseEvent.getModifiers();
            int n2 = 2;
            int n3 = 4;
            if (this.viewer.options.reverseMouseButtons2And3) {
                n2 = 4;
                n3 = 2;
            }
            if (mouseEvent.getID() == 501) {
                if ((n & 8) != 0) {
                    this.pointerMask = n2;
                    n &= 0xFFFFFFF7;
                } else if ((n & 4) != 0) {
                    this.pointerMask = n3;
                    n &= 0xFFFFFFFB;
                } else {
                    this.pointerMask = 1;
                }
            } else if (mouseEvent.getID() == 502) {
                this.pointerMask = 0;
                if ((n & 8) != 0) {
                    n &= 0xFFFFFFF7;
                } else if ((n & 4) != 0) {
                    n &= 0xFFFFFFFB;
                }
            }
            this.eventBufLen = 0;
            this.writeModifierKeyEvents(n);
            int n4 = mouseEvent.getX();
            int n5 = mouseEvent.getY();
            if (n4 < 0) {
                n4 = 0;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            this.eventBuf[this.eventBufLen++] = 5;
            this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
            this.eventBuf[this.eventBufLen++] = (byte)(n4 >> 8 & 0xFF);
            this.eventBuf[this.eventBufLen++] = (byte)(n4 & 0xFF);
            this.eventBuf[this.eventBufLen++] = (byte)(n5 >> 8 & 0xFF);
            this.eventBuf[this.eventBufLen++] = (byte)(n5 & 0xFF);
            if (this.pointerMask == 0) {
                this.writeModifierKeyEvents(0);
            }
            this.os.write(this.eventBuf, 0, this.eventBufLen);
        }
    }

    void writeKeyEvent(KeyEvent keyEvent) throws IOException {
        block43: {
            int n;
            boolean bl;
            block45: {
                int n2;
                block44: {
                    if (this.viewer.ftp.isVisible()) break block43;
                    n2 = keyEvent.getKeyChar();
                    if (n2 == 0) {
                        n2 = 65535;
                    }
                    if (n2 == 65535 && ((bl = keyEvent.getKeyCode()) || bl || bl || bl)) {
                        return;
                    }
                    boolean bl2 = bl = keyEvent.getID() == 401;
                    if (!keyEvent.isActionKey()) break block44;
                    switch (keyEvent.getKeyCode()) {
                        case 36: {
                            n = 65360;
                            break block45;
                        }
                        case 37: {
                            n = 65361;
                            break block45;
                        }
                        case 38: {
                            n = 65362;
                            break block45;
                        }
                        case 39: {
                            n = 65363;
                            break block45;
                        }
                        case 40: {
                            n = 65364;
                            break block45;
                        }
                        case 33: {
                            n = 65365;
                            break block45;
                        }
                        case 34: {
                            n = 65366;
                            break block45;
                        }
                        case 35: {
                            n = 65367;
                            break block45;
                        }
                        case 155: {
                            n = 65379;
                            break block45;
                        }
                        case 112: {
                            n = 65470;
                            break block45;
                        }
                        case 113: {
                            n = 65471;
                            break block45;
                        }
                        case 114: {
                            n = 65472;
                            break block45;
                        }
                        case 115: {
                            n = 65473;
                            break block45;
                        }
                        case 116: {
                            n = 65474;
                            break block45;
                        }
                        case 117: {
                            n = 65475;
                            break block45;
                        }
                        case 118: {
                            n = 65476;
                            break block45;
                        }
                        case 119: {
                            n = 65477;
                            break block45;
                        }
                        case 120: {
                            n = 65478;
                            break block45;
                        }
                        case 121: {
                            n = 65479;
                            break block45;
                        }
                        case 122: {
                            n = 65480;
                            break block45;
                        }
                        case 123: {
                            n = 65481;
                            break block45;
                        }
                        default: {
                            return;
                        }
                    }
                }
                n = n2;
                if (n < 32) {
                    if (keyEvent.isControlDown()) {
                        n += 96;
                    } else {
                        switch (n) {
                            case 8: {
                                n = 65288;
                                break;
                            }
                            case 9: {
                                n = 65289;
                                break;
                            }
                            case 10: {
                                n = 65293;
                                break;
                            }
                            case 27: {
                                n = 65307;
                            }
                        }
                    }
                } else if (n == 127) {
                    n = 65535;
                } else if (n > 255 && (n < 65280 || n > 65535)) {
                    return;
                }
            }
            if (n == 229 || n == 197 || n == 228 || n == 196 || n == 246 || n == 214 || n == 167 || n == 189 || n == 163) {
                if (bl) {
                    this.brokenKeyPressed = true;
                }
                if (!bl && !this.brokenKeyPressed) {
                    this.eventBufLen = 0;
                    this.writeModifierKeyEvents(keyEvent.getModifiers());
                    this.writeKeyEvent(n, true);
                    this.os.write(this.eventBuf, 0, this.eventBufLen);
                }
                if (!bl) {
                    this.brokenKeyPressed = false;
                }
            }
            this.eventBufLen = 0;
            this.writeModifierKeyEvents(keyEvent.getModifiers());
            this.writeKeyEvent(n, bl);
            if (!bl) {
                this.writeModifierKeyEvents(0);
            }
            this.os.write(this.eventBuf, 0, this.eventBufLen);
        }
    }

    void writeKeyEvent(int n, boolean bl) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(bl ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n & 0xFF);
    }

    void writeModifierKeyEvents(int n) {
        if ((n & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        if ((n & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        this.oldModifiers = n;
    }

    void recordCompressedData(byte[] byArray, int n, int n2) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray, n, n2);
        int n3 = n2 + n2 / 100 + 12;
        byte[] byArray2 = new byte[n3];
        deflater.finish();
        int n4 = deflater.deflate(byArray2);
        this.recordCompactLen(n4);
        this.rec.write(byArray2, 0, n4);
    }

    void recordCompressedData(byte[] byArray) throws IOException {
        this.recordCompressedData(byArray, 0, byArray.length);
    }

    void recordCompactLen(int n) throws IOException {
        byte[] byArray = new byte[3];
        int n2 = 0;
        byArray[n2++] = (byte)(n & 0x7F);
        if (n > 127) {
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] | 0x80);
            byArray[n2++] = (byte)(n >> 7 & 0x7F);
            if (n > 16383) {
                int n4 = n2 - 1;
                byArray[n4] = (byte)(byArray[n4] | 0x80);
                byArray[n2++] = (byte)(n >> 14 & 0xFF);
            }
        }
        this.rec.write(byArray, 0, n2);
    }
}

