/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.Inflater;

class VncCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    VncViewer viewer;
    private RfbProto rfb;
    ColorModel cm8_256c;
    ColorModel cm8_64c;
    ColorModel cm8_8c;
    ColorModel cm24;
    Color[] colors;
    int bytesPixel;
    Image memImage;
    Graphics memGraphics;
    Image rawPixelsImage;
    MemoryImageSource pixelsSource;
    byte[] pixels8;
    int[] pixels24;
    byte[] zlibBuf;
    int zlibBufLen = 0;
    Inflater zlibInflater;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    Rectangle jpegRect;
    boolean inputEnabled;
    private Color hextile_bg;
    private Color hextile_fg;
    boolean showSoftCursor = false;
    int[] softCursorPixels;
    MemoryImageSource softCursorSource;
    Image softCursor;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int hotX;
    int hotY;

    VncCanvas(VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.rfb = this.viewer.rfb;
        this.tightInflaters = new Inflater[4];
        this.cm8_256c = new DirectColorModel(8, 7, 56, 192);
        this.cm8_64c = new DirectColorModel(8, 48, 12, 3);
        this.cm8_8c = new DirectColorModel(8, 4, 2, 1);
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.colors = new Color[256];
        for (int i = 0; i < 256; ++i) {
            this.colors[i] = new Color(this.cm8_256c.getRGB(i));
        }
        this.setPixelFormat();
        this.inputEnabled = false;
        if (!this.viewer.options.viewOnly) {
            this.enableInput(true);
        }
        this.addKeyListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle;
        Image image = this.memImage;
        synchronized (image) {
            graphics.drawImage(this.memImage, 0, 0, null);
        }
        if (this.showSoftCursor && (rectangle = new Rectangle(n2 = this.cursorX - this.hotX, n = this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight)).intersects(graphics.getClipBounds())) {
            graphics.drawImage(this.softCursor, n2, n, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xA0) == 0) {
            return true;
        }
        if ((n & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.memGraphics.drawImage(image, this.jpegRect.x, this.jpegRect.y, null);
                this.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    public synchronized void enableInput(boolean bl) {
        if (bl && !this.inputEnabled) {
            this.inputEnabled = true;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else if (!bl && this.inputEnabled) {
            this.inputEnabled = false;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
    }

    public void setPixelFormat() throws IOException {
        if (this.viewer.options.eightBitColors > 0) {
            this.viewer.options.oldEightBitColors = this.viewer.options.eightBitColors;
            switch (this.viewer.options.eightBitColors) {
                case 1: {
                    for (int i = 0; i < 256; ++i) {
                        this.colors[i] = new Color(this.cm8_256c.getRGB(i));
                    }
                    this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6, false);
                    break;
                }
                case 2: {
                    for (int i = 0; i < 256; ++i) {
                        this.colors[i] = new Color(this.cm8_64c.getRGB(i));
                    }
                    this.rfb.writeSetPixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0, false);
                    break;
                }
                case 3: {
                    for (int i = 0; i < 256; ++i) {
                        this.colors[i] = new Color(this.cm8_8c.getRGB(i));
                    }
                    this.rfb.writeSetPixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0, false);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 256; ++i) {
                        this.colors[i] = new Color(this.cm8_64c.getRGB(i));
                    }
                    this.rfb.writeSetPixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0, true);
                    break;
                }
                case 5: {
                    for (int i = 0; i < 256; ++i) {
                        this.colors[i] = new Color(this.cm8_8c.getRGB(i));
                    }
                    this.rfb.writeSetPixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0, true);
                }
            }
            this.bytesPixel = 1;
        } else {
            this.rfb.writeSetPixelFormat(32, 24, false, true, 255, 255, 255, 16, 8, 0, false);
            this.bytesPixel = 4;
        }
        this.updateFramebufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFramebufferSize() {
        Object object;
        int n = this.rfb.framebufferWidth;
        int n2 = this.rfb.framebufferHeight;
        if (this.memImage == null) {
            this.memImage = this.viewer.createImage(n, n2);
            this.memGraphics = this.memImage.getGraphics();
        } else if (this.memImage.getWidth(null) != n || this.memImage.getHeight(null) != n2) {
            object = this.memImage;
            synchronized (object) {
                this.memImage = this.viewer.createImage(n, n2);
                this.memGraphics = this.memImage.getGraphics();
            }
        }
        if (this.bytesPixel == 1) {
            this.pixels24 = null;
            this.pixels8 = new byte[n * n2];
            object = this.cm8_8c;
            switch (this.viewer.options.eightBitColors) {
                case 1: {
                    object = this.cm8_256c;
                    break;
                }
                case 2: 
                case 4: {
                    object = this.cm8_64c;
                    break;
                }
                case 3: 
                case 5: {
                    object = this.cm8_8c;
                }
            }
            this.pixelsSource = new MemoryImageSource(n, n2, (ColorModel)object, this.pixels8, 0, n);
        } else {
            this.pixels8 = null;
            this.pixels24 = new int[n * n2];
            this.pixelsSource = new MemoryImageSource(n, n2, this.cm24, this.pixels24, 0, n);
        }
        this.pixelsSource.setAnimated(true);
        this.rawPixelsImage = this.createImage(this.pixelsSource);
        if (this.viewer.inSeparateFrame) {
            if (this.viewer.desktopScrollPane != null) {
                this.resizeDesktopFrame();
            }
        } else {
            this.setSize(n, n2);
        }
    }

    void resizeDesktopFrame() {
        Dimension dimension;
        this.setSize(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        Insets insets = this.viewer.desktopScrollPane.getInsets();
        this.viewer.desktopScrollPane.setSize(this.rfb.framebufferWidth + 2 * Math.min(insets.left, insets.right), this.rfb.framebufferHeight + 2 * Math.min(insets.top, insets.bottom));
        this.viewer.vncFrame.pack();
        Dimension dimension2 = this.viewer.vncFrame.getToolkit().getScreenSize();
        Dimension dimension3 = dimension = this.viewer.vncFrame.getSize();
        boolean bl = false;
        if (dimension.height > dimension2.height) {
            dimension3.height = dimension2.height;
            bl = true;
        }
        if (dimension.width > dimension2.width) {
            dimension3.width = dimension2.width;
            bl = true;
        }
        if (bl) {
            this.viewer.vncFrame.setSize(dimension3);
        }
        this.viewer.desktopScrollPane.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processNormalProtocol() throws Exception {
        this.viewer.checkRecordingStatus();
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        block22: while (true) {
            var1_1 = this.rfb.readServerMessageType();
            switch (var1_1) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    block23: for (var2_2 = 0; var2_2 < this.rfb.updateNRects; ++var2_2) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        var3_3 = this.rfb.updateRectX;
                        var4_6 = this.rfb.updateRectY;
                        var5_8 = this.rfb.updateRectW;
                        var6_9 = this.rfb.updateRectH;
                        if (this.rfb.updateRectEncoding == -224) break;
                        if (this.rfb.updateRectEncoding == -223) {
                            this.rfb.setFramebufferSize(var5_8, var6_9);
                            this.updateFramebufferSize();
                            break;
                        }
                        if (this.rfb.updateRectEncoding == -240) ** GOTO lbl25
                        if (this.rfb.updateRectEncoding != -239) ** GOTO lbl27
lbl25:
                        // 2 sources

                        this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, var3_3, var4_6, var5_8, var6_9);
                        continue;
lbl27:
                        // 1 sources

                        switch (this.rfb.updateRectEncoding) {
                            case 0: {
                                this.handleRawRect(var3_3, var4_6, var5_8, var6_9);
                                continue block23;
                            }
                            case 1: {
                                this.handleCopyRect(var3_3, var4_6, var5_8, var6_9);
                                continue block23;
                            }
                            case 2: {
                                this.handleRRERect(var3_3, var4_6, var5_8, var6_9);
                                continue block23;
                            }
                            case 4: {
                                this.handleCoRRERect(var3_3, var4_6, var5_8, var6_9);
                                continue block23;
                            }
                            case 5: {
                                this.handleHextileRect(var3_3, var4_6, var5_8, var6_9);
                                continue block23;
                            }
                            case 6: {
                                this.handleZlibRect(var3_3, var4_6, var5_8, var6_9);
                                continue block23;
                            }
                            case 7: {
                                this.handleTightRect(var3_3, var4_6, var5_8, var6_9);
                                continue block23;
                            }
                            case -232: {
                                this.handleCursorPosUpdate(var3_3, var4_6);
                                continue block23;
                            }
                            default: {
                                throw new Exception("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                            }
                        }
                    }
                    var2_2 = 0;
                    if (this.viewer.checkRecordingStatus()) {
                        var2_2 = 1;
                    }
                    if (this.viewer.deferUpdateRequests > 0) {
                        var3_4 = this.rfb;
                        synchronized (var3_4) {
                            try {
                                this.rfb.wait(this.viewer.deferUpdateRequests);
                            }
                            catch (InterruptedException var4_7) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.viewer.options.eightBitColors > 0 && this.bytesPixel != 1 || this.viewer.options.eightBitColors == 0 && this.bytesPixel == 1 || this.viewer.options.eightBitColors != this.viewer.options.oldEightBitColors) {
                        this.setPixelFormat();
                        var2_2 = 1;
                    }
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, var2_2 == 0);
                    continue block22;
                }
                case 1: {
                    throw new Exception("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block22;
                }
                case 3: {
                    var3_5 = this.rfb.readServerCutText();
                    this.viewer.clipboard.setCutText(var3_5);
                    continue block22;
                }
                case 7: {
                    this.viewer.rfb.readRfbFileTransferMsg();
                    continue block22;
                }
            }
            break;
        }
        throw new Exception("Unknown RFB message type " + var1_1);
    }

    void handleRawRect(int n, int n2, int n3, int n4) throws IOException {
        this.handleRawRect(n, n2, n3, n4, true);
    }

    void handleRawRect(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        if (this.bytesPixel == 1) {
            for (int i = n2; i < n2 + n4; ++i) {
                this.rfb.is.readFully(this.pixels8, i * this.rfb.framebufferWidth + n, n3);
                if (this.rfb.rec == null) continue;
                this.rfb.rec.write(this.pixels8, i * this.rfb.framebufferWidth + n, n3);
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            for (int i = n2; i < n2 + n4; ++i) {
                this.rfb.is.readFully(byArray);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(byArray);
                }
                int n5 = i * this.rfb.framebufferWidth + n;
                for (int j = 0; j < n3; ++j) {
                    this.pixels24[n5 + j] = (byArray[j * 4 + 2] & 0xFF) << 16 | (byArray[j * 4 + 1] & 0xFF) << 8 | byArray[j * 4] & 0xFF;
                }
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        if (bl) {
            this.scheduleRepaint(n, n2, n3, n4);
        }
    }

    void handleCopyRect(int n, int n2, int n3, int n4) throws IOException {
        this.rfb.readCopyRect();
        this.memGraphics.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, n3, n4, n - this.rfb.copyRectSrcX, n2 - this.rfb.copyRectSrcY);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleRRERect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readInt();
        byte[] byArray = new byte[this.bytesPixel];
        this.rfb.is.readFully(byArray);
        Color color = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        this.memGraphics.setColor(color);
        this.memGraphics.fillRect(n, n2, n3, n4);
        byte[] byArray2 = new byte[n5 * (this.bytesPixel + 8)];
        this.rfb.is.readFully(byArray2);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(byArray);
            this.rfb.rec.write(byArray2);
        }
        for (int i = 0; i < n5; ++i) {
            if (this.bytesPixel == 1) {
                color = this.colors[dataInputStream.readUnsignedByte()];
            } else {
                dataInputStream.skip(4L);
                color = new Color(byArray2[i * 12 + 2] & 0xFF, byArray2[i * 12 + 1] & 0xFF, byArray2[i * 12] & 0xFF);
            }
            int n6 = n + dataInputStream.readUnsignedShort();
            int n7 = n2 + dataInputStream.readUnsignedShort();
            int n8 = dataInputStream.readUnsignedShort();
            int n9 = dataInputStream.readUnsignedShort();
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n6, n7, n8, n9);
        }
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleCoRRERect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readInt();
        byte[] byArray = new byte[this.bytesPixel];
        this.rfb.is.readFully(byArray);
        Color color = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
        this.memGraphics.setColor(color);
        this.memGraphics.fillRect(n, n2, n3, n4);
        byte[] byArray2 = new byte[n5 * (this.bytesPixel + 4)];
        this.rfb.is.readFully(byArray2);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(byArray);
            this.rfb.rec.write(byArray2);
        }
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            if (this.bytesPixel == 1) {
                color = this.colors[byArray2[n6++] & 0xFF];
            } else {
                color = new Color(byArray2[n6 + 2] & 0xFF, byArray2[n6 + 1] & 0xFF, byArray2[n6] & 0xFF);
                n6 += 4;
            }
            int n7 = n + (byArray2[n6++] & 0xFF);
            int n8 = n2 + (byArray2[n6++] & 0xFF);
            int n9 = byArray2[n6++] & 0xFF;
            int n10 = byArray2[n6++] & 0xFF;
            this.memGraphics.setColor(color);
            this.memGraphics.fillRect(n7, n8, n9, n10);
        }
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleHextileRect(int n, int n2, int n3, int n4) throws IOException {
        this.hextile_bg = new Color(0);
        this.hextile_fg = new Color(0);
        for (int i = n2; i < n2 + n4; i += 16) {
            int n5 = 16;
            if (n2 + n4 - i < 16) {
                n5 = n2 + n4 - i;
            }
            for (int j = n; j < n + n3; j += 16) {
                int n6 = 16;
                if (n + n3 - j < 16) {
                    n6 = n + n3 - j;
                }
                this.handleHextileSubrect(j, i, n6, n5);
            }
            this.scheduleRepaint(n, n2, n3, n4);
        }
    }

    void handleHextileSubrect(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.rfb.is.readUnsignedByte();
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(n5);
        }
        this.rfb.getClass();
        if ((n5 & 1) != 0) {
            this.handleRawRect(n, n2, n3, n4, false);
            return;
        }
        byte[] byArray = new byte[this.bytesPixel];
        this.rfb.getClass();
        if ((n5 & 2) != 0) {
            this.rfb.is.readFully(byArray);
            this.hextile_bg = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(byArray);
            }
        }
        this.memGraphics.setColor(this.hextile_bg);
        this.memGraphics.fillRect(n, n2, n3, n4);
        this.rfb.getClass();
        if ((n5 & 4) != 0) {
            this.rfb.is.readFully(byArray);
            this.hextile_fg = this.bytesPixel == 1 ? this.colors[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(byArray);
            }
        }
        if ((n5 & this.rfb.HextileAnySubrects) == 0) {
            return;
        }
        int n6 = this.rfb.is.readUnsignedByte();
        int n7 = n6 * 2;
        if ((n5 & this.rfb.HextileSubrectsColoured) != 0) {
            n7 += n6 * this.bytesPixel;
        }
        byte[] byArray2 = new byte[n7];
        this.rfb.is.readFully(byArray2);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(n6);
            this.rfb.rec.write(byArray2);
        }
        int n8 = 0;
        if ((n5 & this.rfb.HextileSubrectsColoured) == 0) {
            this.memGraphics.setColor(this.hextile_fg);
            for (int i = 0; i < n6; ++i) {
                int n9 = byArray2[n8++] & 0xFF;
                int n10 = byArray2[n8++] & 0xFF;
                int n11 = n + (n9 >> 4);
                int n12 = n2 + (n9 & 0xF);
                int n13 = (n10 >> 4) + 1;
                int n14 = (n10 & 0xF) + 1;
                this.memGraphics.fillRect(n11, n12, n13, n14);
            }
        } else if (this.bytesPixel == 1) {
            for (int i = 0; i < n6; ++i) {
                this.hextile_fg = this.colors[byArray2[n8++] & 0xFF];
                int n15 = byArray2[n8++] & 0xFF;
                int n16 = byArray2[n8++] & 0xFF;
                int n17 = n + (n15 >> 4);
                int n18 = n2 + (n15 & 0xF);
                int n19 = (n16 >> 4) + 1;
                int n20 = (n16 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(n17, n18, n19, n20);
            }
        } else {
            for (int i = 0; i < n6; ++i) {
                this.hextile_fg = new Color(byArray2[n8 + 2] & 0xFF, byArray2[n8 + 1] & 0xFF, byArray2[n8] & 0xFF);
                n8 += 4;
                int n21 = byArray2[n8++] & 0xFF;
                int n22 = byArray2[n8++] & 0xFF;
                int n23 = n + (n21 >> 4);
                int n24 = n2 + (n21 & 0xF);
                int n25 = (n22 >> 4) + 1;
                int n26 = (n22 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(n23, n24, n25, n26);
            }
        }
    }

    void handleZlibRect(int n, int n2, int n3, int n4) throws Exception {
        int n5 = this.rfb.is.readInt();
        if (this.zlibBuf == null || this.zlibBufLen < n5) {
            this.zlibBufLen = n5 * 2;
            this.zlibBuf = new byte[this.zlibBufLen];
        }
        this.rfb.is.readFully(this.zlibBuf, 0, n5);
        if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
            this.rfb.rec.writeIntBE(n5);
            this.rfb.rec.write(this.zlibBuf, 0, n5);
        }
        if (this.zlibInflater == null) {
            this.zlibInflater = new Inflater();
        }
        this.zlibInflater.setInput(this.zlibBuf, 0, n5);
        if (this.bytesPixel == 1) {
            for (int i = n2; i < n2 + n4; ++i) {
                this.zlibInflater.inflate(this.pixels8, i * this.rfb.framebufferWidth + n, n3);
                if (this.rfb.rec == null || this.rfb.recordFromBeginning) continue;
                this.rfb.rec.write(this.pixels8, i * this.rfb.framebufferWidth + n, n3);
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            for (int i = n2; i < n2 + n4; ++i) {
                this.zlibInflater.inflate(byArray);
                int n6 = i * this.rfb.framebufferWidth + n;
                for (int j = 0; j < n3; ++j) {
                    this.pixels24[n6 + j] = (byArray[j * 4 + 2] & 0xFF) << 16 | (byArray[j * 4 + 1] & 0xFF) << 8 | byArray[j * 4] & 0xFF;
                }
                if (this.rfb.rec == null || this.rfb.recordFromBeginning) continue;
                this.rfb.rec.write(byArray);
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void handleTightRect(int var1_1, int var2_2, int var3_3, int var4_4) throws Exception {
        block72: {
            var5_5 = this.rfb.is.readUnsignedByte();
            if (this.rfb.rec == null) break block72;
            if (this.rfb.recordFromBeginning) ** GOTO lbl-1000
            if (var5_5 == 8 << 4) ** GOTO lbl-1000
            if (var5_5 == 9 << 4) lbl-1000:
            // 3 sources

            {
                this.rfb.rec.writeByte(var5_5);
            } else {
                this.rfb.rec.writeByte(var5_5 | 15);
            }
        }
        for (var6_6 = 0; var6_6 < 4; ++var6_6) {
            if ((var5_5 & 1) != 0 && this.tightInflaters[var6_6] != null) {
                this.tightInflaters[var6_6] = null;
            }
            var5_5 >>= 1;
        }
        if (var5_5 > 9) {
            throw new Exception("Incorrect tight subencoding: " + var5_5);
        }
        if (var5_5 == 8) {
            if (this.bytesPixel == 1) {
                var6_6 = this.rfb.is.readUnsignedByte();
                this.memGraphics.setColor(this.colors[var6_6]);
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(var6_6);
                }
            } else {
                var6_7 = new byte[3];
                this.rfb.is.readFully(var6_7);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(var6_7);
                }
                var7_9 = new Color(-16777216 | (var6_7[0] & 255) << 16 | (var6_7[1] & 255) << 8 | var6_7[2] & 255);
                this.memGraphics.setColor(var7_9);
            }
            this.memGraphics.fillRect(var1_1, var2_2, var3_3, var4_4);
            this.scheduleRepaint(var1_1, var2_2, var3_3, var4_4);
            return;
        }
        if (var5_5 == 9) {
            var6_8 = new byte[this.rfb.readCompactLen()];
            this.rfb.is.readFully(var6_8);
            if (this.rfb.rec != null) {
                if (!this.rfb.recordFromBeginning) {
                    this.rfb.recordCompactLen(var6_8.length);
                }
                this.rfb.rec.write(var6_8);
            }
            var7_10 = Toolkit.getDefaultToolkit().createImage(var6_8);
            var8_12 = this.jpegRect = new Rectangle(var1_1, var2_2, var3_3, var4_4);
            synchronized (var8_12) {
                Toolkit.getDefaultToolkit().prepareImage(var7_10, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException var9_14) {
                    throw new Exception("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        var6_6 = 0;
        var7_11 = var3_3;
        var8_13 = new byte[2];
        var9_15 = new int[256];
        var10_17 = false;
        if ((var5_5 & 4) != 0) {
            var11_18 = this.rfb.is.readUnsignedByte();
            if (this.rfb.rec != null) {
                this.rfb.rec.writeByte(var11_18);
            }
            if (var11_18 == 1) {
                var6_6 = this.rfb.is.readUnsignedByte() + 1;
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(var6_6 - 1);
                }
                if (this.bytesPixel == 1) {
                    if (var6_6 != 2) {
                        throw new Exception("Incorrect tight palette size: " + var6_6);
                    }
                    this.rfb.is.readFully(var8_13);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(var8_13);
                    }
                } else {
                    var12_19 = new byte[var6_6 * 3];
                    this.rfb.is.readFully(var12_19);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(var12_19);
                    }
                    for (var13_22 = 0; var13_22 < var6_6; ++var13_22) {
                        var9_15[var13_22] = (var12_19[var13_22 * 3] & 255) << 16 | (var12_19[var13_22 * 3 + 1] & 255) << 8 | var12_19[var13_22 * 3 + 2] & 255;
                    }
                }
                if (var6_6 == 2) {
                    var7_11 = (var3_3 + 7) / 8;
                }
            } else if (var11_18 == 2) {
                var10_17 = true;
            } else if (var11_18 != 0) {
                throw new Exception("Incorrect tight filter id: " + var11_18);
            }
        }
        if (var6_6 == 0 && this.bytesPixel == 4) {
            var7_11 *= 3;
        }
        var11_18 = var4_4 * var7_11;
        if (var11_18 < 12) {
            if (var6_6 != 0) {
                var12_19 = new byte[var11_18];
                this.rfb.is.readFully(var12_19);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(var12_19);
                }
                if (var6_6 == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(var1_1, var2_2, var3_3, var4_4, var12_19, var8_13);
                    } else {
                        this.decodeMonoData(var1_1, var2_2, var3_3, var4_4, var12_19, var9_15);
                    }
                } else {
                    var13_22 = 0;
                    for (var14_24 = var2_2; var14_24 < var2_2 + var4_4; ++var14_24) {
                        for (var15_27 = var1_1; var15_27 < var1_1 + var3_3; ++var15_27) {
                            this.pixels24[var14_24 * this.rfb.framebufferWidth + var15_27] = var9_15[var12_19[var13_22++] & 255];
                        }
                    }
                }
            } else if (var10_17) {
                var12_19 = new byte[var3_3 * var4_4 * 3];
                this.rfb.is.readFully(var12_19);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(var12_19);
                }
                this.decodeGradientData(var1_1, var2_2, var3_3, var4_4, var12_19);
            } else if (this.bytesPixel == 1) {
                for (var12_20 = var2_2; var12_20 < var2_2 + var4_4; ++var12_20) {
                    this.rfb.is.readFully(this.pixels8, var12_20 * this.rfb.framebufferWidth + var1_1, var3_3);
                    if (this.rfb.rec == null) continue;
                    this.rfb.rec.write(this.pixels8, var12_20 * this.rfb.framebufferWidth + var1_1, var3_3);
                }
            } else {
                var12_19 = new byte[var3_3 * 3];
                for (var15_28 = var2_2; var15_28 < var2_2 + var4_4; ++var15_28) {
                    this.rfb.is.readFully(var12_19);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(var12_19);
                    }
                    var14_25 = var15_28 * this.rfb.framebufferWidth + var1_1;
                    for (var13_22 = 0; var13_22 < var3_3; ++var13_22) {
                        this.pixels24[var14_25 + var13_22] = (var12_19[var13_22 * 3] & 255) << 16 | (var12_19[var13_22 * 3 + 1] & 255) << 8 | var12_19[var13_22 * 3 + 2] & 255;
                    }
                }
            }
        } else {
            var12_21 = this.rfb.readCompactLen();
            var13_23 = new byte[var12_21];
            this.rfb.is.readFully(var13_23);
            if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
                this.rfb.rec.write(var13_23);
            }
            if (this.tightInflaters[var14_26 = var5_5 & 3] == null) {
                this.tightInflaters[var14_26] = new Inflater();
            }
            var15_29 = this.tightInflaters[var14_26];
            var15_29.setInput(var13_23);
            var16_30 = new byte[var11_18];
            var15_29.inflate(var16_30);
            if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                this.rfb.recordCompressedData(var16_30);
            }
            if (var6_6 != 0) {
                if (var6_6 == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(var1_1, var2_2, var3_3, var4_4, var16_30, var8_13);
                    } else {
                        this.decodeMonoData(var1_1, var2_2, var3_3, var4_4, var16_30, var9_15);
                    }
                } else {
                    var17_31 = 0;
                    for (var18_34 = var2_2; var18_34 < var2_2 + var4_4; ++var18_34) {
                        for (var19_37 = var1_1; var19_37 < var1_1 + var3_3; ++var19_37) {
                            this.pixels24[var18_34 * this.rfb.framebufferWidth + var19_37] = var9_15[var16_30[var17_31++] & 255];
                        }
                    }
                }
            } else if (var10_17) {
                this.decodeGradientData(var1_1, var2_2, var3_3, var4_4, var16_30);
            } else if (this.bytesPixel == 1) {
                var17_32 = var2_2 * this.rfb.framebufferWidth + var1_1;
                for (var18_35 = 0; var18_35 < var4_4; ++var18_35) {
                    System.arraycopy(var16_30, var18_35 * var3_3, this.pixels8, var17_32, var3_3);
                    var17_32 += this.rfb.framebufferWidth;
                }
            } else {
                var17_33 = 0;
                for (var20_39 = 0; var20_39 < var4_4; ++var20_39) {
                    var15_29.inflate(var16_30);
                    var18_36 = (var2_2 + var20_39) * this.rfb.framebufferWidth + var1_1;
                    for (var19_38 = 0; var19_38 < var3_3; ++var19_38) {
                        this.pixels24[var18_36 + var19_38] = (var16_30[var17_33] & 255) << 16 | (var16_30[var17_33 + 1] & 255) << 8 | var16_30[var17_33 + 2] & 255;
                        var17_33 += 3;
                    }
                }
            }
        }
        this.handleUpdatedPixels(var1_1, var2_2, var3_3, var4_4);
        this.scheduleRepaint(var1_1, var2_2, var3_3, var4_4);
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            for (n8 = 0; n8 < n3 / 8; ++n8) {
                byte by = byArray[i * n6 + n8];
                for (n7 = 7; n7 >= 0; --n7) {
                    this.pixels8[n5++] = byArray2[by >> n7 & 1];
                }
            }
            for (n7 = 7; n7 >= 8 - n3 % 8; --n7) {
                this.pixels8[n5++] = byArray2[byArray[i * n6 + n8] >> n7 & 1];
            }
            n5 += this.rfb.framebufferWidth - n3;
        }
    }

    void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) {
        int n5 = n2 * this.rfb.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            for (n8 = 0; n8 < n3 / 8; ++n8) {
                byte by = byArray[i * n6 + n8];
                for (n7 = 7; n7 >= 0; --n7) {
                    this.pixels24[n5++] = nArray[by >> n7 & 1];
                }
            }
            for (n7 = 7; n7 >= 8 - n3 % 8; --n7) {
                this.pixels24[n5++] = nArray[byArray[i * n6 + n8] >> n7 & 1];
            }
            n5 += this.rfb.framebufferWidth - n3;
        }
    }

    void decodeGradientData(int n, int n2, int n3, int n4, byte[] byArray) {
        byte[] byArray2 = new byte[n3 * 3];
        byte[] byArray3 = new byte[n3 * 3];
        byte[] byArray4 = new byte[3];
        int[] nArray = new int[3];
        int n5 = n2 * this.rfb.framebufferWidth + n;
        for (int i = 0; i < n4; ++i) {
            int n6;
            for (n6 = 0; n6 < 3; ++n6) {
                byArray4[n6] = (byte)(byArray2[n6] + byArray[i * n3 * 3 + n6]);
                byArray3[n6] = byArray4[n6];
            }
            this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            for (int j = 1; j < n3; ++j) {
                for (n6 = 0; n6 < 3; ++n6) {
                    nArray[n6] = (byArray2[j * 3 + n6] & 0xFF) + (byArray4[n6] & 0xFF) - (byArray2[(j - 1) * 3 + n6] & 0xFF);
                    if (nArray[n6] > 255) {
                        nArray[n6] = 255;
                    } else if (nArray[n6] < 0) {
                        nArray[n6] = 0;
                    }
                    byArray4[n6] = (byte)(nArray[n6] + byArray[(i * n3 + j) * 3 + n6]);
                    byArray3[j * 3 + n6] = byArray4[n6];
                }
                this.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            }
            System.arraycopy(byArray3, 0, byArray2, 0, n3 * 3);
            n5 += this.rfb.framebufferWidth - n3;
        }
    }

    void handleUpdatedPixels(int n, int n2, int n3, int n4) {
        this.pixelsSource.newPixels(n, n2, n3, n4);
        this.memGraphics.setClip(n, n2, n3, n4);
        this.memGraphics.drawImage(this.rawPixelsImage, 0, 0, null);
        this.memGraphics.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    void scheduleRepaint(int n, int n2, int n3, int n4) {
        this.repaint(this.viewer.deferScreenUpdates, n, n2, n3, n4);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalKeyEvent(KeyEvent keyEvent) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (!this.inputEnabled) {
                if ((keyEvent.getKeyChar() == 'r' || keyEvent.getKeyChar() == 'R') && keyEvent.getID() == 401) {
                    try {
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                RfbProto rfbProto = this.rfb;
                synchronized (rfbProto) {
                    try {
                        this.rfb.writeKeyEvent(keyEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.rfb.notify();
                }
            }
        }
        keyEvent.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalMouseEvent(MouseEvent mouseEvent, boolean bl) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (bl) {
                this.softCursorMove(mouseEvent.getX(), mouseEvent.getY());
            }
            RfbProto rfbProto = this.rfb;
            synchronized (rfbProto) {
                try {
                    this.rfb.writePointerEvent(mouseEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.rfb.notify();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    synchronized void handleCursorShapeUpdate(int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = (n4 + 7) / 8;
        int n7 = n6 * n5;
        this.softCursorFree();
        if (n4 * n5 == 0) {
            return;
        }
        if (this.viewer.options.ignoreCursorUpdates) {
            if (n == -240) {
                this.rfb.is.skipBytes(6 + n7 * 2);
            } else {
                this.rfb.is.skipBytes(n4 * n5 + n7);
            }
            return;
        }
        this.softCursorPixels = new int[n4 * n5];
        if (n == -240) {
            byte[] byArray = new byte[6];
            this.rfb.is.readFully(byArray);
            int[] nArray = new int[]{0xFF000000 | (byArray[3] & 0xFF) << 16 | (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF, 0xFF000000 | (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF};
            byte[] byArray2 = new byte[n7];
            this.rfb.is.readFully(byArray2);
            byte[] byArray3 = new byte[n7];
            this.rfb.is.readFully(byArray3);
            int n8 = 0;
            for (int i = 0; i < n5; ++i) {
                int n9;
                int n10;
                int n11;
                for (n11 = 0; n11 < n4 / 8; ++n11) {
                    byte by = byArray2[i * n6 + n11];
                    byte by2 = byArray3[i * n6 + n11];
                    for (n10 = 7; n10 >= 0; --n10) {
                        n9 = (by2 >> n10 & 1) != 0 ? nArray[by >> n10 & 1] : 0;
                        this.softCursorPixels[n8++] = n9;
                    }
                }
                for (n10 = 7; n10 >= 8 - n4 % 8; --n10) {
                    n9 = (byArray3[i * n6 + n11] >> n10 & 1) != 0 ? nArray[byArray2[i * n6 + n11] >> n10 & 1] : 0;
                    this.softCursorPixels[n8++] = n9;
                }
            }
        } else {
            byte[] byArray = new byte[n4 * n5 * this.bytesPixel];
            this.rfb.is.readFully(byArray);
            byte[] byArray4 = new byte[n7];
            this.rfb.is.readFully(byArray4);
            int n12 = 0;
            for (int i = 0; i < n5; ++i) {
                int n13;
                int n14;
                int n15;
                for (n15 = 0; n15 < n4 / 8; ++n15) {
                    byte by = byArray4[i * n6 + n15];
                    for (n14 = 7; n14 >= 0; --n14) {
                        if ((by >> n14 & 1) != 0) {
                            if (this.bytesPixel == 1) {
                                n13 = 0;
                                switch (this.viewer.options.eightBitColors) {
                                    case 1: {
                                        n13 = this.cm8_256c.getRGB(byArray[n12]);
                                        break;
                                    }
                                    case 2: 
                                    case 4: {
                                        n13 = this.cm8_64c.getRGB(byArray[n12]);
                                        break;
                                    }
                                    case 3: 
                                    case 5: {
                                        n13 = this.cm8_8c.getRGB(byArray[n12]);
                                    }
                                }
                            } else {
                                n13 = 0xFF000000 | (byArray[n12 * 4 + 1] & 0xFF) << 16 | (byArray[n12 * 4 + 2] & 0xFF) << 8 | byArray[n12 * 4 + 3] & 0xFF;
                            }
                        } else {
                            n13 = 0;
                        }
                        this.softCursorPixels[n12++] = n13;
                    }
                }
                for (n14 = 7; n14 >= 8 - n4 % 8; --n14) {
                    if ((byArray4[i * n6 + n15] >> n14 & 1) != 0) {
                        if (this.bytesPixel == 1) {
                            n13 = 0;
                            switch (this.viewer.options.eightBitColors) {
                                case 1: {
                                    n13 = this.cm8_256c.getRGB(byArray[n12]);
                                    break;
                                }
                                case 2: 
                                case 4: {
                                    n13 = this.cm8_64c.getRGB(byArray[n12]);
                                    break;
                                }
                                case 3: 
                                case 5: {
                                    n13 = this.cm8_8c.getRGB(byArray[n12]);
                                }
                            }
                        } else {
                            n13 = 0xFF000000 | (byArray[n12 * 4 + 1] & 0xFF) << 16 | (byArray[n12 * 4 + 2] & 0xFF) << 8 | byArray[n12 * 4 + 3] & 0xFF;
                        }
                    } else {
                        n13 = 0;
                    }
                    this.softCursorPixels[n12++] = n13;
                }
            }
        }
        this.softCursorSource = new MemoryImageSource(n4, n5, this.softCursorPixels, 0, n4);
        this.softCursor = this.createImage(this.softCursorSource);
        this.cursorWidth = n4;
        this.cursorHeight = n5;
        this.hotX = n2;
        this.hotY = n3;
        this.showSoftCursor = true;
        this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
    }

    synchronized void handleCursorPosUpdate(int n, int n2) {
        if (n >= this.rfb.framebufferWidth) {
            n = this.rfb.framebufferWidth - 1;
        }
        if (n2 >= this.rfb.framebufferHeight) {
            n2 = this.rfb.framebufferHeight - 1;
        }
        this.softCursorMove(n, n2);
    }

    synchronized void softCursorMove(int n, int n2) {
        if (this.showSoftCursor) {
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, n - this.hotX, n2 - this.hotY, this.cursorWidth, this.cursorHeight);
        }
        this.cursorX = n;
        this.cursorY = n2;
    }

    synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            this.softCursorPixels = null;
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }
}

