<?php // $Id: document.inc.php 22074 2009-07-14 16:28:37Z jhp1411 $

/* For licensing terms, see /dokeos_license.txt */

/**
==============================================================================
*	extra functions for the document module (see also /main/inc/lib/document.lib.php
*
*	@package dokeos.document
==============================================================================
*/


/**
 * Builds the form thats enables the user to 
 * select a directory to browse/upload in
 *
 * @param array 	An array containing the folders we want to be able to select
 * @param string	The current folder (path inside of the "document" directory, including the prefix "/")
 * @param string	Group directory, if empty, prevents documents to be uploaded (because group documents cannot be uploaded in root)
 * @param	boolean	Whether to change the renderer (this will add a template <span> to the QuickForm object displaying the form)
 * @return string html form
 */
function build_directory_selector($folders, $curdirpath, $group_dir='', $changeRenderer = false, $into_lp = false)
{
	$folder_titles = array();
	if(api_get_setting('use_document_title') == 'true')
	{
		if (is_array($folders))
		{
			$escaped_folders = array();
			foreach($folders as $key=>$val){$escaped_folders[$key] = Database::escape_string($val);}
			$folder_sql = implode("','",$escaped_folders);
			$doc_table = Database::get_course_table(TABLE_DOCUMENT);
			$sql = "SELECT * FROM $doc_table WHERE filetype='folder' AND path IN ('".$folder_sql."')";
			$res = api_sql_query($sql,__FILE__,__LINE__);
			$folder_titles = array();
			while($obj = Database::fetch_object($res))
			{
				$folder_titles[$obj->path] = $obj->title;	
			}
		}
	}
	else
	{
		if (is_array($folders)){
			foreach($folders as $folder)
			{
				$folder_titles[$folder] = basename($folder);	
			}	
		}
	}
	
	require_once (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');
	//$form = new FormValidator('selector','POST',api_get_self().'?'.api_get_cidreq(), "", array('class'=>"abs",'style'=>"right:0; top:16px; width:23%;"));
	$form = new FormValidator('selector','POST',api_get_self().'?'.api_get_cidreq(), "", array('class'=>"abs", 'style' => "float: right; position: relative;"));
 // Hide the directory list
	if ($into_lp) $form->addElement('html', '<div style="display:none;">');
	$parent_select = $form->addElement('select', 'curdirpath', get_lang('CurrentDirectory'),'','onchange="javascript:document.selector.submit()" id="curdirpath_id"');
	if ($into_lp) $form->addElement('html', '</div>');
	//if($changeRenderer==true){
		$renderer = $form->defaultRenderer();
		$renderer->setElementTemplate('<span>{label} : {element}</span> ','curdirpath');
	//}
	
	//group documents cannot be uploaded in the root
	if(empty($group_dir))
	{
		$parent_select -> addOption(get_lang('HomeDirectory'),'/');
		if(is_array($folders))
		{
			foreach ($folders as $folder)
			{
				$selected = ($curdirpath==$folder)?' selected="selected"':'';
				$path_parts = explode('/',$folder);
				
				if($folder_titles[$folder]=='shared_folder')
				{
					$folder_titles[$folder]=get_lang('SharedFolder');
				}
				elseif(strstr($folder_titles[$folder], 'sf_user_'))
				{			
						$userinfo=Database::get_user_info_from_id(substr($folder_titles[$folder],8));
						$folder_titles[$folder]=$userinfo['lastname'].', '.$userinfo['firstname'];				
				}				
				
				$label = str_repeat('&nbsp;&nbsp;&nbsp;',count($path_parts)-2).' &mdash; '.$folder_titles[$folder];
				$parent_select -> addOption($label,$folder);
				if($selected!='') $parent_select->setSelected($folder);
			}
		}
	}
	else
	{
		if (is_array($folders)) {
			foreach ($folders as $folder)
			{
				$selected = ($curdirpath==$folder)?' selected="selected"':'';
				$label = $folder_titles[$folder];
				if( $folder == $group_dir)
				{
					$label = '/ ('.get_lang('HomeDirectory').')';
				}
				else
				{
					$path_parts = explode('/',str_replace($group_dir,'',$folder));
					$label = str_repeat('&nbsp;&nbsp;&nbsp;',count($path_parts)-2).' &mdash; '.$label;			
				}
				$parent_select -> addOption($label,$folder);
				if($selected!='') $parent_select->setSelected($folder);
			}
		}
	}
	
	$form=$form->toHtml();

	return $form;
}

/* Function getAudioVideo to open in Media files in the respective player */

function getAudioVideo($title,$i,$path,$filetype,$tooltip_title) {
		$ext = explode(".",$title);
		$return .= build_document_icon_tag($filetype, $tooltip_title);		
		$return .= '<div id="blanket" style="display:none;"></div><div id="popUpDiv'.$i.'" style="display:none;">		
		<div id="popUpDiv'.$i.'">
		<br><span style="padding-left:5px;color:maroon;font-size:14px;">Media</span><a href="#" onclick="popup(\'popUpDiv'.$i.'\')"><span style="align:right;color:red;padding-left:125px;">Close</span></a><br>';

		if($ext[1] == 'flv')
		{

		$return .= "<script type='text/javascript' src='../inc/lib/mediaplayer/swfobject.js'></script> 
		<div id='player".$i."'>This text will be replaced</div>
		 
		<script type='text/javascript'>
		var so = new SWFObject('player.swf','mpl','450','350','9');
		so.addParam('allowscriptaccess','always');
		so.addParam('allowfullscreen','true');
		so.addParam('wmode','transparent');
		so.addParam('flashvars','&file=".$title."&controlbar=over&autostart=true');
		so.write('player".$i."');
		</script>";
		}
		elseif($ext[1] == 'mp3')
		{
		$return .= '<div class="lp_mediaplayer" id="container"><a href="http://www.macromedia.com/go/getflashplayer">Get the Flash Player</a> to see this player.</div>';
			$return .= '<script type="text/javascript" src="../inc/lib/mediaplayer/swfobject.js"></script>';
			$return .= '<script type="text/javascript">
										var s1 = new SWFObject("../inc/lib/mediaplayer/player.swf","ply","260","100","9","#FFFFFF");
										s1.addParam("allowscriptaccess","always");
										s1.addParam("allowfullscreen","true");
										s1.addParam("flashvars","file=' . $title . '&autostart=true");
										s1.write("container");
									</script>';
		}		
		elseif($ext[1] == 'mpg' || $ext[1] == 'wmv' || $ext[1] == 'wma' || $ext[1] == 'avi')
		{
		$return .= '
		<OBJECT ID="MediaPlayer" WIDTH="450" HEIGHT="350" CLASSID="CLSID:22D6F312-B0F6-11D0-94AB-0080C74C7E95"
		STANDBY="Loading Windows Media Player components..." TYPE="application/x-oleobject">
		<PARAM NAME="FileName" VALUE="'.$title.'">
		<PARAM name="autostart" VALUE="true">
		<PARAM name="ShowControls" VALUE="true">
		<param name="ShowStatusBar" value="true">
		<PARAM name="ShowDisplay" VALUE="true">
		<EMBED TYPE="application/x-mplayer2" SRC="'.$title.'" NAME="MediaPlayer"
		WIDTH="400" HEIGHT="300" ShowControls="1" ShowStatusBar="1" ShowDisplay="1" autostart="1"> </EMBED>
		</OBJECT>';
		}
		return $return;
}

/**
 * Create a html hyperlink depending on if it's a folder or a file
 *
 * @param string $curdirpath
 * @param string $www
 * @param string $title
 * @param string $path
 * @param string $filetype (file/folder)
 * @param int $visibility (1/0)
 * @param int $show_as_icon - if it is true, only a clickable icon will be shown
 * @return string url
 */
function create_document_link($curdirpath, $www, $title, $path, $filetype, $size, $visibility, $show_as_icon = false, $doc_id = '')
{
	global $dbl_click_id;
	if(isset($_SESSION['_gid'])) {
		$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	} else {
		$req_gid = '';
	}
	$url_path = urlencode($path);
	//add class="invisible" on invisible files
	$visibility_class= ($visibility==0)?' class="invisible"':'';

	if (!$show_as_icon)
	{
		//build download link (icon)
		$forcedownload_link=($filetype=='folder')?api_get_self().'?'.api_get_cidreq().'&action=downloadfolder&amp;path='.$url_path.$req_gid:api_get_self().'?'.api_get_cidreq().'&amp;action=download&amp;id='.$url_path.$req_gid;
		//folder download or file download?
		//$forcedownload_icon=($filetype=='folder')?'folder_zip.gif':'filesave.gif';
		$forcedownload_icon=($filetype=='folder')?'go-jump.png':'go-jump.png';
		//prevent multiple clicks on zipped folder download
		$prevent_multiple_click =($filetype=='folder')?" onclick=\"javascript:if(typeof clic_$dbl_click_id == 'undefined' || clic_$dbl_click_id == false) { clic_$dbl_click_id=true; window.setTimeout('clic_".($dbl_click_id++)."=false;',10000); } else { return false; }\"":'';
	}

	$target='_self';
	$ext=explode('.',$path);
	$ext=strtolower($ext[sizeof($ext)-1]);
	if($filetype=='file') {
		//check the extension		
		//"htmlfiles" are shown in a frameset
	/*	if($ext == 'htm' || $ext == 'html' || $ext == 'gif' || $ext == 'jpg' || $ext == 'jpeg' || $ext == 'png') {
			$url = "showinframes.php?".api_get_cidreq()."&amp;file=".$url_path.$req_gid;
		} */
		if($ext == 'htm' || $ext == 'html')
		{
			$url = "showinframes.php?".api_get_cidreq()."&amp;&curdirpath=".$curdirpath."&file=".$url_path.$req_gid;
		}
		elseif($ext == 'gif' || $ext == 'jpg' || $ext == 'jpeg' || $ext == 'png')
		{
			$url = "slideshow.php?".api_get_cidReq()."&curdirpath=".$curdirpath."&linkfile=".$url_path.'&slide_id='.$doc_id;
		} elseif ($ext == 'mp3') {
			$path = str_replace('%2F', '/',$url_path).'?'.api_get_cidreq();
			$path_url=$www.$path;
			$url = '../search/view_mp3.php?path='.$path_url.'&width=500&height=280';
            $visibility_class = 'class="thickbox"';
		} elseif ($ext == 'swf') {
			$path = str_replace('%2F', '/',$url_path).'?'.api_get_cidreq();
			$path_url=$www.$path;
			$url = '../search/view_flash.php?path='.$path_url.'&width=800&height=520';
            $visibility_class = 'class="thickbox"';
		}
        // mpg file doesn't work with flowplayer, strange
        /*elseif (in_array($ext, array('mpg','flv','avi', 'wmv','mp4'))) {
			$path = str_replace('%2F', '/',$url_path).'?'.api_get_cidreq();
			$path_url=$www.$path;
			$url = '../search/view_video.php?path='.$path_url.'&width=800&height=520';
            $visibility_class = 'class="thickbox"';
		}  */else {
			//url-encode for problematic characters (we may not call them dangerous characters...)
			$path = str_replace('%2F', '/',$url_path).'?'.api_get_cidreq();
			$url=$www.$path;
		}
		//files that we want opened in a new window
		if($ext=='txt') //add here
		{
			$target='_blank';
		}
	}
	else 
	{
		$url=api_get_self().'?'.api_get_cidreq().'&amp;curdirpath='.$url_path.$req_gid;
	}
	
	//the little download icon
	//$tooltip_title = str_replace('?cidReq='.$_GET['cidReq'],'',basename($path));
	$tooltip_title = explode('?', basename($path));
	$tooltip_title = $tooltip_title[0];
	
	if($tooltip_title=='shared_folder')
	{
		$tooltip_title_alt=get_lang('SharedFolder');
	}
	elseif(strstr($tooltip_title, 'sf_user_'))
	{
		$userinfo=Database::get_user_info_from_id(substr($tooltip_title,8));
		$tooltip_title_alt=$userinfo['lastname'].', '.$userinfo['firstname'];
	}
	else
	{
		$tooltip_title_alt=$tooltip_title;
	}

	if (!$show_as_icon)
	{
		$force_download_html = ($size==0)?'':'<a href="'.$forcedownload_link.'" style="float:right"'.$prevent_multiple_click.'>'.Display::return_icon($forcedownload_icon, get_lang('Download'),array('height'=>'16', 'width' => '16')).'</a>';
		return '<a href="'.$url.'" title="'.$tooltip_title_alt.'" target="'.$target.'"'.$visibility_class.' style="float:left">'.$title.'</a>'.$force_download_html;
	}
	else
	{
		if($ext == 'mp3')
		{
			$i=1;		
			return '<a href="'.$url.'" title="'.$tooltip_title_alt.'" target="'.$target.'"'.$visibility_class.' style="float:left">'.getAudioVideo($title,$i,$path,$filetype,$tooltip_title).'</a>';
		}
		else
		{
		return '<a href="'.$url.'" title="'.$tooltip_title_alt.'" target="'.$target.'"'.$visibility_class.' style="float:left">'.build_document_icon_tag($filetype, $tooltip_title).'</a>';
		}
	}
}

/**
 * Builds an img html tag for the filetype
 *
 * @param string $type (file/folder)
 * @param string $path
 * @return string img html tag
 */
function build_document_icon_tag($type, $path)
{
	$basename = basename($path);

	if ($type == 'file')
	{
		$icon = choose_image($basename);
	}
	else
	{
		if($basename =='shared_folder')
		{
			$icon = 'shared_folder.png';
			if (api_is_allowed_to_edit())
			{
				$basename = get_lang('HelpSharedFolder');
			}
			else
			{
				$basename = get_lang('SharedFolder');
			}
		}
		elseif(strstr($basename, 'sf_user_'))
		{
			$userinfo=Database::get_user_info_from_id(substr($basename,8));	
			$image_path = UserManager::get_user_picture_path_by_id(substr($basename,8),'web',false, true);										
		
			if($image_path['file']=='unknown.jpg')
			{		
				$icon = $image_path['file'];
			}
			else
			{
				$icon = '../upload/users/'.substr($basename,8).'/'.$image_path['file'];
			}
			$basename = $userinfo['lastname'].', '.$userinfo['firstname'];			
		}
		else
		{	
		    if(($basename =='audio' || $basename =='flash' || $basename =='images' || $basename =='video') && api_is_allowed_to_edit()==true)
			{			  
					$basename = get_lang('HelpDefaultDirDocuments');				
			}				
			$icon = 'folder_new_22.png';
		}
	}

	return Display::return_icon($icon, $basename, array('hspace'=>'5', 'align' => 'middle', 'height'=> 22, 'width' => 22));
}

/**
 * Creates the row of edit icons for a file/folder
 *
 * @param string $curdirpath current path (cfr open folder)
 * @param string $type (file/folder)
 * @param string $path dbase path of file/folder
 * @param int $visibility (1/0)
 * @param int $id dbase id of the document
 * @return string html img tags with hyperlinks
 */
/*function build_edit_icons($curdirpath,$type,$path,$visibility,$id,$is_template,$is_read_only=0, $gradebook_category = '')
{
	if(isset($_SESSION['_gid']))
	{
		$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	}
	else 
	{
		$req_gid = '';
	}
	//build URL-parameters for table-sorting
	$sort_params = array();
	if( isset($_GET['column']))
	{
		$sort_params[] = 'column='.Security::remove_XSS($_GET['column']);
	}
	if( isset($_GET['page_nr']))
	{
		$sort_params[] = 'page_nr='.Security::remove_XSS($_GET['page_nr']);
	}
	if( isset($_GET['per_page']))
	{
		$sort_params[] = 'per_page='.Security::remove_XSS($_GET['per_page']);
	}
	if( isset($_GET['direction']))
	{
		$sort_params[] = 'direction='.Security::remove_XSS($_GET['direction']);
	}	
	$sort_params = implode('&amp;',$sort_params);
//	$visibility_icon = ($visibility==0)?'invisible':'visible';
	$visibility_icon = ($visibility==0)?'closedeye_tr':'dokeoseyeopen22';
	$visibility_command = ($visibility==0)?'set_visible':'set_invisible';
	$curdirpath = urlencode($curdirpath);
	$is_certificate_mode = DocumentManager::is_certificate_mode($path);	
	$modify_icons = '';
		
	if ($is_read_only) {
		$modify_icons = Display::return_icon('edit_na.gif', get_lang('Modify'));		
        $modify_icons .= '&nbsp;'.Display::return_icon('delete.png', get_lang('Delete'));
        $modify_icons .= '&nbsp;'.Display::return_icon('movedoc.png', get_lang('Move'));
        $modify_icons .= '&nbsp;'.Display::return_icon($visibility_icon.'_na.gif', get_lang('VisibilityCannotBeChanged'));
	} else {

		
		if ($is_certificate_mode) {
			$modify_icons = '<a href="edit_document.php?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;file='.urlencode($path).$req_gid.'&selectcat='.$gradebook_category.'"><img src="../img/edit.png" border="0" title="'.get_lang('Modify').'" alt="" /></a>';
		} else {
			$modify_icons = '<a href="edit_document.php?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;file='.urlencode($path).$req_gid.'"><img src="../img/edit.png" border="0" title="'.get_lang('Modify').'" alt="" /></a>';
		}						
        $modify_icons .= '&nbsp;&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;move='.urlencode($path).$req_gid.'"><img src="../img/movedoc.png" border="0" title="'.get_lang('Move').'" alt="" /></a>';	

        if (strcmp($path,'/audio')===0 or strcmp($path,'/flash')===0 or strcmp($path,'/images')===0 or strcmp($path,'/shared_folder')===0 or strcmp($path,'/video')===0) { 
        	$modify_icons .= '&nbsp;&nbsp;&nbsp;'.Display::return_icon('delete_na.gif',get_lang('ThisFolderCannotBeDeleted'));
        } else {
        	
			if (isset($_GET['curdirpath']) && $_GET['curdirpath']=='/certificates' && DocumentManager::get_default_certificate_id(api_get_course_id())==$id) {
								
        		$modify_icons .= '&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;delete='.urlencode($path).$req_gid.'&amp;'.$sort_params.'delete_certificate_id='.$id.'&selectcat='.$gradebook_category.' " onclick="return confirmation(\''.basename($path).'\');"><img src="../img/delete.png" border="0" title="'.get_lang('Delete').'" alt="" /></a>';				
			} else {								
				if ($is_certificate_mode) {		
        			$modify_icons .= '&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;delete='.urlencode($path).$req_gid.'&amp;'.$sort_params.'&selectcat='.$gradebook_category.'" onclick="return confirmation(\''.basename($path).'\');"><img src="../img/delete.png" border="0" title="'.get_lang('Delete').'" alt="" /></a>';
				} else {
					$modify_icons .= '&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;delete='.urlencode($path).$req_gid.'&amp;'.$sort_params.'" onclick="return confirmation(\''.basename($path).'\');"><img src="../img/delete.png" border="0" title="'.get_lang('Delete').'" alt="" /></a>';
				}
			}
        }
        
        if ($is_certificate_mode) {
       // 	$modify_icons .= '&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;move='.urlencode($path).$req_gid.'&selectcat='.$gradebook_category.'"><img src="../img/movedoc.png" border="0" title="'.get_lang('Move').'" alt="" /></a>';
        	$modify_icons .= '&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;'.$visibility_command.'='.$id.$req_gid.'&amp;'.$sort_params.'&selectcat='.$gradebook_category.'"><img src="../img/'.$visibility_icon.'.png" border="0" title="'.get_lang('Visible').'" alt="" /></a>';
        } else {
      //  	$modify_icons .= '&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;move='.urlencode($path).$req_gid.'"><img src="../img/movedoc.png" border="0" title="'.get_lang('Move').'" alt="" /></a>';
        	$modify_icons .= '&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;'.$visibility_command.'='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/'.$visibility_icon.'.png" border="0" title="'.get_lang('Visible').'" alt="" /></a>';	
        }
        
	}	
	
	if($type == 'file' && pathinfo($path,PATHINFO_EXTENSION)=='html')
	{
	/*	if($is_template==0)
		{
			if ((isset($_GET['curdirpath']) && $_GET['curdirpath']<>'/certificates') || !isset($_GET['curdirpath'])) {
				$modify_icons .= '&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;add_as_template='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/wizard_small.gif" border="0" title="'.get_lang('AddAsTemplate').'" alt="'.get_lang('AddAsTemplate').'" /></a>';
			}
			if (isset($_GET['curdirpath']) && $_GET['curdirpath']=='/certificates') {//allow attach certificate to course
				  $visibility_icon_certificate='nocertificate';
				  if (DocumentManager::get_default_certificate_id(api_get_course_id())==$id) {
				  	$visibility_icon_certificate='certificate';
				  	$certificate=get_lang('DefaultCertificate');
				  	$preview=get_lang('PreviewCertificate');
					$is_preview=true;
				  } else {
				  	$is_preview=false;
				  	$certificate=get_lang('NoDefaultCertificate');
				  }	
				  if (isset($_GET['selectcat'])) {
				  	$modify_icons .= '&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;selectcat='.Security::remove_XSS($_GET['selectcat']).'&amp;set_certificate='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/'.$visibility_icon_certificate.'.png" border="0" title="'.$certificate.'" alt="" /></a>';				  	
					if ($is_preview) {
					 	$modify_icons .= '&nbsp;<a target="_blank"  href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;set_preview='.$id.$req_gid.'&amp;'.$sort_params.'" ><img src="../img/search.gif" border="0" title="'.$preview.'" alt="" width="16" height="16"/></a>';
						}
				  }
			}
		}
		else{
			$modify_icons .= '&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;remove_as_template='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/wizard_gray_small.gif" border="0" title="'.get_lang('RemoveAsTemplate').'" alt=""'.get_lang('RemoveAsTemplate').'" /></a>';
		}
	}	
	return $modify_icons;
}*/

/**
 * Creates the row of edit certificate icons for a file/folder
 *
 * @param string $curdirpath current path (cfr open folder)
 * @param string $type (file/folder)
 * @param string $path dbase path of file/folder
 * @param int $visibility (1/0)
 * @param int $id dbase id of the document
 * @return string html img tags with hyperlinks
 */
function build_certificate_icons($curdirpath,$type,$path,$visibility,$id,$is_template,$is_read_only=0, $gradebook_category = '', $icon_type = 'certificate') {
	if(isset($_SESSION['_gid'])) {
		$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	} else {
		$req_gid = '';
	}
	//build URL-parameters for table-sorting
	$sort_params = array();
	if( isset($_GET['column'])) {
		$sort_params[] = 'column='.Security::remove_XSS($_GET['column']);
	}
	if( isset($_GET['page_nr'])) {
		$sort_params[] = 'page_nr='.Security::remove_XSS($_GET['page_nr']);
	}
	if( isset($_GET['per_page'])) {
		$sort_params[] = 'per_page='.Security::remove_XSS($_GET['per_page']);
	}
	if( isset($_GET['direction'])) {
		$sort_params[] = 'direction='.Security::remove_XSS($_GET['direction']);
	}
	$sort_params = implode('&amp;',$sort_params);
	$curdirpath = urlencode($curdirpath);
	$is_certificate_mode = DocumentManager::is_certificate_mode($path);
	$modify_icons = '';

	if ($type == 'file' && pathinfo($path,PATHINFO_EXTENSION)=='html') {
		if($is_template==0) {
			if ((isset($_GET['curdirpath']) && $_GET['curdirpath']<>'/certificates') || !isset($_GET['curdirpath'])) {
				$modify_icons .= '&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;add_as_template='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/wizard_small.gif" border="0" title="'.get_lang('AddAsTemplate').'" alt="'.get_lang('AddAsTemplate').'" /></a>';
			}
			if (isset($_GET['curdirpath']) && $_GET['curdirpath']=='/certificates') {//allow attach certificate to course
				  $visibility_icon_certificate='nocertificate';
				  if (DocumentManager::get_default_certificate_id(api_get_course_id())==$id) {
				  	$visibility_icon_certificate='certificate';
				  	$certificate=get_lang('DefaultCertificate');
				  	$preview=get_lang('PreviewCertificate');
					$is_preview=true;
				  } else {
				  	$is_preview=false;
				  	$certificate=get_lang('NoDefaultCertificate');
				  }
				  if (isset($_GET['selectcat'])) {
                    if ($icon_type == 'certificate') {
				  	  $modify_icons .= '&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;selectcat='.Security::remove_XSS($_GET['selectcat']).'&amp;set_certificate='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/'.$visibility_icon_certificate.'.png" border="0" title="'.$certificate.'" alt="" /></a>';
                    }
					if ($is_preview && $icon_type != 'certificate') {
					 	$modify_icons .= '&nbsp;<a target="_blank"  href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;set_preview='.$id.$req_gid.'&amp;'.$sort_params.'" ><img src="../img/preview_22.png" border="0" title="'.$preview.'" alt="" /></a>';
					 }

				  }
			}
		} else {
            // Remove template
			//$modify_icons .= '&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;remove_as_template='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/wizard_gray_small.gif" border="0" title="'.get_lang('RemoveAsTemplate').'" alt=""'.get_lang('RemoveAsTemplate').'" /></a>';
		}
	}
	return '&nbsp;&nbsp;'.$modify_icons;
}

function build_edit_icons($curdirpath,$type,$path,$visibility,$id,$is_template,$is_read_only=0, $gradebook_category = '')
{
	if(isset($_SESSION['_gid']))
	{
		$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	}
	else 
	{
		$req_gid = '';
	}
	//build URL-parameters for table-sorting
	$sort_params = array();
	if( isset($_GET['column']))
	{
		$sort_params[] = 'column='.Security::remove_XSS($_GET['column']);
	}
	if( isset($_GET['page_nr']))
	{
		$sort_params[] = 'page_nr='.Security::remove_XSS($_GET['page_nr']);
	}
	if( isset($_GET['per_page']))
	{
		$sort_params[] = 'per_page='.Security::remove_XSS($_GET['per_page']);
	}
	if( isset($_GET['direction']))
	{
		$sort_params[] = 'direction='.Security::remove_XSS($_GET['direction']);
	}	
	$sort_params = implode('&amp;',$sort_params);
	$curdirpath = urlencode($curdirpath);
	$is_certificate_mode = DocumentManager::is_certificate_mode($path);	
	$modify_icons = '';	
		
	if ($is_read_only) {
		$modify_icons  = Display::return_icon('edit_na.gif', get_lang('Modify'));		       
	} else {		
		if ($is_certificate_mode) {
			$modify_icons  = '<a href="edit_document.php?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;file='.urlencode($path).$req_gid.'&selectcat='.$gradebook_category.'"><img src="../img/edit_link.png" border="0" title="'.get_lang('Modify').'" alt="" /></a>';
		} else {
			$modify_icons = '<a href="edit_document.php?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;file='.urlencode($path).$req_gid.'"><img src="../img/edit_link.png" border="0" title="'.get_lang('Modify').'" alt="" /></a>';
		}       
     }	
	return $modify_icons;
}

function build_move_icons($curdirpath,$type,$path,$visibility,$id,$is_template,$is_read_only=0, $gradebook_category = '')
{
	if(isset($_SESSION['_gid']))
	{
		$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	}
	else 
	{
		$req_gid = '';
	}
	//build URL-parameters for table-sorting
	$sort_params = array();
	if( isset($_GET['column']))
	{
		$sort_params[] = 'column='.Security::remove_XSS($_GET['column']);
	}
	if( isset($_GET['page_nr']))
	{
		$sort_params[] = 'page_nr='.Security::remove_XSS($_GET['page_nr']);
	}
	if( isset($_GET['per_page']))
	{
		$sort_params[] = 'per_page='.Security::remove_XSS($_GET['per_page']);
	}
	if( isset($_GET['direction']))
	{
		$sort_params[] = 'direction='.Security::remove_XSS($_GET['direction']);
	}	
	$sort_params = implode('&amp;',$sort_params);
	$curdirpath = urlencode($curdirpath);
	$is_certificate_mode = DocumentManager::is_certificate_mode($path);	
	$modify_icons = '';	
		
	if ($is_read_only) {		
        $modify_icons = '&nbsp;'.Display::return_icon('movedoc.png', get_lang('Move'));       
	} else {							
        $modify_icons .= '&nbsp;&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;move='.urlencode($path).$req_gid.'"><img src="../img/movedoc.png" border="0" title="'.get_lang('Move').'" alt="" /></a>';	        	
	}		
	return $modify_icons;
}

function build_visible_icons($curdirpath,$type,$path,$visibility,$id,$is_template,$is_read_only=0, $gradebook_category = '')
{
	if(isset($_SESSION['_gid']))
	{
		$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	}
	else 
	{
		$req_gid = '';
	}
	//build URL-parameters for table-sorting
	$sort_params = array();
	if( isset($_GET['column']))
	{
		$sort_params[] = 'column='.Security::remove_XSS($_GET['column']);
	}
	if( isset($_GET['page_nr']))
	{
		$sort_params[] = 'page_nr='.Security::remove_XSS($_GET['page_nr']);
	}
	if( isset($_GET['per_page']))
	{
		$sort_params[] = 'per_page='.Security::remove_XSS($_GET['per_page']);
	}
	if( isset($_GET['direction']))
	{
		$sort_params[] = 'direction='.Security::remove_XSS($_GET['direction']);
	}	
	$sort_params = implode('&amp;',$sort_params);
//	$visibility_icon = ($visibility==0)?'invisible':'visible';
	$visibility_icon = ($visibility==0)?'closedeye_tr':'visible_link';
	$visibility_command = ($visibility==0)?'set_visible':'set_invisible';
	$curdirpath = urlencode($curdirpath);
	$is_certificate_mode = DocumentManager::is_certificate_mode($path);	
	$modify_icons = '';	
		
	if ($is_read_only) {		
        $modify_icons = '&nbsp;'.Display::return_icon($visibility_icon.'_na.gif', get_lang('VisibilityCannotBeChanged'));
	} else {
        if ($is_certificate_mode) {       
        	$modify_icons .= '&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;'.$visibility_command.'='.$id.$req_gid.'&amp;'.$sort_params.'&selectcat='.$gradebook_category.'&type=list"><img src="../img/'.$visibility_icon.'.png" border="0" title="'.get_lang('Visible').'" alt="" /></a>';
        } else {      
        	$modify_icons .= '&nbsp;&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;'.$visibility_command.'='.$id.$req_gid.'&amp;'.$sort_params.'&type=list"><img src="../img/'.$visibility_icon.'.png" border="0" title="'.get_lang('Visible').'" alt="" /></a>';	
        }	
	}	
	
	return $modify_icons;
}

/**
 * Creates the row of edit icons for a file/folder
 *
 * @param string $curdirpath current path (cfr open folder)
 * @param string $type (file/folder)
 * @param string $path dbase path of file/folder
 * @param int $visibility (1/0)
 * @param int $id dbase id of the document
 * @return string html img tags with hyperlinks
 */
function build_template_icons($curdirpath,$type,$path,$visibility,$id,$is_template,$is_read_only=0)
{
	if(isset($_SESSION['_gid']))
	{
		$req_gid = '&amp;gidReq='.$_SESSION['_gid'];
	}
	else 
	{
		$req_gid = '';
	}
	//build URL-parameters for table-sorting
	$sort_params = array();
	if( isset($_GET['column']))
	{
		$sort_params[] = 'column='.Security::remove_XSS($_GET['column']);
	}
	if( isset($_GET['page_nr']))
	{
		$sort_params[] = 'page_nr='.Security::remove_XSS($_GET['page_nr']);
	}
	if( isset($_GET['per_page']))
	{
		$sort_params[] = 'per_page='.Security::remove_XSS($_GET['per_page']);
	}
	if( isset($_GET['direction']))
	{
		$sort_params[] = 'direction='.Security::remove_XSS($_GET['direction']);
	}	
	$sort_params = implode('&amp;',$sort_params);
	$curdirpath = urlencode($curdirpath);
	
	$template_icons = '';	
	
	if($type == 'file' && pathinfo($path,PATHINFO_EXTENSION)=='html')
	{
		if($is_template==0)
		{
			$template_icons .= '<span style="padding-left:20px;">&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;add_as_template='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/tools_wizard_22.png" border="0" title="'.get_lang('AddAsTemplate').'" alt="'.get_lang('AddAsTemplate').'" /></a></span>';
		}
		else{
			$template_icons .= '<span style="padding-left:20px;">&nbsp;<a href="'.api_get_self().'?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&amp;remove_as_template='.$id.$req_gid.'&amp;'.$sort_params.'"><img src="../img/undo.png" border="0" title="'.get_lang('RemoveAsTemplate').'" alt=""'.get_lang('RemoveAsTemplate').'" /></a></span>';
		}
	}	
	return $template_icons;
}

/**
 * Creates the row of edit icons for a file/folder
 *
 * @param string $curdirpath current path (cfr open folder)
 * @param string $type (file/folder)
 * @param string $path dbase path of file/folder
 * @param int $visibility (1/0)
 * @param int $id dbase id of the document
 * @return string html img tags with hyperlinks
 */
function build_addcourse_icons($curdirpath,$type,$path,$visibility,$id,$document_name,$is_read_only=0)
{
	if(isset($_SESSION['_gid']))
	{
		$req_gid = '&gidReq='.$_SESSION['_gid'];
	}
	else 
	{
		$req_gid = '';
	}
	//build URL-parameters for table-sorting
	$sort_params = array();
	if( isset($_GET['column']))
	{
		$sort_params[] = 'column='.Security::remove_XSS($_GET['column']);
	}
	if( isset($_GET['page_nr']))
	{
		$sort_params[] = 'page_nr='.Security::remove_XSS($_GET['page_nr']);
	}
	if( isset($_GET['per_page']))
	{
		$sort_params[] = 'per_page='.Security::remove_XSS($_GET['per_page']);
	}
	if( isset($_GET['direction']))
	{
		$sort_params[] = 'direction='.Security::remove_XSS($_GET['direction']);
	}	
	$sort_params = implode('&',$sort_params);
	$curdirpath = urlencode($curdirpath);
	$addcourse_icons = '';	
	
	if($type == 'file')
	{		
			$addcourse_icons .= '<span style="padding-left:20px;">&nbsp;<a class="thickbox" href="integrate_doc_in_course.php?'.api_get_cidreq().'&curdirpath='.$curdirpath.'&add_to_course='.$id.$req_gid.'&docname='.$document_name.'&'.$sort_params.'height=150&width=500" title="'.get_lang('IntegrateDocInCourse').'"><img src="../img/courseeach.png" border="0" title="'.get_lang('IntegrateDocInCourse').'" alt="'.get_lang('IntegrateDocInCourse').'" /></a></span>';
	}	
	return $addcourse_icons;
}

function build_move_to_selector($folders,$curdirpath,$move_file,$group_dir='')
{
	$form = '<form class="outer_form" name="move_to" action="'.api_get_self().'?'.api_get_cidreq().'" method="post">'."\n";
	$form .= '<input type="hidden" name="move_file" value="'.$move_file.'" />'."\n";

 $form .= '	<div class="formw">';
 $form .= '<div class="row">';
 $form .= '	<div class="label">';
	$form .= 	get_lang('MoveTo').'&nbsp;&nbsp;';
 $form .= '	</div>';
 $form .= '	</div>';


 $form .= '	<div>';
	$form .= ' <select name="move_to">'."\n";
	
	//group documents cannot be uploaded in the root
	if($group_dir=='') 
	{
		if($curdirpath!='/')
		{
			$form .= '<option value="/">/ ('.get_lang('HomeDirectory').')</option>';
		}
		if(is_array($folders))
		{
			foreach ($folders AS $folder)
			{	
				//you cannot move a file to:
				//1. current directory
				//2. inside the folder you want to move
				//3. inside a subfolder of the folder you want to move
				if(($curdirpath!=$folder) && ($folder!=$move_file) && (substr($folder,0,strlen($move_file)+1) != $move_file.'/'))
				{
					$path_displayed = $folder;
					
					// if document title is used, we have to display titles instead of real paths...
					if(api_get_setting('use_document_title'))
					{
						$path_displayed = get_titles_of_path($folder);
					}
					$form .= '<option value="'.$folder.'">'.$path_displayed.'</option>'."\n";
				}
			}
		}
	}
	else
	{
		foreach ($folders AS $folder)
		{	
			if(($curdirpath!=$folder) && ($folder!=$move_file) && (substr($folder,0,strlen($move_file)+1) != $move_file.'/'))//cannot copy dir into his own subdir
			{
				if(api_get_setting('use_document_title'))
				{
					$path_displayed = get_titles_of_path($folder);
				}
				
				$display_folder = substr($path_displayed,strlen($group_dir));
				$display_folder = ($display_folder == '')?'/ ('.get_lang('HomeDirectory').')':$display_folder;
								
				$form .= '<option value="'.$folder.'">'.$display_folder.'</option>'."\n";
			}
		}
	}

	$form .= '		</select>'."\n";
	$form .= '	</div>';
	
	$form .= '<div class="row">';
	$form .= '	<div class="label"></div>';
	$form .= '	<div class="formw">';	
	$form .= '		<button type="submit" class="next" name="move_file_submit">'.get_lang('MoveFile').'</button>'."\n";
	$form .= '	</div>';	
	$form .= '</div>';	
 $form .= '	</div>';
	$form .= '</form>';
	
	//$form .= '<div style="clear: both; margin-bottom: 10px;"></div>';

	return $form;
}


/**
 * get the path translated with title of docs and folders
 * @param string the real path
 * @return the path which should be displayed
 */
function get_titles_of_path($path)
{
	global $tmp_folders_titles;

	$nb_slashes = substr_count($path,'/');
	$tmp_path = '';
	$current_slash_pos = 0;
	$path_displayed = '';
	for($i=0; $i<$nb_slashes; $i++)
	{ // foreach folders of the path, retrieve title.
	
		$current_slash_pos = strpos($path,'/',$current_slash_pos+1);
		$tmp_path = substr($path,strpos($path,'/',0),$current_slash_pos);
		
		if(empty($tmp_path)) // if empty, then we are in the final part of the path
			$tmp_path = $path;
			
		if(!empty($tmp_folders_titles[$tmp_path])) // if this path has soon been stored here we don't need a new query
		{
			$path_displayed .= $tmp_folders_titles[$tmp_path];
		}
		else
		{
			$sql = 'SELECT title FROM '.Database::get_course_table(TABLE_DOCUMENT).' WHERE path LIKE BINARY "'.$tmp_path.'"';
			$rs = api_sql_query($sql,__FILE__,__LINE__);
			$tmp_title = '/'.Database::result($rs,0,0);
			$path_displayed .= $tmp_title;
			$tmp_folders_titles[$tmp_path] = $tmp_title;
		}
	}
	return $path_displayed;
}



/**
* This function displays the name of the user and makes the link tothe user tool.
*
* @param $user_id 
* @param $name
* @return a link to the userInfo.php
* @author Patrick Cool <patrick.cool@UGent.be>, Ghent University
* @version february 2006, dokeos 1.8
*/ 
function display_user_link_document($user_id, $name)
{	
	if ($user_id<>0)
	{
		return '<a href="../user/userInfo.php?uInfo='.$user_id.'">'.$name.'</a>';
	}
	else
	{
		return get_lang('Anonymous');
	}
}

function create_dir_form()
{
	//create the form that asks for the directory name
	$new_folder_text = '<form name="create_folder" action="'.api_get_self().'?'.api_get_cidreq().'" class="outer_form" method="post">';
	$new_folder_text .= '<input type="hidden" name="curdirpath" value="'.Security::remove_XSS($_GET['curdirpath']).'" />';
	// form title
	$new_folder_text .= '<div class="row"><div class="form_header">'.get_lang('CreateDir').'</div></div>';
	
	// folder field
	$new_folder_text .= '<div class="row">';
	$new_folder_text .= '<div class="label"><span class="form_required">*</span>'.get_lang('NewDir').'</div>';
	$new_folder_text .= '<div class="formw"><input type="text" name="dirname" class="focus" /></div>';
	$new_folder_text .= '</div>';
	// submit button
	$new_folder_text .= '<div class="row">';
	$new_folder_text .= '<div class="label">&nbsp;</div>';
	$new_folder_text .= '<div class="formw"><button type="submit" class="add" name="create_dir">'.get_lang('CreateFolder').'</button></div>';
	$new_folder_text .= '</div>';		
	$new_folder_text .= '</form>';
	$new_folder_text .= '<div style="clear: both; margin-bottom: 10px;"></div>';	
	
	return $new_folder_text;
}
?>
