<?php
error_reporting(E_ALL || ~E_NOTICE);
?>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<?php
$image_id = $_REQUEST['image_id'];
/******************************************************************************

参数说明:
$max_file_size  : 上传文件大小限制, 单位BYTE
$destination_folder : 上传文件路径
$watermark   : 是否附加水印(1为加水印,其他为不加水印);

使用说明:
1. 将PHP.INI文件里面的"extension=php_gd2.dll"一行前面的;号去掉,因为我们要用到GD库;
2. 将extension_dir =改为你的php_gd2.dll所在目录;
 ******************************************************************************/

//上传文件类型列表
$uptypes=array(
    'image/jpg',
    'image/jpeg',
    'image/png',
    'image/pjpeg',
    'image/gif',
    'image/bmp',
    'image/x-png'
);

$max_file_size=2000000;     //上传文件大小限制, 单位BYTE
$destination_folder="uploadimg/"; //上传文件路径
$watermark=1;      //是否附加水印(1为加水印,其他为不加水印);
$watertype=1;      //水印类型(1为文字,2为图片)
$waterposition=1;     //水印位置(1为左下角,2为右下角,3为左上角,4为右上角,5为居中);
$waterstring="";  //水印字符串
$waterimg="";    //水印图片
$imgpreview=1;      //是否生成预览图(1为生成,其他为不生成);
$imgpreviewsize=1/2;    //缩略图比例

?>
<html>
<head>
    <title>photo update </title>
    <style type="text/css">
        <!--
        body
        {
            font-size: 9pt;
        }
        -->
    </style>
    <script type="text/javascript" src="../js/jquery.js"></script>
</head>

<body>
<form enctype="multipart/form-data" method="post" name="upform">
    <h3>上传图片</h3>
    <input name="upfile" type="file" style="width: 100px"><br>
    <input type="submit" value="上传" style="width: 90%;"><br/>
    允许上传的文件类型为:<?=implode(', ',$uptypes)?>
</form>

<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if (!is_uploaded_file($_FILES["upfile"][tmp_name]))
        //是否存在文件
    {
        echo "图片不存在!";
        exit;
    }

    $file = $_FILES["upfile"];
    if($max_file_size < $file["size"])
        //检查文件大小
    {
        echo "文件太大!";
        exit;
    }

    if(!in_array($file["type"], $uptypes))
        //检查文件类型
    {
        echo "文件类型不符!".$file["type"];
        exit;
    }

    if(!file_exists($destination_folder))
    {
        mkdir($destination_folder);
    }

    $filename=$file["tmp_name"];
    $image_size = getimagesize($filename);
    $pinfo=pathinfo($file["name"]);
    $ftype=$pinfo['extension'];
    $new_file_name = time().".".$ftype;
    $destination = $destination_folder.$new_file_name;
    if (file_exists($destination) && $overwrite != true)
    {
        echo "同名文件已经存在了";
        exit;
    }

    if(!move_uploaded_file ($filename, $destination))
    {
        echo "移动文件出错";
        exit;
    }

    $pinfo=pathinfo($destination);
    $fname=$pinfo[basename];
   // echo " <font color=red>已经成功上传</font><br>文件名:  <font color=blue>".$destination_folder.$fname."</font><br>";
    //echo " 宽度:".$image_size[0];
    //echo " 长度:".$image_size[1];
    //echo "<br> 大小:".$file["size"]." bytes";

    if($watermark==1)
    {
        $iinfo=getimagesize($destination,$iinfo);
        //得出高
        $small_width="200";
        $small_height = $image_size[1] *($small_width/$image_size[0]) ;
        $small_destination = $destination_folder."s/".$new_file_name;
        $nimage=imagecreatetruecolor($small_width,$small_height);
        $white=imagecolorallocate($nimage,255,255,255);
        $black=imagecolorallocate($nimage,0,0,0);
        $red=imagecolorallocate($nimage,255,0,0);
        imagefill($nimage,0,0,$white);
        switch ($iinfo[2])
        {
            case 1:
                $simage =imagecreatefromgif($small_destination);
                break;
            case 2:
                $simage =imagecreatefromjpeg($small_destination);
                break;
            case 3:
                $simage =imagecreatefrompng($small_destination);
                break;
            case 6:
                $simage =imagecreatefromwbmp($small_destination);
                break;
            default:
                die("不支持的文件类型");
                exit;
        }

        imagecopy($nimage,$simage,0,0,0,0,$image_size[0],$image_size[1]);
        imagefilledrectangle($nimage,1,$image_size[1]-15,80,$image_size[1],$white);

        switch($watertype)
        {
            case 1:   //加水印字符串
               // imagestring($nimage,2,3,$image_size[1]-15,$waterstring,$black);
                break;
            case 2:   //加水印图片
               // $simage1 =imagecreatefromgif("xplore.gif");
               // imagecopy($nimage,$simage1,0,0,0,0,85,15);
               // imagedestroy($simage1);
                break;
        }

        switch ($iinfo[2])
        {
            case 1:
                //imagegif($nimage, $destination);
                imagejpeg($nimage, $small_destination);
                break;
            case 2:
                imagejpeg($nimage, $small_destination);
                break;
            case 3:
                imagepng($nimage, $small_destination);
                break;
            case 6:
                imagewbmp($nimage, $small_destination);
                //imagejpeg($nimage, $destination);
                break;
        }
        //覆盖原上传文件
      //  imagedestroy($nimage);
      //  imagedestroy($simage);
    }

    if($imgpreview==1)
    {
       echo "<img src=\"".$destination."\" width=".($image_size[0]*$imgpreviewsize)." height=".($image_size[1]*$imgpreviewsize)." />";
        //echo " alt=\"图片预览:\r文件名:".$destination."\r上传时间:\" >";
        ?>
        <script language="JavaScript">
            parent.document.getElementById("<?php echo $image_id?>_div").innerHTML="<?php echo "<img src=plug-in/" . $destination . " width=200/><input type = hidden value = plug-in/".$destination." name = ".$image_id." /> ";?>";
            parent.window.location.hash="#img_y";
            $("#frame_main",parent.document).hide();
        </script>

        <?php
    }
}
?>
</body>
</html>