/**
	[OElove v3.x] (C)2010-2012 OEdev.Net Inc.
	This is NOT a freeware, use is subject to license terms
	$Id: ajax.js 2019-07-10 OEdev $
*/

/**
 * $Id:: ajax 检测Email是否合法和存在
 * @param:: string inputid 检测的input ID
 * @param:: string tipsid json显示结果位置
 * @return:: int 0-未知错误，1-格式不正确，2-已存在，3-可以注册
*/
function ajax_email(inputid, tipsid, type){
	if(typeof(type) == 'undefined') {type = 'all';}
	var email = $("#"+inputid).val();
	if(isEmail(email)){
		$("#"+tipsid).html("loading...");
		$.ajax({
			type: "POST",
			url: _ROOT_PATH + "index.php?c=ajax&a=checkemail",
			cache: false,
			data: { email: email, type: type, r: get_rndnum(8)},
			dataType: "json",
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader("request_type","ajax");
			},
			success: function(data) {
				var json = eval(data);
				var response = json.response;
				if (response == 1) {
					$("#"+tipsid).html("<font color='red'>对不起，该Email格式不正确</font>");
				}
				else if (response == 2) {
					$("#"+tipsid).html("<font color='red'>对不起，该Email已被注册</font>");
				}
				else if (response == 4) {
					$("#"+tipsid).html("<font color='red'>对不起，UC存在该邮箱或者格式不符合</font>");
				}
				else{
					$("#"+tipsid).html("<font color='green'>恭喜你，该Email可以注册</font>");
				}
			},
			error: function() {

			}
		});
	}
	else {
		$("#"+tipsid).html("<font color='red'>对不起，该Email格式不正确</font>");
	}
}

/** 
 * $Id:: ajax 检测用户名是否合法和存在
 * @param:: string inputid 检测的input ID
 * @param:: string tipsid json显示结果位置
 * @return:: int 0-未知错误，1-格式不正确，2-系统禁止注册，3-已被注册，4-可以注册
*/
function ajax_user(inputid, tipsid){
	var username = $("#"+inputid).val();
	if(check_userstring(username)){
		if(strlen(username)<3 || strlen(username)>16){
			$("#"+tipsid).html("<font color='red'>对不起，会员名长度不正确！</font>");
		} else {
			$("#"+tipsid).html("loading...");
			$.ajax({
				type: "POST",
				url: _ROOT_PATH + "index.php?c=ajax&a=checkuser",
				cache: false,
				data: { username: username,r:get_rndnum(8)},
				dataType: "json",
				beforeSend: function(XMLHttpRequest) {
					XMLHttpRequest.setRequestHeader("request_type","ajax");
				},
				success: function(data) {
					var json = eval(data);
					var response = json.response;
					if (response == 1) {
						$("#"+tipsid).html("<font color='red'>对不起，该会员名格式不正确</font>");
					}
					else if (response == 2) {
						$("#"+tipsid).html("<font color='red'>对不起，该会员名已被系统禁止</font>");
					}
					else if (response == 3) {
						$("#"+tipsid).html("<font color='red'>对不起，该会员名已被注册</font>");
					} 
					else if (response == 5) {
						$("#"+tipsid).html("<font color='red'>对不起，UC存在该用户或者格式不符合</font>");
					}
					else {
						$("#"+tipsid).html("<font color='green'>恭喜你，该会员名可以注册</font>");
					}
				},
				error: function() {

				}
			});
		}
	} 
	else {
		$("#"+tipsid).html("<font color='red'>对不起，该会员名格式不正确</font>");
	}
}

/**
 * $Id:: ajax 检测注册验证码
 * @param:: string inputid 检测的input ID
 * @param:: string tipsid json显示结果位置
 * @return:: int 0-错误，1-正确
*/
function ajax_checkcode(inputid, tipsid){
	var checkcode = $("#"+inputid).val();
	if(checkcode != ''){
		if (tipsid != '') {
			$("#"+tipsid).html("loading...");
		}
		$.ajax({
			type: "POST",
			url: _ROOT_PATH + "index.php?c=ajax&a=checkcode",
			cache: false,
			data: { checkcode: checkcode, r: get_rndnum(8)},
			dataType: "json",
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader("request_type","ajax");
			},
			success: function(data) {
				var json = eval(data);
				var response = json.response;
				if (response == 1) {
					if (tipsid != '') {
						$("#"+tipsid).html("<font color='green'>验证码正确</font>");
					}
				}
				else{
					if (tipsid != '') {
						$("#"+tipsid).html("<font color='red'>验证码错误</font>");
					}
				}
			},
			error: function() {

			}
		});
	}
}

/**
 * 获取二级地区
 * @param:: string pname 一级地区名
 * @param:: string cname 二级地区名
 * @param:: int cvalue 二级地区值
 * @param:: string text 文字提示
 * @param:: int ajax 是否调用ajax 三级地区
 * @param:: string dname 三级地区名
 * @param:: string dvalue 三级地区值
 * @return:: string options
*/
function fetch_city(pname, cname, cvalue, text, ajax, dname, dvalue){
	//容错处理
	if(typeof(text) == 'undefined'){text = '';}
	if(typeof(ajax) == 'undefined'){ajax = 0;}
	if(typeof(dname) == 'undefined'){dname = '';}
	if(typeof(dvalue) == 'undefined'){dvalue = '';}

	//获取一级地区值
	var pvalue = $('#'+pname).val();
	if(pvalue>0){
		$.getJSON(_ROOT_PATH + "index.php?c=ajax&a=fetchcity&rootid="+pvalue+"&ajax="+ajax+"&text="+text+"&rnd="+get_rndnum(8),
			function(data){
				var option_html = '';
				$.each(data,function(entryIndex,entry){
					option_html += "<option value='"+entry.areaid+"'";
					if(cvalue==entry.areaid){
						option_html += "selected";
					}
					option_html += ">"+entry.areaname+"</option>";
				});
				if(option_html != '' && ajax == 1 && dname!= '') {
					option_html = "<select name='"+cname+"' id='"+cname+"' onchange=\"fetch_dist('"+cname+"', '"+dname+"', '"+dvalue+"', '"+text+"');\"><option value=''>"+text+"</option>"+option_html+"</select>";
				}
				else {
					option_html = "<select name='"+cname+"' id='"+cname+"'><option value=''>"+text+"</option>"+option_html+"</select>";
				}
				$('#json_'+cname).html(option_html);
			}
		);
	}
	else{
		$('#json_'+cname).find('option').remove();
	}
}

/**
 * 获取三级地区
 * @param:: string cname 二级地区名
 * @param:: string dname 三级地区名
 * @param:: int dvalue 三级地区值
 * @param:: string text 文字提示
*/
function fetch_dist(cname, dname, dvalue, text){
	if(typeof(text) == 'undefined'){text = '';}
	var cvalue = $('#'+cname).val();
	if (cvalue>0){
		$.getJSON(_ROOT_PATH + "index.php?c=ajax&a=fetchdist&rootid="+cvalue+"&text="+text+"&rnd="+get_rndnum(8),
			function(data){
				var option_html = '';
				$.each(data,function(entryIndex,entry){
					option_html += "<option value='"+entry.areaid+"'";
					if (dvalue == entry.areaid){
						option_html += "selected";
					}
					option_html += ">"+entry.areaname+"</option>";
				});
				if (option_html != '') {
					option_html = "<select name='"+dname+"' id='"+dname+"'><option value=''>"+text+"</option>"+option_html+"</select>";
				}
				$('#json_'+dname).html(option_html);
			}
		);
	}
	else {
		$('#json_'+dname).find('option').remove();
	}
}

/**
 * jquery 获取户籍二级地区
 * @param:: string pname 一级 SELECT ID
 * @param:: string cname 二级 SELECT ID
 * @param:: intval cvalue 二级值
 * @param:: string text 显示提示
*/
function fetch_hometown(pname, cname, cvalue, text){
	if(typeof(text) == 'undefined'){text = '';}
	var pvalue = $('#'+pname).val();
	if(pvalue>0){
		$.getJSON(_ROOT_PATH + "index.php?c=ajax&a=hometown&rootid="+pvalue+"&text="+text+"&rnd="+get_rndnum(8),
			function(data){
				var option_html = "";
				$.each(data,function(entryIndex,entry){
					option_html += "<option value='"+entry.areaid+"'";
					if(cvalue == entry.areaid){
						option_html += "selected";
					}
					option_html += ">"+entry.areaname+"</option>";
				});
				if(option_html != '') {
					option_html = "<select name='"+cname+"' id='"+cname+"'><option value=''>"+text+"</option>"+option_html+"</select>";
				}
				$('#json_'+cname).html(option_html);
			}
		);
	}
	else {
		$('#json_'+cname).find("option").remove();
	}
}


/**
 * 更新浏览次数
 * @param:: int $id ID编号
 * @param:: string $type 类别
 * @param:: string $hitsid  JSON返回的ID
 * @return:: array
*/
function update_hits(id, type, hitsid) {
	if (id > 0 && type != '') {
		$.ajax({
			type: 'POST',
			url: _ROOT_PATH + 'index.php?c=ajax&a=hits',
			cache: false,
			data: {id: id, type:type, r: get_rndnum(8)},
			dataType: 'json',
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader('request_type', 'ajax');
			},
			success: function(data) {
				var json = eval(data);
				/* JSON */
				var hits = json.hits;
				$('#'+hitsid).html(hits);
			},
			error: function() {
			}
		});
	}
}

/**
 * 关注好友
 * @param:: int tuid 对方ID
 * @param:: string tipid 提示ID
 * @param:: string css CSS样式
 * @return:: string/alert
*/
function ajax_listen(tuid, tipid, css) {
	if(typeof(tipid) == 'undefined') {tipid = '';}
	if(typeof(css) == 'undefined') {css = '';}
	if (tuid > 0) {
		$.ajax({
			type: 'POST',
			url: _ROOT_PATH + 'index.php?c=ajax&a=listen',
			cache: false,
			data: {tuid: tuid, r: get_rndnum(8)},
			dataType: 'json',
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader('request_type', 'ajax');
			},
			success: function(data) {
				var json = eval(data);
				/* JSON */
				var response = json.response;
				var error = json.error;

				if (response == 1) {
					//成功
					if (tipid != '') {
						$('#'+tipid).html("<a id='a_dellisten' href=\"javascript:void(0);\" onclick=\"ajax_dellisten('"+tuid+"', '"+tipid+"');\">取消关注</a>");
						if (css != "") {
							$('#a_dellisten').addClass(css);
						}
					}
					else {
						alert('关注成功');
					}
				}
				else {
					//失败
					if (error != "") {
						alert(error);
					}
				}
			},
			error: function() {
			}
		});
	}
}


/**
 * 取消关注
 * @param:: int tuid 对方ID
 * @param:: string tipid 提示ID
 * @param:: string css CSS样式
 * @return:: string/alert
*/
function ajax_dellisten(tuid, tipid, css) {
	if(typeof(tipid) == 'undefined') {tipid = '';}
	if(typeof(css) == 'undefined') {css = '';}
	if (tuid > 0) {
		$.ajax({
			type: 'POST',
			url: _ROOT_PATH + 'index.php?c=ajax&a=dellisten',
			cache: false,
			data: {tuid: tuid, r: get_rndnum(8)},
			dataType: 'json',
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader('request_type', 'ajax');
			},
			success: function(data) {
				var json = eval(data);
				/* JSON */
				var response = json.response;
				var error = json.error;

				if (response == 1) {
					//成功
					if (tipid != '') {
						$('#'+tipid).html("<a id='a_listen' href=\"javascript:void(0);\" onclick=\"ajax_listen('"+tuid+"', '"+tipid+"');\">加入关注</a>");
						if (css != "") {
							$('#a_listen').addClass(css);
						}
					}
					else {
						alert('取消成功');
					}
				}
				else {
					//失败
					if (error != "") {
						alert(error);
					}
				}
			},
			error: function() {
			}
		});
	}
}

/**
 * 加入黑名单
 * @param:: int tuid 对方ID
 * @param:: string tipid 提示ID
 * @param:: string css CSS样式
 * @return:: string/alert
*/
function ajax_black(tuid, tipid, css) {
	if(typeof(tipid) == 'undefined') {tipid = '';}
	if(typeof(css) == 'undefined') {css = '';}
	if (tuid > 0) {
		$.ajax({
			type: 'POST',
			url: _ROOT_PATH + 'index.php?c=ajax&a=black',
			cache: false,
			data: {tuid: tuid, r: get_rndnum(8)},
			dataType: 'json',
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader('request_type', 'ajax');
			},
			success: function(data) {
				var json = eval(data);
				/* JSON */
				var response = json.response;
				var error = json.error;

				if (response == 1) {
					//成功
					if (tipid != '') {
						$('#'+tipid).html("<a id='a_listen' href=\"javascript:void(0);\" onclick=\"ajax_listen('"+tuid+"', '"+tipid+"');\">加入关注</a>");
						if (css != "") {
							$('#a_listen').addClass(css);
						}
					}
					else {
						alert('拉黑成功');
					}
				}
				else {
					//失败
					if (error != "") {
						alert(error);
					}
				}
			},
			error: function() {
			}
		});
	}
}

/**
 * 设置形象照 需要会员登录
 * @param:: string img 图片地址
 * @param:: int x 
 * @param:: int y
 * @param:: int w
 * @param:: int z
 * @param:: int pw ic缩略图大小
 * @param:: int ph
 * @param:: string cometype 来源 注册/会员中心
 * @return:: array('response'=>, 'message'=>)
*/
function setAvatar(img, x, y, w, h, pw, ph, cometype) {
	if(typeof(cometype) == 'undefined') {cometype = 'cp';}
	$.ajax({
		type: 'POST',
		url: _ROOT_PATH + 'index.php?c=ajax&a=setavatar',
		cache: false,
		data: {img: img, x: x, y: y, w: w, h: h, pw: pw, ph: ph, r: get_rndnum(8)},
		dataType: 'json',
		beforeSend: function(XMLHttpRequest) {
			XMLHttpRequest.setRequestHeader('request_type', 'ajax');
		},
		success: function(data) {
			var json = eval(data);
			/* JSON */
			var response = json.response;
			var message = json.message;
			if (true == response) {
				//设置成功
				if (cometype == 'cp') {
					alert(message);
					window.location.href = _ROOT_PATH + 'usercp.php?c=avatar';
				}
				else {
					//注册 下一步
					alert(message);
					window.location.href = _ROOT_PATH + 'index.php?c=passport&a=setcond';
				}
			}
			else {
				if (message == '') {
					alert('设置失败');
				}
				else {
					alert(message);
				}
			}
		},
		error: function() {
		}
	});
}

/**
 * 访问空间记录
 * @param:: int homeuid 主页ID
*/
function ajax_visithome(homeuid) {
	if (homeuid > 0) {
		$.ajax({
			type: 'POST',
			url: _ROOT_PATH + 'index.php?c=ajax&a=visithome',
			cache: false,
			data: {homeuid: homeuid, r: get_rndnum(8)},
			dataType: 'json',
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader('request_type', 'ajax');
			},
			success: function(data) {
				var json = eval(data);
				/* JSON */
				var response = json.response;
				var error = json.error;
			},
			error: function() {
			}
		});
	}
}

/**
 * 会员中心发送邮箱验证邮件_需登录
 * @param:: string tipsid 提示区ID
 * @param:: string button 按钮ID
 * @return:: array('response'=>bool true/false, 'message'=>)
*/
function ajax_sendmailkey(tipid, button) {
	if(typeof(tipid) == 'undefined') {tipid = '';}
	if(typeof(button) == 'undefined') {button = '';}
	if (tipid != '') {
		$('#'+tipid).html('邮件发送中，请稍候...');
	}
	if (button != '') {
		$('#'+button).attr('disabled', true);
	}
	$.ajax({
		type: 'POST',
		url: _ROOT_PATH + 'index.php?c=ajax&a=sendmailkey',
		cache: false,
		data: {r: get_rndnum(8)},
		dataType: 'json',
		beforeSend: function(XMLHttpRequest) {
			XMLHttpRequest.setRequestHeader('request_type', 'ajax');
		},
		success: function(data) {
			var json = eval(data);
			/* JSON */
			var response = json.response;
			var message = json.message;

			if (response == true) {
				if (message == '') {
					message = '邮件发送成功，请注意查收';
				}
				if (tipid != '') {
					$('#'+tipid).html('<font color=green>'+message+'</font>');
				}
				else {
					alert(message);
				}
			}
			else {
				if (message == '') {
					message = '发送失败';
				}
				if (tipid != '') {
					$('#'+tipid).html('<font color=red>'+message+'</font>');
				}
				else {
					alert(message);
				}
			}
		},
		error: function() {
		}
	});
}


/*----------------------------- 发送手机短信 Start -----------------------------*/
/**
 * 会员主页里 发手机短信 
 * @param:: int uid 对方UID
 * @param:: string content 短信内容
 * @param:: int 扣费类别 0-信使，1-金币
 * @param:: string tipsid 提示区ID
 * @param:: string button 按钮ID
 * @param:: string returntype 返回类型 jdbox/null;
 * @return:: array('response'=>true/false, 'message'=>)
*/
function ajax_home_sendsms(uid, content, type, tipid, button, returntype) {
	if(typeof(tipid) == 'undefined') {tipid = '';}
	if(typeof(button) == 'undefined') {button = '';}
	if(typeof(returntype) == 'undefined') {returntype = '';}
	if (tipid != '') {
		$('#'+tipid).html('短信发送中，请稍候...');
	}
	if (button != '') {
		$('#'+button).attr('disabled', true);
	}
	if (uid > 0) {
		$.ajax({
			type: 'POST',
			url: _ROOT_PATH + 'index.php?c=ajax&a=sendhomesms',
			cache: false,
			data: {uid: uid, content: content, type: type, r: get_rndnum(8)},
			dataType: 'json',
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader('request_type', 'ajax');
			},
			success: function(data) {
				var json = eval(data);
				/* JSON */
				var response = json.response;
				var message = json.message;

				if (response == true) {
					if (message == '') {
						message = '发送成功';
					}
					if (tipid != '') {
						$('#'+tipid).html('<font color=green>'+message+'</font>');
					}
					else {
						alert(message);
						if (returntype == 'jdbox') {
							parent.JqueryDialog.Close();
						}
					}
				}
				else {
					if (message == '') {
						message = '发送失败';
					}
					if (tipid != '') {
						$('#'+tipid).html('<font color=red>'+message+'</font>');
					}
					else {
						alert(message);
					}
				}
			},
			error: function() {
			}
		});
	}
}

/**
 * 会员中心 获取手机验证码 
 * @param:: string tipid 提示区ID
 * @param:: string button 按钮ID
 * @return:: array('response'=>true/false, 'message'=>)
*/
function ajax_getmbkey(mobile, tipid, button) {
	if(typeof(tipid) == 'undefined') {tipid = '';}
	if(typeof(button) == 'undefined') {button = '';}
	if (tipid != '') {
		$('#'+tipid).html('验证码发送中，请稍候...');
	}
	if (button != '') {
		$('#'+button).attr('disabled', true);
	}
	if (mobile > 0) {
		$.ajax({
			type: 'POST',
			url: _ROOT_PATH + 'index.php?c=ajax&a=getmbkey',
			cache: false,
			data: {mobile: mobile, r: get_rndnum(8)},
			dataType: 'json',
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader('request_type', 'ajax');
			},
			success: function(data) {
				var json = eval(data);
				/* JSON */
				var response = json.response;
				var message = json.message;

				if (response == true) {
					if (message == '') {
						message = '验证码发送成功，请注意查收。';
					}
					if (tipid != '') {
						$('#'+tipid).html('<font color=green>'+message+'</font>');
					}
					else {
						alert(message);
					}
				}
				else {
					if (message == '') {
						message = '验证码发送失败';
					}
					if (tipid != '') {
						$('#'+tipid).html('<font color=red>'+message+'</font>');
					}
					else {
						alert(message);
					}
				}
			},
			error: function() {
			}
		});
	}
}

/**
 * 获取手机验证码  注册页第一步&修改已验证手机号码用
 * @param:: string tipid 提示区ID
 * @param:: string button 按钮ID
 * @return:: array('response'=>true/false, 'message'=>)
*/
function ajax_getmbcode(mobile, tipid, button) {
	if(typeof(tipid) == 'undefined') {tipid = '';}
	if(typeof(button) == 'undefined') {button = '';}
	if (tipid != '') {
		$('#'+tipid).html('验证码发送中，请稍候...');
	}
	if (button != '') {
		$('#'+button).attr('disabled', true);
	}
	if (mobile > 0) {
		$.ajax({
			type: 'POST',
			url: _ROOT_PATH + 'index.php?c=ajax&a=getmbcode',
			cache: false,
			data: {mobile: mobile, r: get_rndnum(8)},
			dataType: 'json',
			beforeSend: function(XMLHttpRequest) {
				XMLHttpRequest.setRequestHeader('request_type', 'ajax');
			},
			success: function(data) {
				var json = eval(data);
				/* JSON */
				var response = json.response;
				var message = json.message;

				if (response == true) {
					if (message == '') {
						message = '验证码发送成功，请注意查收。';
					}
					if (tipid != '') {
						$('#'+tipid).html('<font color=green>'+message+'</font>');
					}
					else {
						alert(message);
					}
				}
				else {
					if (message == '') {
						message = '验证码发送失败';
					}
					if (tipid != '') {
						$('#'+tipid).html('<font color=red>'+message+'</font>');
					}
					else {
						alert(message);
					}
				}
			},
			error: function() {
			}
		});
	}
}

/*----------------------------- 发送手机短信 End  ------------------------------*/

