/**
 * [OElove] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.01.18 Update by OE $
*/
var _sms_cd_timer = 60; //倒计时
$(function(){
    
    function OESms() {
        this.sendurl = _ROOT_PATH+'index.php';
        
        this.mobile_input = 'mobile'; //手机号输入框名
        this.mobile = ''; //手机号
        this.send_type = 'reg'; //发送类型
        this.checkimgcode = '0'; //是否启用防刷
        this.validcode = ''; //防刷校验码
        
        this.but_send = 'but_send_mobile_code'; //发送按钮 f
        this.but_obj_id = 'but_send_mobile_code'; //返送按钮 id 
        
        this.picker_imgcode_box = 'picker_imgcode_box'; //防刷框
        
        this.wakeSend();
        this.wakeBrush();
    }
    OESms.prototype = {
        
        wakeSend:function() {
            var _this = this;
            //点击发送按钮
            $(document).on("click", "[f='"+_this.but_send+"']", function(){
                var $input = $(this).attr("data-input");
                if (typeof($input) == "undefined") {
                    
                }
                else {
                    _this.mobile_input = $input;
                }
                var $val = $("#"+_this.mobile_input).val();
                if (typeof($val) == "undefined") {
                    $val = "";
                }
                if ($val == "") {
                    ToastShow('请填写手机号');
                    return;
                }
                var $type = $(this).attr("data-sendtype"); //类型
                if (typeof($type) == "undefined") {
                    $type = "reg";
                }
                _this.send_type = $type;
                
                //是否开启防刷
                var $checkimgcode = $(this).attr("data-checkimgcode");
                if (typeof($checkimgcode) == "undefined") {
                    $checkimgcode = "0";
                }
                _this.checkimgcode = $checkimgcode;
                _this.but_obj_id = $(this).attr("id"); //保存obj_id
                _this.mobile = $val;
                
                if (_this.checkimgcode == '1' && (_this.send_type == 'reg')) {
                    _this.showBrush(); //防刷机制
                }
                else {
                    _this.sendSms(); //直接发送验证
                }
                
            });
            
        },
        
        //发送短信
        sendSms:function() {
            var _this = this;
            
            if (!$("#"+_this.but_obj_id).hasClass("forbid_send")) { 
            
                $("#"+_this.but_obj_id).addClass("forbid_send");
                $.ajax({
                    type: "POST",
                    url: _this.sendurl,
                    cache: false,
                    data: {
                        c:'picker', a:'sendmobile', type:_this.send_type, 
                        mobile:_this.mobile, validcode:_this.validcode
                    },
                    dataType: "json",
                    success: function($data) {
                        $json = eval($data);
                        $response = $json.response;
                        $result = $json.result;
                        $("#"+_this.but_obj_id).removeClass("forbid_send");
                        
                        if ($response == "1") {
                            ToastShow('发送成功，请查收手机短信！');
                            _this.pickerCountDown(); //倒计时
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '发送失败，请检查手机号码是否可用！';
                            }
                            ToastShow($result);
                            $("#"+_this.but_obj_id).html('获取验证码');
                        }
                    },
                    error: function() {
                        $("#"+_this.but_obj_id).removeClass("forbid_send");
                        $("#"+_this.but_obj_id).html('获取验证码');
                    }
                }); 
            }
        },
        
        //倒计时
        pickerCountDown:function() {
            var _this = this;
            var $obj = $("#"+_this.but_obj_id);
            if (_sms_cd_timer == 0) {
                $obj.html("获取验证码");
                $obj.removeClass("current");
                $obj.attr('f', _this.but_send);
                _sms_cd_timer = 60; 
            }
            else {
                $obj.addClass("current"); 
                $obj.html(_sms_cd_timer+"秒重新发送");
                $obj.attr('f', '');
                _sms_cd_timer--; 
                setTimeout(function() { 
                    _this.pickerCountDown();
                },	1000);
            }
        },
        
        //防刷机制
        wakeBrush:function() {
            var _this = this;
            //关闭防刷窗口
            $(document).on("click", "[f='but_picker_close_imgcode']", function(){
                $("#"+_this.picker_imgcode_box).hide();
            });
            
            //刷新图片校验码
            $(document).on("click", "[f='but_picker_refresh_imgcode']", function(){
                $(this).find("img").show();
                _this.pickerGetImageCode();
            });
            
            //校验选中的图片
            $(document).on("click", "[f='but_picker_sel_imgcode']", function(){
                var $validcode = $(this).attr("data-code");
                
                $(this).addClass('current').siblings().removeClass('current');
                $("#picker_imgcode_error").hide();
                $("#picker_imgcode_zhao").show();
                
                $.ajax({
                    type: "POST",
                    url: _this.sendurl,
                    cache: false,
                    data: {
                        c:'picker', a:'checkimgcode', validcode:$validcode
                    },
                    dataType: "json",
                    success: function($data) {
                        $json = eval($data);
                        $response = $json.response;
                        $result = $json.result;
                        if ($response == "1") {
                            //校验通过
                            $("#picker_imgcode_zhao").hide();
                            $("#picker_imgcode_error").hide();
                            $("#picker_imgcode_box").hide();
                            _this.validcode = $validcode; //存
                            //发送验证码
                            _this.sendSms();
                            
                        }
                        else if ($response == "2") {
                            //校验失败  重新刷新
                            $("#picker_imgcode_zhao").show();
                            $("#picker_imgcode_error").slideDown(100, function(){
                                setTimeout(function(){
                                    $("#picker_imgcode_zhao").hide();
                                    $("[f='but_picker_refresh_imgcode']").find("img").show();
                                    _this.pickerGetImageCode();
                                    $("#picker_imgcode_error").slideUp(100);
                                }, 1000);
                            });
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '请求异常，请检查！';
                            }
                            ToastShow($result);
                            
                            $("#picker_imgcode_zhao").hide();
                            $("#picker_imgcode_error").hide();
                        }
                    },
                    error: function() {
                        ToastShow('系统繁忙，请稍后再试！');
                    }
                });
               
            });
                    
        },
        //显示
        showBrush:function() {
            var _this = this;
            $("#"+_this.picker_imgcode_box).show();
            _this.pickerGetImageCode();
        },
        //生成图片校验码
        pickerGetImageCode:function() {
            var _this = this;
            $.ajax({
                type: "POST",
                url: _this.sendurl,
                cache: false,
                data: {
                    c:'picker', a:'imgcode'
                },
                dataType: "json",
                success: function($data) {
                    $json = eval($data);
                    $response = $json.response;
                    $result = $json.result;
                    $wzpic = $json.wzpic;
                    if (typeof($wzpic) == "undefined") {
                        $wzpic = "";
                    }
                    if ($response == "1") {
                        if ($wzpic == "") {
                            ToastShow('点击/刷新过于频繁！');
                        }
                        else {
                            $("#wzpic_title").find("img").attr("src", $wzpic);
                            $("#picker_imgcode_data").html($result);
                        }
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '请求异常，请检查！';
                        }
                        ToastShow($result);
                    }
                    
                    $("[f='but_picker_refresh_imgcode']").find("img").hide();
                },
                error: function() {
                    ToastShow('系统繁忙，请稍后再试！');
                    $("[f='but_picker_refresh_imgcode']").find("img").hide();
                }
            });
    
        }
        
    }
    new OESms();
    
});

