/**
 * [OElove] (C)2010-2099 OELOVE.COM Inc.
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/01/18 by OE $
*/
$(function(){
    
    function OELogin() {
        this.login_type = '';
        this.loginname = '';
        this.password = '';
        this.mobile = '';
        this.mobilecode = '';
        
        this.initLogin();
        this.pwdLogin();
        this.mobileLogin();
    }
    
    OELogin.prototype = {
        
        initLogin:function(){
            var _this = this;
            
            //选择登录方式
            $(document).on("click", "[f='but_select_type']", function(){
                var $type = $(this).attr("data-type");
                _this.login_type = $type;
                if ($type == "pwd") {
                    $(".type_pwd").show();
                    $(".type_mobi").hide();
                }
                else {
                    $(".type_pwd").hide();
                    $(".type_mobi").show();
                }
            });
            
        },
        
        //使用密码登录
        pwdLogin:function() {
            var _this = this;
            
            $(document).on("click", "[f='but_login_pwd']", function(){
                _this.loginname = $("#loginname").val();
                _this.password = $("#password").val();
                
                if(_this.loginname == '') {
                    ToastShow('请输入登录帐号/手机号');
                    return;
                }
                if(_this.password == '') {
                    ToastShow('请输入登录密码');
                    return;
                }
                
                _this.doLogin("pwd");
            });
        },
        
        //使用手机号登录
        mobileLogin:function() {
            var _this = this;
            
            $(document).on("click", "[f='but_login_mobi']", function(){
                _this.mobile = $("#mobile").val();
                _this.mobilecode = $("#mobilecode").val();
                
                if(_this.mobile == '') {
                    ToastShow('请输入手机号');
                    return;
                }
                if(_this.mobilecode == '') {
                    ToastShow('请输入手机验证码');
                    return;
                }
                
                _this.doLogin("mobi");
            });
        },
        
        
        doLogin:function(type) {
            var _this = this;
            
            var $openid = $("#openid").val();
            if (typeof($openid) == "undefined") {
                $openid = "";
            }
            var $au_unionid = $("#au_unionid").val();
            if (typeof($au_unionid) == "undefined") {
                $au_unionid = "";
            }
            
            if (type == 'pwd') {
                //使用密码登录
                var $obj_id = "but_login_pwd";
                var $post_url = WAP_APPFILE + "?c=passport&a=loginpost";
            }
            else {
                //使用短信登录
                var $obj_id = "but_login_mobi";
                var $post_url = WAP_APPFILE + "?c=passport&a=loginbymobi";
            }
            
            if (!$("#"+$obj_id).hasClass("forbid_submit")) {
            
                $("#"+$obj_id).addClass("forbid_submit");
                $.ajax({
                    type: 'POST',
                    url: $post_url,
                    data: {
                        loginname:_this.loginname, password:_this.password, 
                        mobile:_this.mobile, mobilecode:_this.mobilecode, 
                        openid:$openid, au_unionid:$au_unionid
                    },
                    success: function (data) {
                        var $json = JSON.parse(data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        $("#"+$obj_id).removeClass("forbid_submit");
                        
                        
                        if ($response == '1') {
                            window.location.href = WAP_APPFILE+"?c=cp";
                        }
                        else if ($response == '2') {
                            window.location.href = $result; //整合oemarry
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '登录失败，请检查帐号/密码！';
                            }
                            ToastShow($result);
                            
                        }
                    },
                    error: function () {
                        $("#"+$obj_id).removeClass("forbid_submit");
                        ToastShow('网络繁忙，请稍后再试！');
                    }
                });
            }
        }
        
        
    }
    var login = new OELogin();
});