function getLocation() {
    if ($("#need_update_location").length < 0) {
        return;
    }

    var position_option = {
        enableHighAccuracy: true,
        maximumAge: 30000,
        timeout: 20000
    };
    navigator.geolocation.getCurrentPosition(getPositionSuccess, getPositionError, position_option);
    function getPositionSuccess(position) {
        var lat = position.coords.latitude;
        var lng = position.coords.longitude;
        if (lat >= 0 && lng >= 0) {
            var url = "/touch/users/location";
            var data = {"latitude": lat, "longitude": lng};
            $.authPost(url, data, function (data) {
            });
        }
    }

    function getPositionError(error) {
        switch (error.code) {
            case error.TIMEOUT:
                // alert("连接超时，请重试");
                break;
            case error.PERMISSION_DENIED:
                // alert("您拒绝了使用位置共享服务，查询已取消");
                break;
            case error.POSITION_UNAVAILABLE:
                // alert("获取位置信息失败");
                break;
        }
    }

}


function avatarTip() {

    if ($("#is_today_first_time_login").html() == '1') {
        var url = '/touch/users/profile';
        if ($("#ser_sex").attr('value') == '1') {
            scscms_alert('有头像男生收到回信的比没头像的多十倍！', '', '', '', 1, url);
        } else {
            scscms_alert('有头像女生收到回信的比没头像的多十倍！', '', '', '', 1, url);
        }
    }

}


function uploadAvatar() {
    if ($("#upload_avatar_btn").length < 1) {
        return;
    }
    if (!canUserWeixinJs()) {
        $("#upload_avatar_btn").upload({
            action: '/touch/users/create_avatar?ajax=1',
            upload_type: 'avatar',
            onChooseFile: function (img) {
                $("#file_img01").attr('src', img.src);
                $(".img_zt").html('上传中...');
            },
            onSubmit: function (resp) {
                if (resp.error === 0) {
                    location.reload();
                } else {
                    scscms_alert(data.error_reason, "warn", "", 1);
                }
            }
        });
    } else {
        wx.config({
            debug: false,
            appId: appId,
            timestamp: timestamp,
            nonceStr: nonceStr,
            signature: signature,
            jsApiList: [
                'chooseImage',
                'uploadImage',
            ]
        });

        wx.ready(function () {
            // 5 图片接口
            // 5.1 拍照、本地选图
            var images = {
                localId: [],
                serverId: []
            };

            $("body").on("touchstart", "#upload_avatar_btn", function () {
                wx.chooseImage({
                    count: 1,
                    sizeType: ['compressed'],
                    sourceType: ['album'],
                    success: function (res) {
                        images.localId = res.localIds;
                        $(".img_zt").html('上传中...');
                        //上传图片
                        wx.uploadImage({
                            localId: images.localId[0], // 需要上传的图片的本地ID，由chooseImage接口获得
                            isShowProgressTips: 1, // 默认为1，显示进度提示
                            success: function (res) {
                                var url = "/touch/users/upload_avatar";
                                var resp = {'media_id': res.serverId};
                                $.authPost(url, resp, function (data) {
                                    if (data.error === 0) {
                                        var url = "/touch/users/profile";
                                        location.href = url;
                                    } else {
                                        scscms_alert(data.error_reason, "warn", "", 1);
                                    }
                                });
                            }
                        });
                    }
                });
            });
        });
    }
}

//    avatarTip();
uploadAvatar();

$("body").on("tap", ".love_pic", function () {
    event.preventDefault();
    self = $(this);
    if ('disabled' == self.attr('disabled')) {
        return;
    }
    self.attr('disabled', 'disabled');
    var uid = $(this).attr("uid");
    $(this).addClass("hi_love").find("span").addClass("love_icon01").text("已喜欢");
    var url = "/touch/followers/follow";
    var data = {"uid": uid};
    $.authPost(url, data, function (resp) {
        scscms_alert('已 喜 欢 ~', "ok", "", 1);
        self.removeAttr('disabled');
    });

}).on("tap", ".hi_pic", function (e) {
    event.preventDefault();
    self = $(this);
    if ('disabled' == self.attr('disabled')) {
        return;
    }

    self.attr('disabled', 'disabled');

    $(this).attr('disabled', 'disabled');
    var uid = $(this).attr("uid");
    $(this).addClass("hi_love").find("span").addClass("hi_icon01").text("已打招呼").addClass('already_ring');
    var url = "/touch/messages/ring";
    var data = {"uid": uid};
    $.authPost(url, data, function (resp) {
        scscms_alert(resp.error_reason, "ok", "", 1);
        self.removeAttr('disabled');
    });

}).on("tap", "#batch_ring", function (e) {

    e.preventDefault();
    self = $(this);
    if ('disabled' == self.attr("disabled")) {
        return;
    }
    ;
    self.attr('disabled', 'disabled');
    if ($("#ajax_list .already_ring").length >= $("#ajax_list .say_hi").length) {
        self.removeAttr('disabled');
        scscms_alert("已经全部打过招呼", "warn", "", 1);
        return;
    }

    var uids = [];
    var ready_uids = $("#ajax_list .say_hi");
    ready_uids.each(function () {
        if (!$(this).hasClass('already_ring')) {
            uids.push($(this).attr('uid'));
        }

    });
    uids = uids.join(',');
    var url = "/touch/messages/batch_ring";
    var data = {"uids": uids};
    $.authPost(url, data, function (resp) {
        self.removeAttr('disabled');
        if (0 === resp.error) {
            ready_uids.text('已打招呼').removeClass("enter_hi").addClass('already_ring');
            scscms_alert(resp.error_reason, "ok", "", 1);
        } else {
            scscms_alert(resp.error_reason, "warn", "", 1);
        }
    });
});