<?php
/***************************************************************************
*                            Dolphin Smart Community Builder
*                              -------------------
*     begin                : Mon Mar 23 2006
*     copyright            : (C) 2007 BoonEx Group
*     website              : http://www.boonex.com
* This file is part of Dolphin - Smart Community Builder
*
* Dolphin is free software; you can redistribute it and/or modify it under
* the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2 of the
* License, or  any later version.
*
* Dolphin is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU General Public License for more details.
* You should have received a copy of the GNU General Public License along with Dolphin,
* see license.txt file; if not, write to marketing@boonex.com
***************************************************************************/

bx_import('BxDolModuleDb');

class BxPageACDb extends BxDolModuleDb {
	/*
	 * Constructor.
	 */
	function BxPageACDb(&$oConfig) {
		parent::BxDolModuleDb($oConfig);

		$this->_oConfig = &$oConfig;
	}
	function fromCache($sName, $sFunc, $sQuery, $sExtra = '') {
		$sName = 'sys_modules_'.$this->_oConfig->getUri().'_'.$sName;
		$sHash = md5($sName.$GLOBALS['site']['ver'] . $GLOBALS['site']['build'] . $GLOBALS['site']['url']);
		return parent::fromCache($sName.'_'.$sHash, $sFunc, $sQuery, $sExtra);
	}
	function cleanCache($sName) {
		$sName = 'sys_modules_'.$this->_oConfig->getUri().'_'.$sName;
		$sHash = md5($sName.$GLOBALS['site']['ver'] . $GLOBALS['site']['build'] . $GLOBALS['site']['url']);
		return parent::cleanCache($sName.'_'.$sHash);
	}
	function getAllRules() {
	    $aRules = $this->fromCache('rules', 'getAll', "SELECT * FROM `{$this->_sPrefix}rules` ORDER BY `ID`");
	    if (!empty($aRules))
	    	foreach ($aRules as $iID => $aRule)
	    		$aRules[$iID]['MemLevels'] = empty($aRules[$iID]['MemLevels']) ? array() : unserialize($aRules[$iID]['MemLevels']);
	   	return $aRules;
	}
	function addRule($sRule, $aMemLevels) {
		$this->query("INSERT INTO `{$this->_sPrefix}rules` SET `Rule` = '".process_db_input($sRule)."', `MemLevels` = '".serialize($aMemLevels)."'");
		$this->cleanCache('rules');
	}
	function deleteRule($iID) {
		$this->query("DELETE FROM `{$this->_sPrefix}rules` WHERE `ID` = {$iID} LIMIT 1");
		$this->cleanCache('rules');
	}
	function updateRule($iID, $sRule, $aMemLevels) {
		$this->query("UPDATE `{$this->_sPrefix}rules` SET `Rule` = '".process_db_input($sRule)."', `MemLevels` = '".serialize($aMemLevels)."' WHERE `ID` = {$iID} LIMIT 1");
		$this->cleanCache('rules');
	}
	function getTopMenuArray() {
		$aTopItems = array();
		$aCustomItems = array();
		$aSystemItems = array();

		$rTopItems = $this->res("SELECT `ID`, `Name` FROM `sys_menu_top` WHERE `Active`=1 AND `Type`='top' ORDER BY `Order`");
		while( $aTopItem = mysql_fetch_assoc( $rTopItems ) ) {
			$aTopItems[$aTopItem['ID']] = $aTopItem['Name'];
			$aCustomItems[$aTopItem['ID']] = array();

			$rCustomItems = $this->res("SELECT `ID`, `Name` FROM `sys_menu_top` WHERE `Active`=1 AND `Type`='custom' AND `Parent`={$aTopItem['ID']} ORDER BY `Order`");
			while( $aCustomItem = mysql_fetch_assoc( $rCustomItems ) ) {
				$aCustomItems[$aTopItem['ID']][$aCustomItem['ID']] = $aCustomItem['Name'];
			}
		}

		$rSysItems = $this->res("SELECT `ID`, `Name` FROM `sys_menu_top` WHERE `Active`=1 AND `Type`='system' ORDER BY `Order`");
		while( $aSystemItem = mysql_fetch_assoc( $rSysItems ) ) {
			$aSystemItems[$aSystemItem['ID']] = $aSystemItem['Name'];
			$aCustomItems[$aSystemItem['ID']] = array();

			$rCustomItems = $this->res( "SELECT `ID`, `Name` FROM `sys_menu_top` WHERE `Active`=1 AND `Type`='custom' AND `Parent`={$aSystemItem['ID']} ORDER BY `Order`" );
			while( $aCustomItem = mysql_fetch_assoc( $rCustomItems ) ) {
				$aCustomItems[$aSystemItem['ID']][$aCustomItem['ID']] = $aCustomItem['Name'];
			}
		}
		return array(
			'TopItems' => $aTopItems,
			'CustomItems' => $aCustomItems,
			'SystemItems' => $aSystemItems,
		);
	}
	function getMemberMenuArray() {
		$rTopItems = $this->res("SELECT `ID`, `Name` FROM `sys_menu_member` WHERE `Active`='1' AND `Type` <> 'linked_item' ORDER BY `Position`, `Order`");

		$aTopItems = array();
		while( $aTopItem = mysql_fetch_assoc( $rTopItems ) ) {
			$aTopItems[$aTopItem['ID']] = $aTopItem['Name'];
		}
		return $aTopItems;
	}

	function getMenuItemVisibility($sType, $iMenuItemID) {
		$aRes = $this->getOne("SELECT `MemLevels` FROM `{$this->_sPrefix}{$sType}_menu_visibility` WHERE `MenuItemID` = {$iMenuItemID} LIMIT 1");
		return $iRes !== false ? unserialize($aRes) : array();
	}
	function setMenuItemVisibility($sType, $iMenuItemID, $aVisibleTo) {
		if (empty($aVisibleTo)) $this->query("DELETE FROM `{$this->_sPrefix}{$sType}_menu_visibility` WHERE `MenuItemID` = {$iMenuItemID}");
		else $this->query("REPLACE `{$this->_sPrefix}{$sType}_menu_visibility` SET `MemLevels` = '".serialize($aVisibleTo)."', `MenuItemID` = {$iMenuItemID}");
		$this->cleanCache($sType.'_menu');
	}
	function getPageBlockVisibility($iID) {
		$aRes = $this->getOne("SELECT `MemLevels` FROM `{$this->_sPrefix}page_blocks_visibility` WHERE `PageBlockID` = {$iID} LIMIT 1");
		return $iRes !== false ? unserialize($aRes) : array();
	}
	function setPageBlockVisibility($iID, $aMemLevels) {
		if (empty($aMemLevels)) $this->query("DELETE FROM `{$this->_sPrefix}page_blocks_visibility` WHERE `PageBlockID` = {$iID}");
		else $this->query("REPLACE `{$this->_sPrefix}page_blocks_visibility` SET `MemLevels` = '".serialize($aMemLevels)."', `PageBlockID` = {$iID}");
		$this->cleanCache('page_blocks');
	}
	function getAvailablePages() {
		return $this->getAll("SELECT `Name`, `Title` FROM `sys_page_compose_pages` ORDER BY `Order`");
	}
	function getPageBlocks($sPage) {
		$aColumns = array();
		$sPage = process_db_input($sPage);
        $rColumns = $this->res("SELECT DISTINCT `Column` FROM `sys_page_compose` WHERE `Page` = '{$sPage}' AND `Column` != 0 ORDER BY `Column`");
        while( $aColumn = mysql_fetch_assoc( $rColumns ) ) {
            $aColumns[$aColumn['Column']] = $this->getAll("SELECT `ID`, `Caption` FROM `sys_page_compose` WHERE `Page` = '{$sPage}' AND `Column` = {$aColumn['Column']} ORDER BY `Order`");
        }
        return $aColumns;
	}
	function getAllMenuItems($sType) {
		$aCache = $this->fromCache($sType.'_menu', 'getAllWithKey', "SELECT `MenuItemID`, `MemLevels` FROM `{$this->_sPrefix}{$sType}_menu_visibility`", 'MenuItemID');
	    if (!empty($aCache))
	    	foreach ($aCache as $iID => $aItem)
	    		$aCache[$iID]['MemLevels'] = empty($aCache[$iID]['MemLevels']) ? array() : unserialize($aCache[$iID]['MemLevels']);
	   	return $aCache;
	}
	function getAllPageBlocks() {
		$aCache = $this->fromCache('page_blocks', 'getAllWithKey', "SELECT `PageBlockID`, `MemLevels` FROM `{$this->_sPrefix}page_blocks_visibility`", 'PageBlockID');
		if (!empty($aCache))
	    	foreach ($aCache as $iID => $aItem)
	    		$aCache[$iID]['MemLevels'] = empty($aCache[$iID]['MemLevels']) ? array() : unserialize($aCache[$iID]['MemLevels']);
	   	return $aCache;
	}
}
?>