/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.model.impl.upload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jmaster.jumploader.app.ShutdownCleaner;
import jmaster.jumploader.model.api.config.UploaderConfig;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.model.impl.upload.C;
import jmaster.util.log.A;
import jmaster.util.log.B;

public class UploadFilePreprocessor
implements jmaster.jumploader.model.api.upload.B {
    protected A \u017e = B.getInstance().getLog(this.getClass());
    private jmaster.jumploader.model.api.B \u017d;

    public UploadFilePreprocessor(jmaster.jumploader.model.api.B b2) {
        this.\u017d = b2;
        b2.D().addListener(this);
    }

    public void uploaderFileAddFailed(IUploader iUploader, jmaster.jumploader.model.api.A.C c2) {
    }

    public void uploaderFileAdded(IUploader iUploader, IUploadFile iUploadFile) {
        UploaderConfig uploaderConfig = this.\u017d.B();
        if (iUploadFile.isFile() && "zipOnAdd".equals(uploaderConfig.getCompressionMode())) {
            if (uploaderConfig.getSkipZippingFilesPattern() != null && Pattern.matches(uploaderConfig.getSkipZippingFilesPattern(), iUploadFile.getName())) {
                return;
            }
            jmaster.util.C.B.B(this, "zipFile", new Class[]{IUploader.class, C.class}, new Object[]{iUploader, iUploadFile});
        }
        if (iUploadFile.isDirectory() && uploaderConfig.isZipDirectoriesOnAdd()) {
            jmaster.util.C.B.B(this, "zipDirectory", new Class[]{IUploader.class, C.class}, new Object[]{iUploader, iUploadFile});
        }
    }

    public void uploaderFileAdditionEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileMoved(IUploader iUploader, IUploadFile iUploadFile, int n2) {
    }

    public void uploaderFileRemovalEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileRemoved(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFileStatusChanged(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFileUpdated(IUploader iUploader, IUploadFile iUploadFile) {
    }

    public void uploaderFilesReset(IUploader iUploader) {
    }

    public void uploaderStatusChanged(IUploader iUploader) {
    }

    public void uploaderUploadEnabledChanged(IUploader iUploader) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void zipFile(IUploader iUploader, C c2) {
        this.\u017e.D("Preprocessing " + c2);
        try {
            this.\u017d.D().updateFileStatus(c2, 4);
            long l2 = c2.getLength();
            File file = UploadFilePreprocessor.A(c2);
            c2.A(file, true);
            if (l2 > 0L) {
                c2.A(new Double((double)file.length() / (double)l2));
            }
            c2.A(c2.getName() + ".zip");
            c2.F(true);
        }
        catch (Exception exception) {
            this.\u017e.E(exception, exception);
        }
        finally {
            iUploader.updateFileStatus(c2, 0);
            this.\u017e.D("Preprocessing finished for " + c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void zipDirectory(IUploader iUploader, C c2) {
        this.\u017e.D("Preprocessing " + c2);
        try {
            this.\u017d.D().updateFileStatus(c2, 4);
            File file = File.createTempFile("jumploader", ".zip");
            ShutdownCleaner.getInstance().addFile(file);
            jmaster.util.B.C c3 = new jmaster.util.B.C();
            jmaster.util.F.A.A a2 = jmaster.util.F.A.B.B().A();
            a2.A(c2.getPath(), file.getAbsolutePath(), c3);
            c2.A(file, true, true);
            if (c3.A() > 0L) {
                c2.A(new Double((double)file.length() / (double)c3.A()));
            }
            c2.A(c2.getName() + ".zip");
            c2.F(true);
            c2.getAttributeSet().setStringAttribute("zippedDirectory", "true");
        }
        catch (Exception exception) {
            this.\u017e.E(exception, exception);
        }
        finally {
            iUploader.updateFileStatus(c2, 0);
            this.\u017e.D("Preprocessing finished for " + c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File A(IUploadFile iUploadFile) throws Exception {
        File file = null;
        File file2 = File.createTempFile("jumploader_", ".zip");
        ShutdownCleaner.getInstance().addFile(file2);
        file2.deleteOnExit();
        BufferedOutputStream bufferedOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(iUploadFile.getFile()));
            ZipEntry zipEntry = new ZipEntry(iUploadFile.getName());
            zipEntry.setSize(iUploadFile.getLength());
            zipOutputStream.putNextEntry(zipEntry);
            jmaster.util.F.A.A(bufferedInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (Throwable throwable) {
            jmaster.util.F.A.A(zipOutputStream);
            jmaster.util.F.A.A(bufferedOutputStream);
            jmaster.util.F.A.A(bufferedInputStream);
            throw throwable;
        }
        jmaster.util.F.A.A(zipOutputStream);
        jmaster.util.F.A.A(bufferedOutputStream);
        jmaster.util.F.A.A(bufferedInputStream);
        file = file2;
        return file;
    }

    public void destroy() {
    }
}

