/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jmaster.jumploader.model.api.B;
import jmaster.jumploader.model.api.config.ImageConfig;
import jmaster.jumploader.view.impl.image.ImageControlListener;
import jmaster.jumploader.view.impl.image.RectangleRubberBand;
import jmaster.util.swing.GUIHelper;

public class ImageControl
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long B = -6171717419492647594L;
    public static final String PREFIX = "imageControl";
    protected GUIHelper N = GUIHelper.getInstance();
    protected B F;
    protected Vector M = new Vector();
    protected RectangleRubberBand P;
    protected Double I = null;
    protected Integer D = null;
    protected Integer J = null;
    protected JLabel O = new JLabel();
    protected BufferedImage C;
    protected int L;
    protected int G;
    protected double A = 1.0;
    protected Point H = null;
    protected boolean E = false;
    protected Image K;

    public ImageControl(B b2) {
        this.F = b2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.N.injectProperties(this, PREFIX);
        this.N.injectProperties(this.O, PREFIX, "emptyControlLabel");
        this.O.setHorizontalAlignment(0);
    }

    public void init() {
        this.init(true);
    }

    public void init(boolean bl) {
        this.setPreferredSize(new Dimension((int)((double)this.L * this.A), (int)((double)this.G * this.A)));
        if (bl) {
            this.P = null;
            this.B(null);
        }
        this.revalidate();
        this.repaint();
    }

    public void addImageControlListener(ImageControlListener imageControlListener) {
        this.M.add(imageControlListener);
    }

    public void removeImageControlListener(ImageControlListener imageControlListener) {
        this.M.remove(imageControlListener);
    }

    private void B(RectangleRubberBand rectangleRubberBand) {
        for (ImageControlListener imageControlListener : this.M) {
            imageControlListener.rectangleRubberBandChanged(this, rectangleRubberBand);
        }
    }

    public BufferedImage getImage() {
        return this.C;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.C = bufferedImage;
        if (bufferedImage != null) {
            this.L = bufferedImage.getWidth();
            this.G = bufferedImage.getHeight();
        } else {
            this.L = 0;
            this.G = 0;
        }
        this.init();
    }

    public void discardImage() {
        this.C = null;
        this.L = 0;
        this.G = 0;
        this.init();
    }

    public double getZoomFactor() {
        return this.A;
    }

    public void setZoomFactor(double d2) {
        this.A = d2;
        this.init(false);
    }

    public int getImageHeight() {
        return this.G;
    }

    public int getImageWidth() {
        return this.L;
    }

    public RectangleRubberBand getBand() {
        return this.P;
    }

    public void setBandCoords(int n2, int n3, int n4, int n5) {
        if (this.P == null) {
            this.P = this.A();
        } else {
            this.A(this.P);
        }
        n2 = this.A(n2);
        n4 = this.A(n4);
        n3 = this.B(n3);
        n5 = this.B(n5);
        this.P.setCoords(Math.min(n2, n4), Math.min(n3, n5), Math.max(n2, n4), Math.max(n3, n5));
        this.A(this.P);
    }

    private int A(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.L - 1) {
            n2 = this.L - 1;
        }
        return n2;
    }

    private int B(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.G - 1) {
            n2 = this.G - 1;
        }
        return n2;
    }

    public boolean isWaitMode() {
        return this.E;
    }

    public void setWaitMode(boolean bl) {
        this.E = bl;
    }

    public Image getWaitImage() {
        return this.K;
    }

    public void setWaitImage(Image image) {
        this.K = image;
    }

    public Integer getBandPerimeterMax() {
        return this.J;
    }

    public void setBandPerimeterMax(Integer n2) {
        this.J = n2;
    }

    public Integer getBandPerimeterMin() {
        return this.D;
    }

    public void setBandPerimeterMin(Integer n2) {
        this.D = n2;
    }

    public Double getBandProportions() {
        return this.I;
    }

    public void setBandProportions(Double d2) {
        this.I = d2;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.C != null) {
            graphics.drawImage(this.C, 0, 0, (int)((double)this.L * this.A), (int)((double)this.G * this.A), 0, 0, this.L, this.G, null);
            if (this.P != null) {
                this.A((Graphics2D)graphics, this.P);
            }
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.O.setBounds(this.getBounds());
            this.O.paint(graphics);
        }
    }

    protected void A(RectangleRubberBand rectangleRubberBand) {
        this.A(null, rectangleRubberBand);
    }

    protected synchronized void A(Graphics2D graphics2D, RectangleRubberBand rectangleRubberBand) {
        if (graphics2D == null) {
            graphics2D = (Graphics2D)this.getGraphics();
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.setXORMode(Color.WHITE);
        graphics2D.setStroke(RectangleRubberBand.O);
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.A - 1.0, point2.getY() + this.A - 1.0);
        double d2 = point2.getX() - point.getX();
        double d3 = point2.getY() - point.getY();
        graphics2D.drawRect((int)point.getX(), (int)point.getY(), (int)d2, (int)d3);
        graphics2D.setStroke(RectangleRubberBand.I);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n2 = (int)(RectangleRubberBand.ANCHOR_X_FACTOR[i2] * d2 + point.getX() - 3.0);
            int n3 = (int)(RectangleRubberBand.ANCHOR_Y_FACTOR[i2] * d3 + point.getY() - 3.0);
            graphics2D.drawRect(n2, n3, 6, 6);
        }
    }

    public Point screenToImage(Point point) {
        int n2;
        int n3 = (int)(point.getX() / this.A);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.L) {
            n3 = this.L - 1;
        }
        if ((n2 = (int)(point.getY() / this.A)) < 0) {
            n2 = 0;
        }
        if (n2 >= this.G) {
            n2 = this.G - 1;
        }
        return new Point(n3, n2);
    }

    public Point imageToScreen(Point point) {
        Point point2 = new Point();
        point2.setLocation(point.getX() * this.A, point.getY() * this.A);
        return point2;
    }

    public boolean isImagePoint(Point point) {
        return this.C != null && point.getX() >= 0.0 && point.getY() >= 0.0 && point.getX() < (double)this.L && point.getY() < (double)this.G;
    }

    public Rectangle getBandScreenRectangle(RectangleRubberBand rectangleRubberBand) {
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.A - 1.0, point2.getY() + this.A - 1.0);
        Rectangle rectangle = new Rectangle(point);
        rectangle.add(point2);
        return rectangle;
    }

    private boolean A(RectangleRubberBand rectangleRubberBand, Point point) {
        Rectangle rectangle = this.getBandScreenRectangle(rectangleRubberBand);
        return rectangle.contains(point);
    }

    private int B(RectangleRubberBand rectangleRubberBand, Point point) {
        int n2 = -1;
        for (int i2 = 0; i2 < 8; ++i2) {
            Rectangle rectangle = this.A(rectangleRubberBand, i2);
            if (!rectangle.contains(point)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    private Rectangle A(RectangleRubberBand rectangleRubberBand, int n2) {
        Point point = this.imageToScreen(rectangleRubberBand.getLeftTop());
        Point point2 = this.imageToScreen(rectangleRubberBand.getRightBottom());
        point2.setLocation(point2.getX() + this.A - 1.0, point2.getY() + this.A - 1.0);
        double d2 = point2.getX() - point.getX();
        double d3 = point2.getY() - point.getY();
        int n3 = (int)(RectangleRubberBand.ANCHOR_X_FACTOR[n2] * d2 + point.getX() - 3.0);
        int n4 = (int)(RectangleRubberBand.ANCHOR_Y_FACTOR[n2] * d3 + point.getY() - 3.0);
        return new Rectangle(n3, n4, 6, 6);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point;
        if (this.P != null) {
            int n2 = this.B(this.P, mouseEvent.getPoint());
            if (n2 != -1) {
                this.P.setHotAnchorId(n2);
                this.P.setStatus(1);
            } else if (this.A(this.P, mouseEvent.getPoint())) {
                this.P.setStatus(2);
                this.setCursor(RectangleRubberBand.D);
                point = this.imageToScreen(this.P.getLeftTop());
                this.H = new Point((int)((double)mouseEvent.getX() - point.getX()), (int)((double)mouseEvent.getY() - point.getY()));
            }
        }
        if (this.P == null || this.P.getStatus() == 0) {
            Point point2;
            if (this.P != null) {
                this.A(this.P);
            }
            if (this.isImagePoint(point = this.screenToImage(point2 = mouseEvent.getPoint()))) {
                this.P = this.A();
                this.P.setPoint0(point);
                this.P.setPoint1(this.P.getPoint0());
                this.P.setStatus(1);
                this.P.setHotAnchorId(4);
                this.A(this.P);
            }
        }
    }

    private RectangleRubberBand A() {
        RectangleRubberBand rectangleRubberBand = new RectangleRubberBand();
        ImageConfig imageConfig = this.F.J();
        if (imageConfig.getCropPerimeterMin() != null) {
            rectangleRubberBand.setPerimeterMin(new Integer(imageConfig.getCropPerimeterMin()));
        }
        if (imageConfig.getCropRatio() != null) {
            rectangleRubberBand.setProportions(new Double(imageConfig.getCropRatio()));
        }
        return rectangleRubberBand;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.P != null) {
            this.P.setStatus(0);
            if (this.P.getWidth() == 0 && this.P.getHeight() == 0) {
                this.A(this.P);
                this.P = null;
            }
            this.B(this.P);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.P != null && this.P.getStatus() != 0) {
            int n2;
            int n3;
            int n4 = this.P.getX0();
            int n5 = this.P.getY0();
            int n6 = this.P.getX1();
            int n7 = this.P.getY1();
            block0 : switch (this.P.getStatus()) {
                case 2: {
                    Point point = new Point((int)((double)mouseEvent.getX() - this.H.getX()), (int)((double)mouseEvent.getY() - this.H.getY()));
                    Point point2 = this.screenToImage(point);
                    n3 = (int)(point2.getY() + (double)this.P.getHeight() - 1.0);
                    for (n2 = (int)(point2.getX() + (double)this.P.getWidth() - 1.0); n2 >= this.L; --n2) {
                    }
                    while (n3 >= this.G) {
                        --n3;
                    }
                    point2.setLocation(n2 - this.P.getWidth() + 1, n3 - this.P.getHeight() + 1);
                    this.P.setPoint0(point2);
                    this.P.setPoint1(new Point(n2, n3));
                    break;
                }
                case 1: {
                    Point point = this.screenToImage(mouseEvent.getPoint());
                    switch (this.P.getHotAnchorId()) {
                        case 0: 
                        case 2: 
                        case 4: 
                        case 6: {
                            this.P.setPoint1(point);
                            break block0;
                        }
                        case 3: 
                        case 7: {
                            this.P.setX1((int)point.getX());
                            break block0;
                        }
                        case 1: 
                        case 5: {
                            this.P.setY1((int)point.getY());
                        }
                    }
                }
            }
            if (n4 != this.P.getX0() || n5 != this.P.getY0() || n6 != this.P.getX1() || n7 != this.P.getY1()) {
                int n8 = this.P.getX0();
                int n9 = this.P.getY0();
                n2 = this.P.getX1();
                n3 = this.P.getY1();
                this.P.setCoords(n4, n5, n6, n7);
                this.A(this.P);
                this.P.setCoords(n8, n9, n2, n3);
                this.A(this.P);
            }
            this.B(this.P);
        }
        Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
        this.scrollRectToVisible(rectangle);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.P != null) {
            int n2 = this.B(this.P, mouseEvent.getPoint());
            if (n2 != -1) {
                this.setCursor(RectangleRubberBand.F[n2]);
            } else if (this.A(this.P, mouseEvent.getPoint())) {
                this.setCursor(RectangleRubberBand.G);
            } else {
                this.setCursor(RectangleRubberBand.H);
            }
        }
    }
}

