/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.upload.list;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import jmaster.jumploader.model.api.A.C;
import jmaster.jumploader.model.api.config.UploaderConfig;
import jmaster.jumploader.model.api.config.ViewConfig;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.view.api.main.IMainView;
import jmaster.jumploader.view.impl.upload.list.IUploadFileListListener;
import jmaster.jumploader.view.impl.upload.list.UploadFileListCellRenderer;
import jmaster.jumploader.view.impl.upload.list.UploadFileListModel;
import jmaster.jumploader.view.impl.upload.list.dnd.FileDropListener;
import jmaster.jumploader.view.impl.upload.list.dnd.IFileDropTarget;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileListTransferHandler;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileTransferable;
import jmaster.util.B.B;
import jmaster.util.C.A;
import jmaster.util.swing.easylist.EasyList;

public class UploadFileList
extends EasyList
implements jmaster.jumploader.model.api.upload.B,
Runnable,
IFileDropTarget,
KeyListener {
    private static final long s = 9017089770972464908L;
    private static final String v = "uploadFileList";
    private static final String \u00a5 = "uploadFileListUpdater";
    private static final long u = 500L;
    private IUploader z;
    protected A \u00a3 = new A(IUploadFileListListener.class);
    private UploadFileListModel w;
    private long t = 500L;
    private DropTarget r;
    private int \u00ba = -1;
    private Icon \u00aa;
    private ViewConfig \u00a2;
    private IMainView \u00a4;
    private UploaderConfig \u00b5;

    public UploadFileList(jmaster.jumploader.model.api.B b2, IMainView iMainView) {
        this.\u00a4 = iMainView;
        this.\u00a2 = b2.H();
        this.\u00b5 = b2.B();
        this.setModel(new UploadFileListModel(b2));
        this.z = b2.D();
        this.w = (UploadFileListModel)super.getModel();
        this.p = new UploadFileListCellRenderer(b2, iMainView);
        this.setCellRenderer((ListCellRenderer)this.p);
        this.setLayoutOrientation(2);
        String string = v + (this.\u00a2.getUploadListViewName() == null ? "" : this.\u00a2.getUploadListViewName());
        this.o.injectProperties(this, string);
        this.o.injectProperties(this.l, string, "emptyListLabel");
        this.addKeyListener(this);
        this.z.addListener(this);
        this.addKeyListener(this);
        this.setTransferHandler(new UploadFileListTransferHandler());
        this.setDragEnabled(b2.B().isUploadQueueReorderingAllowed());
        this.r = new DropTarget();
        this.setDropTarget(this.r);
        this.r.setComponent(this);
        this.r.setActive(this.z.isFileAdditionEnabled());
        try {
            this.r.addDropTargetListener(new FileDropListener(this));
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
        }
        B b3 = new B();
        b3.A(this);
        b3.A(\u00a5);
        b3.A(true);
        b3.B(true);
        b2.C().A(b3);
        this.updateView();
    }

    public long getUpdateInterval() {
        return this.t;
    }

    public void setUpdateInterval(long l2) {
        this.t = l2;
    }

    public Icon getInsertIcon() {
        return this.\u00aa;
    }

    public void setInsertIcon(Icon icon) {
        this.\u00aa = icon;
    }

    public void addListener(IUploadFileListListener iUploadFileListListener) {
        this.\u00a3.C(iUploadFileListListener);
    }

    public void removeListener(IUploadFileListListener iUploadFileListListener) {
        this.\u00a3.A(iUploadFileListListener);
    }

    private void A(IUploadFile[] iUploadFileArray) {
        for (int i2 = 0; i2 < this.\u00a3.C(); ++i2) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u00a3.A(i2);
            iUploadFileListListener.uflRemoveFilesAction(this, iUploadFileArray);
        }
    }

    private void A(String[] stringArray) {
        for (int i2 = 0; i2 < this.\u00a3.C(); ++i2) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u00a3.A(i2);
            iUploadFileListListener.uflAddFilesAction(this, stringArray);
        }
    }

    public void uploaderFileAdditionEnabledChanged(IUploader iUploader) {
        this.r.setActive(iUploader.isFileAdditionEnabled());
    }

    public void uploaderFileRemovalEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAdded(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileRemoved(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileMoved(IUploader iUploader, IUploadFile iUploadFile, int n2) {
        this.updateView();
    }

    public void uploaderFileStatusChanged(IUploader iUploader, IUploadFile iUploadFile) {
        if (this.\u00a2.isUploadViewAutoscrollToUploadingFile() && iUploadFile.isUploading()) {
            this.scrollToFile(iUploadFile);
        }
    }

    public void uploaderFilesReset(IUploader iUploader) {
        this.updateView();
    }

    public void uploaderStatusChanged(IUploader iUploader) {
    }

    public void uploaderUploadEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAddFailed(IUploader iUploader, C c2) {
    }

    public void uploaderFileUpdated(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void run() {
        while (!this.z.isDestroyed() && !Thread.currentThread().isInterrupted()) {
            this.updateUploadingCells();
            try {
                Thread.sleep(this.t);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            IUploadFile[] iUploadFileArray;
            if (keyEvent.getKeyCode() == 127 && (iUploadFileArray = this.getSelectedFiles()) != null) {
                this.A(iUploadFileArray);
                keyEvent.consume();
            }
            if (keyEvent.getKeyCode() == 65487 || keyEvent.getKeyCode() == 86) {
                this.pasteFromClipoboard();
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.\u00ba != -1) {
            this.\u00ba = -1;
            this.repaint();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(UploadFileTransferable.getDataFlavor())) {
            Rectangle rectangle;
            int n2 = 0;
            Point point = dropTargetDragEvent.getLocation();
            int n3 = this.getCellAtLocation(point);
            if (n3 == -1) {
                rectangle = this.getVisibleRect();
                while (n3 == -1 && rectangle.contains(point)) {
                    n3 = this.getCellAtLocation(point);
                    --point.x;
                }
            }
            n2 = n3 != -1 ? ((rectangle = this.getCellBounds(n3, n3)).getCenterX() > (double)point.x ? n3 : n3 + 1) : this.getModel().getSize();
            if (n2 != this.\u00ba) {
                this.\u00ba = n2;
                this.m.D("cell=" + n3 + ", insertIndex=" + this.\u00ba);
                this.repaint();
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.\u00ba != -1) {
            this.\u00ba = -1;
            this.repaint();
        }
    }

    public void filesDropped(File[] fileArray) {
        if (this.\u00ba != -1) {
            this.\u00ba = -1;
            this.repaint();
        }
        String[] stringArray = new String[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            stringArray[i2] = fileArray[i2].getAbsolutePath();
        }
        this.A(stringArray);
    }

    public void moveFiles(IUploadFile[] iUploadFileArray) {
        try {
            jmaster.util.C.B.B(this.z, "moveFiles", new Class[]{IUploadFile[].class, Integer.TYPE}, new Object[]{iUploadFileArray, new Integer(this.\u00ba)});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.\u00ba != -1) {
            this.\u00ba = -1;
            this.repaint();
        }
    }

    public void updateUploadingCells() {
        if (!jmaster.util.C.B.A()) {
            jmaster.util.C.B.C(this, "updateUploadingCells");
            return;
        }
        for (int i2 = 0; i2 < this.w.getSize(); ++i2) {
            IUploadFile iUploadFile = this.w.getUploadFile(i2);
            if (!iUploadFile.isDownloading() && !iUploadFile.isUploading() && !iUploadFile.isPreprocessing() && !iUploadFile.isServerProcessing()) continue;
            this.repaintCell(i2);
        }
    }

    public IUploadFile[] getSelectedFiles() {
        IUploadFile[] iUploadFileArray = null;
        int[] nArray = this.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            iUploadFileArray = new IUploadFile[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                iUploadFileArray[i2] = this.w.getUploadFile(nArray[i2]);
            }
        }
        return iUploadFileArray;
    }

    public void updateView() {
        if (!jmaster.util.C.B.A()) {
            jmaster.util.C.B.A(this);
            return;
        }
        this.setBackgroundVisible(this.getModel().getSize() == 0);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.\u00ba != -1 && this.\u00aa != null) {
            Rectangle rectangle = null;
            int n2 = 0;
            int n3 = 0;
            if (this.\u00ba < this.w.getSize()) {
                rectangle = this.getCellBounds(this.\u00ba, this.\u00ba);
                n2 = rectangle.x - this.\u00aa.getIconWidth() / 2;
                n3 = rectangle.y + rectangle.height / 2 - this.\u00aa.getIconHeight() / 2;
            } else {
                rectangle = this.getCellBounds(this.w.getSize() - 1, this.w.getSize() - 1);
                n2 = rectangle.x + rectangle.width - this.\u00aa.getIconWidth() / 2;
                n3 = rectangle.y + rectangle.height / 2 - this.\u00aa.getIconHeight() / 2;
            }
            this.m.D("i=" + this.\u00ba + ", x=" + n2 + ", y=" + n3 + ", b=" + rectangle);
            this.\u00aa.paintIcon(this, graphics, n2, n3);
            int n4 = -1;
            int n5 = -1;
            if (this.\u00ba > 0 && this.\u00ba < this.w.getSize()) {
                rectangle = this.getCellBounds(this.\u00ba - 1, this.\u00ba - 1);
                n4 = rectangle.x + rectangle.width - this.\u00aa.getIconWidth() / 2;
                n5 = rectangle.y + rectangle.height / 2 - this.\u00aa.getIconHeight() / 2;
            }
            if (n4 != -1 && n5 != -1 && n2 != n4 && n3 != n5) {
                this.\u00aa.paintIcon(this, graphics, n4, n5);
            }
        }
    }

    public void pasteFromClipoboard() {
        if ("image".equals(this.\u00b5.getPreferredPasteDataFlavor())) {
            if (!this.C()) {
                this.B();
            }
        } else if (!this.B()) {
            this.C();
        }
    }

    private boolean B() {
        boolean bl = false;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor)) {
            try {
                Object object = clipboard.getData(DataFlavor.javaFileListFlavor);
                List list = (List)object;
                File[] fileArray = new File[list.size()];
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    fileArray[i2] = (File)list.get(i2);
                }
                this.filesDropped(fileArray);
                bl = true;
            }
            catch (Exception exception) {
                this.m.E("Failed to get clipboard data", exception);
            }
        }
        return bl;
    }

    private boolean C() {
        boolean bl = false;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (this.\u00b5.isClipboardImageEnabled() && clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
            try {
                Object object = clipboard.getContents(null).getTransferData(DataFlavor.imageFlavor);
                if (object instanceof Image) {
                    Image image = (Image)object;
                    this.z.addImage(image);
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.m.E("Failed to get clipboard data", exception);
            }
        }
        return bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (this.\u00a2.isUploadViewListShowAddDialogOnDblClick() && mouseEvent.getClickCount() == 2 && this.getCellAtLocation(mouseEvent.getPoint()) == -1) {
            this.\u00a4.getUploadView().showOpenDialog();
        }
    }

    public void scrollToFile(IUploadFile iUploadFile) {
        if (!jmaster.util.C.B.A()) {
            jmaster.util.C.B.C(this, "scrollToFile", new Class[]{IUploadFile.class}, new Object[]{iUploadFile});
            return;
        }
        int n2 = this.w.indexOfItem(iUploadFile);
        if (n2 != -1) {
            Rectangle rectangle = this.getCellBounds(n2, n2);
            this.scrollRectToVisible(rectangle);
        }
    }
}

