<?php
/**
 * 缓存类（FileCache，使用方法类似Memcache）
 * 直接通过静态方法调用
 * @author wj45 <j@wj45.net>
 */
class cache {
	
	//禁止实例化
	private function __construct() {}
	/**
	 * 保存
	 * @parame string $key 缓存名称
	 * @parame unkown $var 要缓存的数据
	 */
	public static function set( $key, $var) {
		$dir = DJ_ROOT . 'cache';
		if ( !is_dir($dir) ) {
			@mkdir($dir, 0777);
		}
		$file = $dir . '/' . md5($key) . '.html';
		$ft = @fopen($file, 'w');
		if (!$ft) {
			die('无法写入缓存文件');
		}
		$expire = cacheTime*60;
		if ( !empty($expire) ) {
			$expire += time();
		}
		$cache = array('var'=>$var, 'expire'=>$expire);
		$str = serialize($cache);  //序列化后写入文件
		if ($ft) {
			fwrite($ft, $str);
			fclose($ft);
			return true;
		} else {
			return false;
		}
	}
	/**
	 * 读取
	 */
	public static function get( $key ) {
		$dir = DJ_ROOT . 'cache';
		$file = $dir . '/' . md5($key) . '.html';
		if ( file_exists($file) ) {
			$content = file_get_contents($file);
			$content = unserialize($content);
			if ($content['expire'] > 0 && $content['expire'] < time()) {
				@unlink($file);  //删除超时的缓存
				$content['var'] = false;
			}
			return $content['var'];
		} else {
			return false;
		}
	}
	/**
	 * 删除
	 */
	public static function delete( $key ) {
		$dir = DJ_ROOT . 'cache';
		$file = $dir . '/' . md5($key) . '.html';
		if ( file_exists($file) ) {
			$rs = @unlink($file);
			return $rs;
		} else {
			return false;
		}
	}
	/**
	 * 清除所有缓存
	 */
	public static function flush() {
		$dir = DJ_ROOT . 'cache';
		if (!$hd = @opendir($dir)) {
			return false;
		}
		while ( $obj = readdir($hd) ) {
			if ($obj == '.' || $obj == '..' || $obj == '.htaccess') {
				continue;
			}
			$file =  $dir . '/' . $obj;
			if ( is_dir($file) ) {
				self::flush($file);
			}			
			if ( is_file($file) ) {
				@unlink($file);
			}
		}
	}
}
?>