<?php
error_reporting(E_ERROR);
if(phpversion() < '5.3.0') {
	set_magic_quotes_runtime(0);
}

define('DJ_ROOT', substr(dirname(__FILE__), 0, -3));
define('MAGIC_QUOTES_GPC', function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc());
define('IN_DJCMS', TRUE);
define('TIMESTAMP', time());
timezone_set();
@include DJ_ROOT.'./inc/config.php';
if(!defined('DJ_FUNCTION') && !@include(DJ_ROOT.'./inc/CommonFun.php')) {
	exit('CommonFun.php is missing');
}

if(function_exists('ini_get')) {
	$memorylimit = @ini_get('memory_limit');
	if($memorylimit && return_bytes($memorylimit) < 33554432 && function_exists('ini_set')) {
		ini_set('memory_limit', '128m');
	}
}

$superglobal = array('GLOBALS' => 1,'_GET' => 1,'_POST' => 1, '_REQUEST' => 1,'_COOKIE' => 1,'_SERVER' => 1,'_ENV' => 1, '_FILES' => 1);
foreach ($GLOBALS as $key => $value) {
	if (!isset($superglobal[$key])) {
		$GLOBALS[$key] = null; unset($GLOBALS[$key]);
	}
}
define('QUERY_STRING', safe_replace($_SERVER['QUERY_STRING']));
define("DJCMS_TEMPLATE", DJ_ROOT."template/".defaultTemplate."/".templateFileFolder."/");

header('Content-type: text/html; charset=gb2312');

if(!MAGIC_QUOTES_GPC) {
	$_GET = new_addslashes($_GET);
	$_POST = new_addslashes($_POST);
	$_COOKIE = new_addslashes($_COOKIE);
	//$_FILES = new_addslashes($_FILES);
}

//ݿ
require 'mysql.php';
$db = & DB::object();
$db->connect(databaseServer, databaseUser, databasePwd, 'gbk', databaseName, 0);
//ǩ
require 'MainClass.php';
//԰
require 'lang.php';
//԰
require 'pinyin.php';
//IP
require 'ip.php';

function timezone_set($timeoffset = 8) {
	if(function_exists('date_default_timezone_set')) {
		@date_default_timezone_set('Etc/GMT'.($timeoffset > 0 ? '-' : '+').(abs($timeoffset)));
	}
}

class discuz_memory
{
	var $config;
	var $extension = array();
	var $memory;
	var $prefix;
	var $type;
	var $keys;
	var $enable = false;

	function discuz_memory() {
		$this->extension['eaccelerator'] = function_exists('eaccelerator_get');
		$this->extension['xcache'] = function_exists('xcache_get');
		$this->extension['memcache'] = extension_loaded('memcache');
	}

	function init($config) {

		$this->config = $config;
		$this->prefix = empty($config['prefix']) ? substr(md5($_SERVER['HTTP_HOST']), 0, 6).'_' : $config['prefix'];
		$this->keys = array();

		if($this->extension['memcache'] && !empty($config['memcache']['server'])) {
			require_once libfile('class/memcache');
			$this->memory = new discuz_memcache();
			$this->memory->init($this->config['memcache']);
			if(!$this->memory->enable) {
				$this->memory = null;
			}
		}

		if(!is_object($this->memory) && $this->extension['eaccelerator'] && $this->config['eaccelerator']) {
			require_once libfile('class/eaccelerator');
			$this->memory = new discuz_eaccelerator();
			$this->memory->init(null);
		}

		if(!is_object($this->memory) && $this->extension['xcache'] && $this->config['xcache']) {
			require_once libfile('class/xcache');
			$this->memory = new discuz_xcache();
			$this->memory->init(null);
		}

		if(is_object($this->memory)) {
			$this->enable = true;
			$this->type = str_replace('discuz_', '', get_class($this->memory));
			$this->keys = $this->get('memory_system_keys');
			$this->keys = !is_array($this->keys) ? array() : $this->keys;
		}

	}

	function get($key) {
		$ret = null;
		if($this->enable) {
			$ret = $this->memory->get($this->_key($key));
			if(!is_array($ret)) {
				$ret = null;
				if(array_key_exists($key, $this->keys)) {
					unset($this->keys[$key]);
					$this->memory->set($this->_key('memory_system_keys'), array($this->keys));
				}
			} else {
				return $ret[0];
			}
		}
		return $ret;
	}

	function set($key, $value, $ttl = 0) {

		$ret = null;
		if($this->enable) {
			$ret = $this->memory->set($this->_key($key), array($value), $ttl);
			if($ret) {
				$this->keys[$key] = true;
				$this->memory->set($this->_key('memory_system_keys'), array($this->keys));
			}
		}
		return $ret;
	}

	function rm($key) {
		$ret = null;
		if($this->enable) {
			$ret = $this->memory->rm($this->_key($key));
			unset($this->keys[$key]);
			$this->memory->set($this->_key('memory_system_keys'), array($this->keys));
		}
		return $ret;
	}

	function clear() {
		if($this->enable && is_array($this->keys)) {
			$this->keys['memory_system_keys'] = true;
			foreach ($this->keys as $k => $v) {
				$this->memory->rm($this->_key($k));
			}
		}
		$this->keys = array();
		return true;
	}

	function _key($str) {
		return ($this->prefix).$str;
	}

}
?>