<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( 'init.php' );
}

include( 'sessioninc.php' );

include_once(LIB_DIR . 'blog_class.php');

$blog =& new Blog();

// If the preferences are missing, go to the settings page
//
if ( ! $blog->settingsExist($_SESSION['UserId']) ) {

      header( 'location: blogsettings.php?error_name=nosetup' );
      exit;
}


$blog->loadSettings($_SESSION['UserId']);

// Load template if load template button pushed
//
if ( $_POST['action'] == 'add_blog' && $_POST['load_template'] ) {

     $blog->loadTemplate();
}
// Add Blog if save button pressed
//
elseif ( $_POST['action'] == 'add_blog' ) {

      $blog->addBlog($_SESSION['UserId']);

      if ( $blog->getErrorMessage() ) {

          $t->assign ( 'error_message', $blog->getErrorMessage() );
      }
      else {

          header( 'location: bloglist.php' );
          exit;
      }
}


// If user turned off the gui editor, display the normal text box
//
$t->assign('gui_editor', $blog->settings['gui_editor']);

// Set the values to show on the page
//
$data = $blog->getData();

$t->assign( 'data', $data);

$t->assign( 'loadtemp',  $loadtemp);

$t->assign( 'date_posted', $data['date_posted'] ) ;

unset($data);

// If we already have the max stories, display an error
//
if ( $blog->getStoryCount($_SESSION['UserId']) >= $config['max_blog_stories'] ) {

    $t->assign ( 'error_message', get_lang('blog_errors', 'max_stories_warning') );

    $t->assign('rendered_page', $t->fetch('addbloglimit.tpl') );
}
else {

    $t->assign('rendered_page', $t->fetch('addblog.tpl') );

}


// Put the javascript and ccs into the head of the document
//
$js = '<script type="text/javascript" src="' . DOC_ROOT . 'javascript/calendar/epoch_classes.js"></script>';
$js .= $nogui_spellchecker_js;

$css = '<link rel="stylesheet" type="text/css" href="' . DOC_ROOT . 'javascript/calendar/epoch_styles.css" />';
$t->assign('lang',$lang);
$t->assign('addtional_javascript', $js);
$t->assign('addtional_css', $css);

// Make the page
//
unset($lang);
$t->display( 'index.tpl' );

exit;

?>
