<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}

include( 'sessioninc.php' );

include_once(LIB_DIR . 'blog_class.php');

$blog =& new Blog(true);

// If the preferences are missing, go to the settings page
//
if ( ! $blog->settingsExist($_SESSION['AdminId']) ) {

      header( 'location: blogsettings.php?error_name=nosetup' );
      exit;
}

// Edit the preferences if save button pressed
//
if ( $_POST['action'] == 'edit_blog' ) {

      $blog->editBlog($_POST['id']);

      if ( $blog->getErrorMessage() ) {

          $t->assign ( 'error_message', $blog->getErrorMessage() );
      }
      else {

          header( 'location: bloglist.php' );
          exit;
      }
} else {
// Get the blog info if just clicked a edit link

    $blog->loadBlog($_REQUEST['id']);
    $blog->prepData();
}

// If user turned off the gui editor, display the normal text box
//
$blog->loadSettings($_SESSION['AdminId']);

$t->assign('gui_editor', $blog->settings['gui_editor']);

// Set the values to show on the page
//
$data = $blog->getData();

$t->assign( 'data', $data);

$t->assign( 'blog_id', $data['id'] ) ;

$t->assign( 'date_posted', date('Y-m-d',$data['date_posted']) ) ;
unset($data);

// Put the javascript and ccs into the head of the document
//
$js = '<script type="text/javascript" src="' . DOC_ROOT . 'javascript/calendar/epoch_classes.js"></script>';

$css = '<link rel="stylesheet" type="text/css" href="' . DOC_ROOT . 'javascript/calendar/epoch_styles.css" />';

$t->assign('addtional_javascript', $js);
$t->assign('addtional_css', $css);

// Make the page
//
$t->assign('rendered_page', $t->fetch('admin/editblog.tpl') );

$t->display( 'admin/index.tpl' );

exit;

?>
