<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}

import_request_variables('pg');

/* Loads county codes */

if ( $cntry != '' ) {
	if ($filename != '' && $_REQUEST['loadcities'] != '') {
		$msg = '';
		@set_time_limit(1200);
		/* Contents of the file should be CITYCODE, CITYNAME, COUNTYCODE, STATECODE  */

		$file = "../cities/".$filename;
		if (file_exists($file)) {
			if ($loadaction == 'DB') {
				$osDB->query('delete from ! where countrycode = ?', array(CITIES_TABLE, $cntry) );
			} elseif ($loadaction == 'SQL') {
				$sqlfile = TEMP_DIR.str_replace('.csv','.sql',$filename);
				$outfile = fopen($sqlfile,'wb');
			}
			$handle=fopen($file,'r');
			while (!feof($handle) ) {
				$data = explode(",",str_replace('\n\r','',fgets($handle)));
				if (trim($data[0]) != '' && trim($data[1]) != '' ) {
					if ($loadaction == 'DB') {
						$osDB->query('insert into ! (countrycode, code, name, countycode, statecode) values (?,?,?,?,?)', array(CITIES_TABLE, $cntry, trim($data[0]), trim($data[1]), trim($data[2]), trim($data[3])) );
					} elseif ($loadaction == 'SQL') {
						$writeme = "insert into ".CITIES_TABLE."(countrycode, code, name, countycode, statecode) values ('".$cntry."','".trim($data[0])."','".addslashes(trim($data[1]))."','".addslashes(trim($data[2]))."','".addslashes(trim($data[3]))."');\n";
						fwrite($outfile,$writeme);
					}
				}
			}
			fclose($handle);
			if ($loadaction == 'SQL'){
				fclose($outfile);
				$msg .= $lang['countries'][$cntry].' '.get_lang('cities_sql_created').': '.$sqlfile."<br />";
			} else {
				$msg.=$lang['countries'][$cntry].' '.get_lang('cities_loaded').$filename.'<br />';
			}
			/* Analyze the table to adjust index values */
			$osDB->query('optimize table '.CITIES_TABLE);
		} else {
			$msg= get_lang('file_not_found');
		}
	} elseif ($_REQUEST['delcities'] != '') {
		/* Delete Counties for the country */

		$osDB->query('delete from ! where countrycode = ?', array(CITIES_TABLE, $cntry) );

		/* We should remove the state definition from counties, cities and zips tables also for this country */

		$osDB->query('update ! set citycode=? where countrycode=?', array(ZIPCODES_TABLE, '',$cntry));

		$msg = str_replace('#COUNTRY#', $lang['countries'][$cntry], get_lang('delcities_succ'));

		/* Analyze the table to adjust index values */
		$osDB->query('optimize table '.CITIES_TABLE);
		$osDB->query('optimize table '.ZIPCODES_TABLE);
	}
}

$t->assign('filename',$filename);

$t->assign('loadaction', $loadaction);

$t->assign('sqlfile', $sqlfile);

$t->assign('cntry', $cntry);

$t->assign('msg',$msg);

$t->assign('lang',$lang);

/* Get list of zip code files from the directory */
$files = array();
$dir = opendir("../cities");
while($file = readdir($dir)) {
	if ($file != '.' && $file != '..' && stristr( $file, '.csv' ) )
		$files[] = $file;
}

$t->assign('files', $files);

unset($dir, $files);

$t->assign('rendered_page', $t->fetch('admin/load_cities.tpl'));

$t->display('admin/index.tpl');


?>