<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}

import_request_variables('pg');

/* Loads county codes */

if ( $cntry != '' ) {
	if ($filename != '' && $_REQUEST['loadcounties'] != '') {
		$msg = '';
		@set_time_limit(1200);
		/* Contents of the file should be COUNTYCODE, COUNTYNAME, STATECODE  */

		$file = "../counties/".$filename;
		if (file_exists($file)) {
			if ($loadaction == 'DB') {
				$osDB->query('delete from ! where countrycode = ?', array(COUNTIES_TABLE, $cntry) );
			} elseif ($loadaction == 'SQL') {
				$sqlfile = TEMP_DIR.str_replace('.csv','.sql',$filename);
				$outfile = fopen($sqlfile,'wb');
			}
			$handle=fopen($file,'r');
			while (!feof($handle) ) {
				$data = explode(",",str_replace('\n\r','',fgets($handle)));
				if (trim($data[0]) != '' && trim($data[1]) != '' ) {
					if ($loadaction == 'DB') {
						$osDB->query('insert into ! (countrycode, code, name, statecode) values (?,?,?,?)', array(COUNTIES_TABLE, $cntry, trim($data[0]), trim($data[1]), trim($data[2])) );
					} elseif ($loadaction == 'SQL') {
						$writeme = "insert into ".COUNTIES_TABLE."(countrycode, code, name, statecode) values ('".$cntry."','".addslashes(trim($data[0]))."','".addslashes(trim($data[1]))."','".addslashes(trim($data[2]))."');\n";
						fwrite($outfile,$writeme);
					}
				}
			}
			fclose($handle);
			if ($loadaction == 'SQL'){
				fclose($outfile);
				$msg .= $lang['countries'][$cntry].' '.get_lang('counties_sql_created').': '.$sqlfile."<br />";
			} else {
				$msg.=$lang['countries'][$cntry].' '.get_lang('counties_loaded').$filename.'<br />';
			}
			/* Analyze the table to adjust index values */
			$osDB->query('optimize table '.COUNTIES_TABLE);
		} else {
			$msg= get_lang('file_not_found');
		}
	} elseif ($_REQUEST['delcounties'] != '') {
		/* Delete Counties for the country */

		$osDB->query('delete from ! where countrycode = ?', array(COUNTIES_TABLE, $cntry) );

		/* We should remove the state definition from counties, cities and zips tables also for this country */

		$osDB->query('update ! set countycode=? where countrycode=?', array(CITIES_TABLE, '',$cntry));
		$osDB->query('update ! set countycode=? where countrycode=?', array(ZIPCODES_TABLE, '',$cntry));

		$msg = str_replace('#COUNTRY#', $lang['countries'][$cntry], get_lang('delcounties_succ'));

		/* Analyze the table to adjust index values */
		$osDB->query('optimize table '.COUNTIES_TABLE);
		$osDB->query('optimize table '.CITIES_TABLE);
		$osDB->query('optimize table '.ZIPCODES_TABLE);
	}
}

$t->assign('filename',$filename);

$t->assign('loadaction', $loadaction);

$t->assign('sqlfile', $sqlfile);

$t->assign('cntry', $cntry);

$t->assign('msg',$msg);

$t->assign('lang',$lang);


/* Get list of zip code files from the directory */
$files = array();
$dir = opendir("../counties");
while($file = readdir($dir)) {
	if ($file != '.' && $file != '..' && stristr( $file, '.csv' ) )
		$files[] = $file;
}

$t->assign('files', $files);

unset($dir, $files);

$t->assign('rendered_page', $t->fetch('admin/load_counties.tpl'));

$t->display('admin/index.tpl');


?>