<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}

import_request_variables('pg');

/* Loads state codes */

if ( $cntry != '' ) {
	if ($filename != '' && $_REQUEST['loadstates'] != '') {
		$msg = '';
		@set_time_limit(1200);
		/* Contents of the file should be STATECODE, STATENAME  */

		$file = "../states/".$filename;
		if (file_exists($file)) {
			if ($loadaction == 'DB') {
				$osDB->query('delete from ! where countrycode = ?', array(STATES_TABLE, $cntry) );
			} elseif ($loadaction == 'SQL') {
				$sqlfile = TEMP_DIR.str_replace('.csv','.sql',$filename);
				$outfile = fopen($sqlfile,'wb');
			}
			$handle=fopen($file,'r');
			while (!feof($handle) ) {
				$data = explode(",",str_replace('\n\r','',fgets($handle)));
				if (trim($data[0]) != '' && trim($data[1]) != '' ) {
					if ($loadaction == 'DB') {
						$osDB->query('insert into ! (countrycode, code, name) values (?,?,?)', array(STATES_TABLE, $cntry, trim($data[0]), trim($data[1])) );
					} elseif ($loadaction == 'SQL') {
						$writeme = "insert into ".STATES_TABLE."(countrycode, code, name) values ('".$cntry."','".trim($data[0])."','".trim($data[1])."');\n";
						fwrite($outfile,$writeme);
					}
				}
			}
			fclose($handle);
			if ($loadaction == 'SQL'){
				fclose($outfile);
				$msg .= $lang['countries'][$cntry].' '.get_lang('states_sql_created').': '.$sqlfile."<br />";
			} else {
				$msg.=$lang['countries'][$cntry].' '.get_lang('states_loaded').$filename.'<br />';
			}
			/* Analyze the table to adjust index values */
			$osDB->query('optimize table '.STATES_TABLE);
		} else {
			$msg= get_lang('file_not_found');
		}
	} elseif ($_REQUEST['delstates'] != '') {
		/* Delete states for the country */

		$osDB->query('delete from ! where countrycode = ?', array(STATES_TABLE, $cntry) );

		/* We should remove the state definition from counties, cities and zips tables also for this country */

		$osDB->query('update ! set statecode=? where countrycode=?', array(COUNTIES_TABLE, '',$cntry));
		$osDB->query('update ! set statecode=? where countrycode=?', array(CITIES_TABLE, '',$cntry));
		$osDB->query('update ! set statecode=? where countrycode=?', array(ZIPCODES_TABLE, '',$cntry));

		$msg = str_replace('#COUNTRY#', $lang['countries'][$cntry], get_lang('delstates_succ'));

		/* Analyze the table to adjust index values */
		$osDB->query('optimize table '.STATES_TABLE);
		$osDB->query('optimize table '.COUNTIES_TABLE);
		$osDB->query('optimize table '.CITIES_TABLE);
		$osDB->query('optimize table '.ZIPCODES_TABLE);
	}
}

$t->assign('filename',$filename);

$t->assign('loadaction', $loadaction);

$t->assign('sqlfile', $sqlfile);

$t->assign('cntry', $cntry);

$t->assign('msg',$msg);

$t->assign('lang',$lang);


/* Get list of zip code files from the directory */
$files = array();
$dir = opendir("../states");
while($file = readdir($dir)) {
	if ($file != '.' && $file != '..' && stristr( $file, '.csv' ) )
		$files[] = $file;
}

$t->assign('files', $files);
unset($files, $dir);
$t->assign('rendered_page', $t->fetch('admin/load_states.tpl'));

$t->display('admin/index.tpl');


?>