<?php
	//Include init.php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}

include ( 'sessioninc.php' );

define( 'PAGE_ID', 'profile_ratings' );
if ( !checkAdminPermission( PAGE_ID ) ) {
	header( 'location: not_authorize.php' );
	exit;
}

//Default Sorting
if( $_GET['sort'] == '' ) {
	$sort = 'displayorder asc ';
} else if( $_GET['sort'] == get_lang('col_head_name') ) {
		$sort = 'rating '. checkSortType ( $_GET['type'] );
} else {
	$sort = findSortBy();
}

//For Editing ratings
if ( $_GET['edit'] ) {
	$data =& $osDB->getRow( 'SELECT id, rating, description, enabled from ! Where id = ?', array( RATINGS_TABLE, $_GET['edit'] ));
	$t->assign( 'lang', $lang );
	$t->assign( 'error', get_lang('admin_error_msgs', $_GET['errid'] ) );
	$t->assign( 'data', $data );
	unset($data);
	$t->assign('rendered_page', $t->fetch('admin/ratingsedit.tpl'));
	$t->display( 'admin/index.tpl' );
	exit;
}

//For Deletion of ratings
if ( $_POST['frm'] == 'frmDelrating' && $_POST['delaction'] == 'Yes') {

	// Deleting rating
	$osDB->query( 'DELETE FROM ! WHERE id = ?', array( RATINGS_TABLE, $_POST['txtid'] ) );
	header('location: manageratings.php');
	exit;
}

//Insert in ratings with max displayorder
if ( $_POST['frm'] == 'frmAddrating') {
	$rating = stripslashes(trim( $_POST['txtrating'] ));
	$enabled = trim( $_POST['txtenabled'] );
	$ordno = $osDB->getOne( 'SELECT MAX(displayorder)+1 as orderno FROM ! ', array( RATINGS_TABLE ) );
	$osDB->query( 'INSERT INTO ! (rating, enabled , displayorder) VALUES (?, ?, ? )', array( RATINGS_TABLE, $rating, $enabled,  (is_null($ordno)?"0":$ordno) ) );
	header('location: manageratings.php');
	exit;
}//End of if

if ( $_GET['moveup'] ) {
	$nrowdispord = $osDB->getOne( 'SELECT displayorder FROM ! WHERE id = ?', array( RATINGS_TABLE, $_GET['moveup'] ) );
	//to check whether it is at the highest order
	//if not then move up
	if ( $nrowdispord != 0){
		$prow =& $osDB->getRow( 'SELECT id, displayorder FROM ! WHERE displayorder = ?', array( RATINGS_TABLE, ($nrowdispord-1) ) );
		$osDB->query( 'UPDATE ! SET displayorder = ? WHERE displayorder = ? AND id = ?', array( RATINGS_TABLE, $nrowdispord, $prow['displayorder'], $prow['id'] ));
		$osDB->query( 'UPDATE ! SET displayorder = ? WHERE displayorder = ? AND id = ?', array( RATINGS_TABLE, $nrowdispord-1, $nrowdispord, $_GET['moveup'] ));
		header('location: manageratings.php');
		exit;
	}
	header('location: manageratings.php?msg=rating is already at the top');
	exit;
}

if ( $_GET['movedown'] ) {
	$nrowdispord = $osDB->getOne( 'SELECT displayorder FROM ! WHERE id = ?', array( RATINGS_TABLE,$_GET['movedown'] ) );
	//get maximum order of ratings
	$maxorder = $osDB->getOne( 'SELECT MAX(displayorder) as maxorder FROM !', array( RATINGS_TABLE ) );
	//to check whether it is at the lowest order
	//if not then move down
	if ( $nrowdispord !=  $maxorder['maxorder'] ){
		$prow =& $osDB->getRow( 'SELECT id, displayorder FROM ! WHERE displayorder = ?', array( RATINGS_TABLE,($nrowdispord+1) ) );
		$osDB->query( 'UPDATE ! SET displayorder = ? WHERE displayorder = ? AND
			id = ?' , array( RATINGS_TABLE, ($nrowdispord+1), $nrowdispord, $_GET['movedown'] ));
		$osDB->query( 'UPDATE ! SET displayorder = ? WHERE displayorder = ? AND
			id = ?' , array( RATINGS_TABLE, $nrowdispord, $prow['displayorder'], $prow['id'] ));
		header('location: manageratings.php');
		exit;
	}
	header('location: manageratings.php?msg=rating is already at the bottom');
	exit;
}

$t->assign( 'data', $osDB->getAll( 'SELECT id, rating, displayorder, enabled from ! order by ' . $sort, array(RATINGS_TABLE) ) );
$t->assign( 'lang', $lang );
$t->assign( 'sort_type', checkSortType( $_GET['type'] ) );
$t->assign('rendered_page', $t->fetch('admin/manageratings.tpl'));
$t->display( 'admin/index.tpl' );
?>
