<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}

include ( 'sessioninc.php' );

define( 'PAGE_ID', 'story_mgt' );

if ( !checkAdminPermission( PAGE_ID ) ) {

	header( 'location: not_authorize.php' );
	exit;
}

$psize = getPageSize();

$rsuser =& $osDB->getAll( 'SELECT id, username FROM ! ORDER BY username', array( USER_TABLE ) );

foreach( $rsuser as $row ) {

	$users[ $row['id'] ] = $row['username'];
}

$t->assign( 'users', $users );

unset($users, $rsuser);

if ( $_GET['edit'] ) {

	if ($_SESSION['modified'] != '') {

		$data = $_SESSION['modified'];

		$_SESSION['modified'] = '';
	} else {

		$data =& $osDB->getRow( 'SELECT * from ! Where storyid = ?', array( STORIES_TABLE, $_GET['edit'] ) );
	}

	$t->assign( 'lang', $lang );

	if (isset($_GET['errid'])) {
		$t->assign( 'error_msg', get_lang('story_error', $_GET['errid'] ) );
	}
	$t->assign( 'story', $data );

	unset($data);

	$t->assign('rendered_page', $t->fetch('admin/storyedit.tpl'));

	$t->display( 'admin/index.tpl' );

	exit;
}

if ( $_POST['deletestory'] ) {

	$osDB->query( 'DELETE FROM ! Where storyid = ?', array( STORIES_TABLE, $_POST['deletestory'] ) );

}

$t->assign('psize', $psize);

$page_size = $psize;

$page = (int)$_GET['offset'];

if( $page == 0 ) { $page = 1; }

$upr = ($page)*$page_size - $page_size;

if( $_GET['sort'] == get_lang('col_head_sendtime') ) {

	$sort = 'date '. checkSortType ( $_GET['type'] );

} else {

	$sort = findSortBy('storyid');

}

$t->assign ( 'total_recs', $osDB->getOne( 'SELECT count(*) as num FROM !', array( STORIES_TABLE ) ) );

$data =& $osDB->getAll( 'SELECT * FROM ! ORDER BY ' . $sort . " LIMIT $upr,$page_size ", array( STORIES_TABLE ) );

$dta_array = array();

foreach ($data as $ke => $rec) {
	if ($rec['sender'] > 0) {
		$uname = $osDB->getOne('SELECT username FROM ! where id = ?', array(USER_TABLE, $rec['sender']));
		$rec['username'] = $uname;
	} else {
		$rec['username'] = '';
	}
	$dta_array[]=$rec;
}

$t->assign( 'data', $dta_array );
unset($data, $dta_array);

$t->assign( 'lang', $lang );

$t->assign( 'sort_type', checkSortType( $_GET['type'] ) );

$t->assign( 'querystring', 'sort=' . $_GET['sort'] . '&type=' . $_GET['type']);

$t->assign( 'upr', $upr );

$t->assign('rendered_page', $t->fetch('admin/managestories.tpl'));

$t->display( 'admin/index.tpl' );

?>