<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}

include ( 'sessioninc.php' );

if(empty($_REQUEST["calendarid"]))
{	// Finding first calendar
	$calendarid=$osDB->getOne("select id from ! order by displayorder ",array(CALENDARS_TABLE));
} else {
	$calendarid=$_REQUEST["calendarid"];
}

$t->assign("calendarid",$calendarid);

$date_timestamp=$_REQUEST["timestamp"];
$date_array=getdate_safe($date_timestamp);
$date=$date_array["year"]."-".$date_array["mon"]."-".$date_array["mday"];

$item=array();
$item["timestamp"]=$date_timestamp;
$item["date"]=$date_array;
$item["cur_date"]=$date;
$item["events"]=array();

// selecting all events for that date
$rs=$osDB->getAll("select id, userid, event, description, ".
	   "        datetime_from, ".
	   "        datetime_to, ".
	   "       calendarid, timezone, private_to ".
	   "from !  ".
	   "where 1 ".
	   "  and to_days(datetime_from)<=to_days(?) ".
	   "  and to_days(datetime_to)>=to_days(?) ".
	   "  and enabled='Y' ".
	   "  and calendarid=? ".
	   "order by datetime_from ",array( EVENTS_TABLE,$date,$date,$calendarid));
foreach($rs as $event)
{	// Check for private event here
	$add_event=true;
	$event['username'] = $osDB->getOne('select username from ! where id = ?', array(USER_TABLE, $event['userid']) );
	if ($event['username'] == '') $event['username']='Admin';

	if($event["private_to"]!="")
	{	$add_event=false;
		$private_to=explode(",",$event["private_to"]);
		$private_to=array_map("trim",$private_to);
		if(in_array($user["username"],$private_to))
		{	$add_event=true;
		}
	}
	$event['calendar_name'] = $osDB->getOne('select calendar from ! where id=?',array(CALENDARS_TABLE, $calendarid) );
	if($add_event)
	{	// Checking for watch events
		$event["watched"]=$osDB->getOne("select count(*) from ! where userid=? and eventid=? ",array(WATCHES_TABLE, $_SESSION["UserId"], $event["id"]));
		$item["events"][]=$event;
	}

}

if (count($item["events"]) <= 0) {
	$t->assign('error','1');
}

$t->assign("events",$item["events"]);
unset($item, $rs);
$t->assign('lang', $lang);
$t->assign("date",$date);
$t->assign('rendered_page', $t->fetch('moreevents.tpl') );
$t->display ( 'admin/index.tpl' );

exit;
?>