<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}
include ( 'sessioninc.php' );

define( 'PAGE_ID', 'profile_mgt' );

if ( !checkAdminPermission( PAGE_ID ) ) {

	header( 'location: not_authorize.php' );
	exit;
}


$psize = getPageSize();

$t->assign ( 'psize',  $psize );

// rewrite later

$cpage = $_GET['page'];

if( $cpage == '' ) {
	$cpage = 1;
}

$data_list =& $osDB->getAll( 'SELECT u.*, floor((to_days(curdate())-to_days(birth_date))/365.25)  as age FROM ! u, ! ou WHERE u.allow_viewonline=? AND u.status in (?, ?) AND u.id = ou.userid ', array( USER_TABLE, ONLINE_USERS_TABLE, '1', get_lang('status_enum','active'), 'active') );

$rcount = count($data_list);

if( $rcount > 0 ) {

	$t->assign( 'totalrecs', $rcount );

	$pages = ceil( $rcount / $psize );

	$start = ( $cpage - 1 ) * $psize;

	$t->assign ( 'start', $start );

	if( $pages > 1 ) {

		if ( $cpage > 1 ) {

			$prev = $cpage - 1;

			$t->assign( 'prev', $prev );

		}
		$t->assign ( 'cpage', $cpage );

		$t->assign ( 'pages', $pages );

		if ( $cpage < $pages ) {

			$next = $cpage + 1;

			$t->assign ( 'next', $next );
		}

		$data_list = array_slice($data_list,$start, $psize);

	}
}

if ( sizeof( $data_list ) == 0 ) {

	$t->assign ( 'error', "1" );

} else {

	$data = array();

	foreach ($data_list as $row) {

		$row['countryname'] = getCountryName($row['country'] );

		$row['statename'] = getStateName( $row['country'],$row['state_province'] );

		$data[] = $row;

	}

	hasRight('');

	$t->assign ( 'data', $data );

	unset($data, $data_list);

}

$t->assign ( 'lang', $lang );

$t->assign('rendered_page', $t->fetch('admin/onlineusers.tpl') );

$t->display ( 'admin/index.tpl' );

exit;

?>