<?php
if ( !defined( 'SMARTY_DIR' ) ) {
	include_once( '../init.php' );
}

include ( 'sessioninc.php' );


function createImg($type,$file) {
	if($type == 'png') $img=imagecreatefrompng($file);
	else if($type == 'gif') $img=imagecreatefromgif($file);
	else if($type == 'jpg') $img=imagecreatefromjpeg($file);
	return $img;
}



function createJpeg( $img , $reduce='Y') {

	global $config;
	global $userid;
	global $ext;

	$tnsize = $config['upload_snap_tnsize'];

	//$img = imagecreatefrompng($org);

	$w = imagesx( $img );

	$h = imagesy( $img );

	if ($reduce == 'Y' && ($w > $tnsize || $h > $tnsize)) {
		if( $w > $h ) {
			$ratio = $w / $h;
			$nw = $tnsize;
			$nh = $nw / $ratio;
		} else {
			$ratio = $h / $w;
			$nh = $tnsize;
			$nw = $nh /$ratio;
		}
	} else {

		$nh = $h;
		$nw = $w;
	}

	$img2 = imagecreatetruecolor( $nw, $nh );

	imagecopyresampled ( $img2, $img, 0, 0, 0 , 0, $nw, $nh, $w, $h );

	$fimg = 'img_' . $userid . '.jpg';

	$real_tpath = realpath ("../temp");

	if(	$HTTP_ENV_VARS['OS'] == 'Windows_NT'){

		$real_tpath= str_replace( "\\", "\\\\", $real_tpath);

		$file = $real_tpath . "\\" . $fimg;

	}else{

		$file = $real_tpath . "/" . $fimg;

	}

	imagejpeg( $img2, $file );

	imagedestroy($img2);

	imagedestroy($img);

	return $file;
}



function writeImageToFile($img, $userid, $picno, $file="") {
/* This routine will create an image file */
	if ($file == '') {
		$filename= time().$userid.$picno.'.jpg';
	} else {
		$filename = $file;
	}

	$img = imagecreatefromstring( $img );
	imagejpeg($img, USER_IMAGE_DIR.$filename);

	return ($filename);
}

function sendAdminEmail () {
/* Send email to admin */
	global $osDB, $userid, $config;

	$body = get_lang('newpic', MAIL_FORMAT);

	$Subject = get_lang('newpic_sub'). ' - ' . $config['site_name'];

	$From = $To = $email = $config['admin_email'];

	$username = $osDB->getOne('select username from ! where id=?', array(USER_TABLE, $userid) );

	$body = str_replace( '#UserName#',  $username , $body );

	$body = str_replace( '#PicNo#',  $_POST['txtpicno'] , $body );

	$success = mailSender($From, $To, $To, $Subject, $body);
	unset($From, $To, $Subject, $body);

}

$userid = $_REQUEST['userid'];

$row =& $osDB->getRow( 'SELECT id, picture, tnpicture FROM ! WHERE userid = ? AND picno = ?', array( USER_SNAP_TABLE, $userid, $_POST['txtpicno'] ) );

$userinfo =& $osDB->getRow('select * from ! where id = ?', array( USER_TABLE, $userid) );

$err = 0;

if ($config['snaps_require_approval'] == 'Y') {

	$act = 'N';

} else {

	$act = 'Y';

}

$curr_imgfile = $curr_tnimgfile = '';

if ($config['images_in_db'] == 'N') {

	if (substr_count($row['picture'], 'file:' )>0 ) {
		$curr_imgfile = ltrim(rtrim(str_replace('file:','',$row['picture'] ) ) );
	}
	if (substr_count($row['tnpicture'],'file:' )>0 ) {
		$curr_tnimgfile = ltrim(rtrim(str_replace('file:','',$row['tnpicture'] ) ) );
	}
}

$allwdsize = $config['upload_snap_maxsize'];

if ($_POST['album_name'] != '') {

/* Add new album first and then process the image */

	$album_id = $osDB->getOne('select id from ! where name = ? and username = ?', array(USERALBUMS_TABLE, $_POST['album_name'], $userinfo['username'] )  );

	if ($album_id > 0 ) {
		null;
	} else {
		$osDB->query('insert into ! (username, name, passwd) values (?, ?, ?)', array( USERALBUMS_TABLE, $userinfo['username'], $_POST['album_name'], md5($_POST['album_passwd'])) );

		$album_id = $osDB->getOne('select id from ! where name = ? and username = ?', array(USERALBUMS_TABLE, $_POST['album_name'], $userinfo['username']  )  );
	}

} else {

	$album_id = $_POST['album_id'];

}

if (isset($_POST['changealbum']) ) {
/* Change album name  */

	$osDB->query("update ! set album_id = ? where userid = ? and picno = ?", array(USER_SNAP_TABLE, $album_id, $userid, $_POST['txtpicno']) );
	header( 'location: userpics.php?userid='.$userid.'&msg='.ALBUM_CHANGED );
	exit;

}

if( is_uploaded_file( $_FILES['txtimage']['tmp_name'] ) ) {

	$img_file = $_FILES['txtimage']['tmp_name'];

	$ext = split( '/', $_FILES['txtimage']['type'] );

	$picext = strtolower($ext[1]);

	if( $picext == 'pjpeg' || $picext == 'jpeg'){

		$picext = 'jpg';
	}

	if( $picext == 'x-png' ) {
		$picext= 'png';
	}
	//echo "$picext<br>";

	$ext_ok = '0';

	foreach (explode(',',$config['upload_snap_ext']) as $ex) {


		if ( $ex == $picext ) $ext_ok++;

	}

/* bmp files are temporarily removed from valid source */

	if ( $ext_ok <= '0' or $picext == 'bmp') {

		header( 'location: userpics.php?userid='.$userid.'&msg=' .WRONG_TYPE  );
		exit;

	}

	clearstatcache();

	$fstats= stat($img_file);

	$picsize = $fstats[7];

	/* Get current picture size and allowed size. If pic size is more than the allowed size, flag error.. */


	if ($picsize > $allwdsize) {

		header( 'location: userpics.php?userid='.$userid.'&msg='.BIG_PIC_SIZE );
		exit;

	}

	if ( $picext != 'jpg' ) {
	/* convert the picture to jpg. This is to enable picture editing  */


		//$jpgfile = createThumb($orgimg, 'N');
		$img_tmp=createImg($picext,$img_file);
		$jpgfile = createJpeg($img_tmp, 'N');
		$newimg = file_get_contents($jpgfile);

		unlink($jpgfile);

	} else {
		$handle = fopen ($img_file, 'rb');

		$orgimg = fread($handle, $picsize);

		fclose ($handle);

		$newimg = $orgimg;
	}

	if (!is_uploaded_file( $_FILES['tnimage']['tmp_name'] ) ) {

		//$tnimg_file = createThumb( $orgimg );
		$img_tmp=createImg($picext,$img_file);
		$tnimg_file = createJpeg($img_tmp,'Y');

		$tnimg = file_get_contents($tnimg_file);

		$tnext = 'jpg';

		unlink($tnimg_file);
	}
	$picext = 'jpg';

	if ($config['images_in_db'] == 'N') {

		$imgfile = writeImageToFile($newimg, $userid, '1'.$_POST['txtpicno'],$curr_imgfile);

		$newimg = 'file:'.$imgfile;

		$tnimgfile = writeImageToFile($tnimg, $userid, '2'.$_POST['txtpicno'],$curr_tnimgfile);

		$tnimg = 'file:'.$tnimgfile;
	} else {

		$newimg = base64_encode($newimg);

		$tnimg = base64_encode($tnimg);
	}

	if ( $row ) {

		$osDB->query('update ! set picture = ?, ins_time = ?, active=?, picext=?, tnpicture = ?, tnext = ?, album_id = ?  where userid = ? and picno = ? and id = ?', array( USER_SNAP_TABLE, $newimg, $time, $act,	$picext, $tnimg, $tnext, $album_id, $userid, $_POST['txtpicno'], $row['id'] ) );

	} else {

		if ($_POST['txtpicno'] == '' or !isset($_POST['txtpicno']) ) {
			$_POST['txtpicno'] = $osDB->getOne('select max(picno) from ! where userid = ?',array(USER_SNAP_TABLE,$userid) );
			$_POST['txtpicno']++;
		}

		$osDB->query( 'insert into ! (  userid, picno, picture, ins_time, active, picext, tnpicture, tnext, album_id ) values (  ?, ?, ?, ?, ?, ?, ?, ?, ? )', array( USER_SNAP_TABLE, $userid, $_POST['txtpicno'], $newimg, $time, $act, $picext, $tnimg, $tnext, $album_id ) );

	}

	updateLoadedPicturesCnt($userid);

	unset($newimg, $tnimg);

	Header("Cache-Control: must-revalidate");

	$ExpStr = "Expires: " . gmdate("D, d M Y H:i:s", time() -30) . " GMT";
	Header($ExpStr);

	header( 'location: userpics.php?userid='.$userid.'&msg='.PICTURE_LOADED );
	exit;

}

if ( is_uploaded_file( $_FILES['tnimage']['tmp_name'] ) ) {

	$tnimg_file = $_FILES['tnimage']['tmp_name'];

	$ext = split( '/', $_FILES['tnimage']['type'] );

	$tnext = strtolower($ext[1]);

	$tnsize = $config['upload_snap_tnsize'];

	if( $tnext == 'pjpeg' || $tnext == 'jpeg'){

		$tnext = 'jpg';

	}

	if( $tnext == 'x-png' ) {
		$tnext= 'png';
	}

	$ext_ok = 0;

	foreach (explode(',',$config['upload_snap_ext']) as $ex) {

		if ( $ex == $tnext ) $ext_ok++;

	}

	if ( $ext_ok <= 0 ) {

		header( 'location: userpics.php?userid='.$userid.'&msg=' .WRONG_TYPE  );
		exit;

	}

	clearstatcache();

	$fstats= stat($tnimg_file);

	$picsize = $fstats[7];

	if ($picsize > $allwdsize) {

		header( 'location: userpics.php?userid='.$userid.'&msg='.BIG_PIC_SIZE );
		exit;

	}

	list($tnwidth, $tnheight, $tntype, $tnattr) = getimagesize($tnimg_file);


	if ($tnwidth > $tnsize or $tnheight > $tnsize) {

			header( 'location: userpics.php?userid='.$userid.'&msg='.BIGTHUMBNAIL );
			exit;
	}

	$handle = fopen ($tnimg_file, 'rb');

	/* Get current picture size and allowed size. If pic size is more than the allowed size, flag error.. */

	$tnimg = fread($handle, filesize ($tnimg_file));

	fclose ($handle);

	if ( $tnext != 'jpg' ) {

	/* convert the picture to jpg. This is to enable picture editing  */

		//$jpgfile = createThumb($tnimg, 'N');
		$img_tmp=createImg($tnext,$tnimg_file);
		$jpgfile = createJpeg($img_tmp, 'N');

		$newtnimg = file_get_contents($jpgfile);

		unlink($jpgfile);

		$tnext = 'jpg';

	} else {

		$newtnimg = $tnimg;
	}


	$tnimg = base64_encode( $newtnimg );

	unset($newtnimg);

	if ($config['images_in_db'] == 'N') {

		$tnimgfile = writeImageToFile($tnimg, $userid, $_POST['txtpicno'], $curr_tnimgfile);

		$tnimg = 'file:'.tnimgfile;
	}

	if ($row) {

		$osDB->query( 'update ! set tnpicture = ?, ins_time = ?, active=?, tnext=?, album_id = ? where id = ?', array( USER_SNAP_TABLE, $tnimg, $time, $act, 	$tnext, $album_id, $row['id'] ) );

	} else {

		if ($_POST['txtpicno'] == '' or !isset($_POST['txtpicno']) ) {
			$_POST['txtpicno'] = $osDB->getOne('select max(picno) from ! where userid = ?',array(USER_SNAP_TABLE,$userid) );
		}


		$osDB->query('insert into ! (  userid, picno, tnpicture, ins_time, active, tnext, album_id ) values (  ?, ?, ?, ?, ?, ?, ? )', array( USER_SNAP_TABLE,  $userid, $_POST['txtpicno'], $tnimg, $time, $act, $tnext, $album_id ) );

	}

	updateLoadedPicturesCnt($userid);

	unset($tnimg);
	header( 'location: userpics.php?userid='.$userid.'&msg='.PICTURE_LOADED );
	exit;

}

header( 'location: userpics.php?userid='.$userid.'&msg='.FAILED_UPLOAD );
exit;


?>