<?php
/* This will remove all cached files which is older than the time limit
	given in config['page_cache_limit']

	Vijay Nair
*/

include_once('../init.php');

$tm = time() - $config['time_cache_expiry']*60;

DeleteFiles('../cache/', $tm);

echo("Old cache files deleted.. <br />");

function DeleteFiles($fromdir, $tm, $recursed = 1 ) {
	if ($fromdir == "" or !is_dir($fromdir)) {
		echo ('Invalid directory');
		return false;
	}

	$filelist = array();
	$dir = opendir($fromdir);

	while($file = readdir($dir)) {
		if($file == "." || $file == ".." || $file == 'readme.txt' || $file == 'index.html' || $file == 'index.htm') {
			continue;
		} elseif (is_dir($fromdir."/".$file)) {
			if ($recursed == 1) {
				$temp = DeleteFiles($fromdir."/".$file, $recursed);
			}
		} elseif (file_exists($fromdir."/".$file) && filemtime($fromdir."/".$file) < $tm) {
			unlink($fromdir."/".$file);
		}
	}

	closedir($dir);

	return true;
}
?>