<?php

include_once( dirname(__FILE__).'/../init.php' );

/* Create user id list to exclude in this selection */

if (!isset($_SESSION['mymatches_total_count']) ) {

	$exempts = $osDB->getAll('select userid, curdate() as dt1, from_unixtime(last_act_date) as dt2 from ! where choice_name = ? and (choice_value = 0 or choice_value = "" or ( (to_days(curdate())-to_days(from_unixtime(last_act_date))) <= choice_value and choice_value > 0 ) )', array(USER_CHOICES_TABLE, 'email_match_mail_days') );

	if (count($exempts) > 0) {

		$str = ' id not in (';

		$cnt=0;

		foreach ($exempts as $exempt) {
			if ($cnt > 0) $str .= ',';
			$str .= "'".$exempt['userid']."'";
			$cnt++;
		}

		$str.=') ';

	}


	/* get last user id to update all user records so that next select will be from this id onwards */

	$last_userid = $osDB->getOne('select max(id) from ! ',array(USER_TABLE));

	/* Get all users order by lastvisit */

	/* First get the count of users */


	if ($str != '') {
		$total_count = $osDB->getOne( 'SELECT count(*) FROM ! WHERE status = ? and ! ',array( USER_TABLE,  'active', $str) );
	} else {
		$total_count = $osDB->getOne( 'SELECT count(*) FROM ! WHERE status = ? ',array( USER_TABLE,'active' ) );
	}

	$_SESSION['mymatches_total_count'] = $total_count;
}

if (!isset($_SESSION['mymatches_start_count']) ) $_SESSION['mymatches_start_count'] = 0;

/* Now get profiles */

if ($str != '') {
	$users = $osDB->getAll( 'SELECT * FROM ! WHERE status = ? and ! order by lastvisit desc limit !,!',array( USER_TABLE,  'active', $str, $_SESSION['mymatches_start_count'], $config['mail_count']) );
} else {
	$users = $osDB->getAll( 'SELECT * FROM ! WHERE status = ? order by lastvisit desc  limit !,!',array( USER_TABLE,'active', $_SESSION['mymatches_start_count'], $config['mail_count'] ) );
}

if (count($users) <= 0 or !isset($users)) {
	exit;
}

$mail_sub = get_lang('mymatches_sub');
$mail_body = get_lang('mymatches_body','html');

foreach ($users as $k => $user) {
	echo("Processing user: ".$user['username']."<br />");

	/* Now get the last userid of last email for this user */
	$prev_lastid = $osDB->getOne('select last_act_value from ! where userid = ? and choice_name = ?', array(USER_CHOICES_TABLE, $user['id'], 'email_match_mail_days') );

	if (!isset($prev_lastid) || $prev_lastid == '') $prev_lastid = 0;

	/* Now do the search to select matching records. But include the condition of id > $prev_lastid */
	$radius = $user['lookradius'];

	$radiustype = $user['radiustype'];

	$zipcodes_in = "";

	/* Check for zip code proximity search */
	if ($user['lookzip'] != '' && isset($radius) && $radius > 0) {

		$ziprow = $osDB->getRow('select * from ! where code=?  and countrycode=?',array(ZIPCODES_TABLE, $user['lookzip'], $user['lookcountry'] ) );

		$lat = $ziprow['latitude'];
		$lng = $ziprow['longitude'];

		if ($lng!='' && $lat!='') {

		   if ($radiustype == 'kms') {
			/* Kilometers calculation */
			   $zipcodes_in = " ( sqrt(power(69.1*(user.zip_latitude - $lat),2)+power(69.1*(user.zip_longitude-$lng)*cos(user.zip_latitude/57.3),2)) < " . $radius ." ) ";
		   } else {
			/* Miles  */
			   $zipcodes_in = " (  (3958* 3.1415926 * sqrt((user.zip_latitude - $lat) * (user.zip_latitude- $lat) + cos(user.zip_latitude / 57.29578) * cos($lat/57.29578)*(user.zip_longitude - $lng) * (user.zip_longitude - $lng))/180) < " . $radius ." ) ";
		   }
		}
	}

	$bannedlist = '';
	$bannedusers = $osDB->getAll('select usr.id as ref_userid from ! as bdy, ! as usr where bdy.act=? and ((usr.username = bdy.username and bdy.ref_username = ?) or (usr.username = bdy.ref_username and bdy.username = ? ) )', array(BUDDY_BAN_TABLE, USER_TABLE, 'B', $user['username'], $user['username']) );
	if (count($bannedusers) > 0) {
		$bannedlist=' and user.id not in (';
		$bdylst = '';
		foreach ($bannedusers as $busr) {
			if ($bdylst != '') $bdylst .= ',';
			$bdylst .= "'".$busr['ref_userid']."'";
		}
		$bannedlist .=$bdylst.') ';
	}


	$sqlSelect = 'SELECT user.*, floor((to_days(curdate())-to_days(birth_date))/365.25)  as age';

	$sqlFrom = ' FROM ! user, ! mem ';

	$sqlWhere = ' WHERE user.id > ?  AND mem.roleid=user.level and mem.includeinsearch=1 ';

	$sqlWhere .= $bannedlist;

	$txtgender_search = " AND user.lookgender in  ( 'A', ";

	if ($user['gender'] == 'M' or $user['gender'] == 'F') {
		$txtgender_search .= "'B',";
	}

	$txtgender_search .= "'".$user['gender']."' )";


	$txtlookgender_search = '';

	if ($user['lookgender'] == 'B') {
		$txtlookender_search = " AND user.gender in ('M','F') ";
	} elseif ($user['lookgender'] != 'A') {
		$txtlookgender_search = " AND user.gender = '".$user['lookgender']."' ";
	}

	$sqlWhere .= ' AND user.status in (\'active\',\' '.get_lang('status_enum','active')."') " . $txtlookgender_search . $txtgender_search;

	if( $user['lookcountry'] ){

		if( $user['lookcountry'] == 'AA' ) {

			$sqlWhere .= ' AND country LIKE \'%\' ';

		}else{

		$sqlWhere .= ' AND country = \'' . $user['lookcountry'] ."' ";
		}
	}

	if( $user['lookstate_province'] ){

		if( $user['lookstate_province'] == 'AA' ) {

			$sqlWhere .= ' AND state_province LIKE \'%\' ';

		}else{

		$sqlWhere .= ' AND state_province = \'' . $user['lookstate_province'] ."' ";
		}
	}

	if( $user['lookcounty'] ){

		if( $user['lookcounty'] == 'AA' ) {

			$sqlWhere .= ' AND county LIKE \'%\' ';

		}else{

		$sqlWhere .= ' AND county = \'' . $user['lookcounty'] ."' ";
		}
	}

	if( $user['lookcity'] ){

		if( $user['lookcity'] == 'AA' ) {

			$sqlWhere .= ' AND city LIKE \'%\' ';

		}else{

		$sqlWhere .= ' AND city = \'' . $user['lookcity'] ."' ";
		}
	}

	if( $user['lookzip'] ) {
		if (!isset($radius) ){

			if( $user['lookzip'] == 'AA' ) {

				$sqlWhere .= ' AND zip LIKE \'%\' ';

			}else{

				$sqlWhere .= ' AND zip = \'' . $user['lookzip'] ."' ";
			}
		} else {

			$sqlWhere .= $zipcodes_in;
		}
	}


	$yearstart  = date("Y-m-d", mktime(0, 0, 0, date("m"),   date("d")+1,   date("Y") - $user['lookageend']));
	$yearend  = date("Y-m-d", mktime(0, 0, 0, date("m"),   date("d"),   date("Y") - $user['lookagestart']));

	$sqlWhere .= " AND birth_date BETWEEN '"
		. $yearstart. "' AND '" . $yearend ."' ";

	$sql = $sqlSelect . $sqlFrom . $sqlWhere;

	$data = $osDB->getAll ( $sql, array( USER_TABLE, MEMBERSHIP_TABLE, $prev_lastid ) );

	/* Now create html portion which displays 2 profiles side by side */
	$cnt = 0;
	$profs = '<table border=0 cellspacing=1 cellpadding=2 width="100%">';

	$matched_id = '0';

	foreach ($data as $row) {

		/* Store highest matched ID to update the choice record to use for next time email generation */
		if ($matched_id < $row['id']) $matched_id = $row['id'];

		$row['countryname'] = $osDB->getOne('select name from ! where code = ?', array( COUNTRIES_TABLE, $row['country'] ) );

		$row['statename'] = $osDB->getOne('select name from ! where code = ? and countrycode = ?', array( STATES_TABLE, $row['state_province'], $row['country'] ) );

		$row['statename'] = ($row['statename'] != '') ? $row['statename'] : $row['state_province'];

		$t->assign('item',$row);

		$prof = $t->fetch('profile_for_html_mail.tpl');

		if ($cnt == 0) {
			$profs .= '<tr>';
		}
		$profs.= '<td width="50%">'.$prof.'</td>';
		$cnt++;
		if ($cnt == 2) {
			$cnt = 0;
			$profs.="</tr>";
		}
	}
	if ($cnt == 1) $profs.='<td width="50%"></td></tr>';
	$profs.="</table>";

	if ($matched_id > 0) {
		/* There are some matches. Send email */
		/* Now we are ready with details of matched profiles. Prepare email and send */

		$From= $config['admin_email'];

		$To = $user['email'];

		$message = $mail_body;

		$message = str_replace('#FirstName#', $user['firstname'] ,$message);

		$message = str_replace('#matchedProfiles#', $profs, $message);

		/* Don't bombard mail server. Wait for some time */
		mailSender($From, $To, $user['email'], $mail_sub, $message);

		sleep(2);

	}
	/* Now that mail is sent, let us update the user choice record */

	/* Check if there is already a record for this user. If not, create a record with default days = 7 */

	$recno = $osDB->getOne('select id from ! where userid = ? and choice_name = ?', array(USER_CHOICES_TABLE, $user['id'],  'email_match_mail_days') );

	if ($recno > 0) {
		$osDB->query('update ! set last_act_date = ?, last_act_value = ? where userid = ? and choice_name = ?', array(USER_CHOICES_TABLE, time(), $matched_id, $user['id'],  'email_match_mail_days'));
	} else {
		$osDB->query('insert into ! (userid, choice_name, choice_value, last_act_date, last_act_value) values (?,?,?,?,?)', array( USER_CHOICES_TABLE, $user['id'],  'email_match_mail_days', '7', time(), $matched_id) );
	}
}

$_SESSION['mymatches_start_count'] = $_SESSION['mymatches_start_count']+$config['mail_count'];
if ($_SESSION['mymatches_start_count'] < $_SESSION['mymatches_total_count'] ) {
	header($_SERVER['PHP_SELF']);
}
?>