<?php
/* This include functions used while managing snaps */

function createImg($type,$file) {
	$type=strtolower($type);
	if($type == 'bmp') $img=imagecreatefromwbmp($file);
	else if($type == 'png') $img=imagecreatefrompng($file);
	else if($type == 'gif') $img=imagecreatefromgif($file);
	else if($type == 'jpg') $img=imagecreatefromjpeg($file);
	return $img;
}



function createJpeg( $img , $reduce='Y') {

	global $config;
	global $userid;
	global $ext;

	$tnsize = $config['upload_snap_tnsize'];

	//$img = imagecreatefrompng($org);

	$w = imagesx( $img );

	$h = imagesy( $img );

	if ($reduce == 'Y' && ($w > $tnsize || $h > $tnsize)) {

		if( $w > $h ) {
			$ratio = $w / $h;
			$nw = $tnsize;
			$nh = $nw / $ratio;
		} else {
			$ratio = $h / $w;
			$nh = $tnsize;
			$nw = $nh /$ratio;
		}
	} else {

		$nh = $h;
		$nw = $w;
	}

	$img2 = imagecreatetruecolor( $nw, $nh );

	imagecopyresampled ( $img2, $img, 0, 0, 0 , 0, $nw, $nh, $w, $h );

	$fimg = 'img_' . time().$userid . '.jpg';

	$real_tpath = TEMP_DIR;

	if(	$HTTP_ENV_VARS['OS'] == 'Windows_NT'){

		$real_tpath= str_replace( "\\", "\\\\", $real_tpath);

		$file = $real_tpath . "\\" . $fimg;

	}else{

		$file = $real_tpath . "/" . $fimg;

	}

	imagejpeg( $img2, $file );

	imagedestroy($img2);

	imagedestroy($img);

	return $file;
}


function writeImageToFile($img, $userid, $picno, $file="") {
/* This routine will create an image file */
	if ($file == '') {
		$filename= time().$userid.$picno.'.jpg';
	} else {
		$filename = $file;
	}

	$img = imagecreatefromstring( $img );
	imagejpeg($img, USER_IMAGE_DIR.$filename);

	return ($filename);
}

function sendAdminEmail () {
/* Send email to admin */
	global $osDB, $userid, $config, $t;

    $opt_lang = $_SESSION['opt_lang'];

	$_SESSION['opt_lang'] = $config['admin_lang'];

	$siteurl = HTTP_METHOD. $_SERVER['SERVER_NAME'] . DOC_ROOT;

	$body = get_lang('newpic', MAIL_FORMAT);

	$Subject = get_lang('newpic_sub');

	$From = $To = $email = $config['admin_email'];

	$username = $osDB->getOne('select username from ! where id=?', array(USER_TABLE, $userid) );

	$t->assign("userid", $_SESSION['UserId']);
	$t->assign('picno', $_POST['txtpicno']);


	$body = str_replace( '#UserName#',  $username , $body );

	$body = str_replace( '#PicNo#',  $_POST['txtpicno'] , $body );

	$body = str_replace( '#smallPic#',  $t->fetch('smallPic.tpl') , $body );

	mailSender($From, $To, $email, $Subject, $body);

	$_SESSION['opt_lang'] = $opt_lang;

	unset($opt_lang, $body, $Subject, $email, $To, $From);
}

?>