<?php

error_reporting( E_ERROR );

session_start();

define ('FULL_PATH', dirname(__FILE__).'/');

if (!is_readable(FULL_PATH.'myconfigs/config.php') ) {
	if (is_readable('install.php')){
		header("location: install.php");
	} else {
		header("location: ../install.php");
	}
}

if (file_exists(FULL_PATH.'myconfigs/config.php')) {
	require_once( FULL_PATH.'myconfigs/config.php' );
} else {
	echo (FULL_PATH.'myconfigs/config.php is missing..<br />');
	exit;
}

if(!isset($_SERVER)) $_SERVER=$GLOBALS['_SERVER'];

include_once(FULL_PATH."osdate_init.php");

if ( !OSDATE_INSTALLED ) {
	die ( '<font face=Arial size=2>osDate is not installed, or a previous installation was not successfully completed.<br /><br />Please run <a href=install.php>install.php</a> to use osDate. You will need your database login parameters, and the ability to set the permissions on various files and folders on your server.</font>' );
}

if ( (isset($_SESSION['UserId']) && $_SESSION['UserId'] == '') || !isset($_SESSION['UserId']) || ($_SERVER['SCRIPT_NAME'] == DOC_ROOT.'showprofile.php' && $config['use_profilepopups'] == 'Y') ) {
	/* Cache checking enabled only for general public i.e. the user is not logged in */
	require_once FULL_PATH.'includes/internal/osdate_check_cache.php';
	/* Check for page caching now */
	/* if cached page was available, it would have closed the session there. */
}

require_once SMARTY_DIR . 'Smarty.class.php';
require_once FULL_PATH. 'libs/Smarty/osDate_Smarty.class.php';
// require_once PEAR_DIR . 'Mail.php';

require LIB_DIR . 'osDateDB.php';
require FULL_PATH.'includes/internal/Functions.php' ;
require_once PEAR_DIR . 'Compat.php';
PHP_Compat::loadFunction('file_get_contents');

$lang = array();

$_SESSION['browser'] = getUserBrowser();

$t =& new osDate_Smarty;


/************************/
// SECURITY CHECK
/************************/

if ( $_SERVER['HTTP_HOST'] != 'localhost' && ( file_exists( FULL_PATH.'install.php' ) || is_dir( FULL_PATH.'install_files' ) ) ) {

	echo '
	<br /><br /><br /><center>
	<table border=0 width=500 cellpadding=2 cellspacing=0>
		<tr>
			<td align=center>
				<font color=red face=Arial size=2><B>SECURITY ALERT<br /><br />Please remove the following from your server before continuing: install.php file, and the install_files folder. Then, click "Reload osDate" below to continue.<br /><br />

				<a href=index.php>Reload osDate</a></B></font>
			</td>
		</tr>
	</table></center>';

	exit;
}


/**********************************/
// Instantiate DB Access methods
/**********************************/
if ( !isset( $osDB ) ) {

	$osDB = new osDateDB;

	if ($config['MAIL_FORMAT'] == '') {$config['MAIL_FORMAT'] = 'html';}
	if ($config['MAIL_TYPE'] == '') {$config['MAIL_TYPE'] = 'mail';}

	define('MAIL_FORMAT',strtolower($config['MAIL_FORMAT']));
	define('MAIL_TYPE',$config['MAIL_TYPE']);
	define('SMTP_HOST',$config['SMTP_HOST']);
	define('SMTP_POST',$config['SMTP_POST']);
	define('SMTP_USER',$config['SMTP_USER']);
	define('SMTP_PASS',$config['SMTP_PASS']);
	define('SMTP_AUTH',$config['SMTP_AUTH']);
	define('SM_PATH',$config['SM_PATH']);

}


if ( $config['MAIL_TYPE'] == 'smtp' ) {
	$params = array();// for mail sending with Pear's Mail class
	$params['host'] = $config['SMTP_HOST'];
	$params['port'] = $config['SMTP_PORT'];
	$params['auth'] = (int)$config['SMTP_AUTH'];
	$params['username'] = $config['SMTP_USER'];
	$params['password'] = $config['SMTP_PASS'];
}

/**********************************/
// STARTUP CONFIGURATION DATA
/**********************************/


$config['use_popups'] = 'Y';

define('DEFAULT_COUNTRY', $config['default_country']);

if (isset( $_COOKIE[$config['cookie_prefix'].'osdate_info'] ) ) {

	$cookie = $_COOKIE[$config['cookie_prefix'].'osdate_info'];

	list($_SESSION['lookagestart'], $_SESSION['lookageend'])= split(':',$cookie['search_ages']);
}

$skin_name = $config['skin_name'];
$lang['site_name'] = $config['site_name'];
define ('SITENAME', $config['site_name']);

if ($_REQUEST['lang']!= '') {$opt_lang=$_REQUEST['lang'];}
elseif ($_SESSION['opt_lang'] != '') {$opt_lang=str_replace("'",'',$_SESSION['opt_lang']);}
elseif ($_COOKIE[$config['cookie_prefix'].'opt_lang'] != '') {$opt_lang=$_COOKIE[$config['cookie_prefix'].'opt_lang'];}
elseif ($_SESSION['AdminId'] > 0) { $opt_lang = $config['admin_lang']; }
else {$opt_lang=DEFAULT_LANG; }

// hack - fix later
if ( strlen( $opt_lang ) <= 3 ) {
	$opt_lang = DEFAULT_LANG;
}

// $langfile = LANG_DIR.$language_files[$opt_lang];
if ($_SERVER['HTTPS'] == 'on') {
	$HTTP = 'https://';
} else {
	$HTTP = 'http://';
}
define ('HTTP_METHOD', $HTTP);

$_SESSION['spam_code_length'] = $config['spam_code_length'];


$_SESSION['opt_lang'] = ($opt_lang=='')?'english':$opt_lang;
setcookie($config['cookie_prefix'].'opt_lang',$opt_lang,time()+60*60*24*365);

if (isset($_SESSION['profile_questions']) ) unset($_SESSION['profile_questions']);

include('language/lang_'.$opt_lang.'/profile_questions.php');

$_SESSION['profile_questions'] = $profile_questions;

$t->template_dir = TEMPLATE_DIR . $skin_name.'/';
$t->compile_dir = TEMPLATE_C_DIR;
$t->cache_dir = CACHE_DIR;
// set the default handler and other values for caching and faster loading
$t->default_template_handler_func = 'getTplFile';
$t->caching = false;
$t->force_compile = false;
$t->register_prefilter("prefilter_getlang");
$t->compile_id=$_SESSION['opt_lang'];
$t->assign('DOC_ROOT', DOC_ROOT);

$t->assign ( 'config', $config );

define('SKIN_IMAGES_DIR', TEMPLATE_DIR.$skin_name.'/images/');

$agecounter = array();
for($i=($config['end_year']*-1); $i<=($config['start_year']*-1); $i++ ) {
	$agecounter[] = $i;
}
$lang['start_agerange'] = $agecounter;
$lang['end_agerange'] = $agecounter;
unset($agecounter);

if (!isset($_SESSION['loaded_languages'])) {
	$langs_loaded =& $osDB->getAll('select distinct lang from !',array(LANGUAGE_TABLE) );

	$loaded_languages = array();

	foreach ($langs_loaded as $lng) {
		$loaded_languages[$lng['lang']] = $language_options[$lng['lang']];
	}
	unset($langs_loaded);
	$_SESSION['loaded_languages'] = $loaded_languages;

}

//require_once $langfile;

$lang['status_enum'] = get_lang_values('status_enum');

$lang['status_disp'] = get_lang_values('status_disp');

$lang['status_act'] = get_lang_values('status_act');

$lang['error_msg_color'] = 'red';

$lang['useronlinetext'] = get_lang_values('useronlinetext');

$lang['useronlinecolor'] = get_lang_values('useronlinecolor');

$lang['tz'] = get_lang_values('tz');

$t->assign('languages_options', $language_options);

$t->assign('loaded_languages', $_SESSION['loaded_languages']);

$t->assign('language_conversions', $language_conversion);

$lang['ENCODING'] = get_lang('ENCODING');

$lang['DIRECTION'] = get_lang('DIRECTION');

$lang['DATE_FORMAT'] = get_lang('DATE_FORMAT');

$lang['search_results_per_page'] = get_lang_values('search_results_per_page');

$lang['enabled_values'] = get_lang_values('enabled_values');

$lang['forum_values'] = get_lang_values('forum_values');

$lang['support_currency'] = get_lang_values('support_currency');

$lang['signup_gender_values'] = get_lang_values('signup_gender_values');

$lang['signup_gender_look'] = get_lang_values('signup_gender_look');

$lang['recuring_labels'] = get_lang_values('recuring_labels');

$_SESSION['datetime_month'] = get_lang('datetime_month');

$_SESSION['datetime_day'] = get_lang('datetime_day');

/* MOD START */

$lang['mod_lowtohigh'] = get_lang_values('mod_lowtohigh');

if (strtoupper($lang['DIRECTION']) == 'RTL') {
	$t->assign('imgrtl','RTL');
}

/* MOD END */

/**********************************/
// GET CALENDARS
/**********************************/
if ($_SESSION['UserId'] != '' || substr_count($_SERVER['SCRIPT_NAME'],'calendar') > 0 ) {

	$temp =& $osDB->getAll( 'select id, calendar from ! where enabled = ? order by displayorder asc', array( CALENDARS_TABLE, 'Y' ) );
	foreach( $temp as $index => $row ) {
		$calendars[ $row[id] ] = $row[calendar];
	}
	$t->assign( 'calendars', $calendars );

	// fix later....
	$temp =& $osDB->getAll( 'select id, displayorder, calendar from !', array( CALENDARS_TABLE ) );
	foreach( $temp as $index => $row ) {
		$calendars[ $row[id] ] = $row[calendar];
	}
	$t->assign( 'allcalendars', $calendars );
	unset($temp, $calendars);
}


/**********************************/
// GET REGISTRATION SECTIONS
/**********************************/

if ($_SESSION['UserId'] != '' || $_SESSION['AdminId'] != '' ) {

	if ($_SESSION['UserId'] > 0 ) {
		$usr = $osDB->getRow('select active, status, level from ! where id = ?',array(USER_TABLE, $_SESSION['UserId'] ) ) ;
		$_SESSION['active'] = $usr['active'];
		$_SESSION['status'] = $usr['status'];
		$_SESSION['level'] = $usr['level'];
		hasRight('');
		unset($usr);
	}

	$temp =& $osDB->getAll( 'select id, section from ! where enabled = ?  order by displayorder asc', array( SECTIONS_TABLE, 'Y' ) );

	$sections = array();

	$sections['0']=get_lang('section_signup_title');

	foreach( $temp as $index => $row ) {
		$qcnt = 1;
		if ($_SESSION['UserId'] > 0 ) {
			$qcnt = $osDB->getOne("select count(*) from ! where section = ? and gender in (?,?)", array(QUESTIONS_TABLE,$row['id'], 'A', $_SESSION['gender']) );
		}
		if ($qcnt > 0) {
			if ($lang['sections'][$row[id] ] != '') {
				$sections[ $row[id] ] = $lang['sections'][$row[id] ];
			} else {
				$sections[ $row[id] ] = get_lang('sections', $row[id]);
			}
		}
	}

	$t->assign( 'sections', $sections );

	// fix later....
	$temp =& $osDB->getAll('select id, displayorder, section from !', array( SECTIONS_TABLE ) );

	foreach( $temp as $index => $row ) {
		if ($lang['sections'][$row[id] ] != '') {
			$sections[ $row[id] ] = $lang['sections'][$row[id] ];
		} else {
			$sections[ $row[id] ] = get_lang('sections', $row[id]);
		}

		if ($sections[$row[id]] == '') {
			$sections[$row[id]]=$row['section'];
		}
	}

	$t->assign( 'allsections', $sections );
	unset($temp);
}

/***********************************************/
// COUNTRIES & STATES - MOVE LATER & COLSOLIDATE
/***********************************************/

include_once(FULL_PATH.'countries_list.php');

$lang['countries'] = $countries;

$lang['allcountries'] = $allcountries;

unset($countries, $allcountries);

/**********************************/
// GET ONLINE USERS
/**********************************/

$t->assign( 'online_users_count',$osDB->getOne('SELECT count(ou.userid) as onlineusers FROM ! ou, ! as user where ou.userid <> ifnull(?,-1) and ou.userid = user.id and user.allow_viewonline = ? and ou.lastactivitytime > ?', array( ONLINE_USERS_TABLE, USER_TABLE, $_SESSION['UserId'], '1', (time()-90) ) ) );

$t->assign( 'docroot', DOC_ROOT );
$t->assign( 'banner_dir', DOC_ROOT.'banners/' );
// $t->assign( 'zodiac_dir', DOC_ROOT.'templates/'.$skin_name. '/zodiacsigns/' );
$t->assign( 'image_dir', DOC_ROOT.'templates/'.$skin_name.'/images/' );
$t->assign( 'css_path', DOC_ROOT.'templates/'.$skin_name.'/' );

include_once( 'polls.php' );
include_once( 'stories.php' );
include_once( 'news.php' );

include_once(LIB_DIR.'blog_class.php');
$blog =& new Blog();
$t->assign( 'adminblog', $blog->getAllAdminStories('Y'));
$t->assign('userblog', $blog->getAllUserStories('Y'));


$time = time();

/**********************************/
// BANNERS
/**********************************/

$banner = array();

$index = 0;

$temp =& $osDB->getAll( 'SELECT id FROM ! WHERE ( startdate <= ? AND  expdate >= ? ) AND enabled = ? and ( language is null or language = ?)', array( BANNER_TABLE, $time, $time, 'Y', $opt_lang ) );

if ( count( $temp ) > 0 ) {

	$j = 1;

	foreach( $temp as $index => $row ) {
		$banner[$j++] = $row[id];
	}

	$my_banner = $banner[ rand( 1, --$j ) ];

	$banner = $osDB->getRow( 'SELECT bannerurl FROM ! WHERE id = ?', array( BANNER_TABLE, $my_banner ) );

	$t->assign( 'banner',  stripslashes($banner['bannerurl']) );
}

unset($temp);

$t->assign( 'lang', $lang );


/**********************************/
// UPDATE ONLINE STATUS and COLLECT USER STATS
/**********************************/

if (!$_SESSION['online_deleted']) {
	$curr_session_id = session_id();

	$lastactivitytime = time() - ($config['session_timeout'] * 60);

	$temp =& $osDB->getAll( 'SELECT * FROM ! where lastactivitytime < ?', array( ONLINE_USERS_TABLE, $lastactivitytime ) );

	if ( count( $temp ) > 0 ) {
		session_write_close();
		foreach( $temp as $index => $row ) {

			if ($row['session_id'] != '') {
				/* First destroy session */
				session_id($row['session_id']);
				session_start();
				session_destroy();
			}
			$osDB->query( 'DELETE FROM ! WHERE userid = ?', array( ONLINE_USERS_TABLE, $row['userid'] ) );
		}

		session_id($curr_session_id);
		session_start();
	}
	$_SESSION['online_deleted'] = '1';
	unset($temp);
}

if ( isset( $_SESSION['UserId'] ) && !isset($_SESSION['AdminId']) ) {

	if ($_SESSION['UserId'] > 0) {

		$isOnline = $osDB->getOne( 'SELECT count(*) FROM ! WHERE userid = ?', array( ONLINE_USERS_TABLE, $_SESSION['UserId'] ) );

		if( $isOnline == 0 ) {

			$osDB->query( 'INSERT INTO ! ( userid, lastactivitytime, session_id ) values (?, ?, ? )', array( ONLINE_USERS_TABLE, $_SESSION['UserId'], $time, $curr_session_id ) );
		}

		$t->assign('new_messages', $osDB->getOne('select count(id) from ! where owner=? and recipientid = ? and flagread = ? and folder = ?', array(MAILBOX_TABLE, $_SESSION['UserId'],$_SESSION['UserId'], '0', 'inbox') ) );
	}
}

/* Now delete cache files */
deleteCache();

/***********************************/
/* Collect site statistics         */
/***********************************/

$t->assign( 'weekcnt',$osDB->getOne('select count(*) from ! where active = ? and regdate > ? and status in ( ?, ?) ', array( USER_TABLE, '1', strtotime("-7 day"), 'active', get_lang('status_enum','active') ) ) );

$row = $osDB->getRow( 'select sum(if(gender=\'M\',1,0)) as gents, sum(if(gender=\'F\',1,0)) as females, sum(if(gender=\'C\',1,0)) as couples from ! where active = ? and status in (?, ?)', array( USER_TABLE, '1', 'active', get_lang('status_enum','active')  ) );

$t->assign( 'gents', $row['gents'] );

$t->assign( 'females', $row['females'] );

$t->assign( 'couples', $row['couples'] );

unset($row);

$t->assign( 'weeksnaps', $osDB->getOne( 'select count(*) from ! where ins_time > ? ', array( USER_SNAP_TABLE, strtotime("-7 day") ) ) );

/**********************************/
// TOGGLE CHECK ONLINE STATUS
/**********************************/

if ( !isset( $_SESSION['LastExecTime'] ) || ( time() - $_SESSION['LastExecTime'] > 300 ) ) {

	$_SESSION['LastExecTime'] = time();
}

/**********************************/
// INCLUDE THE FORUM FUNCTIONS
/**********************************/

include_once( FORUM_DIR . 'forum_inc.php');


//Log code by Nathan Adams
$page = $_SERVER['REQUEST_URI'];
$IS_IN_ADMIN = strpos($page, 'admin');
if ($IS_IN_ADMIN === FALSE){
	if (strpos($page, 'allnews') > 0  || strpos($page, 'shownews') > 0) {$sql_page = 'allnews';}
	elseif (strpos($page, 'stories') > 0 || strpos($page, 'showstory') > 0) {$sql_page = 'stories';}
	else {
		$pos = strrpos($page, '/');
		$page_script = substr($page, $pos+1);

		$pos0 = strpos($page_script,'.');

		$sql_page = str_replace('.','',substr($page_script,0,$pos0+1));
	}

	if ($sql_page != 'getuser' && $sql_page != 'getinstantmsg'){
		if ($sql_page == ''){
			$sql_page = 'index';
		}
		addLog($sql_page);

/*		$check_page = $osDB->getOne ( 'SELECT page FROM ! WHERE page = ?', array ( LOG_TABLE, $sql_page ) );
		if ($check_page == $sql_page){ //ok it exists
			$query = $osDB->Query ( 'UPDATE ! SET visits = visits + 1 WHERE page = ?', array ( LOG_TABLE, $sql_page ) );
		} else {
			$osDB->Query ( "INSERT INTO ! (page, visits) VALUES (?, '1')", array ( LOG_TABLE, $sql_page ) );
		}  */
	}
}


/**********************************/
// Initialize Mod Osdate
/**********************************/

require_once MODOSDATE_DIR . 'modOsDate.php';

$mod =& new modOsDate();
// Build the mod osdate content into predefined Smarty variables

$mod->modSetContent();

function addLog($sql_page) {
	global $osDB;
	$check_page = $osDB->getOne ( 'SELECT page FROM ! WHERE page = ?', array ( LOG_TABLE, $sql_page ) );
	if ($check_page == $sql_page){ //ok it exists
		$query = $osDB->Query ( 'UPDATE ! SET visits = visits + 1 WHERE page = ?', array ( LOG_TABLE, $sql_page ) );
	} else {
		$osDB->Query ( "INSERT INTO ! (page, visits) VALUES (?, '1')", array ( LOG_TABLE, $sql_page ) );
	}
}

?>