<?php
session_start();
error_reporting( E_ERROR );

define ('FULL_PATH', dirname(__FILE__).'/');

require_once( FULL_PATH.'myconfigs/config.php' );

if(!isset($_SERVER)) $_SERVER=$GLOBALS['_SERVER'];

include_once(FULL_PATH."osdate_init.php");

require_once SMARTY_DIR . 'Smarty.class.php';
require_once FULL_PATH. 'libs/Smarty/osDate_Smarty.class.php';
require LIB_DIR . 'osDateDB.php';
require_once PEAR_DIR . 'Compat.php';

PHP_Compat::loadFunction('file_get_contents');

$lang = array();

$_SESSION['browser'] = getUserBrowser();

$t =& new osDate_Smarty;

if ( !isset( $osDB ) ) {

	$osDB =& new osDateDB;

}

$skin_name = $config['skin_name'];
$lang['site_name'] = $config['site_name'];
define ('SITENAME', $config['site_name']);

if ($_SERVER['HTTPS'] == 'on') {
	$HTTP = 'https://';
} else {
	$HTTP = 'http://';
}
define ('HTTP_METHOD', $HTTP);

$t->template_dir = TEMPLATE_DIR . $skin_name.'/';
$t->compile_dir = TEMPLATE_C_DIR;
$t->cache_dir = CACHE_DIR;
// set the default handler and other values for caching and faster loading
$t->default_template_handler_func = 'getTplFile';
$t->caching = false;
$t->force_compile = false;
$t->register_prefilter("prefilter_getlang");
$t->compile_id=$_SESSION['opt_lang'];
$t->assign('DOC_ROOT', DOC_ROOT);

$t->assign ( 'config', $config );

define('SKIN_IMAGES_DIR', TEMPLATE_DIR.$skin_name.'/images/');

$lang['ENCODING'] = get_lang('ENCODING');

$lang['DIRECTION'] = get_lang('DIRECTION');

$lang['DATE_FORMAT'] = get_lang('DATE_FORMAT');

$t->assign( 'image_dir', DOC_ROOT.'templates/'.$skin_name.'/images/' );

$t->assign( 'css_path', DOC_ROOT.'templates/'.$skin_name.'/' );

$t->assign( 'lang', $lang );

function get_lang ($mainkey, $subkey='') {
	global $osDB, $config;
	if ($subkey != '') {
	   $y = $osDB->getOne('select descr from ! where lang=? and mainkey= ? and subkey=?', array(LANGUAGE_TABLE, $_SESSION['opt_lang'], $mainkey, $subkey));
	} else {
	   $y = $osDB->getOne('select descr from ! where lang=? and mainkey= ? ', array(LANGUAGE_TABLE, $_SESSION['opt_lang'], $mainkey));
	}
	if (!$y) {
		if ($subkey != '') {
		   $y = $osDB->getOne('select descr from ! where lang=? and mainkey= ? and subkey=?', array(LANGUAGE_TABLE, 'english', $mainkey, $subkey));
		} else {
		   $y = $osDB->getOne('select descr from ! where lang=? and mainkey= ? ', array(LANGUAGE_TABLE, 'english', $mainkey));
		}
	}

	$y = str_replace('SITENAME', $config['site_name'], $y);
	$y = str_replace('DATE_FORMAT',DATE_FORMAT,$y);
	$y = str_replace('DATE_TIME_FORMAT',DATE_TIME_FORMAT,$y);
	$y = str_replace('DISPLAY_DATE_FORMAT',DISPLAY_DATE_FORMAT,$y);

	return html_entity_decode($y);
}


function get_lang_values ($mainkey) {
	global $osDB;
    $y = $osDB->getAll('select subkey, descr from ! where lang=? and mainkey= ? order by id', array(LANGUAGE_TABLE, 'english', $mainkey));
	$x=array();
	foreach ($y as $ky => $vl) {
		$x[$vl['subkey']] = $vl['descr'];
	}
	$y = $osDB->getAll('select subkey, descr from ! where lang=? and mainkey= ? order by id', array(LANGUAGE_TABLE, $_SESSION['opt_lang'], $mainkey));
	foreach ($y as $ky => $vl) {
		$x[$vl['subkey']] = $vl['descr'];
	}
	return $x;
}


function hasRight($field)
{
	global $osDB, $config;

	if( $_SESSION['security'] == '' )
	{
		if ($_SESSION['UserId'] == '')
		{
			$sqlsecurity = 'SELECT * FROM ! where name = ?';
			$row = $osDB->getRow( $sqlsecurity, array( MEMBERSHIP_TABLE, 'Visitor' ) );
		}
		elseif( $_SESSION['UserId'] != ''  )
		{
			// fix later
			$sqlsecurity = 'SELECT * FROM ! where roleid = ?';
			$row = $osDB->getRow( $sqlsecurity, array( MEMBERSHIP_TABLE, $_SESSION['RoleId'] ) );
		}
		else
		{
			$sqlsecurity = 'SELECT * FROM ! WHERE  roleid = ?';
			$row = $osDB->getRow( $sqlsecurity, array( MEMBERSHIP_TABLE, $config['default_user_level'] ) );
		}

		if( $row )
		{
			$_SESSION['security'] = $row;
		}
	}
	return (int)$_SESSION['security'][$field];
}

function getUserBrowser()
{
    global $HTTP_USER_AGENT, $_SERVER;
    if (!empty($_SERVER['HTTP_USER_AGENT'])) {
        $HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
    }
    elseif (getenv("HTTP_USER_AGENT")) {
        $HTTP_USER_AGENT = getenv("HTTP_USER_AGENT");
    }
    elseif (empty($HTTP_USER_AGENT)) {
        $HTTP_USER_AGENT = "";
    }

    if (eregi("MSIE ([0-9].[0-9]{1,2})", $HTTP_USER_AGENT, $regs)) {
        $browser['agent'] = 'MSIE';
        $browser['version'] = $regs[1];
    }
    elseif (eregi("Mozilla/([0-9].[0-9]{1,2})", $HTTP_USER_AGENT, $regs)) {
        $browser['agent'] = 'MOZILLA';
        $browser['version'] = $regs[1];
    }
    elseif (eregi("Opera(/| )([0-9].[0-9]{1,2})", $HTTP_USER_AGENT, $regs)) {
        $browser['agent'] = 'OPERA';
        $browser['version'] = $regs[2];
    }
    else {
        $browser['agent'] = 'OTHER';
        $browser['version'] = 0;
    }

    return $browser['agent'];
}

?>