<?php
if ( !defined( 'SMARTY_DIR' ) ) {

	include_once( 'init.php' );
}

include( 'sessioninc.php');

$psize = getPageSize();

$t->assign ( 'psize',  $psize );

$user =& $osDB->getRow( 'SELECT * FROM ! WHERE id = ?',array( USER_TABLE,  $_SESSION['UserId']) );

$user['countryname'] = getCountryName( $user['country'] ) ;

$user['statename'] = getStateName( $user['country'], $user['state_province'] );

$user['cityname'] = getCityName($user['country'], $user['state_province'], $user['city'], $user['county']);

$user['lookcountryname'] = getCountryName( $user['lookcountry'] ) ;

$user['lookstatename'] = getStateName( $user['lookcountry'], $user['lookstate_province'] );

$user['look_cityname'] = getCityName($user['lookcountry'], $user['lookstate_province'], $user['lookcity'], $user['lookcounty']);

$radius = isset($user['lookradius'])?$user['lookradius']:0;

$radiustype = $user['radiustype'];

$zipcodes_in = "";

/* Check for zip code proximity search */
if ($user['lookzip'] != '' && isset($radius) && $radius > 0) {

	$ziprow =& $osDB->getRow('select * from ! where code=?  and countrycode=?',array(ZIPCODES_TABLE, $user['lookzip'], $user['lookcountry'] ) );

	$lat = $ziprow['latitude'];
	$lng = $ziprow['longitude'];

	if ($lng!='' && $lat!='') {

		if ($radiustype == 'kms') {
			/* Kilometers calculation */
			$sql = "select DISTINCT code, sqrt(power(69.1*(latitude - $lat),2) +  power( 69.1 * (longitude-$lng) * cos(latitude/57.3),2)) as dist from ! where countrycode=? and sqrt(power(69.1*(latitude - $lat),2)+power(69.1*(longitude-$lng)*cos(latitude/57.3),2)) <= " . $radius ;
		} else {
			/* Miles  */
			$sql = "select DISTINCT code, (3958* 3.1415926 * sqrt((latitude - $lat) * (latitude- $lat) + cos(latitude / 57.29578) * cos($lat/57.29578)*(longitude - $lng) * (longitude - $lng))/180) as dist from ! where countrycode=? and (3958* 3.1415926 * sqrt((latitude - $lat) * (latitude- $lat) + cos(latitude / 57.29578) * cos($lat/57.29578)*(longitude - $lng) * (longitude - $lng))/180) <= " . $radius ;
		}

		$zipcodes =& $osDB->getAll($sql, array(ZIPCODES_TABLE, $user['lookcountry'] ) );

		foreach ($zipcodes as $val) {
			if ($zipcodes_in != '') $zipcodes_in.=", ";
			$zipcodes_in.= "'".strtoupper($val['code'])."'";
		}

		if ($zipcodes_in != '') {
			if ($cntrycode == 'GB') {

				$zipcodes_in = " substr(upper(user.zip),1,instr(user.zip,' ')) in (".$zipcodes_in.") ";

			} else {

				$zipcodes_in = " upper(user.zip) in (".$zipcodes_in.") ";

			}

		} else {
			$zipcodes_in = " and user.zip is null ";
		}
	}
}

$bannedlist = '';
$bannedusers =& $osDB->getAll('select usr.id as ref_userid from ! as bdy, ! as usr where bdy.act=? and ((usr.username = bdy.username and bdy.ref_username = ?) or (usr.username = bdy.ref_username and bdy.username = ? ) )', array(BUDDY_BAN_TABLE, USER_TABLE, 'B', $_SESSION['UserName'], $_SESSION['UserName']) );
if (count($bannedusers) > 0) {
	$bannedlist=' and user.id not in (';
	$bdylst = '';
	foreach ($bannedusers as $busr) {
		if ($bdylst != '') $bdylst .= ',';
		$bdylst .= "'".$busr['ref_userid']."'";
	}
	unset($bannedusers);
	$bannedlist .=$bdylst.') ';
}


$sqlSelect = 'SELECT user.*, floor((to_days(curdate())-to_days(birth_date))/365.25)  as age';

$sqlFrom = ' FROM ! user, ! mem ';

$sqlWhere = ' WHERE user.id > 0  AND mem.roleid=user.level and mem.includeinsearch=1 ';

$sqlWhere .= $bannedlist;

$txtgender_search = " AND user.lookgender in  ( 'A', ";

if ($user['gender'] == 'M' or $user['gender'] == 'F') {
	$txtgender_search .= "'B',";
}

$txtgender_search .= "'".$user['gender']."' )";


$txtlookgender_search = '';

if ($user['lookgender'] == 'B') {
	$txtlookgender_search = " AND user.gender in ('M','F') ";
} elseif ($user['lookgender'] != 'A') {
	$txtlookgender_search = " AND user.gender = '".$user['lookgender']."' ";
}

$sqlWhere .= ' AND user.status in (\'active\',\' '.get_lang('status_enum','active')."') " . $txtlookgender_search ;

if ($config['bypass_search_lookgender'] != 'Y') {

	$sqlWhere .= $txtgender_search;

}

if( $user['lookcountry'] ){

	if( $user['lookcountry'] == 'AA' ) {

		$sqlWhere .= ' AND user.country LIKE \'%\' ';

	}else{

	$sqlWhere .= ' AND user.country = \'' . $user['lookcountry'] ."' ";
	}
}

if ($zipcodes_in == '') {
	if( $user['lookstate_province'] ){

		if( $user['lookstate_province'] == 'AA' ) {

			$sqlWhere .= ' AND user.state_province LIKE \'%\' ';

		}else{

		$sqlWhere .= ' AND user.state_province = \'' . $user['lookstate_province'] ."' ";
		}
	}

	if( $user['lookcounty'] ){

		if( $user['lookcounty'] == 'AA' ) {

			$sqlWhere .= ' AND user.county LIKE \'%\' ';

		}else{

		$sqlWhere .= ' AND user.county = \'' . $user['lookcounty'] ."' ";
		}
	}

	if( $user['lookcity'] ){

		if( $user['lookcity'] == 'AA' ) {

			$sqlWhere .= ' AND user.city LIKE \'%\' ';

		}else{

			$sqlWhere .= " AND user.city = '" . $user['lookcity'] ."' ";
		}
	}

}

if( $user['lookzip'] ) {
	if (!isset($radius) ){

		if( $user['lookzip'] == 'AA' ) {

			$sqlWhere .= ' AND user.zip LIKE \'%\' ';

		}else{

			$sqlWhere .= ' AND user.zip = \'' . $user['lookzip'] ."' ";
		}
	} else {

		$sqlWhere .= ' AND '.$zipcodes_in;
	}
}

$yearstart  = date("Y-m-d", mktime(0, 0, 0, date("m"),   date("d")+1,   date("Y") - $user['lookageend']));
$yearend  = date("Y-m-d", mktime(0, 0, 0, date("m"),   date("d"),   date("Y") - $user['lookagestart']-1));

$sqlWhere .= " AND user.birth_date BETWEEN '"
	. $yearstart. "' AND '" . $yearend ."' ";

$sql = $sqlSelect . $sqlFrom . $sqlWhere;

$cpage = $_GET['page'];

if( $cpage == '' ) $cpage = 1;

$rs =& $osDB->getAll( $sql, array( USER_TABLE, MEMBERSHIP_TABLE ) );

unset($sql, $sqlSelect, $sqlFrom, $sqlWhere);

$rcount = count($rs);

if( $rcount > 0 ) {

	$t->assign( 'totalrecs', $rcount );

	$pages = ceil( $rcount / $psize );

	$start = ( $cpage - 1 ) * $psize;

	$t->assign ( 'start', $start );

	if( $pages > 1 ) {

		if ( $cpage > 1 ) {

			$prev = $cpage - 1;

			$t->assign( 'prev', $prev );

		}

		$t->assign ( 'cpage', $cpage );

		$t->assign ( 'pages', $pages );

		if ( $cpage < $pages ) {

			$next = $cpage + 1;

			$t->assign ( 'next', $next );

		}
		$data = array_slice($rs,$start, $psize);

	} else  {
		$data = $rs;
	}
	unset($rs);
}


$t->assign( 'user', $user );

unset($user);

if ( count($data) <= 0 ) {

	$t->assign ( 'error', "1" );

} else {

	$t->assign ( 'message_right', hasRight('message') );

	$t->assign ( 'view_pic_profile_right', hasRight('seepictureprofile') );

	$users = array();

	foreach ($data as $row) {

		$row['countryname'] = getCountryName( $row['country'] ) ;

		$row['statename'] = getStateName( $row['country'], $row['state_province']);

		$row['statename'] = ($row['statename'] == 'AA') ? get_lang('any_where'): $row['statename'];

		$users[] = $row;
	}


	$t->assign ( 'data', $users );

	unset($data, $users);
}

$t->assign ( 'backlink', 'index.php' );

$t->assign ( 'lang', $lang );

$t->assign('rendered_page', $t->fetch('mymatches.tpl') );

$t->display ( 'index.tpl' );

exit;


?>