
## 
## Table structure for table `[prefix]_zipcodes`
## 

CREATE TABLE `[prefix]_zipcodes` (
  `zipcode` varchar(5) default NULL,
  `zipcodetype` char(1) default NULL,
  `city` varchar(28) default NULL,
  `citytype` char(1) default NULL,
  `county` varchar(25) default NULL,
  `countyfips` varchar(5) default NULL,
  `state` varchar(30) default NULL,
  `statecode` char(2) default NULL,
  `statefips` char(2) default NULL,
  `msa` varchar(4) default NULL,
  `areacode` char(3) default NULL,
  `timezone` varchar(10) default NULL,
  `gmtoffset` int(11) default NULL,
  `dst` char(1) default NULL,
  `latitude` double default NULL,
  `longitude` double default NULL,
  KEY `zipcode` (`zipcode`),
  KEY `state` (`state`),
  KEY `latitude` (`latitude`),
  KEY `longitude` (`longitude`),
  KEY `gmtoffset` (`gmtoffset`),
  KEY `timezone` (`timezone`)
) TYPE=MyISAM;

## 
## Dumping data for table `[prefix]_zipcodes`
## 

INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('00501', 'U', 'Holtsville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.813078, -73.046388);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('00544', 'U', 'Holtsville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.813223, -73.049288);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('06390', 'P', 'Fishers Island', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.271965, -71.983379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10001', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.75205, -73.994517);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10001', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.75205, -73.994517);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10002', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.715523, -73.988379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10002', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.715523, -73.988379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10003', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.732373, -73.989477);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10003', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.732373, -73.989477);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10004', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.704169, -74.012311);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10005', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.708119, -74.012238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10005', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.708119, -74.012238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10006', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.71123, -74.012908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10006', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.71123, -74.012908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10007', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.712808, -74.009507);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10007', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.712808, -74.009507);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10008', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.712215, -74.006968);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10008', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.712215, -74.006968);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10009', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.724608, -73.980332);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10009', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.724608, -73.980332);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10010', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.742272, -73.987907);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10010', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.742272, -73.987907);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10011', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.74179, -73.999332);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10012', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.724324, -73.996124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10012', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.724324, -73.996124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10013', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.720024, -74.003648);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10013', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.720024, -74.003648);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10014', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.73396, -74.005276);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10014', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.73396, -74.005276);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10015', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.713309, -74.009937);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10016', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.745154, -73.980751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10016', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.745154, -73.980751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10017', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.751186, -73.972138);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10017', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.751186, -73.972138);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10018', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755284, -73.992008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10018', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755284, -73.992008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10019', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.764248, -73.987442);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10019', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.764248, -73.987442);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10020', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.758933, -73.978818);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10020', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.758933, -73.978818);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10021', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.768479, -73.960718);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10021', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.768479, -73.960718);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10022', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.756416, -73.970295);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10022', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.756416, -73.970295);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10023', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.777277, -73.982489);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10023', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.777277, -73.982489);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10024', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.786538, -73.978644);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10024', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.786538, -73.978644);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10025', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.799621, -73.970312);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10025', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.799621, -73.970312);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10026', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.80343, -73.952625);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10027', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.81207, -73.954377);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10027', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.81207, -73.954377);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10028', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.778345, -73.955085);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10028', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.778345, -73.955085);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10029', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.790284, -73.946781);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10029', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.790284, -73.946781);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10030', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.818115, -73.944054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10030', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.818115, -73.944054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10031', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.827379, -73.948071);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10031', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.827379, -73.948071);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10032', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.83668, -73.939944);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10032', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.83668, -73.939944);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10033', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.847553, -73.936012);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10033', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.847553, -73.936012);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10034', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.867121, -73.920588);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10034', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.867121, -73.920588);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10035', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.803001, -73.940497);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10035', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.803001, -73.940497);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10035', 'S', 'Randalls Island', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.803001, -73.940497);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10035', 'S', 'Wards Island', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.803001, -73.940497);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10036', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.759011, -73.989876);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10036', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.759011, -73.989876);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10037', 'S', 'Lincolnton', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.814876, -73.938236);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10037', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.814876, -73.938236);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10037', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.814876, -73.938236);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10038', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.706088, -74.004447);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10038', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.706088, -74.004447);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10039', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.826414, -73.936319);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10039', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.826414, -73.936319);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10040', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.85837, -73.927473);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10040', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.85837, -73.927473);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10041', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.707642, -74.013523);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10041', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.707642, -74.013523);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10043', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.759473, -73.973389);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10044', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.760799, -73.945729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10044', 'S', 'Roosevelt Island', 'A', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.760799, -73.945729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10045', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.690858, -74.011905);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10046', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.713078, -74.008599);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10047', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.710451, -74.011209);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10048', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.715564, -74.007943);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10048', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.715564, -74.007943);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10055', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.759658, -73.96858);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10055', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.759658, -73.96858);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10060', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.748746, -73.997962);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10069', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.770156, -73.988079);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10072', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.753236, -74.000603);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10079', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.714715, -74.005876);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10080', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.698283, -73.981208);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10081', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.710424, -74.006157);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10082', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.775676, -73.984484);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10087', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755837, -73.973221);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10090', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754817, -73.994447);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10094', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.714888, -74.006126);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10095', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.748793, -73.989926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10096', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.715079, -74.006343);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10098', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.715814, -74.012915);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10099', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.751591, -74.000261);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10101', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.766708, -73.990523);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10101', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.766708, -73.990523);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10102', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.764955, -73.982933);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10103', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.756711, -73.975074);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10103', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.756711, -73.975074);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10104', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.761151, -73.977549);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10104', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.761151, -73.977549);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10105', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.762235, -73.975175);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10105', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.762235, -73.975175);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10106', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.766517, -73.983784);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10106', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.766517, -73.983784);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10107', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.768216, -73.987951);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10107', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.768216, -73.987951);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10108', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.758763, -73.992621);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10108', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.758763, -73.992621);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10109', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.760712, -73.989366);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10110', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.724052, -73.980266);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10110', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.724052, -73.980266);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10111', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.758985, -73.978625);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10111', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.758985, -73.978625);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10112', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.76066, -73.981818);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10112', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.76066, -73.981818);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10113', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.742669, -73.999421);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10113', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.742669, -73.999421);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10114', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.743057, -74.000308);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10115', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.815047, -73.953521);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10116', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.814261, -73.952564);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10116', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.814261, -73.952564);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10117', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.752294, -73.995082);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10118', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.748827, -73.996353);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10118', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.748827, -73.996353);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10119', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.751108, -73.998842);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10119', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.751108, -73.998842);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10120', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.748958, -73.997849);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10120', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.748958, -73.997849);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10121', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750095, -73.998867);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10121', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750095, -73.998867);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10122', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750153, -73.997056);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10122', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750153, -73.997056);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10123', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750161, -74.000838);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10123', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750161, -74.000838);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10124', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.757053, -73.970342);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10125', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.753195, -74.000885);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10126', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.760726, -73.970532);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10128', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.779563, -73.949559);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10128', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.779563, -73.949559);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10129', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755624, -73.990453);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10130', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754891, -74.003971);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10131', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.785617, -73.949816);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10132', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.785292, -73.981536);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10133', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.776988, -73.983519);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10138', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.756075, -73.989193);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10149', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.763991, -73.985329);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10150', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.757563, -73.972925);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10150', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.757563, -73.972925);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10151', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.76436, -73.97649);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10151', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.76436, -73.97649);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10152', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.759241, -73.971816);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10152', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.759241, -73.971816);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10153', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.763133, -73.972541);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10153', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.763133, -73.972541);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10154', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.756535, -73.9706);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10154', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.756535, -73.9706);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10155', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.760757, -73.965739);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10155', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.760757, -73.965739);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10156', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.746242, -73.980923);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10157', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.743962, -73.977191);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10158', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755219, -73.966956);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10158', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755219, -73.966956);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10159', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.738556, -73.984332);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10159', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.738556, -73.984332);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10160', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.739111, -73.983857);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10161', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.747012, -74.005347);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10162', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.766659, -73.958508);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10162', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.766659, -73.958508);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10163', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755007, -73.967791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10164', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.751519, -73.977272);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10165', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755416, -73.980319);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10165', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.755416, -73.980319);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10166', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754811, -73.977146);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10166', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754811, -73.977146);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10167', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.75556, -73.974469);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10167', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.75556, -73.974469);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10168', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750979, -73.977238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10168', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750979, -73.977238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10169', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.797792, -73.946351);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10169', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.797792, -73.946351);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10170', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.749247, -73.976527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10170', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.749247, -73.976527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10171', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.758429, -73.972144);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10171', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.758429, -73.972144);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10172', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.741194, -73.987354);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10172', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.741194, -73.987354);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10173', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754208, -73.980058);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10173', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754208, -73.980058);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10174', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.749366, -73.976646);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10174', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.749366, -73.976646);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10175', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754254, -73.983164);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10175', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754254, -73.983164);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10176', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.752612, -73.981704);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10176', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.752612, -73.981704);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10177', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.738338, -73.985633);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10177', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.738338, -73.985633);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10178', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.752881, -73.97856);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10178', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.752881, -73.97856);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10179', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754518, -73.976308);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10184', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.712536, -74.003088);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10185', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.757484, -73.991365);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10196', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.714709, -74.007236);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10197', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.757284, -73.968174);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10199', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.726252, -73.979012);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10203', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.711931, -74.011806);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10211', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.731775, -73.989953);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10212', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.713127, -74.01013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10213', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.71844, -74.006344);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10242', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.715181, -74.009474);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10249', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.714735, -74.008556);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10249', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.714735, -74.008556);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10256', 'U', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.706232, -74.010903);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10256', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.706232, -74.010903);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10257', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.712067, -74.003313);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10258', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.71372, -74.007559);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10259', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.754165, -73.973439);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10260', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.703143, -74.012787);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10261', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.750339, -73.975338);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10265', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.703113, -74.013325);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10268', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.70694, -74.011574);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10268', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.70694, -74.011574);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10269', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.701869, -74.010178);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10270', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.703355, -74.007485);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10270', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.703355, -74.007485);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10271', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.706437, -74.006835);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10271', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.706437, -74.006835);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10272', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.760631, -74.005451);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10273', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.711049, -74.003348);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10274', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.70592, -74.012392);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10275', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.701876, -74.013967);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10276', 'P', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.733951, -73.989188);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10276', 'P', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.733951, -73.989188);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10277', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.718432, -74.015507);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10278', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.711322, -74.00888);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10278', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.711322, -74.00888);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10279', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.713759, -74.009621);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10279', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.713759, -74.009621);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10280', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.711844, -74.019133);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10280', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.711844, -74.019133);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10281', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.71668, -74.012932);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10281', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.71668, -74.012932);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10282', 'S', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.714419, -74.008255);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10282', 'S', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.714419, -74.008255);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10285', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.710807, -74.015235);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10286', 'U', 'Manhattan', 'N', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.705704, -74.007966);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10286', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.705704, -74.007966);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10292', 'U', 'New York', 'D', 'New York', '36061', 'New York', 'NY', '36', '5600', '212', 'Eastern', -5, 'Y', 40.708181, -74.003846);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10301', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.621813, -74.100324);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10302', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.629815, -74.138408);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10303', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.629027, -74.162595);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10304', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.603229, -74.09021);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10305', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.594867, -74.0778);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10306', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.566903, -74.120829);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10307', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.509906, -74.239854);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10308', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.553407, -74.150326);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10309', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.530762, -74.213351);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10310', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.630863, -74.117886);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10311', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.604748, -74.180644);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10312', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.542579, -74.178991);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10313', 'P', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.614826, -74.124364);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10314', 'S', 'Staten Island', 'D', 'Richmond', '36085', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.606393, -74.152402);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10451', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.820195, -73.920218);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10452', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.841676, -73.921773);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10452', 'S', 'Highbridge', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.841676, -73.921773);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10452', 'S', 'University Heights', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.841676, -73.921773);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10453', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.852613, -73.914221);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10454', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.808965, -73.916818);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10454', 'S', 'Mott Haven', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.808965, -73.916818);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10455', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.812989, -73.903711);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10455', 'S', 'Hub', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.812989, -73.903711);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10456', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.830175, -73.906791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10456', 'S', 'Morrisania', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.830175, -73.906791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10457', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.846394, -73.902732);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10458', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.859035, -73.890784);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10459', 'S', 'Boulevard', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.827628, -73.896045);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10459', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.827628, -73.896045);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10459', 'S', 'Longwood', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.827628, -73.896045);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10460', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.837082, -73.880734);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10460', 'S', 'Crotona Park', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.837082, -73.880734);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10460', 'S', 'West Farms', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.837082, -73.880734);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10461', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.844984, -73.843255);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10461', 'S', 'Morris Park', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.844984, -73.843255);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10461', 'S', 'Pilgrim', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.844984, -73.843255);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10461', 'S', 'Westchester', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.844984, -73.843255);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10462', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.840999, -73.85721);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10463', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.881512, -73.907521);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10463', 'S', 'Riverdale', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.881512, -73.907521);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10463', 'S', 'Spuyten Duyvil', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.881512, -73.907521);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10464', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.862846, -73.809564);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10465', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.823241, -73.826218);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10465', 'S', 'Throggs Neck', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.823241, -73.826218);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10466', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.889675, -73.845608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10466', 'S', 'Wakefield', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.889675, -73.845608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10467', 'S', 'Allerton', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.884641, -73.871095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10467', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.884641, -73.871095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10467', 'S', 'Mosholu', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.884641, -73.871095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10467', 'S', 'Van Cott', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.884641, -73.871095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10467', 'S', 'Williamsbridge', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.884641, -73.871095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10468', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.868013, -73.896417);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10469', 'S', 'Baychester', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.868747, -73.849303);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10469', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.868747, -73.849303);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10469', 'S', 'Esplanade', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.868747, -73.849303);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10469', 'S', 'Hillside', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.868747, -73.849303);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10470', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.901193, -73.860637);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10471', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.903491, -73.903466);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10471', 'S', 'Riverdale', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.903491, -73.903466);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10472', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.830485, -73.870026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10473', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.818719, -73.85718);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10474', 'S', 'Boulevard', 'N', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.809555, -73.885815);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10474', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.809555, -73.885815);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10475', 'S', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.876918, -73.830136);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10499', 'U', 'Bronx', 'D', 'Bronx', '36005', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.827159, -73.824345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10501', 'S', 'Amawalk', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.294884, -73.762148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10502', 'S', 'Ardsley', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.015609, -73.844361);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10502', 'S', 'Chauncey', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.015609, -73.844361);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10503', 'P', 'Ardsley on Hudson', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.025309, -73.868081);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10504', 'S', 'Armonk', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.128688, -73.697188);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10504', 'S', 'North Castle', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.128688, -73.697188);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10505', 'S', 'Baldwin Place', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.342445, -73.747115);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10506', 'S', 'Banksville', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.200742, -73.639665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10506', 'S', 'Bedford', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.200742, -73.639665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10506', 'S', 'Bedford Village', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.200742, -73.639665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10507', 'S', 'Bedford Hills', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.231606, -73.690681);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10509', 'S', 'Brewster', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.422678, -73.599511);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10509', 'S', 'Sears Corners', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.422678, -73.599511);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10509', 'S', 'Southeast', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.422678, -73.599511);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10510', 'S', 'Briarcliff Manor', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.145661, -73.833747);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10510', 'S', 'Scarborough', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.145661, -73.833747);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10511', 'S', 'Buchanan', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.258401, -73.939031);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10512', 'S', 'Carmel', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.449121, -73.679279);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10512', 'S', 'Kent Cliffs', 'A', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.449121, -73.679279);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10512', 'S', 'Lake Carmel', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.449121, -73.679279);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10514', 'S', 'Chappaqua', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.173209, -73.76922);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10516', 'S', 'Cold Spring', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.453774, -73.909862);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10516', 'S', 'Nelsonville', 'A', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.453774, -73.909862);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10516', 'S', 'North Highland', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.453774, -73.909862);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10516', 'S', 'Philipstown', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.453774, -73.909862);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10517', 'P', 'Crompond', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.295589, -73.861835);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10518', 'S', 'Cross River', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.268446, -73.602238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10519', 'P', 'Croton Falls', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.345613, -73.660066);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10520', 'S', 'Croton Hudson', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.220816, -73.887874);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10520', 'S', 'Croton on Hudson', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.220816, -73.887874);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10521', 'P', 'Croton on Hudson', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.234521, -73.924343);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10521', 'P', 'Crugers', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.234521, -73.924343);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10522', 'S', 'Dobbs Ferry', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.011736, -73.865605);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10523', 'S', 'Elmsford', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.055081, -73.816734);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10524', 'S', 'Garrison', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.369283, -73.919944);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10524', 'S', 'Manitou', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.369283, -73.919944);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10526', 'S', 'Goldens Brg', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.295831, -73.666608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10526', 'S', 'Goldens Bridge', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.295831, -73.666608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10527', 'S', 'Granite Springs', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.317032, -73.76449);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10528', 'S', 'Harrison', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.980573, -73.724601);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10530', 'S', 'Hartsdale', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.021378, -73.805692);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10532', 'S', 'Hawthorne', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.107363, -73.793734);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10533', 'S', 'East Irvington', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.04176, -73.855752);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10533', 'S', 'Irvington', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.04176, -73.855752);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10533', 'S', 'Irvington on Hudson', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.04176, -73.855752);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10535', 'S', 'Jefferson Valley', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.339561, -73.798456);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10536', 'S', 'Katonah', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.255201, -73.678419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10536', 'S', 'Lake Katonah', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.255201, -73.678419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10537', 'S', 'Lake Peekskill', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.337997, -73.885707);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10538', 'S', 'Larchmont', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.936489, -73.755346);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10540', 'P', 'Lincolndale', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.342061, -73.721539);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10541', 'S', 'Lake Lincolndale', 'A', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.378032, -73.749712);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10541', 'S', 'Lake Mahopac', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.378032, -73.749712);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10541', 'S', 'Lake Secor', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.378032, -73.749712);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10541', 'S', 'Mahopac', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.378032, -73.749712);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10542', 'P', 'Mahopac Falls', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.372926, -73.759834);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10543', 'S', 'Mamaroneck', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.955281, -73.737657);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10545', 'P', 'Maryknoll', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.18353, -73.829151);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10546', 'S', 'Millwood', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.198444, -73.801573);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10547', 'S', 'Lake Mohegan', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.317149, -73.84668);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10547', 'S', 'Mohegan Lake', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.317149, -73.84668);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10548', 'S', 'Montrose', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.247304, -73.934623);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10549', 'S', 'Bedford Corners', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.1998, -73.728606);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10549', 'S', 'Mount Kisco', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.1998, -73.728606);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10550', 'S', 'Mount Vernon', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.907698, -73.838538);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10551', 'P', 'Mount Vernon', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.901727, -73.823937);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10552', 'S', 'Fleetwood', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.922381, -73.829403);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10552', 'S', 'Mount Vernon', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.922381, -73.829403);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10553', 'S', 'Mount Vernon', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.904734, -73.8246);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10557', 'U', 'Mount Vernon', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.910001, -73.845252);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10558', 'U', 'Mount Vernon', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.913905, -73.835372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10560', 'S', 'North Salem', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.330181, -73.607527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10562', 'S', 'Crotonville', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.174335, -73.845908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10562', 'S', 'Kitchawan', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.174335, -73.845908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10562', 'S', 'Ossining', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.174335, -73.845908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10566', 'S', 'Peekskill', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.282628, -73.918771);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10567', 'S', 'Cortlandt Manor', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.279156, -73.87283);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10570', 'S', 'Pleasantville', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.134752, -73.784806);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10571', 'U', 'Pleasantville', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.128215, -73.807459);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10572', 'U', 'Pleasantville', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.136316, -73.793269);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10573', 'S', 'Port Chester', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.011395, -73.678286);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10573', 'S', 'Portchester', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.011395, -73.678286);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10573', 'S', 'Rye Brook', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.011395, -73.678286);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10576', 'S', 'Pound Ridge', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.224542, -73.57148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10576', 'S', 'Scotts Corners', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.224542, -73.57148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10577', 'S', 'Purchase', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.041406, -73.715358);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10578', 'S', 'Purdy Station', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.320695, -73.679913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10578', 'S', 'Purdys', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.320695, -73.679913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10579', 'S', 'Adams Corners', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.390553, -73.846426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10579', 'S', 'Crofts Corners', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.390553, -73.846426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10579', 'S', 'Oscawana Lake', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.390553, -73.846426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10579', 'S', 'Putnam Valley', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.390553, -73.846426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10579', 'S', 'Tompkins Corners', 'N', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.390553, -73.846426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10580', 'S', 'Rye', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.982377, -73.689314);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10583', 'S', 'Edgemont', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.989799, -73.80007);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10583', 'S', 'Heathcote', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.989799, -73.80007);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10583', 'S', 'Scarsdale', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.989799, -73.80007);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10583', 'S', 'Scarsdale Park', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.989799, -73.80007);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10587', 'P', 'Shenorock', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.32713, -73.736741);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10588', 'S', 'Shrub Oak', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.330384, -73.83412);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10589', 'S', 'Somers', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.335949, -73.6941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10589', 'S', 'Somers Town', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.335949, -73.6941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10590', 'S', 'Lake Kitchawan', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.251239, -73.543589);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10590', 'S', 'Lewisboro', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.251239, -73.543589);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10590', 'S', 'South Salem', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.251239, -73.543589);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10591', 'S', 'North Tarrytown', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.077148, -73.857479);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10591', 'S', 'Philipse Manor', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.077148, -73.857479);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10591', 'S', 'Pocantico Hills', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.077148, -73.857479);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10591', 'S', 'Sleepy Hollow', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.077148, -73.857479);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10591', 'S', 'Sleepy Hollow Manor', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.077148, -73.857479);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10591', 'S', 'Tarrytown', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.077148, -73.857479);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10594', 'S', 'Thornwood', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.117322, -73.773933);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10595', 'S', 'East View', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.088128, -73.777872);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10595', 'S', 'Valhalla', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.088128, -73.777872);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10596', 'P', 'Verplanck', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.256445, -73.95933);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10597', 'S', 'Waccabuc', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.297002, -73.600825);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10598', 'S', 'Yorktown', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.294911, -73.797703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10598', 'S', 'Yorktown Heights', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.294911, -73.797703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10601', 'S', 'White Plains', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.030604, -73.76394);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10602', 'P', 'White Plains', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.032214, -73.76525);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10603', 'S', 'North White Plains', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.050315, -73.777527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10603', 'S', 'White Plains', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.050315, -73.777527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10604', 'S', 'East White Plains', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.04356, -73.752106);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10604', 'S', 'West Harrison', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.04356, -73.752106);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10604', 'S', 'White Plains', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.04356, -73.752106);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10605', 'S', 'Gedney', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.006687, -73.746222);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10605', 'S', 'White Plains', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.006687, -73.746222);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10606', 'S', 'White Plains', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.031329, -73.779151);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10607', 'S', 'Greenburgh', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.040477, -73.809229);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10607', 'S', 'White Plains', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.040477, -73.809229);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10610', 'P', 'White Plains', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.022482, -73.812614);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10650', 'U', 'White Plains', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 41.060065, -73.742261);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10701', 'S', 'Yonkers', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.941652, -73.877562);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10702', 'P', 'Yonkers', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.932578, -73.902251);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10703', 'S', 'Yonkers', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.953777, -73.88101);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10704', 'S', 'Yonkers', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.919089, -73.861638);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10705', 'S', 'Yonkers', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.918301, -73.891148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10706', 'S', 'Hastings on Hudson', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.988472, -73.870817);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10706', 'S', 'Yonkers', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.988472, -73.870817);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10707', 'S', 'Eastchester', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.958543, -73.826785);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10707', 'S', 'Tuckahoe', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.958543, -73.826785);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10707', 'S', 'Yonkers', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.958543, -73.826785);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10708', 'S', 'Bronxville', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.940639, -73.822578);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10708', 'S', 'Yonkers', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.940639, -73.822578);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10709', 'S', 'Eastchester', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.955972, -73.807475);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10709', 'S', 'Yonkers', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.955972, -73.807475);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10710', 'S', 'Centuck', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.965847, -73.845926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10710', 'S', 'Yonkers', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.965847, -73.845926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10801', 'S', 'New Rochelle', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.916607, -73.785532);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10802', 'P', 'New Rochelle', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.91314, -73.779734);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10803', 'S', 'New Rochelle', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.905342, -73.804941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10803', 'S', 'Pelham', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.905342, -73.804941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10803', 'S', 'Pelham Manor', 'N', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.905342, -73.804941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10804', 'S', 'New Rochelle', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.949073, -73.785808);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10804', 'S', 'Wykagyl', 'A', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.949073, -73.785808);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10805', 'S', 'New Rochelle', 'D', 'Westchester', '36119', 'New York', 'NY', '36', '5600', '914', 'Eastern', -5, 'Y', 40.902888, -73.777829);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10901', 'S', 'Airmont', 'A', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.127671, -74.111934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10901', 'S', 'Montebello', 'A', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.127671, -74.111934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10901', 'S', 'Suffern', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.127671, -74.111934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10910', 'P', 'Arden', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.38879, -74.165439);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10911', 'S', 'Bear Mountain', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.306188, -73.99218);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10912', 'P', 'Bellvale', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.247332, -74.303862);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10913', 'S', 'Blauvelt', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.060202, -73.961158);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10914', 'P', 'Blooming Grove', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.382548, -74.179202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10915', 'P', 'Bullville', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.541982, -74.362554);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10916', 'S', 'Campbell Hall', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.437341, -74.250632);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10917', 'S', 'Central Valley', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.333541, -74.134438);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10918', 'S', 'Chester', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.352758, -74.266372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10919', 'S', 'Circleville', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.513113, -74.37616);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10920', 'S', 'Congers', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.147711, -73.941171);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10921', 'S', 'Florida', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.329376, -74.347207);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10922', 'P', 'Fort Montgomery', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.338977, -73.987248);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10923', 'S', 'Garnerville', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.203736, -74.000708);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10924', 'S', 'Goshen', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.396494, -74.319687);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10925', 'S', 'Greenwood Lake', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.21895, -74.294664);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10926', 'S', 'Harriman', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.307707, -74.150676);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10927', 'S', 'Haverstraw', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.199797, -73.969661);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10928', 'S', 'Highland Falls', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.368496, -73.970013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10930', 'S', 'Highland Mills', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.353753, -74.130068);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10931', 'S', 'Hillburn', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.121428, -74.169527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10932', 'P', 'Howells', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.480603, -74.463537);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10933', 'P', 'Johnson', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.365309, -74.507791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10940', 'S', 'Middletown', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.457721, -74.410797);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10940', 'S', 'Silver Lake', 'N', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.457721, -74.410797);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10941', 'S', 'Middletown', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.463349, -74.421398);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10943', 'U', 'Middletown', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.438016, -74.421736);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10950', 'S', 'Monroe', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.338274, -74.185886);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10952', 'S', 'Chestnut Ridge', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.114522, -74.07751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10952', 'S', 'Monsey', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.114522, -74.07751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10952', 'S', 'Wesley Hills', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.114522, -74.07751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10953', 'P', 'Mountainville', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.401699, -74.079126);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10954', 'S', 'Bardonia', 'A', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.098338, -74.009393);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10954', 'S', 'Nanuet', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.098338, -74.009393);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10956', 'S', 'Clarkstown', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.144539, -73.996493);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10956', 'S', 'New City', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.144539, -73.996493);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10958', 'S', 'New Hampton', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.344004, -74.451815);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10959', 'P', 'New Milford', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.234545, -74.413065);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10960', 'S', 'Central Nyack', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.09368, -73.93213);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10960', 'S', 'Grandview', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.09368, -73.93213);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10960', 'S', 'Grandview on Hudson', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.09368, -73.93213);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10960', 'S', 'Nyack', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.09368, -73.93213);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10960', 'S', 'South Nyack', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.09368, -73.93213);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10960', 'S', 'Upper Grandview', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.09368, -73.93213);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10960', 'S', 'Upper Nyack', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.09368, -73.93213);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10962', 'S', 'Orangeburg', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.047289, -73.963065);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10963', 'S', 'Otisville', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.465261, -74.537215);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10964', 'S', 'Palisades', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.012718, -73.924838);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10965', 'S', 'Chestnut Ridge', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.062979, -74.018824);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10965', 'S', 'Pearl River', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.062979, -74.018824);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10968', 'S', 'Piermont', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.039429, -73.921498);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10969', 'S', 'Pine Island', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.367776, -74.240829);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10970', 'S', 'Mount Ivy', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.184834, -74.046948);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10970', 'S', 'Pomona', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.184834, -74.046948);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10973', 'S', 'Slate Hill', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.374755, -74.486379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10974', 'S', 'Sloatsburg', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.160022, -74.146904);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10975', 'S', 'Southfields', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.259946, -74.175595);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10976', 'S', 'Sparkill', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.031057, -73.927325);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10977', 'S', 'Chestnut Ridge', 'A', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.120211, -74.046736);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10977', 'S', 'New Hempstead', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.120211, -74.046736);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10977', 'S', 'New Square', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.120211, -74.046736);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10977', 'S', 'Spring Valley', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.120211, -74.046736);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10977', 'S', 'Wesley Hills', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.120211, -74.046736);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10979', 'P', 'Sterling Forest', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.182254, -74.315748);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10980', 'S', 'Grassy Point', 'N', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.226779, -73.999941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10980', 'S', 'Stony Point', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.226779, -73.999941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10981', 'P', 'Sugar Loaf', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.323014, -74.285588);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10982', 'P', 'Tallman', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.106544, -74.09865);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10983', 'S', 'Tappan', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.0291, -73.952176);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10984', 'S', 'Thiells', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.206448, -74.015747);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10985', 'S', 'Thompson Ridge', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.578953, -74.365152);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10986', 'S', 'Tomkins Cove', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.259488, -73.990449);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10987', 'S', 'Tuxedo', 'N', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.200012, -74.216239);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10987', 'S', 'Tuxedo Park', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.200012, -74.216239);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10988', 'P', 'Unionville', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.303157, -74.565904);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10989', 'S', 'Valley Cottage', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.12327, -73.942049);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10990', 'S', 'Warwick', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.263712, -74.36706);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10992', 'S', 'Washingtonville', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.429891, -74.158182);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10993', 'S', 'West Haverstraw', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.205428, -73.983291);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10994', 'S', 'West Nyack', 'D', 'Rockland', '36087', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.099095, -73.973848);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10996', 'S', 'United States Military Acade', 'N', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.38867, -73.982179);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10996', 'S', 'West Point', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.38867, -73.982179);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10997', 'P', 'U S C C', 'N', 'Orange', '36071', 'New York', 'NY', '36', '5660', '914', 'Eastern', -5, 'Y', 41.3615, -74.027051);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10997', 'P', 'West Point', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.3615, -74.027051);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('10998', 'S', 'Westtown', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.324124, -74.543313);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11001', 'S', 'Bellerose Terrace', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.719635, -73.706913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11001', 'S', 'Bellerose Village', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.719635, -73.706913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11001', 'S', 'Bellrose Village', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.719635, -73.706913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11001', 'S', 'Floral Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.719635, -73.706913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11001', 'S', 'South Floral Park', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.719635, -73.706913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11002', 'P', 'Floral Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.720452, -73.707429);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11003', 'S', 'Alden Manor', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.699109, -73.703659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11003', 'S', 'Argo Village', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.699109, -73.703659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11003', 'S', 'Elmont', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.699109, -73.703659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11003', 'S', 'Floral Park', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.699109, -73.703659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11003', 'S', 'Locustwood', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.699109, -73.703659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11003', 'S', 'Meacham', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.699109, -73.703659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11004', 'S', 'Floral Park', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.747846, -73.710498);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11004', 'S', 'Glen Oaks', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.747846, -73.710498);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11005', 'S', 'Floral Park', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.755594, -73.715036);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11010', 'S', 'Franklin Square', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.705094, -73.674202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11020', 'S', 'Great Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.786686, -73.72577);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11020', 'S', 'Lake Success', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.786686, -73.72577);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11020', 'S', 'University Gardens', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.786686, -73.72577);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11021', 'S', 'Allenwood', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.788775, -73.728665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11021', 'S', 'Great Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.788775, -73.728665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11021', 'S', 'Great Neck Estates', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.788775, -73.728665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11021', 'S', 'Kensington', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.788775, -73.728665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11021', 'S', 'Russell Gardens', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.788775, -73.728665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11021', 'S', 'Saddle Rock Estates', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.788775, -73.728665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11021', 'S', 'Thomaston', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.788775, -73.728665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11022', 'P', 'Great Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.787695, -73.731862);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11022', 'P', 'Lake Gardens', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.787695, -73.731862);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11023', 'S', 'Great Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.798973, -73.733349);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11023', 'S', 'Harbor Hills', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.798973, -73.733349);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11023', 'S', 'Saddle Rock', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.798973, -73.733349);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11024', 'S', 'Great Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.8131, -73.736666);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11024', 'S', 'Kenilworth', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.8131, -73.736666);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11024', 'S', 'Kings Point', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.8131, -73.736666);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11025', 'U', 'Great Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.800025, -73.731577);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11026', 'P', 'Great Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.791618, -73.729669);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11027', 'P', 'Great Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.798205, -73.738285);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11030', 'S', 'Manhasset', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.795533, -73.684954);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11030', 'S', 'Plandome', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.795533, -73.684954);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11030', 'S', 'Strathmore', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.795533, -73.684954);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11040', 'S', 'Garden City Park', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.742887, -73.676015);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11040', 'S', 'Herricks', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.742887, -73.676015);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11040', 'S', 'Lakeville Estates', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.742887, -73.676015);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11040', 'S', 'Manhasset Hills', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.742887, -73.676015);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11040', 'S', 'New Hyde Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.742887, -73.676015);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11040', 'S', 'North Hills', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.742887, -73.676015);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11040', 'S', 'North New Hyde Park', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.742887, -73.676015);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11041', 'U', 'New Hyde Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.728912, -73.68576);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11042', 'S', 'Lake Success', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.757711, -73.697796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11042', 'S', 'New Hyde Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.757711, -73.697796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11043', 'U', 'New Hyde Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.756071, -73.695447);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11044', 'U', 'New Hyde Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.73455, -73.685839);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11050', 'S', 'Baxter Estates', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.832225, -73.698379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11050', 'S', 'Harbor Acres', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.832225, -73.698379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11050', 'S', 'Manorhaven', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.832225, -73.698379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11050', 'S', 'Port Wash', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.832225, -73.698379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11050', 'S', 'Port Washington', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.832225, -73.698379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11050', 'S', 'Sands Point', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.832225, -73.698379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11050', 'S', 'The Terrace', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.832225, -73.698379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11051', 'U', 'Port Washington', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.841029, -73.694052);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11052', 'U', 'Port Washington', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.844414, -73.701934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11053', 'U', 'Port Washington', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.839189, -73.703262);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11054', 'U', 'Port Washington', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.831342, -73.683314);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11055', 'U', 'Port Washington', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.840893, -73.704913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11096', 'S', 'Far Rockaway', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.618459, -73.748859);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11096', 'S', 'Inwood', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.618459, -73.748859);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11099', 'U', 'New Hyde Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.735245, -73.691496);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11101', 'S', 'Astoria', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.74847, -73.93918);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11101', 'S', 'Long Island City', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.74847, -73.93918);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11102', 'S', 'Astoria', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.770391, -73.923967);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11102', 'S', 'Long Island City', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.770391, -73.923967);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11103', 'S', 'Astoria', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.762281, -73.910107);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11103', 'S', 'Long Island City', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.762281, -73.910107);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11104', 'S', 'Astoria', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.744648, -73.917792);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11104', 'S', 'Long Island City', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.744648, -73.917792);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11104', 'S', 'Sunnyside', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.744648, -73.917792);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11105', 'S', 'Astoria', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.778285, -73.910175);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11105', 'S', 'Long Island City', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.778285, -73.910175);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11106', 'S', 'Astoria', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.761688, -73.930747);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11106', 'S', 'Long Island City', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.761688, -73.930747);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11109', 'S', 'Long Island City', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.742578, -73.949048);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11120', 'U', 'Long Island City', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.747242, -73.949347);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11201', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.695472, -73.992723);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11202', 'P', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.692402, -73.991159);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11203', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.649673, -73.937666);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11204', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.620189, -73.985706);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11205', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.694985, -73.965575);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11206', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.703008, -73.943208);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11207', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.669311, -73.895528);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11208', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.673964, -73.872964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11209', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.623738, -74.033806);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11210', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.628777, -73.945814);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11211', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.714112, -73.952354);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11212', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.663426, -73.912354);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11213', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.671767, -73.935934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11214', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.59848, -73.996892);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11215', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.666364, -73.985457);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11216', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.679695, -73.950292);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11217', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.684381, -73.980437);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11218', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.641581, -73.975901);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11219', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.631209, -73.998416);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11220', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.642875, -74.015564);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11221', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.693561, -73.926509);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11222', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.727965, -73.949305);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11223', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.59646, -73.972916);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11224', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.577387, -73.994493);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11225', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.662208, -73.95527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11226', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.647083, -73.954915);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11228', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.620567, -74.015141);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11229', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.602665, -73.948556);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11230', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.619153, -73.965619);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11231', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.680052, -74.004522);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11232', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.657218, -74.005878);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11233', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.671472, -73.924489);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11234', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.619061, -73.923116);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11235', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.582828, -73.951811);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11236', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.640108, -73.904411);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11237', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.704643, -73.921609);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11238', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.678989, -73.961819);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11239', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.647564, -73.877052);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11240', 'P', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.622952, -73.992843);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11241', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.696629, -73.993851);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11242', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.692087, -73.988815);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11243', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.679972, -73.981434);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11244', 'U', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.682013, -73.981616);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11245', 'U', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.693148, -73.985871);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11247', 'P', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.675485, -73.966404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11248', 'U', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.69893, -73.993151);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11249', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.750696, -74.00069);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11251', 'U', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.702428, -73.96741);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11252', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.624546, -74.031281);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11252', 'S', 'Fort Hamilton', 'A', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.624546, -74.031281);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11254', 'U', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.69878, -73.992599);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11255', 'U', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.69522, -73.988676);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11256', 'S', 'Brooklyn', 'D', 'Kings', '36047', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.691816, -73.988955);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11351', 'S', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.781091, -73.830914);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11352', 'P', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.753276, -73.820637);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11354', 'S', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.770167, -73.825967);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11354', 'S', 'Linden Hill', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.770167, -73.825967);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11355', 'S', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.754005, -73.821132);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11356', 'S', 'College Point', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.786, -73.84407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11356', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.786, -73.84407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11357', 'S', 'Beechhurst', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.783792, -73.812287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11357', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.783792, -73.812287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11357', 'S', 'Malba', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.783792, -73.812287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11357', 'S', 'Whitestone', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.783792, -73.812287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11358', 'S', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.760434, -73.799188);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11359', 'S', 'Bayside', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.789436, -73.777382);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11359', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.789436, -73.777382);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11359', 'S', 'Fort Totten', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.789436, -73.777382);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11360', 'S', 'Bay Terrace', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.776438, -73.78038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11360', 'S', 'Bayside', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.776438, -73.78038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11360', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.776438, -73.78038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11361', 'S', 'Bayside', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.76476, -73.77751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11361', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.76476, -73.77751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11362', 'S', 'Douglaston', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.76185, -73.729718);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11362', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.76185, -73.729718);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11362', 'S', 'Little Neck', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.76185, -73.729718);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11363', 'S', 'Douglaston', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.773215, -73.746899);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11363', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.773215, -73.746899);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11363', 'S', 'Little Neck', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.773215, -73.746899);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11364', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.7465, -73.761707);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11364', 'S', 'Oakland Gardens', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.7465, -73.761707);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11365', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.738549, -73.790001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11365', 'S', 'Fresh Meadows', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.738549, -73.790001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11365', 'S', 'Pomonok', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.738549, -73.790001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11366', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.729445, -73.797794);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11366', 'S', 'Fresh Meadows', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.729445, -73.797794);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11366', 'S', 'Utopia', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.729445, -73.797794);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11367', 'S', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.72816, -73.818582);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11367', 'S', 'Kew Garden Hills', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.72816, -73.818582);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11368', 'S', 'Corona', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.752572, -73.854759);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11368', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.752572, -73.854759);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11369', 'S', 'East Elmhurst', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.764426, -73.870771);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11369', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.764426, -73.870771);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11370', 'S', 'East Elmhurst', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.760333, -73.890833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11370', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.760333, -73.890833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11370', 'S', 'Trainsmeadow', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.760333, -73.890833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11371', 'S', 'East Elmhurst', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.775842, -73.874904);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11371', 'S', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.775842, -73.874904);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11371', 'S', 'La Guardia Airport', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.775842, -73.874904);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11372', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.749542, -73.883319);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11372', 'S', 'Jackson Heights', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.749542, -73.883319);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11373', 'S', 'Corona-Elmhurst', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.738937, -73.87916);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11373', 'S', 'Elmhurst', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.738937, -73.87916);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11373', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.738937, -73.87916);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11374', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.727079, -73.861454);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11374', 'S', 'Rego Park', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.727079, -73.861454);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11375', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.721216, -73.85021);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11375', 'S', 'Forest Hills', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.721216, -73.85021);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11375', 'S', 'Parkside', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.721216, -73.85021);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11377', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.743107, -73.906134);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11377', 'S', 'Woodside', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.743107, -73.906134);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11378', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.725746, -73.903899);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11378', 'S', 'Maspeth', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.725746, -73.903899);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11379', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.71587, -73.882583);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11379', 'S', 'Middle Village', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.71587, -73.882583);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11380', 'P', 'Elmhurst', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.742946, -73.884618);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11380', 'P', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.742946, -73.884618);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11381', 'U', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.715918, -73.875773);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11385', 'S', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.706331, -73.891914);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11385', 'S', 'Fresh Pond', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.706331, -73.891914);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11385', 'S', 'Glendale', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.706331, -73.891914);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11385', 'S', 'Ridgewood', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.706331, -73.891914);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11386', 'P', 'Flushing', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.700392, -73.894731);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11386', 'P', 'Ridgewood', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.700392, -73.894731);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11390', 'U', 'Flushing', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.788165, -73.812193);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11405', 'U', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.699453, -73.788562);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11411', 'S', 'Cambria Heights', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.694491, -73.737461);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11411', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.694491, -73.737461);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11412', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.694225, -73.760504);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11412', 'S', 'Saint Albans', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.694225, -73.760504);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11413', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.67182, -73.751834);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11413', 'S', 'Laurelton', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.67182, -73.751834);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11413', 'S', 'Springfield Gardens', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.67182, -73.751834);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11414', 'S', 'Howard Beach', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.658635, -73.843765);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11414', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.658635, -73.843765);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11415', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.708943, -73.826125);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11415', 'S', 'Kew Gardens', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.708943, -73.826125);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11416', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.684494, -73.850427);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11416', 'S', 'Ozone Park', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.684494, -73.850427);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11417', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.67426, -73.843796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11417', 'S', 'Ozone Park', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.67426, -73.843796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11418', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.69852, -73.835575);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11418', 'S', 'Kew Gardens', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.69852, -73.835575);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11418', 'S', 'Richmond Hill', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.69852, -73.835575);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11419', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.688921, -73.823304);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11419', 'S', 'South Richmond Hill', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.688921, -73.823304);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11420', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.674361, -73.813156);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11420', 'S', 'South Ozone Park', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.674361, -73.813156);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11421', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.692189, -73.856141);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11421', 'S', 'Woodhaven', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.692189, -73.856141);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11422', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.663176, -73.733191);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11422', 'S', 'Rosedale', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.663176, -73.733191);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11423', 'S', 'Hollis', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.716723, -73.76841);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11423', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.716723, -73.76841);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11424', 'P', 'Borough Hall', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.70655, -73.828147);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11424', 'P', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.70655, -73.828147);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11424', 'P', 'Kew Gardens', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.70655, -73.828147);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11425', 'U', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.674365, -73.771894);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11426', 'S', 'Bellerose', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.733204, -73.722052);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11426', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.733204, -73.722052);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11427', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.728919, -73.748586);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11427', 'S', 'Queens Village', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.728919, -73.748586);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11428', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.71999, -73.740969);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11428', 'S', 'Queens Village', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.71999, -73.740969);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11429', 'S', 'Jamaica', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.711559, -73.742091);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11429', 'S', 'Queens Village', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.711559, -73.742091);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11430', 'S', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.661453, -73.81183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11430', 'S', 'John F Kennedy Airport', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.661453, -73.81183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11431', 'P', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.717893, -73.793487);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11432', 'S', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.715744, -73.794362);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11432', 'S', 'Jamaica Estates', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.715744, -73.794362);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11433', 'S', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.697305, -73.789271);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11434', 'S', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.677047, -73.778208);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11434', 'S', 'Rochdale', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.677047, -73.778208);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11434', 'S', 'Rochdale Village', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.677047, -73.778208);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11435', 'S', 'Briarwood', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.699477, -73.808819);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11435', 'S', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.699477, -73.808819);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11436', 'S', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.678055, -73.797848);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11436', 'S', 'South Ozone Park', 'N', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.678055, -73.797848);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11439', 'U', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.722867, -73.788363);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11451', 'U', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.699605, -73.799982);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11484', 'U', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.661314, -73.737601);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11499', 'U', 'Jamaica', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.649401, -73.783733);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11501', 'S', 'Mineola', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.745251, -73.64111);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11507', 'S', 'Albertson', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.772577, -73.652127);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11509', 'S', 'Atlantic Beach', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.592092, -73.728017);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11510', 'S', 'Baldwin', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.655358, -73.607376);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11510', 'S', 'Baldwin Harbor', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.655358, -73.607376);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11510', 'S', 'North Baldwin', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.655358, -73.607376);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11514', 'S', 'Carle Place', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.752349, -73.615237);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11516', 'S', 'Cedarhurst', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.627307, -73.720608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11518', 'S', 'East Rockaway', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.641066, -73.666046);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11520', 'S', 'Freeport', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.652023, -73.588242);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11530', 'S', 'Garden City', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.725142, -73.641864);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11530', 'S', 'Garden City South', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.725142, -73.641864);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11530', 'S', 'Mitchell Field', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.725142, -73.641864);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11530', 'S', 'Roosevelt Field', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.725142, -73.641864);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11530', 'S', 'Stewart Manor', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.725142, -73.641864);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11531', 'P', 'Garden City', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.721588, -73.632436);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11531', 'P', 'Roosevelt Field', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.721588, -73.632436);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11535', 'U', 'Garden City', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.725316, -73.635499);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11536', 'U', 'Garden City', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.724374, -73.642201);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11542', 'S', 'Glen Cove', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.865104, -73.62706);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11545', 'S', 'Brookville', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.823528, -73.597631);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11545', 'S', 'Glen Head', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.823528, -73.597631);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11545', 'S', 'Muttontown', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.823528, -73.597631);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11545', 'S', 'Old Brookville', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.823528, -73.597631);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11545', 'S', 'Roslyn Harbor', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.823528, -73.597631);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11545', 'S', 'Upper Brookville', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.823528, -73.597631);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11547', 'P', 'Glenwood Landing', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.829786, -73.644155);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11548', 'S', 'Brookville', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.810905, -73.621427);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11548', 'S', 'East Hills', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.810905, -73.621427);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11548', 'S', 'Greenvale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.810905, -73.621427);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11548', 'S', 'Old Brookville', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.810905, -73.621427);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11548', 'S', 'Roslyn Harbor', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.810905, -73.621427);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11549', 'U', 'Hempstead', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.705686, -73.618785);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11550', 'S', 'Hempstead', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.701037, -73.617149);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11550', 'S', 'South Hempstead', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.701037, -73.617149);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11551', 'P', 'Hempstead', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.703341, -73.628577);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11552', 'S', 'Lakeview', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.694225, -73.64469);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11552', 'S', 'West Hempstead', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.694225, -73.64469);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11553', 'S', 'Mitchell Field', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.703352, -73.590714);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11553', 'S', 'Uniondale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.703352, -73.590714);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11554', 'S', 'East Meadow', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.715698, -73.556154);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11555', 'U', 'Uniondale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.705942, -73.595749);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11556', 'U', 'Uniondale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.701858, -73.620203);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11557', 'S', 'Hewlett', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.638779, -73.693176);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11557', 'S', 'Hewlett Bay', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.638779, -73.693176);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11557', 'S', 'Hewlett Bay Park', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.638779, -73.693176);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11557', 'S', 'Hewlett Harbor', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.638779, -73.693176);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11558', 'S', 'Barnum Island', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.600901, -73.654227);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11558', 'S', 'Harbor Island', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.600901, -73.654227);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11558', 'S', 'Harbor Isle', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.600901, -73.654227);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11558', 'S', 'Island Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.600901, -73.654227);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11559', 'S', 'Lawrence', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.611795, -73.732344);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11559', 'S', 'Meadowmere Park', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.611795, -73.732344);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11559', 'S', 'Sutton Park', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.611795, -73.732344);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11560', 'S', 'Lattingtown', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.882245, -73.592578);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11560', 'S', 'Locust Valley', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.882245, -73.592578);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11560', 'S', 'Matinecock', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.882245, -73.592578);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11561', 'S', 'East Atlantic Beach', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.585753, -73.657497);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11561', 'S', 'Lido Beach', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.585753, -73.657497);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11561', 'S', 'Long Beach', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.585753, -73.657497);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11563', 'S', 'Lynbrook', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.659727, -73.675918);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11564', 'U', 'Lynbrook', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.656559, -73.672599);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11565', 'S', 'Malverne', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.678396, -73.671004);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11566', 'S', 'Merrick', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.671577, -73.556694);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11566', 'S', 'North Merrick', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.671577, -73.556694);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11568', 'S', 'Old Westbury', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.784723, -73.599457);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11568', 'S', 'Westbury', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.784723, -73.599457);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11569', 'P', 'Point Lookout', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.593413, -73.580963);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11570', 'S', 'Lakeview', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.665099, -73.637798);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11570', 'S', 'Rockville Center', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.665099, -73.637798);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11570', 'S', 'Rockville Centre', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.665099, -73.637798);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11571', 'P', 'Rockville Center', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.657461, -73.648593);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11571', 'P', 'Rockville Centre', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.657461, -73.648593);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11572', 'S', 'Oceanside', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.639307, -73.636777);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11572', 'S', 'Rockville Center', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.639307, -73.636777);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11572', 'S', 'Rockville Centre', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.639307, -73.636777);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11575', 'S', 'Roosevelt', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.679893, -73.59143);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11576', 'S', 'East Hills', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.794758, -73.647514);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11576', 'S', 'Roslyn', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.794758, -73.647514);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11576', 'S', 'Roslyn Estates', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.794758, -73.647514);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11576', 'S', 'Roslyn Harbor', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.794758, -73.647514);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11577', 'S', 'East Hills', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.785766, -73.637013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11577', 'S', 'Roslyn Heights', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.785766, -73.637013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11579', 'S', 'Sea Cliff', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.84499, -73.642613);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11580', 'S', 'North Valley Stream', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.674214, -73.709056);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11580', 'S', 'Valley Stream', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.674214, -73.709056);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11581', 'S', 'North Woodmere', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.65543, -73.712757);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11581', 'S', 'Valley Stream', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.65543, -73.712757);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11582', 'P', 'Valley Stream', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.664547, -73.704277);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11583', 'U', 'Valley Stream', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.664442, -73.705589);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11588', 'U', 'Uniondale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.701546, -73.591473);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11590', 'S', 'New Cassel', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.757311, -73.577498);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11590', 'S', 'Westbury', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.757311, -73.577498);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11592', 'U', 'Rockville Center', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.66292, -73.639023);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11592', 'U', 'Rockville Centre', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.66292, -73.639023);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11593', 'U', 'Westbury', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.758186, -73.58513);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11594', 'U', 'Westbury', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.756752, -73.587132);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11595', 'U', 'Westbury', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.758124, -73.571426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11596', 'S', 'East Williston', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.757885, -73.644633);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11596', 'S', 'Williston Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.757885, -73.644633);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11597', 'U', 'Westbury', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.7627, -73.523913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11598', 'S', 'Hewlett Neck', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.633418, -73.714284);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11598', 'S', 'Woodmere', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.633418, -73.714284);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11598', 'S', 'Woodsburgh', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.633418, -73.714284);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11599', 'S', 'Garden City', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.724849, -73.632559);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11690', 'P', 'Edgemere', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.601071, -73.762108);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11690', 'P', 'Far Rockaway', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.601071, -73.762108);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11690', 'P', 'Wave Crest', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.601071, -73.762108);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11691', 'S', 'Far Rockaway', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.602157, -73.760226);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11692', 'S', 'Arverne', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.590874, -73.796576);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11692', 'S', 'Far Rockaway', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.590874, -73.796576);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11693', 'S', 'Broad Channel', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.589797, -73.813567);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11693', 'S', 'Far Rockaway', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.589797, -73.813567);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11693', 'S', 'Rockaway Beach', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.589797, -73.813567);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11694', 'S', 'Far Rockaway', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.576767, -73.84416);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11694', 'S', 'Neponsit', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.576767, -73.84416);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11694', 'S', 'Rockaway Park', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.576767, -73.84416);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11695', 'P', 'Far Rockaway', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.558349, -73.911454);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11695', 'P', 'Fort Tilden', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.558349, -73.911454);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11697', 'S', 'Breezy Point', 'D', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.560988, -73.913347);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11697', 'S', 'Far Rockaway', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.560988, -73.913347);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11697', 'S', 'Rockaway Point', 'A', 'Queens', '36081', 'New York', 'NY', '36', '5600', '718', 'Eastern', -5, 'Y', 40.560988, -73.913347);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11701', 'S', 'Amity Harbor', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.686293, -73.412179);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11701', 'S', 'Amityville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.686293, -73.412179);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11701', 'S', 'North Amityville', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.686293, -73.412179);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11702', 'S', 'Babylon', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.694282, -73.322269);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11702', 'S', 'Captree Island', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.694282, -73.322269);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11702', 'S', 'Gilgo Beach', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.694282, -73.322269);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11702', 'S', 'Oak Beach', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.694282, -73.322269);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11702', 'S', 'Oak Island', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.694282, -73.322269);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11702', 'S', 'West Gilgo Beach', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.694282, -73.322269);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11703', 'S', 'Babylon', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.7316, -73.32322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11703', 'S', 'North Babylon', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.7316, -73.32322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11704', 'S', 'Babylon', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.719226, -73.359044);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11704', 'S', 'West Babylon', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.719226, -73.359044);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11705', 'S', 'Bay Port', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.745346, -73.058503);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11705', 'S', 'Bayport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.745346, -73.058503);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11706', 'S', 'Bay Shore', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.733264, -73.257719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11706', 'S', 'Bayshore', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.733264, -73.257719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11706', 'S', 'Fair Harbor', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.733264, -73.257719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11706', 'S', 'Kismet', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.733264, -73.257719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11706', 'S', 'North Bay Shore', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.733264, -73.257719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11706', 'S', 'Point O Woods', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.733264, -73.257719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11706', 'S', 'Saltaire', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.733264, -73.257719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11706', 'S', 'West Bay Shore', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.733264, -73.257719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11707', 'P', 'Babylon', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.800849, -73.242817);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11707', 'P', 'West Babylon', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.800849, -73.242817);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11708', 'P', 'Amityville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.671395, -73.415695);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11709', 'S', 'Bayville', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.907634, -73.560621);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11710', 'S', 'Bellmore', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.678704, -73.537182);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11710', 'S', 'North Bellmore', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.678704, -73.537182);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11713', 'S', 'Bellport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.769052, -72.9426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11713', 'S', 'North Bellport', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.769052, -72.9426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11714', 'S', 'Bethpage', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.73854, -73.488866);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11715', 'S', 'Blue Point', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.747173, -73.039885);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11716', 'S', 'Bohemia', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.770237, -73.112442);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11717', 'S', 'Brentwood', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.781739, -73.243911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11717', 'S', 'Edgewood', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.781739, -73.243911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11717', 'S', 'Pine Air', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.781739, -73.243911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11717', 'S', 'West Brentwood', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.781739, -73.243911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11718', 'S', 'Brightwaters', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.719572, -73.265136);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11719', 'S', 'Brookhaven', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.779227, -72.915009);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11719', 'S', 'South Haven', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.779227, -72.915009);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11720', 'S', 'Centereach', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.871518, -73.084611);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11720', 'S', 'South Setauket', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.871518, -73.084611);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11721', 'S', 'Center Port', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.890176, -73.372822);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11721', 'S', 'Centerport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.890176, -73.372822);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11722', 'S', 'Central Islip', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.786098, -73.19904);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11722', 'S', 'South Hauppauge', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.786098, -73.19904);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11724', 'S', 'Cold Spring Harbor', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.866028, -73.450581);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11725', 'S', 'Commack', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.837825, -73.281154);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11726', 'S', 'Copiague', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.680826, -73.393642);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11726', 'S', 'Marconiville', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.680826, -73.393642);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11727', 'S', 'Coram', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.885609, -73.006703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11729', 'S', 'Deer Park', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.759058, -73.325501);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11729', 'S', 'Deerpark', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.759058, -73.325501);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11730', 'S', 'East Islip', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.728521, -73.186687);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11731', 'S', 'East Northport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.864288, -73.317866);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11731', 'S', 'Elwood', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.864288, -73.317866);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11732', 'S', 'East Norwich', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.844086, -73.537272);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11732', 'S', 'Muttontown', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.844086, -73.537272);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11732', 'S', 'Upper Brookville', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.844086, -73.537272);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11733', 'S', 'East Setauket', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.93285, -73.108934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11733', 'S', 'Old Field', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.93285, -73.108934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11733', 'S', 'Poquott', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.93285, -73.108934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11733', 'S', 'Setauket', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.93285, -73.108934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11733', 'S', 'Strongs Neck', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.93285, -73.108934);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11735', 'S', 'East Farmingdale', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.72278, -73.451001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11735', 'S', 'Farmingdale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.72278, -73.451001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11735', 'S', 'South Farmingdale', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.72278, -73.451001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11736', 'U', 'Farmingdale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.734441, -73.443376);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11737', 'U', 'Farmingdale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.734914, -73.4456);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11738', 'S', 'Farmingville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.837113, -73.044352);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11739', 'P', 'Great River', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.726303, -73.157742);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11740', 'S', 'Greenlawn', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.859896, -73.362616);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11741', 'S', 'Holbrook', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.798188, -73.076253);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11742', 'S', 'Holtsville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.810612, -73.043845);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Bay Hills', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Baycrest', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Beech Croft', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Cold Spring Hills', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Halesite', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Harbor Heights', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Huntington', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Huntington Bay', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Knollwood Beach', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Lloyd Harbor', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Lloyd Neck', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'West Hills', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11743', 'S', 'Wincoma', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.869083, -73.4093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11745', 'U', 'Smithtown', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.855557, -73.202963);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11746', 'S', 'Dix Hills', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.817398, -73.369148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11746', 'S', 'Huntington Station', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.817398, -73.369148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11746', 'S', 'South Huntington', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.817398, -73.369148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11747', 'S', 'Huntington Station', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.791898, -73.401348);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11747', 'S', 'Melville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.791898, -73.401348);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11749', 'S', 'Central Islip', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.83103, -73.028626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11749', 'S', 'Hauppauge', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.83103, -73.028626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11749', 'S', 'Islandia', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.83103, -73.028626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11749', 'S', 'Ronkonkoma', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.83103, -73.028626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11750', 'U', 'Huntington Station', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.846562, -73.403918);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11750', 'U', 'Melville', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.846562, -73.403918);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11751', 'S', 'Bayberry Point', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.732034, -73.213359);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11751', 'S', 'Islip', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.732034, -73.213359);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11751', 'S', 'Islip Manor', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.732034, -73.213359);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11752', 'S', 'Islip Terrace', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.751159, -73.184614);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11753', 'S', 'Jericho', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.784785, -73.5355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11753', 'S', 'Muttontown', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.784785, -73.5355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11754', 'S', 'Kings Park', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.886446, -73.244857);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11754', 'S', 'San Remo', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.886446, -73.244857);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11755', 'S', 'Lake Grove', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.858261, -73.117533);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11756', 'S', 'Island Trees', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.726674, -73.519676);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11756', 'S', 'Levittown', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.726674, -73.519676);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11756', 'S', 'Plainedge', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.726674, -73.519676);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11757', 'S', 'Heer Park', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.688951, -73.376317);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11757', 'S', 'Lindenhurst', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.688951, -73.376317);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11757', 'S', 'North Lindenhurst', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.688951, -73.376317);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11758', 'S', 'East Massapequa', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.678389, -73.458032);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11758', 'S', 'Massapequa', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.678389, -73.458032);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11758', 'S', 'North Massapequa', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.678389, -73.458032);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11760', 'P', 'Central Islip', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.816034, -73.212013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11760', 'P', 'Hauppauge', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.816034, -73.212013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11760', 'P', 'Islandia', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.816034, -73.212013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11762', 'S', 'Bar Harbor', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.683043, -73.446969);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11762', 'S', 'Massapequa Park', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.683043, -73.446969);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11763', 'S', 'Gordon Heights', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.816842, -72.984605);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11763', 'S', 'Medford', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.816842, -72.984605);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11764', 'S', 'Miller Place', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.946583, -72.995207);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11765', 'S', 'Mill Neck', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.870523, -73.566912);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11766', 'S', 'Mount Sinai', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.931723, -73.012963);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11767', 'S', 'Nesconset', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.843134, -73.147736);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11768', 'S', 'Asharoken', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.90285, -73.327419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11768', 'S', 'Crab Meadow', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.90285, -73.327419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11768', 'S', 'Eatons Neck', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.90285, -73.327419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11768', 'S', 'Fort Salonga', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.90285, -73.327419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11768', 'S', 'Northport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.90285, -73.327419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11768', 'S', 'Sunken Meadow', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.90285, -73.327419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11769', 'S', 'Oakdale', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.739823, -73.133122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11770', 'P', 'Corneil Estates', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.647098, -73.151777);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11770', 'P', 'Fire Island', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.647098, -73.151777);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11770', 'P', 'Ocean Bay Park', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.647098, -73.151777);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11770', 'P', 'Ocean Beach', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.647098, -73.151777);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11770', 'P', 'Seaview', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.647098, -73.151777);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11771', 'S', 'Centre Island', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.862368, -73.523478);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11771', 'S', 'Cove Neck', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.862368, -73.523478);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11771', 'S', 'Laurel Hollow', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.862368, -73.523478);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11771', 'S', 'Muttontown', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.862368, -73.523478);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11771', 'S', 'Oyster Bay', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.862368, -73.523478);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11771', 'S', 'Oyster Bay Cove', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.862368, -73.523478);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11771', 'S', 'Upper Brookville', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.862368, -73.523478);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11772', 'S', 'Canaan Lake', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.77421, -73.00238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11772', 'S', 'Davis Park', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.77421, -73.00238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11772', 'S', 'East Patchogue', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.77421, -73.00238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11772', 'S', 'North Patchogue', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.77421, -73.00238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11772', 'S', 'Patchogue', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.77421, -73.00238);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11773', 'U', 'Syosset', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.828208, -73.503625);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11774', 'U', 'Farmingdale', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.724629, -73.44461);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11775', 'U', 'Melville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.793182, -73.41794);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11776', 'S', 'Port Jefferson Station', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.90984, -73.046164);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11776', 'S', 'Terryville', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.90984, -73.046164);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11777', 'S', 'Belle Terre', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.943922, -73.058697);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11777', 'S', 'Port Jefferson', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.943922, -73.058697);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11777', 'S', 'Port Jefferson Station', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.943922, -73.058697);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11778', 'S', 'Rocky Point', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.949705, -72.93642);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11779', 'S', 'Lake Ronkonkoma', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.828205, -73.118972);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11779', 'S', 'Lake Ronkonkoma Heights', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.828205, -73.118972);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11779', 'S', 'Ronkonkoma', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.828205, -73.118972);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11780', 'S', 'Box Hill', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.880815, -73.157296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11780', 'S', 'Deer Wells', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.880815, -73.157296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11780', 'S', 'Flowerfield', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.880815, -73.157296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11780', 'S', 'Head of the Harbor', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.880815, -73.157296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11780', 'S', 'Nissequogue', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.880815, -73.157296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11780', 'S', 'Saint James', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.880815, -73.157296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11782', 'S', 'Cherry Grove', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.734181, -73.080076);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11782', 'S', 'Fire Island Pines', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.734181, -73.080076);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11782', 'S', 'Sayville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.734181, -73.080076);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11783', 'S', 'Seaford', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.679988, -73.492076);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11784', 'S', 'Old Westfield', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.871531, -73.043571);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11784', 'S', 'Selden', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.871531, -73.043571);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11786', 'S', 'Shoreham', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.949365, -72.891529);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11787', 'S', 'Smithtown', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.855292, -73.209738);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11788', 'S', 'Hauppauge', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.816902, -73.210989);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11788', 'S', 'Smithtown', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.816902, -73.210989);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11789', 'S', 'Scotts Beach', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.9539, -72.97881);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11789', 'S', 'Sound Beach', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.9539, -72.97881);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11790', 'S', 'Stony Brook', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.905287, -73.125351);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11790', 'S', 'Stonybrook', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.905287, -73.125351);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11791', 'S', 'Laurel Hollow', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.813797, -73.502844);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11791', 'S', 'Muttontown', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.813797, -73.502844);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11791', 'S', 'Oyster Bay Cove', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.813797, -73.502844);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11791', 'S', 'Syosset', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.813797, -73.502844);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11792', 'S', 'Wading River', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.953111, -72.840407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11792', 'S', 'Wildwood', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.953111, -72.840407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11792', 'S', 'Willwood', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.953111, -72.840407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11793', 'S', 'Briar Park', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.685767, -73.51402);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11793', 'S', 'North Wantagh', 'N', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.685767, -73.51402);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11793', 'S', 'Wantagh', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.685767, -73.51402);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11794', 'U', 'Stony Brook', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.902157, -73.127632);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11794', 'U', 'Stonybrook', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.902157, -73.127632);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11795', 'S', 'West Islip', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.709304, -73.299311);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11796', 'S', 'West Sayville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.732739, -73.100528);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11797', 'S', 'Woodbury', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.81381, -73.468323);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11798', 'S', 'Wheatley Heights', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.756804, -73.364139);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11798', 'S', 'Wyandanch', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.756804, -73.364139);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11801', 'S', 'Hicksville', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.766663, -73.51647);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11802', 'P', 'Hicksville', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.764323, -73.531618);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11803', 'S', 'Hicksville', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.780517, -73.478813);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11803', 'S', 'Plainview', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.780517, -73.478813);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11804', 'S', 'Hicksville', 'A', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.768805, -73.455029);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11804', 'S', 'Old Bethpage', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.768805, -73.455029);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11805', 'P', 'Mid Island', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.764012, -73.527219);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11815', 'U', 'Hicksville', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.768318, -73.514148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11819', 'U', 'Hicksville', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.763511, -73.532506);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11853', 'U', 'Jericho', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.786573, -73.542199);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11854', 'U', 'Hicksville', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.753879, -73.5033);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11855', 'U', 'Hicksville', 'D', 'Nassau', '36059', 'New York', 'NY', '36', '5380', '516', 'Eastern', -5, 'Y', 40.762253, -73.525848);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11901', 'S', 'Flanders', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.928084, -72.65583);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11901', 'S', 'Northampton', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.928084, -72.65583);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11901', 'S', 'Riverhead', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.928084, -72.65583);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11930', 'P', 'Amagansett', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.976299, -72.13367);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11930', 'P', 'Beach Hampton', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.976299, -72.13367);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11930', 'P', 'Promised Land', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.976299, -72.13367);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11931', 'S', 'Aquebogue', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.946526, -72.598308);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11932', 'P', 'Bridge Hampton', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.962338, -72.306224);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11932', 'P', 'Bridgehampton', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.962338, -72.306224);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11933', 'S', 'Baiting Hollow', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.924576, -72.746313);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11933', 'S', 'Calverton', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.924576, -72.746313);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11934', 'S', 'Center Moriches', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.800258, -72.796529);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11934', 'S', 'Center Moriches', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.800258, -72.796529);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11935', 'S', 'Cutchogue', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.015049, -72.472897);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11935', 'S', 'Nassau Point', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.015049, -72.472897);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11937', 'S', 'East Hampton', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.004735, -72.178804);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11939', 'S', 'East Marion', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.128421, -72.341905);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11940', 'S', 'East Moriches', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.80849, -72.75228);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11941', 'S', 'Eastport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.830437, -72.731567);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11942', 'S', 'East Quogue', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.847122, -72.573666);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11944', 'S', 'Greenport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.102895, -72.370978);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11946', 'S', 'Hampton Bays', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.877152, -72.516667);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11947', 'S', 'Jamesport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.946167, -72.583098);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11948', 'S', 'Laurel', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.963392, -72.548573);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11949', 'S', 'Manorville', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.85218, -72.788976);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11950', 'S', 'Manor Park', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.806599, -72.840193);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11950', 'S', 'Mastic', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.806599, -72.840193);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11950', 'S', 'Rivers Edge', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.806599, -72.840193);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11951', 'S', 'Mastic Beach', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.764527, -72.843517);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11951', 'S', 'Old Mastic', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.764527, -72.843517);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11952', 'S', 'Mattituck', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.993754, -72.539624);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11953', 'S', 'Middle Island', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.87772, -72.955011);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11954', 'S', 'Hither Plains', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.041068, -71.950598);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11954', 'S', 'Montauk', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.041068, -71.950598);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11955', 'S', 'Moriches', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.804137, -72.820828);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11956', 'P', 'New Suffolk', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.992282, -72.477555);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11957', 'S', 'Orient', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.145539, -72.2766);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11957', 'S', 'Orient Point', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.145539, -72.2766);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11958', 'S', 'Peconic', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.04158, -72.458859);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11959', 'P', 'Quogue', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.823016, -72.601639);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11960', 'P', 'Remsenburg', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.812687, -72.695052);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11961', 'S', 'Lake Panamoka', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.905116, -72.878039);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11961', 'S', 'Panamoka', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.905116, -72.878039);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11961', 'S', 'Ridge', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.905116, -72.878039);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11962', 'P', 'Sagaponack', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.950826, -72.287798);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11963', 'S', 'Bay Point', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.000568, -72.317352);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11963', 'S', 'North Haven', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.000568, -72.317352);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11963', 'S', 'Pine Neck', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.000568, -72.317352);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11963', 'S', 'Sag Harbor', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.000568, -72.317352);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11964', 'P', 'Shelter Island', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.067294, -72.337204);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11965', 'P', 'Shelter Island Heights', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.075213, -72.354368);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11967', 'S', 'East Yaphank', 'A', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.795028, -72.869264);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11967', 'S', 'Shirley', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.795028, -72.869264);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11968', 'S', 'North Sea', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.907565, -72.411077);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11968', 'S', 'South Hampton', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.907565, -72.411077);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11968', 'S', 'Southampton', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.907565, -72.411077);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11969', 'P', 'South Hampton', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.965942, -72.357568);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11969', 'P', 'Southampton', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.965942, -72.357568);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11970', 'P', 'South Jamesport', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.936611, -72.579128);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11971', 'S', 'Southold', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 41.057698, -72.415683);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11972', 'P', 'Speonk', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.819732, -72.706941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11973', 'P', 'Upton', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.849836, -72.889667);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11975', 'P', 'Wainscott', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.952826, -72.249776);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11976', 'S', 'Water Mill', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.930979, -72.35279);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11976', 'S', 'Watermill', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.930979, -72.35279);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11976', 'S', 'Wtr Mill', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.930979, -72.35279);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11977', 'S', 'West Hampton', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.819853, -72.666788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11977', 'S', 'Westhampton', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.819853, -72.666788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11978', 'S', 'Quioque', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.811711, -72.645053);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11978', 'S', 'Westhampton Beach', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.811711, -72.645053);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11978', 'S', 'Westhampton Dunes', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.811711, -72.645053);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11980', 'S', 'Carver Park', 'N', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.838524, -72.933522);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('11980', 'S', 'Yaphank', 'D', 'Suffolk', '36103', 'New York', 'NY', '36', '5380', '631', 'Eastern', -5, 'Y', 40.838524, -72.933522);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12007', 'S', 'Alcove', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.748146, -73.801434);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12008', 'S', 'Alplaus', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.854388, -73.904169);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12008', 'S', 'Schenectady', 'A', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.854388, -73.904169);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12009', 'S', 'Altamont', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.697778, -74.025728);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12009', 'S', 'Thompsons Lake', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.697778, -74.025728);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12010', 'S', 'Amsterdam', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.943005, -74.188796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12010', 'S', 'Perth', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.943005, -74.188796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12010', 'S', 'West Charlton', 'A', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.943005, -74.188796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12010', 'S', 'West Glenville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.943005, -74.188796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12015', 'S', 'Athens', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.262647, -73.810372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12016', 'P', 'Auriesville', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.928783, -74.319642);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12016', 'P', 'Fultonville', 'A', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.928783, -74.319642);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12017', 'S', 'Austerlitz', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.316394, -73.458542);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12018', 'S', 'Alps', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.611818, -73.584345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12018', 'S', 'Averill Park', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.611818, -73.584345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12018', 'S', 'Burden Lake', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.611818, -73.584345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12018', 'S', 'Dunham Hollow', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.611818, -73.584345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12018', 'S', 'East Poestenkill', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.611818, -73.584345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12018', 'S', 'Glass Lake', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.611818, -73.584345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12019', 'S', 'Ballston', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.922447, -73.856309);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12019', 'S', 'Ballston Lake', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.922447, -73.856309);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12019', 'S', 'Burnt Hills', 'A', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.922447, -73.856309);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12019', 'S', 'Charlton', 'A', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.922447, -73.856309);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Ballston Center', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Ballston Spa', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'East Line', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Factory Village', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Harmony Corners', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Malta', 'A', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Malta Ridge', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Maltaville', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Milton Center', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Pioneer', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'Riley Cove', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12020', 'S', 'West Milton', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.005586, -73.860404);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12022', 'S', 'Berlin', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.694299, -73.370325);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12022', 'S', 'Center Berlin', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.694299, -73.370325);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12023', 'S', 'Berne', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.598536, -74.121153);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12023', 'S', 'South Berne', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.598536, -74.121153);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12023', 'S', 'West Berne', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.598536, -74.121153);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12024', 'S', 'Brainard', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.405919, -73.612531);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12025', 'S', 'Broadalbin', 'D', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.057254, -74.198122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12025', 'S', 'Fish House', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.057254, -74.198122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12025', 'S', 'Galway Lake', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.057254, -74.198122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12025', 'S', 'Honeywell Corners', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.057254, -74.198122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12025', 'S', 'North Broadalbin', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.057254, -74.198122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12025', 'S', 'Stevers Mills', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.057254, -74.198122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12025', 'S', 'Union Mills', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.057254, -74.198122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12025', 'S', 'Vail Mills', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.057254, -74.198122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12027', 'S', 'Burnt Hills', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.916475, -73.901761);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12028', 'S', 'Buskirk', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.962677, -73.447303);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12029', 'S', 'Canaan', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.391057, -73.400428);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12031', 'S', 'Carlisle', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.746768, -74.45741);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12032', 'S', 'Caroga', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.166561, -74.502419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12032', 'S', 'Caroga Lake', 'D', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.166561, -74.502419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12032', 'S', 'Pine Lake', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.166561, -74.502419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12032', 'S', 'Wheelerville', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.166561, -74.502419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12033', 'S', 'Brookview', 'A', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.535438, -73.70907);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12033', 'S', 'Castleton on Hudson', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.535438, -73.70907);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12035', 'S', 'Central Bridge', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.716078, -74.361941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12036', 'S', 'Charlotteville', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '607', 'Eastern', -5, 'Y', 42.541441, -74.657149);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12037', 'S', 'Chatham', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.359632, -73.589364);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12040', 'P', 'Cherry Plain', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.634921, -73.355054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12040', 'P', 'Cherryplain', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.634921, -73.355054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12041', 'S', 'Clarksville', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.560143, -73.980356);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12042', 'S', 'Climax', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.372564, -73.865815);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12043', 'S', 'Cobleskill', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679057, -74.487086);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12043', 'S', 'Dorloo', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679057, -74.487086);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12043', 'S', 'Hyndsville', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679057, -74.487086);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12043', 'S', 'Janesville', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679057, -74.487086);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12043', 'S', 'Lawyersville', 'A', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679057, -74.487086);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12043', 'S', 'Mineral Springs', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679057, -74.487086);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12043', 'S', 'Seward', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679057, -74.487086);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12045', 'P', 'Coeymans', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.472313, -73.793901);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12046', 'S', 'Coeymans Hollow', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.486055, -73.926051);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12047', 'S', 'Boght Corners', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.774939, -73.715732);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12047', 'S', 'Cohoes', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.774939, -73.715732);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12047', 'S', 'Dunsbach Ferry', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.774939, -73.715732);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12050', 'P', 'Columbiaville', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.315037, -73.748815);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12051', 'S', 'Coxsackie', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.357823, -73.807318);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12052', 'S', 'Cropseyville', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.548054, -73.693645);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12053', 'S', 'Braman Corners', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.745233, -74.18913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12053', 'S', 'Delanson', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.745233, -74.18913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12054', 'S', 'Bethlehem', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.613346, -73.840619);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12054', 'S', 'Delmar', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.613346, -73.840619);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12054', 'S', 'Elsmere', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.613346, -73.840619);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12055', 'S', 'Dormansville', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.542142, -73.990058);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12055', 'S', 'Westerlo', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.542142, -73.990058);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12056', 'S', 'Duanesburg', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.788214, -74.07921);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12056', 'S', 'Princetown', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.788214, -74.07921);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12057', 'S', 'Eagle Bridge', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 42.936611, -73.342245);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12057', 'S', 'White Creek', 'A', 'Rensselaer', '36083', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 42.936611, -73.342245);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12058', 'S', 'Earlton', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.349583, -73.902962);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12059', 'S', 'East Berne', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.617126, -74.058841);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12060', 'S', 'East Chatham', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.428925, -73.491439);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12060', 'S', 'Red Rock', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.428925, -73.491439);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12061', 'S', 'East Greenbush', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.595189, -73.693628);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12062', 'S', 'East Nassau', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.531602, -73.502202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12062', 'S', 'Hoag Corners', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.531602, -73.502202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12063', 'S', 'East Schodack', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.569709, -73.61451);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12064', 'S', 'East Worcester', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.557719, -74.64435);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12065', 'S', 'Clifton Park', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.851899, -73.785028);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12065', 'S', 'Clifton Park Center', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.851899, -73.785028);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12065', 'S', 'Elnora', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.851899, -73.785028);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12065', 'S', 'Halfmoon', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.851899, -73.785028);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12065', 'S', 'Jonesville', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.851899, -73.785028);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12066', 'S', 'Burtonsville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.769372, -74.260535);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12066', 'S', 'Esperance', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.769372, -74.260535);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12067', 'S', 'Feura Bush', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.565899, -73.913257);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12068', 'S', 'Fonda', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.952959, -74.347319);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12068', 'S', 'Sammonsville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.952959, -74.347319);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12069', 'P', 'Fort Hunter', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.941659, -74.279913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12070', 'S', 'Fort Johnson', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.962988, -74.251122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12071', 'S', 'Fultonham', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.591388, -74.393816);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12072', 'S', 'Fultonville', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.944695, -74.376969);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12073', 'P', 'Gallupville', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.662066, -74.229925);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12074', 'S', 'Galway', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.032199, -74.036378);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12074', 'S', 'Hagedorns Mills', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.032199, -74.036378);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12074', 'S', 'Mosherville', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.032199, -74.036378);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12075', 'S', 'Ghent', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.292747, -73.702189);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12076', 'S', 'Gilboa', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '607', 'Eastern', -5, 'Y', 42.410715, -74.390183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12077', 'S', 'Bethlehem Center', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.596487, -73.794423);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12077', 'S', 'Glenmont', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.596487, -73.794423);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12078', 'S', 'Bleecker', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.054502, -74.33833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12078', 'S', 'Gloversville', 'D', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.054502, -74.33833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12078', 'S', 'Meco', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.054502, -74.33833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12078', 'S', 'Riceville', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.054502, -74.33833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12078', 'S', 'West Bush', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.054502, -74.33833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12082', 'P', 'Grafton', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.768623, -73.447387);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12083', 'S', 'Greenville', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.416705, -74.011373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12083', 'S', 'Norton Hill', 'A', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.416705, -74.011373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12083', 'S', 'South Westerlo', 'A', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.416705, -74.011373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12084', 'S', 'Guilderland', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.699325, -73.89971);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12085', 'S', 'Guilderland Center', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.702864, -73.968446);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12086', 'S', 'Hagaman', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.974141, -74.154373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12087', 'S', 'Hannacroix', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.422544, -73.886598);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12089', 'P', 'Hoosick', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.864306, -73.327143);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12090', 'S', 'Boyntonville', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903091, -73.350837);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12090', 'S', 'Hoosick Falls', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903091, -73.350837);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12090', 'S', 'Walloomsac', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903091, -73.350837);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12092', 'S', 'Barnerville', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.711693, -74.36353);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12092', 'S', 'Bramanville', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.711693, -74.36353);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12092', 'S', 'Howes Cave', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.711693, -74.36353);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12093', 'S', 'East Jefferson', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '607', 'Eastern', -5, 'Y', 42.497077, -74.724214);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12093', 'S', 'Jefferson', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '607', 'Eastern', -5, 'Y', 42.497077, -74.724214);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12093', 'S', 'North Harpersfield', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '607', 'Eastern', -5, 'Y', 42.497077, -74.724214);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12094', 'S', 'Johnsonville', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.932662, -73.506739);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12095', 'S', 'Garoga', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.004789, -74.370507);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12095', 'S', 'Johnstown', 'D', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.004789, -74.370507);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12095', 'S', 'Northbush', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.004789, -74.370507);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12095', 'S', 'Rockwood', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.004789, -74.370507);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12106', 'S', 'Kinderhook', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.395508, -73.711549);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12107', 'P', 'Knox', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.669807, -74.119886);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12108', 'S', 'Higgins Bay', 'N', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.574421, -74.416891);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12108', 'S', 'Lake Pleasant', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.574421, -74.416891);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12110', 'S', 'Latham', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.747077, -73.767886);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12110', 'S', 'Newtonville', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.747077, -73.767886);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12110', 'S', 'Verdoy', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.747077, -73.767886);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12110', 'S', 'West Latham', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.747077, -73.767886);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12111', 'U', 'Latham', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.745456, -73.743584);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12115', 'S', 'Malden Brg', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.45604, -73.591434);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12115', 'S', 'Malden Bridge', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.45604, -73.591434);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12116', 'S', 'Chaseville', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.542837, -74.899432);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12116', 'S', 'Cooperstown Junction', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.542837, -74.899432);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12116', 'S', 'Maryland', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.542837, -74.899432);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12117', 'S', 'Mayfield', 'D', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.102843, -74.263232);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12118', 'S', 'Mechanicville', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.913913, -73.707978);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12120', 'S', 'Medusa', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.435003, -74.147921);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12121', 'S', 'Melrose', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.843234, -73.618514);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12122', 'S', 'Breakabeen', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.59473, -74.333891);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12122', 'S', 'Huntersland', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.59473, -74.333891);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12122', 'S', 'Livingstonville', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.59473, -74.333891);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12122', 'S', 'Middleburg', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.59473, -74.333891);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12122', 'S', 'Middleburgh', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.59473, -74.333891);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12123', 'S', 'Nassau', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.521046, -73.625267);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12124', 'P', 'New Baltimore', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.444613, -73.787763);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12125', 'S', 'Lebanon Springs', 'A', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.483586, -73.377729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12125', 'S', 'New Lebanon', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.483586, -73.377729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12125', 'S', 'New Lebanon Center', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.483586, -73.377729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12128', 'P', 'Latham', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.724446, -73.750908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12128', 'P', 'Newtonville', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.724446, -73.750908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12130', 'S', 'Niverville', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.451428, -73.65886);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12131', 'S', 'North Blenheim', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.487846, -74.429697);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12132', 'P', 'North Chatham', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.471422, -73.633263);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12133', 'P', 'Hoosick Junction', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.924518, -73.345704);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12133', 'P', 'North Hoosick', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.924518, -73.345704);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12134', 'S', 'Edinburg', 'N', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.237513, -74.111493);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12134', 'S', 'Northville', 'D', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.237513, -74.111493);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12136', 'S', 'Old Chatham', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.469547, -73.55641);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12137', 'S', 'Mariaville', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.855513, -74.114251);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12137', 'S', 'Pattersonville', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.855513, -74.114251);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12138', 'S', 'North Petersburg', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.741778, -73.40726);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12138', 'S', 'Petersburg', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.741778, -73.40726);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12138', 'S', 'Petersburgh', 'A', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.741778, -73.40726);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12138', 'S', 'Taconic Lake', 'A', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.741778, -73.40726);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12139', 'S', 'Arietta', 'N', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.425277, -74.528147);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12139', 'S', 'Piseco', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.425277, -74.528147);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12140', 'S', 'Poestenkill', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.695254, -73.578996);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12141', 'P', 'Quaker Street', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.732998, -74.186598);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12143', 'S', 'Ravena', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.47172, -73.820415);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12144', 'S', 'Defreestville', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.63338, -73.721769);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12144', 'S', 'Rensselaer', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.63338, -73.721769);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12147', 'S', 'Rensselaerville', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.521047, -74.14625);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12148', 'S', 'Rexford', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.838672, -73.859359);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12148', 'S', 'Vischer Ferry', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.838672, -73.859359);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12149', 'S', 'Richmondville', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.632159, -74.56396);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12149', 'S', 'West Richmondville', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.632159, -74.56396);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12150', 'S', 'Rotterdam Junction', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.87668, -74.043438);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12151', 'S', 'Round Lake', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.933359, -73.793211);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12151', 'S', 'Ushers', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.933359, -73.793211);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12153', 'S', 'Sand Lake', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.6371, -73.491691);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12153', 'S', 'Taborton', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.6371, -73.491691);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12154', 'S', 'Easton', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.897909, -73.589565);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12154', 'S', 'Schaghticoke', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.897909, -73.589565);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12155', 'S', 'Elk Creek', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.551154, -74.82389);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12155', 'S', 'Fergusonville', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.551154, -74.82389);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12155', 'S', 'Schenevus', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.551154, -74.82389);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12155', 'S', 'Simpsonville', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.551154, -74.82389);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12155', 'S', 'Westville', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.551154, -74.82389);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12156', 'S', 'Schodack Landing', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.488375, -73.730065);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12157', 'S', 'Schoharie', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.668153, -74.311743);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12158', 'S', 'Beckers Corners', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.551716, -73.817741);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12158', 'S', 'Selkirk', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.551716, -73.817741);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12159', 'S', 'Slingerlands', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.642796, -73.877696);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12160', 'S', 'Sloansville', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.76266, -74.372274);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12161', 'P', 'South Bethlehem', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.535245, -73.89339);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12164', 'S', 'Speculator', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.557902, -74.357613);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12165', 'S', 'Spencertown', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.320381, -73.548607);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12166', 'S', 'Charleston Four Corners', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.839353, -74.461911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12166', 'S', 'Lykers', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.839353, -74.461911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12166', 'S', 'Root', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.839353, -74.461911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12166', 'S', 'Rural Grove', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.839353, -74.461911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12166', 'S', 'Sprakers', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.839353, -74.461911);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12167', 'S', 'Stamford', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.407598, -74.619982);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12168', 'S', 'Stephentown', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.535601, -73.383666);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12168', 'S', 'Stephentown Center', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.535601, -73.383666);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12169', 'S', 'Stephentown', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.562, -73.367385);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12170', 'S', 'Bemis Heights', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.984499, -73.666001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12170', 'S', 'Stillwater', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.984499, -73.666001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12172', 'P', 'Stottville', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.287538, -73.742015);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12173', 'S', 'Newton Hook', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.384753, -73.770358);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12173', 'S', 'Stuyvesant', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.384753, -73.770358);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12174', 'P', 'Stuyvesant Falls', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.351815, -73.733223);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12175', 'S', 'Summit', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.533016, -74.53883);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12176', 'S', 'Surprise', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.359083, -73.950092);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12177', 'P', 'Tribes Hill', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.95363, -74.291341);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12179', 'U', 'Troy', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.732972, -73.678887);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Albia', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Brunswick', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Center Brunswick', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Eagle Mills', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Raymertown', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Snyders Corners', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Snyders Lake', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Speigletown', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Sycaway', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12180', 'S', 'Troy', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.719804, -73.657008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12181', 'P', 'Troy', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.731923, -73.686799);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12182', 'S', 'Lansingburg', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.775992, -73.660085);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12182', 'S', 'Pleasantdale', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.775992, -73.660085);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12182', 'S', 'Speigletown', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.775992, -73.660085);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12182', 'S', 'Troy', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.775992, -73.660085);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12183', 'S', 'Green Island', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.744346, -73.695668);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12183', 'S', 'Troy', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.744346, -73.695668);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12184', 'S', 'Chatham Center', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.412809, -73.673072);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12184', 'S', 'Valatie', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.412809, -73.673072);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12185', 'S', 'Valley Falls', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.88714, -73.544884);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12185', 'S', 'West Valley Falls', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.88714, -73.544884);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12186', 'S', 'Reidsville', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.647963, -73.937714);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12186', 'S', 'Voorheesville', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.647963, -73.937714);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12187', 'S', 'Patria', 'N', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.614747, -74.475755);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12187', 'S', 'Warnerville', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.614747, -74.475755);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12188', 'S', 'Waterford', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.804301, -73.693679);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12189', 'S', 'Mannville', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.726113, -73.713355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12189', 'S', 'Maplewood', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.726113, -73.713355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12189', 'S', 'Watervliet', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.726113, -73.713355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12190', 'S', 'Gilmantown', 'N', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.475882, -74.270426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12190', 'S', 'Wells', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.475882, -74.270426);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12192', 'S', 'Coxsackie', 'N', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.367858, -73.828696);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12192', 'S', 'West Coxsackie', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.367858, -73.828696);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12193', 'S', 'Westerlo', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.540237, -74.045892);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12194', 'S', 'West Fulton', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.53856, -74.454716);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12195', 'P', 'West Lebanon', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.490534, -73.448183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12196', 'S', 'West Sand Lake', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.627847, -73.632094);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12197', 'S', 'Decatur', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.594213, -74.748114);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12197', 'S', 'South Worcester', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.594213, -74.748114);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12197', 'S', 'Worcester', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.594213, -74.748114);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12198', 'S', 'North Greenbush', 'N', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.688254, -73.640164);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12198', 'S', 'Wynantskill', 'D', 'Rensselaer', '36083', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.688254, -73.640164);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12201', 'P', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.648322, -73.751608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12202', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.639674, -73.769661);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12203', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679949, -73.832153);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12203', 'S', 'Mc Kownville', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679949, -73.832153);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12203', 'S', 'McKownville', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679949, -73.832153);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12203', 'S', 'Pine', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679949, -73.832153);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12203', 'S', 'Westmere', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679949, -73.832153);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12204', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.685128, -73.737123);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12204', 'S', 'Menands', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.685128, -73.737123);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12205', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.714746, -73.821155);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12205', 'S', 'Colonie', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.714746, -73.821155);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12205', 'S', 'Colonie Center', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.714746, -73.821155);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12205', 'S', 'Roessleville', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.714746, -73.821155);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12206', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.67297, -73.77601);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12207', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.652365, -73.754418);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12208', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.652812, -73.807109);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12209', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.641762, -73.788358);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12210', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.654387, -73.75738);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12211', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.707382, -73.772002);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12211', 'S', 'Loudonville', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.707382, -73.772002);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12211', 'S', 'Siena', 'A', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.707382, -73.772002);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12212', 'P', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.67967, -73.840113);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12214', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.686317, -73.846929);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12220', 'P', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.664897, -73.883261);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12222', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.693234, -73.838124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12223', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.651781, -73.757949);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12224', 'P', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.664656, -73.841729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12225', 'P', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.682259, -73.838108);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12226', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.684962, -73.807547);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12227', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.689555, -73.845984);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12228', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.645681, -73.756663);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12229', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.650418, -73.814413);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12230', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.6547, -73.757766);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12231', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.656061, -73.760129);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12232', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.652603, -73.754055);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12233', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.649243, -73.755554);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12234', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.671814, -73.736501);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12235', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.649742, -73.756061);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12236', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.651877, -73.758413);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12237', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.645888, -73.797658);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12238', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.652025, -73.761447);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12239', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.650821, -73.758546);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12240', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.651487, -73.7569);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12241', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.630394, -73.761975);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12242', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.652754, -73.757551);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12243', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.653793, -73.746424);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12244', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.651521, -73.761175);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12245', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.671218, -73.772898);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12246', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.689007, -73.821157);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12247', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.68227, -73.727879);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12248', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.653981, -73.758374);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12249', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.697178, -73.994306);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12250', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.673005, -73.735244);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12252', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.648263, -73.761928);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12255', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.654469, -73.759719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12256', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.651907, -73.758318);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12257', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.653571, -73.757472);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12260', 'S', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.669387, -73.773554);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12261', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.679058, -73.782986);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12262', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.717487, -73.826454);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12288', 'U', 'Albany', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.728717, -73.847757);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12301', 'P', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.813236, -73.939399);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12302', 'S', 'East Glenville', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.856481, -73.956093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12302', 'S', 'Glenville', 'A', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.856481, -73.956093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12302', 'S', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.856481, -73.956093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12302', 'S', 'Scotia', 'A', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.856481, -73.956093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12302', 'S', 'Stoodley Corners', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.856481, -73.956093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12303', 'S', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.783122, -73.938595);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12304', 'S', 'Brandywine', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.780295, -73.909969);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12304', 'S', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.780295, -73.909969);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12305', 'S', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.814529, -73.943411);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12306', 'S', 'Bellevue', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.792392, -73.984961);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12306', 'S', 'Lower Rotterdam', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.792392, -73.984961);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12306', 'S', 'Rotterdam', 'A', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.792392, -73.984961);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12306', 'S', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.792392, -73.984961);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12307', 'S', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.802385, -73.93657);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12308', 'S', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.820842, -73.91998);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12309', 'S', 'Niskayuna', 'A', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.802944, -73.880986);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12309', 'S', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.802944, -73.880986);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12309', 'S', 'Upper Union', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.802944, -73.880986);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12325', 'P', 'Glenville', 'A', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.869886, -73.934515);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12325', 'P', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.869886, -73.934515);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12345', 'U', 'Schdy', 'N', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.815656, -73.942324);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12345', 'U', 'Schenectady', 'D', 'Schenectady', '36093', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.815656, -73.942324);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12401', 'S', 'Eddyville', 'A', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.930217, -74.009783);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12401', 'S', 'Kingston', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.930217, -74.009783);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12401', 'S', 'Saint Remy', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.930217, -74.009783);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12402', 'P', 'Kingston', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.932386, -74.032331);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12404', 'S', 'Accord', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.797423, -74.238287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12404', 'S', 'Leibhardt', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.797423, -74.238287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12404', 'S', 'Lyonsville', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.797423, -74.238287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12404', 'S', 'Mettacahonts', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.797423, -74.238287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12404', 'S', 'Whitfield', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.797423, -74.238287);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12405', 'S', 'Acra', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.332936, -74.093813);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12405', 'S', 'South Durham', 'N', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.332936, -74.093813);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12406', 'S', 'Arkville', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.108167, -74.530179);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12407', 'S', 'Ashland', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.241195, -74.305935);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12409', 'S', 'Bearsville', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.034034, -74.187802);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12409', 'S', 'Shady', 'A', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.034034, -74.187802);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12410', 'S', 'Big Indian', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.071132, -74.461292);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12410', 'S', 'Oliverea', 'A', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.071132, -74.461292);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12411', 'S', 'Bloomington', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.877055, -74.043228);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12412', 'S', 'Boiceville', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.004425, -74.261329);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12413', 'S', 'Cairo', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.28797, -73.98071);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12414', 'S', 'Catskill', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.224593, -73.874142);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12414', 'S', 'Cementon', 'A', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.224593, -73.874142);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12416', 'S', 'Chichester', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.090912, -74.268664);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12417', 'P', 'Connelly', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.911892, -73.994188);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12418', 'S', 'Cornwallville', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.379172, -74.126219);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12419', 'S', 'Cottekill', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.850267, -74.115043);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12420', 'P', 'Cragsmoor', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.670081, -74.385271);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12421', 'S', 'Denver', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.270333, -74.531212);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12422', 'S', 'Durham', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.409931, -74.182742);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12422', 'S', 'West Durham', 'N', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.409931, -74.182742);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12423', 'S', 'East Durham', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.388331, -74.13671);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12424', 'S', 'East Jewett', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.275928, -74.211251);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12424', 'S', 'Tannersville', 'A', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.275928, -74.211251);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12427', 'S', 'Elka Park', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.185227, -74.13212);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12428', 'S', 'Ellenville', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.723241, -74.408003);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12429', 'P', 'Esopus', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.837603, -73.995484);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12430', 'S', 'Fleischmanns', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.202662, -74.513418);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12430', 'S', 'Halcott Center', 'A', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.202662, -74.513418);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12431', 'S', 'Freehold', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.377411, -74.056683);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12432', 'P', 'Glasco', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.01853, -73.961443);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12433', 'S', 'Glenford', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.008101, -74.15142);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12434', 'S', 'Grand Gorge', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.385715, -74.527852);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12435', 'S', 'Greenfield Park', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.714155, -74.495343);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12436', 'P', 'Haines Falls', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.194504, -74.11845);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12438', 'P', 'Halcottsville', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.208259, -74.60121);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12439', 'S', 'East Windham', 'A', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.277709, -74.228317);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12439', 'S', 'Hensonville', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.277709, -74.228317);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12440', 'S', 'High Falls', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.820309, -74.126454);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12441', 'P', 'Highmount', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.143627, -74.489371);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12442', 'S', 'Hunter', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.215149, -74.200233);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12443', 'S', 'Hurley', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.924537, -74.067379);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12444', 'S', 'Jewett', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.270415, -74.31588);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12446', 'S', 'Cherrytown', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.780862, -74.289154);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12446', 'S', 'Kerhonkson', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.780862, -74.289154);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12448', 'S', 'Lake Hill', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.072851, -74.210051);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12449', 'S', 'Lake Katrine', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.997672, -74.003214);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12450', 'S', 'Lanesville', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.134503, -74.264765);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12451', 'S', 'Leeds', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.305672, -73.944172);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12452', 'P', 'Lexington', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.24021, -74.364377);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12453', 'P', 'Malden', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.094637, -73.933788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12453', 'P', 'Malden Hudson', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.094637, -73.933788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12453', 'P', 'Malden on Hudson', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.094637, -73.933788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12453', 'P', 'Mldn on Hdsn', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.094637, -73.933788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12454', 'S', 'Maplecrest', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.289106, -74.147239);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12455', 'S', 'Margaretville', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.080931, -74.582959);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12456', 'S', 'Mount Marion', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.981905, -74.03299);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12456', 'S', 'Mount Merion Park', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.981905, -74.03299);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12457', 'S', 'Mount Tremper', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.04216, -74.258837);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12458', 'S', 'Napanoch', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.813621, -74.413644);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12459', 'P', 'New Kingston', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.211411, -74.683175);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12460', 'S', 'Oak Hill', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.411793, -74.148999);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12461', 'S', 'Krumville', 'A', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.918797, -74.235536);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12461', 'S', 'Olive', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.918797, -74.235536);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12461', 'S', 'Olivebridge', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.918797, -74.235536);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12461', 'S', 'Samsonville', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.918797, -74.235536);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12463', 'S', 'Palenville', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.174316, -74.021686);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12464', 'S', 'Phoenicia', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.997088, -74.334644);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12465', 'S', 'Pine Hill', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.129525, -74.481912);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12466', 'S', 'Port Ewen', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.904729, -73.979877);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12468', 'S', 'Prattsville', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.294988, -74.396044);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12468', 'S', 'Red Falls', 'N', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.294988, -74.396044);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12469', 'S', 'Preston Hlow', 'N', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.441139, -74.233147);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12469', 'S', 'Preston Hollow', 'D', 'Albany', '36001', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.441139, -74.233147);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12470', 'S', 'Purling', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.270473, -74.008879);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12471', 'P', 'Rifton', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.832741, -74.03745);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12472', 'S', 'Rosendale', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.846911, -74.073956);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12473', 'S', 'Round Top', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.270121, -74.070612);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12474', 'S', 'Hubbell Cors', 'N', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.287672, -74.561318);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12474', 'S', 'Roxbury', 'D', 'Delaware', '36025', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.287672, -74.561318);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12475', 'P', 'Ruby', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.019102, -74.010805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12477', 'S', 'Saugerties', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.072858, -73.981989);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12477', 'S', 'West Saugerties', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.072858, -73.981989);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12480', 'S', 'Shandaken', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.115562, -74.392622);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12481', 'S', 'Shokan', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.976701, -74.217025);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12482', 'S', 'South Cairo', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.274889, -73.952337);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12483', 'P', 'Spring Glen', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.664498, -74.428203);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12484', 'S', 'Stone Ridge', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.866602, -74.175833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12484', 'S', 'The Vly', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.866602, -74.175833);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12485', 'S', 'Tannersville', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.194261, -74.134684);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12486', 'S', 'Tillson', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.841672, -74.05452);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12487', 'S', 'Ulster Park', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.866568, -73.99021);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12489', 'P', 'Wawarsing', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.759074, -74.357613);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12490', 'P', 'West Camp', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.122589, -73.934344);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12491', 'S', 'West Hurley', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.006495, -74.105729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12492', 'S', 'West Kill', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.21917, -74.413218);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12493', 'P', 'West Park', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.810969, -74.003333);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12494', 'S', 'West Shokan', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.945647, -74.291909);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12495', 'S', 'Willow', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.091198, -74.202183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12496', 'S', 'Windham', 'D', 'Greene', '36039', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.305984, -74.221683);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12498', 'S', 'Woodstock', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.032936, -74.116116);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12501', 'S', 'Amenia', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.848904, -73.54105);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12502', 'S', 'Ancram', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.085918, -73.659775);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12503', 'S', 'Ancramdale', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.037624, -73.62789);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12504', 'P', 'Annandale', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '914', 'Eastern', -5, 'Y', 42.012397, -73.898328);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12504', 'P', 'Annandale on Hudson', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 42.012397, -73.898328);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12504', 'P', 'Red Hook', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '914', 'Eastern', -5, 'Y', 42.012397, -73.898328);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12506', 'P', 'Bangall', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.875132, -73.690376);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12507', 'S', 'Barrytown', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.993499, -73.92256);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12507', 'S', 'Red Hook', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.993499, -73.92256);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12508', 'S', 'Beacon', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.502328, -73.95485);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12510', 'P', 'Billings', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.672319, -73.762471);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12511', 'P', 'Castle Point', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.528219, -73.963443);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12512', 'P', 'Chelsea', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.554815, -73.965035);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12513', 'S', 'Claverack', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.22224, -73.734878);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12514', 'S', 'Clinton Corners', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.82598, -73.788494);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12514', 'S', 'Clinton Crn', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.82598, -73.788494);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12515', 'S', 'Clintondale', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.697609, -74.063101);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12516', 'S', 'Copake', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.118527, -73.556302);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12517', 'S', 'Copake Falls', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.139997, -73.500933);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12518', 'S', 'Cornwall', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.432794, -74.045095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12520', 'S', 'Cornwall on Hudson', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.442299, -74.015486);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12521', 'S', 'Craryville', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.158335, -73.611737);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12522', 'S', 'Dover Plains', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.718078, -73.605767);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12523', 'S', 'Elizaville', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 42.0726, -73.792544);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12524', 'S', 'Fishkill', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.541709, -73.902683);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12525', 'S', 'Gardiner', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.662675, -74.149433);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12526', 'S', 'Cheviot', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.116017, -73.859202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12526', 'S', 'Clermont', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.116017, -73.859202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12526', 'S', 'Germantown', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.116017, -73.859202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12526', 'S', 'Linlithgo', 'N', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.116017, -73.859202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12527', 'P', 'Glenham', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.521756, -73.937292);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12528', 'S', 'Highland', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.719051, -73.994305);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12529', 'S', 'Hillsdale', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.180067, -73.520311);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12530', 'P', 'Hollowville', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.225766, -73.677514);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12531', 'S', 'Holmes', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.531936, -73.669087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12531', 'S', 'Homes', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.531936, -73.669087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12531', 'S', 'Whaley Lake', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.531936, -73.669087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12533', 'S', 'East Fishkill', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.57359, -73.796075);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12533', 'S', 'Hopewell', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.57359, -73.796075);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12533', 'S', 'Hopewell Junction', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.57359, -73.796075);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12533', 'S', 'Wiccopee', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.57359, -73.796075);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12534', 'S', 'Hudson', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.248254, -73.774447);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12537', 'P', 'Hughsonville', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.583149, -73.927217);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12538', 'S', 'Hyde Park', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.785136, -73.903791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12540', 'S', 'La Grange', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.652678, -73.741597);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12540', 'S', 'Lagrangeville', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.652678, -73.741597);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12541', 'P', 'Livingston', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.141513, -73.7782);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12542', 'S', 'Marlboro', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.608715, -73.992141);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12542', 'S', 'Marlborough', 'N', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.608715, -73.992141);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12543', 'S', 'Maybrook', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.486349, -74.212862);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12544', 'P', 'Mellenville', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.250628, -73.666472);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12545', 'S', 'Millbrook', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.797249, -73.692479);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12546', 'S', 'Millerton', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '518', 'Eastern', -5, 'Y', 41.997293, -73.543272);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12547', 'S', 'Milton', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.655535, -73.977058);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12548', 'S', 'Modena', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.655818, -74.112788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12549', 'S', 'Montgomery', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.525576, -74.236316);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12550', 'S', 'Balmville', 'N', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.510296, -74.053975);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12550', 'S', 'Middle Hope', 'N', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.510296, -74.053975);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12550', 'S', 'Newburgh', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.510296, -74.053975);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12551', 'P', 'Newburgh', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.540771, -74.046731);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12552', 'P', 'Newburgh', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.538018, -74.049012);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12553', 'S', 'New Windsor', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.475138, -74.05178);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12553', 'S', 'Newburgh', 'A', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.475138, -74.05178);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12555', 'P', 'Mid Hudson', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.508604, -74.013373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12555', 'P', 'Newburgh', 'N', 'Orange', '36071', 'New York', 'NY', '36', '5660', '914', 'Eastern', -5, 'Y', 41.508604, -74.013373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12561', 'S', 'New Paltz', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.740002, -74.095014);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12563', 'S', 'Patterson', 'D', 'Putnam', '36079', 'New York', 'NY', '36', '5600', '845', 'Eastern', -5, 'Y', 41.503033, -73.577046);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12564', 'S', 'Pawling', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.56593, -73.59145);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12565', 'P', 'Philmont', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.24815, -73.649027);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12566', 'S', 'Pine Bush', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.605775, -74.305189);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12567', 'S', 'Gallatin', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '518', 'Eastern', -5, 'Y', 42.048015, -73.597053);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12567', 'S', 'Mount Ross', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '518', 'Eastern', -5, 'Y', 42.048015, -73.597053);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12567', 'S', 'Pine Plains', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '518', 'Eastern', -5, 'Y', 42.048015, -73.597053);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12567', 'S', 'Shekomeko', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '518', 'Eastern', -5, 'Y', 42.048015, -73.597053);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12568', 'P', 'Plattekill', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.612267, -74.06228);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12569', 'S', 'Pleasant Valley', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.746335, -73.817266);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12570', 'S', 'Poughquag', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.644619, -73.674092);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12571', 'S', 'Milan', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 42.000773, -73.875034);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12571', 'S', 'Red Hook', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 42.000773, -73.875034);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12572', 'S', 'Rhinebeck', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.926105, -73.894669);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12574', 'P', 'Rhinecliff', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.910591, -73.951351);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12575', 'S', 'Rock Tavern', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.473305, -74.146634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12577', 'S', 'Salisbury Mills', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.433031, -74.1214);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12578', 'S', 'Salt Point', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.796696, -73.794052);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12580', 'S', 'Staatsburg', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.846035, -73.910551);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12580', 'S', 'Staatsburgh', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.846035, -73.910551);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12581', 'S', 'Stanfordville', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.890719, -73.666476);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12582', 'S', 'Stormville', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.543279, -73.725207);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12583', 'S', 'Nevis', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 42.060554, -73.914126);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12583', 'S', 'Tivoli', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 42.060554, -73.914126);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12584', 'P', 'Vails Gate', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.466225, -74.049239);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12585', 'S', 'Verbank', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.719922, -73.70086);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12586', 'S', 'Walden', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.562389, -74.173819);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12588', 'P', 'Walker Valley', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.633499, -74.377182);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12589', 'S', 'Wallkill', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.617824, -74.149503);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12590', 'S', 'New Hamburg', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.595832, -73.88745);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12590', 'S', 'Wappinger', 'N', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.595832, -73.88745);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12590', 'S', 'Wappingers Falls', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.595832, -73.88745);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12592', 'S', 'Wassaic', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.78198, -73.545429);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12593', 'P', 'Copake', 'A', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.09729, -73.585764);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12593', 'P', 'West Copake', 'D', 'Columbia', '36021', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 42.09729, -73.585764);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12594', 'S', 'Wingdale', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.669591, -73.558676);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12601', 'S', 'Poughkeepsie', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.701664, -73.916805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12602', 'P', 'Poughkeepsie', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.706233, -73.92854);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12603', 'S', 'Arlington', 'A', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.671733, -73.874295);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12603', 'S', 'Poughkeepsie', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.671733, -73.874295);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12604', 'U', 'Poughkeepsie', 'D', 'Dutchess', '36027', 'New York', 'NY', '36', '2281', '845', 'Eastern', -5, 'Y', 41.685996, -73.896069);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12701', 'S', 'Monticello', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.654176, -74.694961);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12719', 'S', 'Barryville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.483085, -74.910653);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12720', 'S', 'Bethel', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.662164, -74.907661);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12721', 'S', 'Bloomingburg', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.551493, -74.452492);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12722', 'P', 'Burlingham', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.589021, -74.383635);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12723', 'S', 'Callicoon', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.781826, -74.983676);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12724', 'P', 'Callicoon Center', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.839043, -74.946526);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12725', 'S', 'Claryville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.974754, -74.541152);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12726', 'S', 'Cochecton', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.696891, -74.978617);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12727', 'P', 'Cochecton Center', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.640608, -74.96813);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12729', 'S', 'Cuddebackville', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.485047, -74.627581);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12729', 'S', 'Godeffroy', 'A', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.485047, -74.627581);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12732', 'S', 'Eldred', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.526668, -74.889314);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12733', 'S', 'Fallsburg', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.735601, -74.613484);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12734', 'S', 'Ferndale', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.726667, -74.762909);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12736', 'S', 'Fremont', 'N', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.848718, -75.02435);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12736', 'S', 'Fremont Center', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.848718, -75.02435);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12737', 'S', 'Glen Spey', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.476622, -74.789321);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12738', 'S', 'Glen Wild', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.63425, -74.594325);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12740', 'S', 'Grahamsville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.888409, -74.521026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12741', 'S', 'Hankins', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.826399, -75.100729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12742', 'S', 'Harris', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.718078, -74.72847);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12743', 'S', 'Highland Lake', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.526306, -74.846729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12745', 'S', 'Hortonville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.787313, -75.028169);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12746', 'S', 'Huguenot', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.412347, -74.641586);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12747', 'S', 'Hurleyville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.769272, -74.658509);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12748', 'S', 'Jeffersonville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.775544, -74.913411);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12749', 'P', 'Kauneonga Lake', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.690769, -74.844513);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12750', 'S', 'Kenoza Lake', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.778207, -74.93345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12751', 'S', 'Kiamesha Lake', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.680968, -74.674693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12752', 'S', 'Lake Huntington', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.687177, -74.991409);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12754', 'S', 'Liberty', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.798793, -74.749431);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12758', 'S', 'Lew Beach', 'A', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.912654, -74.754347);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12758', 'S', 'Livingston Manor', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.912654, -74.754347);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12759', 'S', 'Loch Sheldrake', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.775391, -74.653289);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12760', 'S', 'Long Eddy', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.869262, -75.080306);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12762', 'S', 'Mongaup Valley', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.688622, -74.802774);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12763', 'S', 'Mountain Dale', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.691362, -74.525101);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12763', 'S', 'Mountaindale', 'N', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.691362, -74.525101);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12764', 'S', 'Narrowsburg', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.587155, -74.978315);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12765', 'S', 'Neversink', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.853274, -74.62189);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12766', 'S', 'North Branch', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.807528, -74.998309);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12767', 'P', 'Obernburg', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.846503, -75.007705);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12768', 'S', 'Parksville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.868458, -74.721907);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12769', 'P', 'Phillipsport', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.649429, -74.439099);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12770', 'S', 'Pond Eddy', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.454785, -74.852456);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12771', 'S', 'Port Jervis', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.373715, -74.665744);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12775', 'S', 'Rock Hill', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.616893, -74.583219);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12776', 'S', 'Roscoe', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 41.966965, -74.930453);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12777', 'S', 'Forestburg', 'N', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.59597, -74.714814);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12777', 'S', 'Forestburgh', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.59597, -74.714814);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12777', 'S', 'Monticello', 'A', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.59597, -74.714814);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12778', 'P', 'Smallwood', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.663676, -74.820124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12779', 'S', 'South Fallsburg', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.709537, -74.635185);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12780', 'S', 'Sparrow Bush', 'D', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.432778, -74.720524);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12780', 'S', 'Sparrowbush', 'A', 'Orange', '36071', 'New York', 'NY', '36', '5660', '845', 'Eastern', -5, 'Y', 41.432778, -74.720524);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12781', 'P', 'Summitville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.61928, -74.448438);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12782', 'S', 'Grahamsville', 'A', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '914', 'Eastern', -5, 'Y', 41.821084, -74.534384);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12782', 'S', 'Sundown', 'D', 'Ulster', '36111', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.821084, -74.534384);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12783', 'S', 'Swan Lake', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.740653, -74.792651);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12784', 'P', 'Thompsonville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.671144, -74.626556);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12785', 'P', 'Port Jervis', 'A', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.495716, -74.561461);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12785', 'P', 'Westbrookville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.495716, -74.561461);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12786', 'S', 'White Lake', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.648614, -74.870751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12787', 'S', 'White Sulphur Springs', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.7898, -74.82839);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12788', 'S', 'Woodbourne', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.807448, -74.609122);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12789', 'S', 'Woodridge', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.693208, -74.58433);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12790', 'S', 'Wurtsboro', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.590168, -74.526249);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12791', 'S', 'Youngsville', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.80509, -74.885943);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12792', 'S', 'Yulan', 'D', 'Sullivan', '36105', 'New York', 'NY', '36', '0000', '845', 'Eastern', -5, 'Y', 41.521354, -74.929301);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12801', 'S', 'Glens Falls', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.318508, -73.659865);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12801', 'S', 'Queensbury', 'A', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.318508, -73.659865);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12801', 'S', 'West Glens Falls', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.318508, -73.659865);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12803', 'S', 'Glens Falls', 'A', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.288989, -73.639429);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12803', 'S', 'South Glens Falls', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.288989, -73.639429);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12804', 'S', 'Glens Falls', 'A', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.325733, -73.67717);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12804', 'S', 'Queensbury', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.325733, -73.67717);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12808', 'S', 'Adirondack', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.733474, -73.757263);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12809', 'S', 'Argyle', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.220516, -73.489771);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12809', 'S', 'North Argyle', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.220516, -73.489771);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12809', 'S', 'South Argyle', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.220516, -73.489771);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12810', 'S', 'Athol', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.491212, -73.896855);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12811', 'P', 'Bakers Mills', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.612146, -74.025481);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12812', 'S', 'Blue Mountain Lake', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.835368, -74.426553);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12814', 'S', 'Bolton Landing', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.559596, -73.66336);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12815', 'S', 'Brant Lake', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.69447, -73.724373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12815', 'S', 'Horicon', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.69447, -73.724373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12816', 'S', 'Cambridge', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.027046, -73.384267);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12816', 'S', 'Center Cambridge', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.027046, -73.384267);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12816', 'S', 'Coila', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.027046, -73.384267);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12817', 'S', 'Chestertown', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.63599, -73.803616);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12819', 'S', 'Clemons', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.639502, -73.441071);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12820', 'P', 'Cleverdale', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.471968, -73.639216);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12820', 'P', 'Rockhurst', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.471968, -73.639216);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12821', 'S', 'Comstock', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.462256, -73.370925);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12822', 'S', 'Corinth', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.242443, -73.838394);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12822', 'S', 'Palmer', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.242443, -73.838394);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12823', 'S', 'Cossayuna', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.197597, -73.424771);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12823', 'S', 'Cossayuna Lake', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.197597, -73.424771);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12824', 'S', 'Diamond Point', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.512019, -73.694418);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12824', 'S', 'Trout Lake', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.512019, -73.694418);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12827', 'S', 'Fort Ann', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.418917, -73.51921);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12827', 'S', 'South Bay Village', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.418917, -73.51921);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12827', 'S', 'West Fort Ann', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.418917, -73.51921);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12828', 'S', 'Fort Edward', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.271395, -73.58739);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12828', 'S', 'Fort Miller', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.271395, -73.58739);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12831', 'S', 'Fortsville', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.181659, -73.692634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12831', 'S', 'Gansevoort', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.181659, -73.692634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12831', 'S', 'Gurn Spring', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.181659, -73.692634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12831', 'S', 'Kings Station', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.181659, -73.692634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12831', 'S', 'Wilton', 'A', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.181659, -73.692634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12832', 'S', 'Granville', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.403707, -73.26626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12832', 'S', 'Hebron', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.403707, -73.26626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12832', 'S', 'North Hebron', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.403707, -73.26626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12832', 'S', 'Slateville', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.403707, -73.26626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12832', 'S', 'South Granville', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.403707, -73.26626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12832', 'S', 'Truthville', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.403707, -73.26626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12833', 'S', 'Greenfield', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.1292, -73.858864);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12833', 'S', 'Greenfield Center', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.1292, -73.858864);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12834', 'S', 'Bald Mountain', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.090326, -73.50008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12834', 'S', 'Battenville', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.090326, -73.50008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12834', 'S', 'Clarks Mills', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.090326, -73.50008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12834', 'S', 'Greenwich', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.090326, -73.50008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12834', 'S', 'Thomson', 'A', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.090326, -73.50008);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12835', 'S', 'Conklingville', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.312842, -73.90869);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12835', 'S', 'Day', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.312842, -73.90869);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12835', 'S', 'Hadley', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.312842, -73.90869);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12836', 'S', 'Graphite', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.788709, -73.497895);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12836', 'S', 'Hague', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.788709, -73.497895);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12837', 'S', 'Hampton', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.468193, -73.271446);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12838', 'S', 'Hartford', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.335141, -73.402119);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12839', 'S', 'Hudson Falls', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.306163, -73.582006);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12839', 'S', 'Kingsbury', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.306163, -73.582006);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12839', 'S', 'Sandy Hill', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.306163, -73.582006);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12839', 'S', 'Smiths Basin', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.306163, -73.582006);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12841', 'P', 'Huletts Landing', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.640008, -73.506355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12842', 'S', 'Indian Lake', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.746756, -74.262085);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12843', 'S', 'Garnet Lake', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.591775, -74.076767);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12843', 'S', 'Johnsburg', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.591775, -74.076767);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12844', 'S', 'Kattskill Bay', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.48879, -73.630188);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12844', 'S', 'Pilot Knob', 'A', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.48879, -73.630188);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12845', 'S', 'Assembly Point', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.422435, -73.709683);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12845', 'S', 'Lake George', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.422435, -73.709683);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12846', 'S', 'Lake Luzerne', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.318047, -73.818377);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12846', 'S', 'Luzerne', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.318047, -73.818377);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12847', 'S', 'Brandreth', 'N', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.95228, -74.443935);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12847', 'S', 'Long Lake', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.95228, -74.443935);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12847', 'S', 'Sabattis', 'N', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.95228, -74.443935);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12848', 'P', 'Middle Falls', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.102413, -73.526359);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12849', 'S', 'Middle Granville', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.451548, -73.301373);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12850', 'S', 'Barkersville', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.084224, -73.949846);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12850', 'S', 'Lake Desolation', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.084224, -73.949846);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12850', 'S', 'Middle Grove', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.084224, -73.949846);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12850', 'S', 'Providence', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.084224, -73.949846);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12851', 'S', 'Minerva', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.769475, -73.994003);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12852', 'S', 'Newcomb', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.017069, -74.127361);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12853', 'S', 'Holcombville', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.70876, -73.914746);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12853', 'S', 'Igerna', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.70876, -73.914746);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12853', 'S', 'North Creek', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.70876, -73.914746);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12854', 'S', 'North Granville', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.507018, -73.335407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12855', 'S', 'North Hudson', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.002417, -73.80035);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12856', 'P', 'North River', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.740463, -74.050649);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12857', 'S', 'Olmstedville', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.863707, -74.064209);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12858', 'S', 'Paradox', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.878878, -73.401475);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12858', 'S', 'Paradox Lake', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.878878, -73.401475);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12858', 'S', 'Ticonderoga', 'A', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.878878, -73.401475);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12859', 'S', 'Porter Corners', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.164848, -73.89148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12860', 'S', 'Pottersville', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.697539, -73.757282);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12861', 'S', 'Putnam Station', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.749622, -73.417889);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12862', 'P', 'Riparius', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.66166, -73.897245);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12863', 'S', 'Rock City Falls', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.06261, -73.924524);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12864', 'P', 'Sabael', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.728403, -74.305522);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12865', 'S', 'Belcher', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.152744, -73.342735);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12865', 'S', 'East Greenwich', 'A', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.152744, -73.342735);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12865', 'S', 'East Hebron', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.152744, -73.342735);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12865', 'S', 'Salem', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.152744, -73.342735);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12865', 'S', 'West Hebron', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.152744, -73.342735);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12866', 'S', 'Saratoga Springs', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.075993, -73.774821);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12870', 'S', 'Blue Ridge', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.850677, -73.770387);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12870', 'S', 'Schroon Lake', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.850677, -73.770387);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12871', 'S', 'Bacon Hill', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.095063, -73.607659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12871', 'S', 'Grangerville', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.095063, -73.607659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12871', 'S', 'Quaker Springs', 'N', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.095063, -73.607659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12871', 'S', 'Schuylerville', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.095063, -73.607659);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12872', 'P', 'Severance', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.884025, -73.72439);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12873', 'S', 'Eagleville', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.127464, -73.30747);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12873', 'S', 'Shushan', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.127464, -73.30747);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12874', 'S', 'Sabbath Day Point', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.705144, -73.515745);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12874', 'S', 'Silver Bay', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.705144, -73.515745);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12878', 'S', 'Stony Creek', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.426602, -73.962388);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12879', 'S', 'Newcomb', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.018002, -74.12899);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12879', 'S', 'Tahawus', 'A', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.018002, -74.12899);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12883', 'S', 'Chilson', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.843857, -73.431459);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12883', 'S', 'Eagle Lake', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.843857, -73.431459);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12883', 'S', 'Streetroad', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.843857, -73.431459);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12883', 'S', 'Ticonderoga', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.843857, -73.431459);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12884', 'P', 'Victory Mills', 'D', 'Saratoga', '36091', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 43.088703, -73.594357);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12885', 'S', 'Riverbank', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.500656, -73.787701);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12885', 'S', 'The Glen', 'N', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.500656, -73.787701);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12885', 'S', 'Thurman', 'A', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.500656, -73.787701);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12885', 'S', 'Warrensburg', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.500656, -73.787701);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12886', 'S', 'Wevertown', 'D', 'Warren', '36113', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.435403, -73.719224);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12887', 'S', 'Dresden Station', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.544806, -73.407017);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12887', 'S', 'Low Hampton', 'N', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.544806, -73.407017);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12887', 'S', 'Whitehall', 'D', 'Washington', '36115', 'New York', 'NY', '36', '2975', '518', 'Eastern', -5, 'Y', 43.544806, -73.407017);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12901', 'S', 'Beekmantown', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.698423, -73.466263);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12901', 'S', 'Plattsburgh', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.698423, -73.466263);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12901', 'S', 'South Plattsburgh', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.698423, -73.466263);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12903', 'S', 'Plattsburgh', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.707491, -73.475457);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12910', 'S', 'Alder Bend', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.961446, -73.405016);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12910', 'S', 'Altona', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.961446, -73.405016);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12910', 'S', 'Irona', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.961446, -73.405016);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12910', 'S', 'Purdys Mills', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.961446, -73.405016);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12911', 'S', 'Au Sable Chasm', 'A', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.533729, -73.50029);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12911', 'S', 'Ausable Chasm', 'A', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.533729, -73.50029);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12911', 'S', 'Keeseville', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.533729, -73.50029);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12912', 'S', 'Au Sable Forks', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.439434, -73.675017);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12912', 'S', 'Hawkeye', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.439434, -73.675017);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12913', 'S', 'Bloomingdale', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.398502, -74.070744);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12914', 'S', 'Bombay', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.953343, -74.599279);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12915', 'P', 'Brainardsville', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.857117, -74.034613);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12916', 'S', 'Alburgh', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.827852, -74.530013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12916', 'S', 'Brushton', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.827852, -74.530013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12916', 'S', 'Cooks Corners', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.827852, -74.530013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12916', 'S', 'Irish Corners', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.827852, -74.530013);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12917', 'S', 'Burke', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.926563, -74.176701);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12918', 'S', 'Cadyville', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.672587, -73.664389);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12919', 'S', 'Champlain', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.951755, -73.450223);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12919', 'S', 'Coopersville', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.951755, -73.450223);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12919', 'S', 'Perrys Mills', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.951755, -73.450223);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12920', 'S', 'Chateaugay', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.92315, -74.082893);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12921', 'S', 'Chazy', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.889987, -73.466593);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12921', 'S', 'Chazy Landing', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.889987, -73.466593);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12922', 'S', 'Childwold', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.304455, -74.698838);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12923', 'S', 'Churubusco', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.952809, -73.933845);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12924', 'S', 'Clintonville', 'A', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.473734, -73.589677);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12924', 'S', 'Keeseville', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.473734, -73.589677);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12926', 'S', 'Constable', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.938046, -74.301384);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12926', 'S', 'Trout River', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.938046, -74.301384);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12926', 'S', 'Westville Center', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.938046, -74.301384);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12927', 'P', 'Cranberry Lake', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.220251, -74.832828);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12928', 'S', 'Crown Point', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.953682, -73.509936);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12928', 'S', 'Factoryville', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.953682, -73.509936);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12928', 'S', 'Ironville', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 43.953682, -73.509936);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12929', 'P', 'Dannemora', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.723692, -73.72178);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12930', 'S', 'Dickinson Center', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.71966, -74.535081);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12930', 'S', 'East Dickinson', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.71966, -74.535081);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12932', 'S', 'Elizabethtown', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.226627, -73.624732);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12933', 'P', 'Ellenburg', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.894704, -73.837993);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12934', 'S', 'Ellenburg Center', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.829883, -73.859154);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12935', 'S', 'Ellenburg Depot', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.845205, -73.720393);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12936', 'S', 'Essex', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.261839, -73.374299);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12936', 'S', 'Whallonsburg', 'A', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.261839, -73.374299);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12937', 'S', 'Fort Covington', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.956408, -74.489215);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12939', 'P', 'Gabriels', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.432868, -74.178382);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12941', 'S', 'Jay', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.353596, -73.71053);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12942', 'S', 'Keene', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.257018, -73.784256);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12943', 'S', 'Keene Valley', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.202582, -73.772843);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12943', 'S', 'Saint Huberts', 'A', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.202582, -73.772843);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12944', 'S', 'Keeseville', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.517191, -73.487669);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12945', 'S', 'Lake Clear', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.36656, -74.24733);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12945', 'S', 'Upper Saint Regis', 'A', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.36656, -74.24733);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12946', 'S', 'Lake Placid', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.281966, -73.988816);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12946', 'S', 'North Pole', 'A', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.281966, -73.988816);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12949', 'S', 'Lawrenceville', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.758806, -74.662758);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12950', 'S', 'Lewis', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.314607, -73.582276);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12952', 'S', 'Lyon Mountain', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.71815, -73.91882);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12952', 'S', 'Standish', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.71815, -73.91882);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12953', 'S', 'Duane', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.849409, -74.284928);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12953', 'S', 'Malone', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.849409, -74.284928);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12955', 'S', 'Lyon Mountain', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.793668, -73.965388);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12955', 'S', 'Merrill', 'A', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.793668, -73.965388);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12956', 'S', 'Grover Hills', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.078155, -73.517787);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12956', 'S', 'Mineville', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.078155, -73.517787);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12957', 'S', 'Moira', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.862955, -74.57239);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12957', 'S', 'South Bombay', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.862955, -74.57239);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12958', 'S', 'Mooers', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.961265, -73.581139);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12959', 'S', 'Mooers Forks', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.965896, -73.694298);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12960', 'S', 'Moriah', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.037103, -73.516791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12960', 'S', 'Moriah Corners', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.037103, -73.516791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12961', 'S', 'Moriah Center', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.053032, -73.53527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12962', 'S', 'Morrisonville', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.689601, -73.57766);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12962', 'S', 'West Plattsburgh', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.689601, -73.57766);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12964', 'S', 'New Russia', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.147061, -73.607718);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12965', 'S', 'Hopkinton', 'A', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.718819, -74.652944);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12965', 'S', 'Nicholville', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.718819, -74.652944);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12966', 'S', 'Bangor', 'A', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.781153, -74.455399);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12966', 'S', 'North Bangor', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.781153, -74.455399);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12966', 'S', 'West Bangor', 'A', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.781153, -74.455399);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12967', 'S', 'North Lawrence', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.761693, -74.654141);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12969', 'S', 'Mountain View', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.715848, -74.080775);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12969', 'S', 'Owls Head', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.715848, -74.080775);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12970', 'S', 'Paul Smiths', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.434675, -74.276736);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12972', 'S', 'Harkness', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.584805, -73.530084);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12972', 'S', 'Peru', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.584805, -73.530084);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12973', 'P', 'Piercefield', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.22765, -74.568181);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12974', 'S', 'Port Henry', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.045341, -73.465362);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12975', 'P', 'Port Kent', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.527154, -73.412205);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12976', 'P', 'Rainbow Lake', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.489959, -74.121297);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12977', 'P', 'Ray Brook', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.299084, -74.086284);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12978', 'S', 'Redford', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.609012, -73.805908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12979', 'S', 'Rouses Point', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.990534, -73.367171);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12980', 'S', 'Saint Regis Falls', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.65852, -74.511646);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12980', 'S', 'Santa Clara', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.65852, -74.511646);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12981', 'S', 'Saranac', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.679046, -73.824306);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12983', 'S', 'Harrietstown', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.344798, -74.135095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12983', 'S', 'Lake Colby', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.344798, -74.135095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12983', 'S', 'Saranac Lake', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.344798, -74.135095);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12985', 'S', 'Peasleeville', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.560287, -73.755571);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12985', 'S', 'Schuyler Falls', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.560287, -73.755571);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12985', 'S', 'Swastika', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.560287, -73.755571);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12986', 'S', 'Conifer', 'N', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.23505, -74.46496);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12986', 'S', 'Massawepie', 'A', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.23505, -74.46496);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12986', 'S', 'Tupper Lake', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.23505, -74.46496);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12987', 'S', 'Upper Jay', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.329626, -73.840421);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12989', 'S', 'Loon Lake', 'A', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.469526, -74.044265);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12989', 'S', 'Onchiota', 'A', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.469526, -74.044265);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12989', 'S', 'Vermontville', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.469526, -74.044265);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12992', 'S', 'Ingraham', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.78096, -73.505322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12992', 'S', 'Sciota', 'N', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.78096, -73.505322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12992', 'S', 'West Chazy', 'D', 'Clinton', '36019', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.78096, -73.505322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12993', 'S', 'Wadhams', 'A', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.178354, -73.43451);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12993', 'S', 'Westport', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.178354, -73.43451);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12995', 'P', 'Whippleville', 'D', 'Franklin', '36033', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.808327, -74.261237);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12996', 'S', 'Reber', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.365798, -73.397124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12996', 'S', 'Willsboro', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.365798, -73.397124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12996', 'S', 'Willsboro Point', 'N', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.365798, -73.397124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12997', 'S', 'Whiteface Mountain', 'A', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.388992, -73.8437);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12997', 'S', 'Wilmington', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.388992, -73.8437);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('12998', 'S', 'Witherbee', 'D', 'Essex', '36031', 'New York', 'NY', '36', '0000', '518', 'Eastern', -5, 'Y', 44.086571, -73.536128);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13020', 'P', 'Apulia Station', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.818065, -76.07347);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13021', 'S', 'Auburn', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.920644, -76.559964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13021', 'S', 'Aurelius', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.920644, -76.559964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13021', 'S', 'Fleming', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.920644, -76.559964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13021', 'S', 'Fosterville', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.920644, -76.559964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13021', 'S', 'Owasco', 'A', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.920644, -76.559964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13021', 'S', 'Sennett', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.920644, -76.559964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13021', 'S', 'Throop', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.920644, -76.559964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13022', 'P', 'Auburn', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.919963, -76.55292);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13024', 'U', 'Auburn', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.920638, -76.552564);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13026', 'S', 'Aurora', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.743286, -76.652204);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13026', 'S', 'Ledyard', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.743286, -76.652204);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13027', 'S', 'Baldwinsville', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.166729, -76.339805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13027', 'S', 'Belgium', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.166729, -76.339805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13027', 'S', 'Bville', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.166729, -76.339805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13027', 'S', 'Lysander', 'A', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.166729, -76.339805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13027', 'S', 'Radison', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.166729, -76.339805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13027', 'S', 'Radisson', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.166729, -76.339805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13027', 'S', 'Van Buren', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.166729, -76.339805);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13028', 'S', 'Bernhards Bay', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.264959, -75.989179);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13029', 'S', 'Brewerton', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.22688, -76.141632);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13030', 'S', 'Bridgeport', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.160577, -75.98454);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13031', 'S', 'Camillus', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.044375, -76.289134);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13031', 'S', 'Howlett Hill', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.044375, -76.289134);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13031', 'S', 'Split Rock', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.044375, -76.289134);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13032', 'S', 'Canastota', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.083843, -75.768034);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13032', 'S', 'Perryville', 'A', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.083843, -75.768034);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13032', 'S', 'South Bay', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.083843, -75.768034);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13032', 'S', 'Whitelaw', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.083843, -75.768034);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13033', 'S', 'Cato', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.193419, -76.565257);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13034', 'S', 'Cayuga', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.927604, -76.720691);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13035', 'S', 'Cazenovia', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.94544, -75.839613);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13035', 'S', 'Fenner', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.94544, -75.839613);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13035', 'S', 'Nelson', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.94544, -75.839613);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13036', 'S', 'Central Square', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.29032, -76.148041);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13037', 'S', 'Chittenango', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.05729, -75.872483);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13037', 'S', 'Lakeport', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.05729, -75.872483);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13037', 'S', 'North Chittenango', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.05729, -75.872483);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13037', 'S', 'Sullivan', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.05729, -75.872483);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13039', 'S', 'Cicero', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.160369, -76.135871);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13040', 'S', 'Cincinnatus', 'D', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.562547, -75.928525);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13040', 'S', 'East Freetown', 'A', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.562547, -75.928525);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13040', 'S', 'Taylor', 'N', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.562547, -75.928525);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13041', 'S', 'Clay', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.171563, -76.13194);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13042', 'S', 'Cleveland', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.233646, -75.881359);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13043', 'P', 'Clockville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.039802, -75.744094);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13043', 'P', 'Lincoln', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.039802, -75.744094);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13044', 'S', 'Constantia', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.266484, -76.009432);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13044', 'S', 'Gayville', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.266484, -76.009432);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13045', 'S', 'Cortland', 'D', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.590148, -76.182989);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13045', 'S', 'Cortlandville', 'N', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.590148, -76.182989);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13045', 'S', 'Munsons Corners', 'N', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.590148, -76.182989);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13045', 'S', 'Virgil', 'N', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.590148, -76.182989);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13051', 'P', 'Delphi Falls', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.878158, -75.912999);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13052', 'S', 'De Ruyter', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.731051, -75.905863);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13052', 'S', 'Deruyter', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.731051, -75.905863);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13052', 'S', 'Lincklaen', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.731051, -75.905863);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13053', 'S', 'Dryden', 'D', 'Tompkins', '36109', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.48891, -76.296223);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13054', 'S', 'Durhamville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.132136, -75.62634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13054', 'S', 'Higginsville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.132136, -75.62634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13054', 'S', 'Stacy Basin', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.132136, -75.62634);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13056', 'P', 'East Homer', 'D', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.672626, -76.096831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13056', 'P', 'Truxton', 'N', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.672626, -76.096831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13057', 'S', 'East Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.07553, -76.05182);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13060', 'S', 'Elbridge', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.024371, -76.418761);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13060', 'S', 'Hart Lot', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.024371, -76.418761);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13061', 'S', 'Erieville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.866074, -75.751527);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13062', 'P', 'Etna', 'D', 'Tompkins', '36109', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.482285, -76.390876);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13063', 'S', 'Fabius', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.855288, -75.987549);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13064', 'P', 'Fair Haven', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.319427, -76.702751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13065', 'P', 'Fayette', 'D', 'Seneca', '36099', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.821298, -76.812129);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13066', 'S', 'Fayetteville', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.027198, -76.013016);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13066', 'S', 'Fville', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.027198, -76.013016);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13068', 'S', 'Freeville', 'D', 'Tompkins', '36109', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.502142, -76.354802);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13069', 'S', 'Bowens Corners', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.319759, -76.413639);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13069', 'S', 'Fulton', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.319759, -76.413639);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13069', 'S', 'Granby', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.319759, -76.413639);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13069', 'S', 'Granby Center', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.319759, -76.413639);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13069', 'S', 'Palermo', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.319759, -76.413639);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13069', 'S', 'Volney', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.319759, -76.413639);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13071', 'S', 'Genoa', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.673961, -76.541497);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13072', 'S', 'Georgetown', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.763862, -75.753162);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13072', 'S', 'Geotown', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.763862, -75.753162);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13072', 'S', 'Otselic', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.763862, -75.753162);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13073', 'S', 'Groton', 'D', 'Tompkins', '36109', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.585725, -76.393025);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13073', 'S', 'Groton City', 'N', 'Tompkins', '36109', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.585725, -76.393025);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13073', 'S', 'West Groton', 'N', 'Tompkins', '36109', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.585725, -76.393025);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13074', 'S', 'Fairdale', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.315604, -76.56925);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13074', 'S', 'Hannibal', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.315604, -76.56925);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13074', 'S', 'Hannibal Center', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.315604, -76.56925);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13074', 'S', 'South Hannibal', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.315604, -76.56925);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13076', 'S', 'Hastings', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.351755, -76.149799);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13077', 'S', 'Homer', 'D', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.676667, -76.18953);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13077', 'S', 'Scott', 'N', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.676667, -76.18953);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13078', 'S', 'Jamesville', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.98303, -76.073762);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13078', 'S', 'Sentinel Heights', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.98303, -76.073762);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13080', 'S', 'Cross Lake', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.072472, -76.461788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13080', 'S', 'Jordan', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.072472, -76.461788);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13081', 'S', 'Atwater', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.662592, -76.62677);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13081', 'S', 'Goodyears Corners', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.662592, -76.62677);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13081', 'S', 'King Ferry', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.662592, -76.62677);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13081', 'S', 'Kings Ferry', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.662592, -76.62677);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13082', 'S', 'Kirkville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.083758, -75.970572);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13083', 'S', 'Boylston', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.647853, -76.060983);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13083', 'S', 'Lacona', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.647853, -76.060983);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13083', 'S', 'Smartville', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.647853, -76.060983);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13084', 'S', 'Berwyn', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.887029, -76.106535);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13084', 'S', 'Cardiff', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.887029, -76.106535);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13084', 'S', 'La Fayette', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.887029, -76.106535);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13084', 'S', 'Lafayette', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.887029, -76.106535);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13087', 'P', 'Little York', 'D', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.705528, -76.157984);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13088', 'S', 'Galeville', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.111538, -76.195307);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13088', 'S', 'Jewell Manor', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.111538, -76.195307);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13088', 'S', 'Liverpool', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.111538, -76.195307);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13088', 'S', 'Lpool', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.111538, -76.195307);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13088', 'S', 'Lvpl', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.111538, -76.195307);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13088', 'S', 'Lvrpool', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.111538, -76.195307);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13088', 'S', 'Salina', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.111538, -76.195307);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13089', 'P', 'Liverpool', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.139774, -76.22722);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13090', 'S', 'Bayberry', 'A', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.149327, -76.223372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13090', 'S', 'Dominion Park', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.149327, -76.223372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13090', 'S', 'Liverpool', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.149327, -76.223372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13090', 'S', 'Lpool', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.149327, -76.223372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13090', 'S', 'Lvpl', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.149327, -76.223372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13090', 'S', 'Lvrpool', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.149327, -76.223372);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13092', 'S', 'East Genoa', 'N', 'Tompkins', '36109', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.650405, -76.422311);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13092', 'S', 'Locke', 'D', 'Tompkins', '36109', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.650405, -76.422311);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13092', 'S', 'Summerhill', 'N', 'Tompkins', '36109', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.650405, -76.422311);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13093', 'P', 'Lycoming', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.501366, -76.388574);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13101', 'S', 'Mc Graw', 'D', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.597772, -76.078518);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13101', 'S', 'McGraw', 'N', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.597772, -76.078518);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13102', 'P', 'Mc Lean', 'D', 'Tompkins', '36109', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.554414, -76.293544);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13102', 'P', 'McLean', 'N', 'Tompkins', '36109', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.554414, -76.293544);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13103', 'S', 'Mallory', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.324996, -76.098694);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13104', 'S', 'Manlius', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.994893, -75.970433);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13107', 'P', 'Maple View', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.46048, -76.147002);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13108', 'S', 'Marcellus', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.978356, -76.334796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13108', 'S', 'Marcellus Falls', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.978356, -76.334796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13108', 'S', 'Martisco', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.978356, -76.334796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13108', 'S', 'Navarino', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.978356, -76.334796);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13110', 'S', 'Amber', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.888966, -76.283957);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13110', 'S', 'Marietta', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.888966, -76.283957);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13110', 'S', 'Otisco Valley', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.888966, -76.283957);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13111', 'S', 'Martville', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.232544, -76.620098);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13112', 'S', 'Memphis', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.105832, -76.416327);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13113', 'P', 'Meridian', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.162731, -76.538014);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13114', 'S', 'Mexico', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.461264, -76.233234);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13115', 'P', 'Minetto', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.398509, -76.493251);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13116', 'S', 'Minoa', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.077436, -76.009926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13117', 'P', 'Montezuma', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.009921, -76.700005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13118', 'S', 'Montville', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.750862, -76.438383);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13118', 'S', 'Moravia', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.750862, -76.438383);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13118', 'S', 'Sempronius', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.750862, -76.438383);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13119', 'P', 'Mottville', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.973215, -76.441929);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13119', 'P', 'Skaneateles Falls', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.973215, -76.441929);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13120', 'S', 'Indian Village', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.963401, -76.160356);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13120', 'S', 'Nedrow', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.963401, -76.160356);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13120', 'S', 'Onondaga Nation', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.963401, -76.160356);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13120', 'S', 'Rockwell Springs', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.963401, -76.160356);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13120', 'S', 'South Onondaga', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.963401, -76.160356);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13121', 'P', 'New Haven', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.479969, -76.313034);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13122', 'S', 'New Woodstock', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.855055, -75.914421);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13122', 'S', 'Sheds', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.855055, -75.914421);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13123', 'P', 'North Bay', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.228347, -75.748595);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13124', 'S', 'North Pitcher', 'D', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.435912, -75.471202);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Bundyville', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Dempster Beach', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Demster', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Fruit Valley', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Furniss', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'North Hannibal', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Oswego', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Oswego Center', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Scriba', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Scriba Center', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Seneca Hill', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13126', 'S', 'Southwest Oswego', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.451477, -76.501703);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13129', 'S', 'Georgetown', 'D', 'Chenango', '36017', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.665877, -75.756481);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13131', 'S', 'Colosse', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.40727, -76.108685);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13131', 'S', 'Parish', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.40727, -76.108685);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13132', 'S', 'Pennellville', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.252751, -76.232419);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13134', 'P', 'Peterboro', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.968836, -75.687569);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13134', 'P', 'Smithfield', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.968836, -75.687569);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13135', 'S', 'Hinmansville', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.24457, -76.30221);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13135', 'S', 'Phoenix', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.24457, -76.30221);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13135', 'S', 'Schroeppel', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.24457, -76.30221);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13136', 'S', 'Pitcher', 'D', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.6154, -75.853885);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13137', 'P', 'Plainville', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.151646, -76.446002);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13138', 'P', 'Pompey', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.901818, -76.013663);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13139', 'P', 'Poplar Ridge', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.740575, -76.597936);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13140', 'S', 'Conquest', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.037014, -76.637091);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13140', 'S', 'Port Byron', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.037014, -76.637091);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13141', 'S', 'Preble', 'D', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.738644, -76.158017);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13142', 'S', 'Fernwood', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.557794, -76.128407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13142', 'S', 'Port Ontario', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.557794, -76.128407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13142', 'S', 'Pulaski', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.557794, -76.128407);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13143', 'S', 'Red Creek', 'D', 'Wayne', '36117', 'New York', 'NY', '36', '6840', '315', 'Eastern', -5, 'Y', 43.235287, -76.731148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13144', 'S', 'Richland', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.561546, -76.014406);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13145', 'S', 'Sandy Creek', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.656766, -76.114729);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13146', 'S', 'Savannah', 'D', 'Wayne', '36117', 'New York', 'NY', '36', '6840', '315', 'Eastern', -5, 'Y', 43.103753, -76.760166);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13147', 'S', 'Merrifield', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.770847, -76.564345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13147', 'S', 'Scipio', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.770847, -76.564345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13147', 'S', 'Scipio Center', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.770847, -76.564345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13147', 'S', 'Scipioville', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.770847, -76.564345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13147', 'S', 'Venice', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.770847, -76.564345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13147', 'S', 'Venice Center', 'A', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.770847, -76.564345);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13148', 'S', 'Canoga', 'N', 'Seneca', '36099', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.910232, -76.793412);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13148', 'S', 'Seneca Falls', 'D', 'Seneca', '36099', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.910232, -76.793412);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13148', 'S', 'Tyre', 'N', 'Seneca', '36099', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.910232, -76.793412);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13152', 'S', 'Mandana', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.914175, -76.397038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13152', 'S', 'Niles', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.914175, -76.397038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13152', 'S', 'Skan', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.914175, -76.397038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13152', 'S', 'Skaneateles', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.914175, -76.397038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13153', 'P', 'Skan Fa', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.994912, -76.452863);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13153', 'P', 'Skaneateles Falls', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.994912, -76.452863);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13154', 'P', 'South Butler', 'D', 'Wayne', '36117', 'New York', 'NY', '36', '6840', '315', 'Eastern', -5, 'Y', 43.133174, -76.762628);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13155', 'S', 'South Otselic', 'D', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.665692, -75.760212);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13156', 'S', 'Sterling', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.317187, -76.70096);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13157', 'P', 'Sylvan Beach', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.207563, -75.730526);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13158', 'S', 'Cuyler', 'A', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.695444, -76.01425);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13158', 'S', 'East Homer', 'A', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.695444, -76.01425);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13158', 'S', 'Truxton', 'D', 'Cortland', '36023', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.695444, -76.01425);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13159', 'S', 'Otisco', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.817619, -76.145511);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13159', 'S', 'Tully', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.817619, -76.145511);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13159', 'S', 'Vesper', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.817619, -76.145511);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13160', 'S', 'Allens Point', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.842257, -76.688186);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13160', 'S', 'Farleys Point', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.842257, -76.688186);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13160', 'S', 'Springport', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.842257, -76.688186);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13160', 'S', 'Union Springs', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.842257, -76.688186);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13162', 'P', 'Verona Beach', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.192705, -75.728282);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13163', 'P', 'Wampsville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.08309, -75.705865);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13164', 'S', 'Warners', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.090879, -76.311279);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13165', 'S', 'Junius', 'N', 'Seneca', '36099', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.907458, -76.877046);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13165', 'S', 'Waterloo', 'D', 'Seneca', '36099', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.907458, -76.877046);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13166', 'S', 'Brutus', 'N', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.055291, -76.559355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13166', 'S', 'Weedsport', 'D', 'Cayuga', '36011', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.055291, -76.559355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13167', 'S', 'West Monroe', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.284609, -76.076927);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13201', 'P', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.04092, -76.15264);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13202', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.04285, -76.149717);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13203', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.060624, -76.139954);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13204', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.052042, -76.177065);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13205', 'S', 'Colvin', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.006472, -76.148241);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13205', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.006472, -76.148241);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13206', 'S', 'Eastwood', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.070202, -76.106706);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13206', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.070202, -76.106706);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13207', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.017354, -76.167626);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13208', 'S', 'Lyncourt', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.072766, -76.147309);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13208', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.072766, -76.147309);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13209', 'S', 'Geddes', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.078045, -76.241832);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13209', 'S', 'Solvay', 'A', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.078045, -76.241832);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13209', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.078045, -76.241832);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13210', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.034249, -76.126286);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13211', 'S', 'Mattydale', 'A', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.098535, -76.13219);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13211', 'S', 'Mdale', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.098535, -76.13219);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13211', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.098535, -76.13219);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13212', 'S', 'North Syracuse', 'A', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.131472, -76.136007);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13212', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.131472, -76.136007);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13214', 'S', 'De Witt', 'A', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.036965, -76.073608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13214', 'S', 'Dewitt', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.036965, -76.073608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13214', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.036965, -76.073608);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13215', 'S', 'Onon Hill', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.997261, -76.221694);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13215', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.997261, -76.221694);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13217', 'P', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.051842, -76.123159);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13218', 'P', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.047082, -76.148417);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13219', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.040139, -76.21702);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13219', 'S', 'Taunton', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.040139, -76.21702);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13219', 'S', 'Westvale', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.040139, -76.21702);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13220', 'P', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.125489, -76.129731);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13221', 'P', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.048798, -76.149827);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13224', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.042678, -76.101087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13225', 'U', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.12951, -76.131355);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13235', 'P', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.04875, -76.148002);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13235', 'P', 'University', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.04875, -76.148002);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13244', 'U', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.041575, -76.133784);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13250', 'U', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.122569, -76.132866);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13251', 'U', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.123742, -76.135103);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13252', 'U', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.048582, -76.156564);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13260', 'U', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.039766, -76.141249);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13261', 'P', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.04285, -76.149717);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13290', 'S', 'Carousel Center', 'N', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.05011, -76.150573);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13290', 'S', 'Syracuse', 'D', 'Onondaga', '36067', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.05011, -76.150573);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13301', 'S', 'Alder Creek', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.414193, -75.21042);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13302', 'S', 'Altmar', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.505683, -75.992926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13302', 'S', 'Howardville', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.505683, -75.992926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13302', 'S', 'Kasoag', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.505683, -75.992926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13302', 'S', 'Pine Meadows', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.505683, -75.992926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13302', 'S', 'Ricard', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.505683, -75.992926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13302', 'S', 'South Albion', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.505683, -75.992926);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13303', 'S', 'Ava', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.306203, -75.43564);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13303', 'S', 'West Branch', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.306203, -75.43564);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13304', 'S', 'Barneveld', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.253659, -75.193228);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13304', 'S', 'South Trenton', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.253659, -75.193228);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13305', 'P', 'Beaver Falls', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.887639, -75.425266);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13308', 'S', 'Blossvale', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.241534, -75.652043);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13308', 'S', 'Vienna', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.241534, -75.652043);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13309', 'S', 'Boonville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.485067, -75.330236);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13309', 'S', 'Hawkinsville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.485067, -75.330236);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13309', 'S', 'Mohawk Hill', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.485067, -75.330236);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13309', 'S', 'Talcottville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.485067, -75.330236);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13310', 'S', 'Bouckville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.897902, -75.574398);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13310', 'S', 'Pine Woods', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.897902, -75.574398);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13312', 'P', 'Brantingham', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.685598, -75.289871);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13312', 'P', 'Glenfield', 'A', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.685598, -75.289871);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13313', 'P', 'Bridgewater', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.878013, -75.249924);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13314', 'S', 'Brookfield', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.807903, -75.342084);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13315', 'S', 'Burlington', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.746099, -75.156827);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13315', 'S', 'Burlington Flats', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.746099, -75.156827);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13315', 'S', 'Exeter', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.746099, -75.156827);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13316', 'S', 'Camden', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.335012, -75.753087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13316', 'S', 'Empeyville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.335012, -75.753087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13316', 'S', 'Florence', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.335012, -75.753087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13316', 'S', 'Hillsboro', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.335012, -75.753087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13316', 'S', 'Osceola', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.335012, -75.753087);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Ames', 'A', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Browns Hollow', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Buel', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Canajoharie', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Flat Creek', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Mapletown', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Marshville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Sprout Brook', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13317', 'S', 'Van Deusenville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.903348, -74.574005);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13318', 'S', 'Cassville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.940901, -75.285826);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13318', 'S', 'North Bridgewater', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.940901, -75.285826);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13319', 'S', 'Chadwicks', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.023165, -75.269856);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13319', 'S', 'Willowvale', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.023165, -75.269856);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13320', 'S', 'Cherry Valley', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.796521, -74.756366);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13321', 'P', 'Clark Mills', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.091712, -75.378449);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13322', 'S', 'Clayville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.97391, -75.243398);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13323', 'S', 'Clinton', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.056309, -75.375791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13323', 'S', 'Kirkland', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.056309, -75.375791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13323', 'S', 'Lairdsville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.056309, -75.375791);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13324', 'S', 'Cold Brook', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.459912, -74.935665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13324', 'S', 'Grant', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.459912, -74.935665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13324', 'S', 'Gray', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.459912, -74.935665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13324', 'S', 'Morehouse', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.459912, -74.935665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13324', 'S', 'Morehouseville', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.459912, -74.935665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13324', 'S', 'Noblesboro', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.459912, -74.935665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13324', 'S', 'Ohio', 'A', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.459912, -74.935665);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13325', 'S', 'Constableville', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.577189, -75.564678);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13325', 'S', 'Fish Creek', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.577189, -75.564678);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13325', 'S', 'West Turin', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.577189, -75.564678);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13326', 'S', 'Cooperstown', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.716131, -74.906704);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13326', 'S', 'Hartwick Seminary', 'A', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.716131, -74.906704);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13327', 'S', 'Belfort', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.891531, -75.386158);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13327', 'S', 'Croghan', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.891531, -75.386158);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13327', 'S', 'Indian River', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.891531, -75.386158);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13327', 'S', 'Kirschnerville', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.891531, -75.386158);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13328', 'S', 'Deansboro', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.997626, -75.428706);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13329', 'S', 'Dolgeville', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.101523, -74.775986);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13329', 'S', 'Manheim', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.101523, -74.775986);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13329', 'S', 'Oppenheim', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.101523, -74.775986);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13331', 'S', 'Big Moose', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.817857, -74.876972);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13331', 'S', 'Eagle Bay', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.817857, -74.876972);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13332', 'S', 'Earlville', 'D', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.742625, -75.566682);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13332', 'S', 'Lebanon', 'A', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.742625, -75.566682);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13332', 'S', 'Lebanon Center', 'N', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.742625, -75.566682);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13332', 'S', 'South Hamilton', 'N', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.742625, -75.566682);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13332', 'S', 'South Lebanon', 'N', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.742625, -75.566682);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13333', 'S', 'East Springfield', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.831907, -74.761141);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13334', 'S', 'Eaton', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.827651, -75.654124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13334', 'S', 'Georgtown Station', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.827651, -75.654124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13334', 'S', 'Pierceville', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.827651, -75.654124);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13335', 'S', 'Edmeston', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.697595, -75.238939);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13337', 'S', 'Cattown', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.734651, -74.991943);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13337', 'S', 'Fly Creek', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.734651, -74.991943);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13337', 'S', 'Oaksville', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.734651, -74.991943);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13337', 'S', 'Otsego', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.734651, -74.991943);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13338', 'S', 'Atwell', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.504495, -75.157638);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13338', 'S', 'Forestport', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.504495, -75.157638);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13338', 'S', 'Forestport Station', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.504495, -75.157638);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13338', 'S', 'Honnedaga Lake', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.504495, -75.157638);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13338', 'S', 'Kayuta Lake', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.504495, -75.157638);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13338', 'S', 'McKeever', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.504495, -75.157638);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13338', 'S', 'Otter Lake', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.504495, -75.157638);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Ephratah', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Fort Plain', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Hallsville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Hessville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Minden', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Mindenville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Sand Hill', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Starkville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13339', 'S', 'Stone Arabia', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.931659, -74.627057);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13340', 'S', 'Frankfort', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.040165, -75.082322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13340', 'S', 'Frankfort Center', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.040165, -75.082322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13340', 'S', 'North Ilion', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.040165, -75.082322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13340', 'S', 'Schuyler', 'A', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.040165, -75.082322);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13341', 'P', 'Franklin Springs', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.034678, -75.390751);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13342', 'S', 'Garrattsville', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.64075, -75.226719);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13343', 'S', 'Chase Lake', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.721582, -75.258001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13343', 'S', 'Glenfield', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.721582, -75.258001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13343', 'S', 'Otter Creek', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.721582, -75.258001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13343', 'S', 'Pine Grove', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.721582, -75.258001);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13345', 'S', 'Greig', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.679971, -75.311066);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13346', 'S', 'Colgate', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.822498, -75.544063);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13346', 'S', 'Hamilton', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.822498, -75.544063);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13346', 'S', 'Randallsville', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.822498, -75.544063);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13348', 'S', 'Hartwick', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.662402, -75.046094);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13348', 'S', 'Patent', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.662402, -75.046094);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13348', 'S', 'Snowden', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.662402, -75.046094);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13350', 'S', 'East Herkimer', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.030105, -74.984973);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13350', 'S', 'Herkimer', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.030105, -74.984973);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13352', 'P', 'Hinckley', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.2745, -75.18046);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13353', 'P', 'Hoffmeister', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.468973, -74.727687);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13354', 'S', 'East Floyd', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.234071, -75.267955);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13354', 'S', 'Holland Patent', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.234071, -75.267955);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13354', 'S', 'Steuben', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.234071, -75.267955);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13354', 'S', 'Steuben Valley', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.234071, -75.267955);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13355', 'S', 'Hubbardsville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.815696, -75.457847);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13357', 'S', 'Cedarville', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.012843, -75.045183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13357', 'S', 'Columbia', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.012843, -75.045183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13357', 'S', 'Columbia Center', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.012843, -75.045183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13357', 'S', 'Ilion', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.012843, -75.045183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13357', 'S', 'North Columbia', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.012843, -75.045183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13357', 'S', 'South Ilion', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.012843, -75.045183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13357', 'S', 'Spinnerville', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.012843, -75.045183);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13360', 'S', 'Inlet', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.732253, -74.73682);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13361', 'S', 'Jordanville', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.89477, -74.81734);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13362', 'P', 'Knoxboro', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.984335, -75.519009);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13363', 'S', 'Lee Center', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.295281, -75.52258);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13363', 'S', 'Stokes', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.295281, -75.52258);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13363', 'S', 'West Lee', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.295281, -75.52258);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13364', 'P', 'Leonardsville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.808457, -75.253988);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13365', 'S', 'Little Falls', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.046057, -74.857063);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13365', 'S', 'Salisbury', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.046057, -74.857063);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13367', 'S', 'Beaver River', 'A', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.78488, -75.484093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13367', 'S', 'Dadville', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.78488, -75.484093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13367', 'S', 'Harrisburg', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.78488, -75.484093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13367', 'S', 'Lowville', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.78488, -75.484093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13367', 'S', 'Montague', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.78488, -75.484093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13367', 'S', 'New Breman', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.78488, -75.484093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13367', 'S', 'Watson', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.78488, -75.484093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13367', 'S', 'West Lowville', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.78488, -75.484093);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13368', 'S', 'Goulds Mill', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.621898, -75.364296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13368', 'S', 'Lyons Falls', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.621898, -75.364296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13368', 'S', 'Lyonsdale', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.621898, -75.364296);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13401', 'P', 'Blossvale', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.271481, -75.689343);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13401', 'P', 'McConnellsville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.271481, -75.689343);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13402', 'S', 'Madison', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.915824, -75.493148);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13403', 'S', 'Marcy', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.150854, -75.25208);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13404', 'P', 'Martinsburg', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.738157, -75.468625);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13406', 'S', 'Fairfield', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.139808, -74.969563);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13406', 'S', 'Middleville', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.139808, -74.969563);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13407', 'S', 'Dennison Corners', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.009038, -75.007102);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13407', 'S', 'Fort Herkimer', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.009038, -75.007102);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13407', 'S', 'German Flatts', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.009038, -75.007102);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13407', 'S', 'Mohawk', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.009038, -75.007102);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13407', 'S', 'Paines Hollow', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.009038, -75.007102);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13408', 'S', 'Morrisville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.905156, -75.67763);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13408', 'S', 'Morrisville Station', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.905156, -75.67763);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13409', 'S', 'Munnsville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.98475, -75.5922);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13409', 'S', 'Pratts Hollow', 'A', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.98475, -75.5922);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13409', 'S', 'Stockbridge', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.98475, -75.5922);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13409', 'S', 'Valley Mills', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.98475, -75.5922);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13410', 'P', 'Nelliston', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.932952, -74.608756);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13411', 'S', 'Columbus', 'N', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.624636, -75.330038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13411', 'S', 'Hoboken', 'N', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.624636, -75.330038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13411', 'S', 'New Berlin', 'D', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.624636, -75.330038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13411', 'S', 'Pittsfield', 'N', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.624636, -75.330038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13411', 'S', 'South Edmeston', 'A', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.624636, -75.330038);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13413', 'S', 'New Hartfd', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.066052, -75.290055);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13413', 'S', 'New Hartford', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.066052, -75.290055);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13415', 'S', 'New Lisbon', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.573325, -75.327871);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13415', 'S', 'Stetsonville', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.573325, -75.327871);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13416', 'S', 'Newport', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.189629, -75.018362);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13417', 'S', 'New York Mills', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.100821, -75.290988);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13417', 'S', 'NY Mills', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.100821, -75.290988);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13418', 'S', 'North Brookfield', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.851796, -75.374964);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13420', 'S', 'Old Forge', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.750933, -74.920748);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13421', 'S', 'Kenwood', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.082808, -75.64909);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13421', 'S', 'Merrillsville', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.082808, -75.64909);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13421', 'S', 'Oneida', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.082808, -75.64909);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13421', 'S', 'Oneida Castle', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.082808, -75.64909);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13421', 'S', 'Scribner Corners', 'N', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.082808, -75.64909);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13424', 'S', 'Oriskany', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.154445, -75.332472);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13425', 'S', 'Augusta', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.939058, -75.459424);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13425', 'S', 'Oriskany Falls', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.939058, -75.459424);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13426', 'P', 'Orwell', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.560573, -75.993101);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13428', 'S', 'Palatine Bridge', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.909641, -74.57437);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13431', 'S', 'Gravesville', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.19161, -75.072304);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13431', 'S', 'Poland', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.19161, -75.072304);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13431', 'S', 'Russia', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.19161, -75.072304);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13433', 'S', 'Collinsville', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.578827, -75.33795);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13433', 'S', 'Fowlersville', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.578827, -75.33795);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13433', 'S', 'Leyden', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.578827, -75.33795);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13433', 'S', 'Moose River', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.578827, -75.33795);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13433', 'S', 'Port Leyden', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.578827, -75.33795);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13435', 'P', 'Prospect', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.303611, -75.148084);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13436', 'S', 'Brightside', 'N', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.871342, -74.552949);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13436', 'S', 'Raquette Lake', 'D', 'Hamilton', '36041', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.871342, -74.552949);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13437', 'S', 'Redfield', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.595477, -75.813913);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13438', 'S', 'North Wilmurt', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.333117, -75.200513);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13438', 'S', 'Remsen', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.333117, -75.200513);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13439', 'S', 'Cullen', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.85141, -74.988541);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13439', 'S', 'Richfield', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.85141, -74.988541);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13439', 'S', 'Richfield Springs', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.85141, -74.988541);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13439', 'S', 'South Columbia', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.85141, -74.988541);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13439', 'S', 'Warren', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.85141, -74.988541);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Bartlett', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Camroden', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Coonrod', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Floyd', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Fort Stanwix National Monume', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Greenway', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Lake Delta', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Lee', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Ridge Mills', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Rome', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Seifert Corners', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Spencer Settlement', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Stanwix', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13440', 'S', 'Stanwix Heights', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.221299, -75.452831);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13441', 'S', 'Rome', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.212972, -75.41017);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13442', 'P', 'Rome', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.217615, -75.447424);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13449', 'U', 'Rome', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.225494, -75.492278);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13450', 'S', 'Cherry Valley', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.787665, -74.746102);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13450', 'S', 'Roseboom', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.787665, -74.746102);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13452', 'S', 'Crum Creek', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.997521, -74.681054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13452', 'S', 'Johnsville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.997521, -74.681054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13452', 'S', 'Kringsbush', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.997521, -74.681054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13452', 'S', 'Lassellsville', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.997521, -74.681054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13452', 'S', 'Saint Johnsville', 'D', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.997521, -74.681054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13452', 'S', 'Scotchbush', 'N', 'Montgomery', '36057', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.997521, -74.681054);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13454', 'S', 'Salisbury Center', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.231609, -74.791568);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13455', 'P', 'Sangerfield', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.916248, -75.381705);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13456', 'S', 'Paris', 'A', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.009513, -75.255844);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13456', 'S', 'Sauquoit', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.009513, -75.255844);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13457', 'P', 'Schuyler Lake', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.779466, -75.026726);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13459', 'S', 'Sharon Springs', 'D', 'Schoharie', '36095', 'New York', 'NY', '36', '0160', '518', 'Eastern', -5, 'Y', 42.791988, -74.614106);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13460', 'S', 'Sherburne', 'D', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.68097, -75.49917);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13461', 'S', 'Sherrill', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.071891, -75.595941);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13464', 'S', 'Bonney', 'N', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.691125, -75.632663);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13464', 'S', 'Smyrna', 'D', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.691125, -75.632663);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13464', 'S', 'Upperville', 'N', 'Chenango', '36017', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.691125, -75.632663);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13465', 'P', 'Solsville', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.91064, -75.521019);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13468', 'S', 'Springfield Center', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.844523, -74.841105);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13468', 'S', 'Springfld Center', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.844523, -74.841105);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13469', 'S', 'Stittville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.22122, -75.285717);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13470', 'S', 'Stratford', 'D', 'Fulton', '36035', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.189457, -74.635488);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13471', 'S', 'Annsville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.395357, -75.611063);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13471', 'S', 'Point Rock', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.395357, -75.611063);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13471', 'S', 'Taberg', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.395357, -75.611063);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13472', 'P', 'Thendara', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.839312, -74.998485);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13473', 'S', 'Houseville', 'N', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.6556, -75.428792);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13473', 'S', 'Turin', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.6556, -75.428792);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13475', 'S', 'Van Hornesville', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.867883, -74.850165);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13476', 'S', 'Vernon', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.076874, -75.533524);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13477', 'S', 'Vernon Center', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.044137, -75.524912);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13478', 'S', 'Verona', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.142576, -75.584483);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13479', 'P', 'Washington Mills', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.056604, -75.273986);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13480', 'S', 'Conger Corners', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.930337, -75.378181);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13480', 'S', 'Daytonville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.930337, -75.378181);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13480', 'S', 'Stockwell', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.930337, -75.378181);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13480', 'S', 'Waterville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.930337, -75.378181);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13482', 'S', 'West Burlington', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.694287, -75.193783);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13483', 'S', 'Westdale', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.415556, -75.815422);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13484', 'P', 'West Eaton', 'D', 'Madison', '36053', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 42.851757, -75.662247);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13485', 'S', 'South Brookfield', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.78784, -75.318973);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13485', 'S', 'West Edmeston', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 42.78784, -75.318973);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13486', 'S', 'Big Brook', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.34721, -75.324999);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13486', 'S', 'Frenchville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.34721, -75.324999);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13486', 'S', 'Westernville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.34721, -75.324999);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13488', 'S', 'Maple Valley', 'N', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.504687, -75.106374);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13488', 'S', 'Westford', 'D', 'Otsego', '36077', 'New York', 'NY', '36', '0000', '607', 'Eastern', -5, 'Y', 42.504687, -75.106374);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13489', 'S', 'West Leyden', 'D', 'Lewis', '36049', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.473901, -75.53277);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13490', 'S', 'Hecla', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.113737, -75.416336);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13490', 'S', 'Westmoreland', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.113737, -75.416336);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'East Winfield', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'Millers Mills', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'North Winfield', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'Plainfield', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'Plainfield Center', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'Unadilla Forks', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'West Exeter', 'A', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'West Winfield', 'D', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13491', 'S', 'Winfield', 'N', 'Herkimer', '36043', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 42.881365, -75.189026);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13492', 'S', 'Walesville', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.116607, -75.308297);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13492', 'S', 'Whitesboro', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.116607, -75.308297);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13492', 'S', 'Whitestown', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.116607, -75.308297);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13493', 'S', 'Williamstn', 'N', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.422128, -75.88823);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13493', 'S', 'Williamstown', 'D', 'Oswego', '36075', 'New York', 'NY', '36', '8160', '315', 'Eastern', -5, 'Y', 43.422128, -75.88823);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13494', 'S', 'Woodgate', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.540179, -75.120878);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13495', 'S', 'Yorkville', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.114065, -75.274396);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13501', 'S', 'Utica', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.08437, -75.234461);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13502', 'S', 'Deerfield', 'A', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.109411, -75.230062);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13502', 'S', 'Schuyler', 'N', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.109411, -75.230062);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13502', 'S', 'Utica', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.109411, -75.230062);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13503', 'P', 'Utica', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.100145, -75.23291);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13504', 'P', 'Utica', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.085213, -75.188377);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13505', 'P', 'Utica', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.100405, -75.230473);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13599', 'U', 'Utica', 'D', 'Oneida', '36065', 'New York', 'NY', '36', '8680', '315', 'Eastern', -5, 'Y', 43.097704, -75.229256);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13601', 'S', 'Glen Park', 'A', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.981137, -75.909508);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13601', 'S', 'Knowsville', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.981137, -75.909508);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13601', 'S', 'Watertown', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.981137, -75.909508);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13601', 'S', 'Wtown', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.981137, -75.909508);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13602', 'S', 'Fort Drum', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.047536, -75.749225);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13602', 'S', 'Watertown', 'A', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.047536, -75.749225);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13602', 'S', 'Wtown', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.047536, -75.749225);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13603', 'S', 'Fort Drum', 'A', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.033867, -75.759408);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13603', 'S', 'Watertown', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.033867, -75.759408);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13605', 'S', 'Adams', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.807506, -76.021908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13605', 'S', 'Smithville', 'A', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.807506, -76.021908);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13606', 'S', 'Adams Center', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.858497, -76.009224);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13607', 'S', 'Alexandra Bay', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.331922, -75.917693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13607', 'S', 'Alexandria', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.331922, -75.917693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13607', 'S', 'Alexandria Bay', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.331922, -75.917693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13607', 'S', 'Collins Landing', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.331922, -75.917693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13607', 'S', 'Edgewood Park', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.331922, -75.917693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13607', 'S', 'Point Vivian', 'A', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.331922, -75.917693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13607', 'S', 'Saint Lawrence Park', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.331922, -75.917693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13607', 'S', 'Westminster Park', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.331922, -75.917693);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13608', 'S', 'Antwerp', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.198498, -75.607636);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13608', 'S', 'Oxbow', 'A', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.198498, -75.607636);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13608', 'S', 'Wegatchie', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.198498, -75.607636);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13611', 'P', 'Belleville', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 43.788347, -76.114594);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13612', 'S', 'Black River', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.00621, -75.796688);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13613', 'S', 'Brasher Falls', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.860326, -74.725235);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13614', 'S', 'Brier Hill', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.541243, -75.688955);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13615', 'P', 'Brownville', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.006764, -75.986222);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13615', 'P', 'Paddy Hill', 'N', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.006764, -75.986222);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13616', 'S', 'Calcium', 'D', 'Jefferson', '36045', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.02437, -75.858123);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13617', 'S', 'Bucks Bridge', 'N', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.597232, -75.168484);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13617', 'S', 'Canton', 'D', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.597232, -75.168484);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13617', 'S', 'Crary Mills', 'N', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.597232, -75.168484);
INSERT INTO `[prefix]_zipcodes` (`zipcode`, `zipcodetype`, `city`, `citytype`, `county`, `countyfips`, `state`, `statecode`, `statefips`, `msa`, `areacode`, `timezone`, `gmtoffset`, `dst`, `latitude`, `longitude`) VALUES ('13617', 'S', 'Eddy', 'N', 'Saint Lawrence', '36089', 'New York', 'NY', '36', '0000', '315', 'Eastern', -5, 'Y', 44.597232, -75.168484);
INSERT INTO `[prefi