<?php
/**
*
* example目录下为简单的支付样例，仅能用于搭建快速体验微信支付使用
* 样例的作用仅限于指导如何使用sdk，在安全上面仅做了简单处理， 复制使用样例代码时请慎重
* 请勿直接直接使用样例对外提供服务
* 
**/

require_once "../lib/WxPay.Api.php";
require_once "WxPay.NativePay.php";
require_once 'log.php';

//初始化日志
$logHandler= new CLogFileHandler("../logs/".date('Y-m-d').'.log');
$log = Log::Init($logHandler, 15);

//模式一
//不再提供模式一支付方式
/**

 * 流程：
 * 1、组装包含支付信息的url，生成二维码
 * 2、用户扫描二维码，进行支付
 * 3、确定支付之后，微信服务器会回调预先配置的回调地址，在【微信开放平台-微信支付-支付配置】中进行配置
 * 4、在接到回调通知之后，用户进行统一下单支付，并返回支付信息以完成支付（见：native_notify.php）
 * 5、支付完成之后，微信服务器会通知支付成功
 * 6、在支付成功通知中需要查单确认是否真正支付成功（见：notify.php）
 */

$notify = new NativePay();
$url1 = $notify->GetPrePayUrl("123456789");

//模式二
/**
 * 流程：
 * 1、调用统一下单，取得code_url，生成二维码
 * 2、用户扫描二维码，进行支付
 * 3、支付完成之后，微信服务器会通知支付成功
 * 4、在支付成功通知中需要查单确认是否真正支付成功（见：notify.php）
 */
 $order_num=$_GET['order_num'];$order_money=$_GET['order_money']*100;
 
$input = new WxPayUnifiedOrder();
$input->SetBody($order_num);
$input->SetAttach("test");
$input->SetOut_trade_no($order_num);  //订单号
$input->SetTotal_fee($order_money);  
$input->SetTime_start(date("YmdHis"));
$input->SetTime_expire(date("YmdHis", time() + 600));
$input->SetGoods_tag("test");   //商品标记
$input->SetNotify_url("http://www.wevalueweb.com/pay/weixin/example/notify.php"); //回调地址
$input->SetTrade_type("NATIVE");            //商品类型  
$input->SetProduct_id("123456789");         //商品ID

$result = $notify->GetPayUrl($input); 
$url2 = $result["code_url"];
?>

<html>
<head>
    <meta http-equiv="content-type" content="text/html;charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1" /> 
    <title>微信支付</title>
</head>
<body style="border: 0px;padding: 0px;margin: 0px;">

	<div style="width: 100%;">
  <div style="width: 800px;height: 877px;margin: auto;background-image: url('../../../images/weixin-pay.jpg');">
	<img src="qrcode.php?data=<?php echo urlencode($url2);?>" style="width:230px;height:230px;margin-top: 240px;margin-left: 290px;"/>
    <p style="margin-top: 40px;text-align: center;font-size:25px;">&nbsp;&nbsp;<span style="color: red;"><?php echo urlencode($_GET['order_money']);?></span>元</p>
    <p style="margin-top: 5px;text-align: center;font-size:25px;"><a href="../../../index.php">取消并返回首页</a></p>
   </div>          
     </div> 

<input type="hidden" name="out_trade_no" id="out_trade_no" value="<?php echo urlencode($order_num);?>" />
	<script src="../../../js/jquery-1.8.3.min.js"></script>
<script>
    $(function(){
       setInterval(function(){check()}, 5000);  //5秒查询一次支付是否成功
    })
    function check(){
        var url = "http://www.wevalueweb.com/pay/weixin/example/orderquery2.php";　　//新建
        var out_trade_no = $("#out_trade_no").val();
        var param = {'out_trade_no':out_trade_no};
        $.post(url, param, function(data){
           data = data.split("{");
            data_one=data[1];
            data_two='{'+data_one;
            data_three = JSON.parse(data_two); 
            if(data_three['trade_state'] == "SUCCESS"){
              //  alert("订单支付成功,即将跳转...");
                window.location.href = "../../../index.php?c=main&a=weixin_pay_return&order_num="+out_trade_no;
                return false;  
            }else{
              //  console.log(data_three);
            }
        });
    }
</script>

</body>
</html>