<%
'==========================================
'文 件 名：Class/Cls_Fso.asp
'文件用途：常规函数类
'版权所有：方卡在线
'==========================================

Class Cls_Fso
	Private FsoTemp,FsoTempArr
	'==============================
	'函 数 名：FsoLineWrite
	'作    用：按行写入文件
	'参    数：文件相对路径FilePath，写入行号LineNum，写入内容LineContent
	'==============================
	Public Function FsoLineWrite(FilePath,LineNum,LineContent)
		If LineNum<1 Then Exit Function
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		If Not Fso.FileExists(Server.MapPath(FilePath)) Then Exit Function
		FsoTemp=FsoFileRead(FilePath)
		FsoTempArr=Split(FsoTemp,Chr(13)&Chr(10))
		FsoTempArr(LineNum-1)=LineContent
		FsoTemp=Join(FsoTempArr,Chr(13)&Chr(10))
		Call CreateFile(FilePath,FsoTemp)
		Set Fso=Nothing
	End Function
	
	'==============================
	'函 数 名：FsoFileRead
	'作    用：读取文件
	'参    数：文件相对路径FilePath
	'==============================
	Public Function FsoFileRead(FilePath)
		Set objAdoStream = Server.CreateObject("A"&"dod"&"b.St"&"r"&"eam")
		objAdoStream.Type=2
		objAdoStream.mode=3  
		objAdoStream.charset="utf-8"
		objAdoStream.open 
		objAdoStream.LoadFromFile Server.MapPath(FilePath) 
		FsoFileRead=objAdoStream.ReadText 
		objAdoStream.Close
		Set objAdoStream=Nothing
	End Function
	
	'==============================
	'函 数 名：CreateFolder
	'作    用：创建文件夹
	'参    数：文件夹相对路径FolderPath
	'==============================
	Public Function CreateFolder(FolderPath)
		If FolderPath<>"" Then
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			Set F=Fso.CreateFolder(Server.MapPath(FolderPath))
			CreateFolder=F.Path
			Set F=Nothing
			Set Fso=Nothing
		End If
	End Function
	
	'==============================
	'函 数 名：CreateFile
	'作    用：创建文件
	'参    数：文件相对路径FilePath，文件内容FileContent
	'==============================
	Public Function CreateFile(FilePath,FileContent)
		Set objAdoStream = Server.CreateObject("A"&"dod"&"b.St"&"r"&"eam")
		objAdoStream.Type = 2
		objAdoStream.Charset = "utf-8" 
		objAdoStream.Open
		objAdoStream.WriteText = FileContent
		objAdoStream.SaveToFile Server.MapPath(FilePath),2
		objAdoStream.Close()
		Set objAdoStream = Nothing
	End Function
	
	'==============================
	'函 数 名：DelFolder
	'作    用：删除文件夹
	'参    数：文件夹相对路径FolderPath
	'==============================
	Public Function DelFolder(FolderPath)
		If IsFolder(FolderPath)=True Then
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			Fso.DeleteFolder(Server.MapPath(FolderPath))
			Set Fso=Nothing
		End If 
	End Function 
	
	'==============================
	'函 数 名：DelFile
	'作    用：删除文件
	'参    数：文件相对路径FilePath
	'==============================
	Public Function DelFile(FilePath)
		If IsFile(FilePath)=True Then 
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			Fso.DeleteFile(Server.MapPath(FilePath))
			Set Fso=Nothing
		End If
	End Function 
	 
	'==============================
	'函 数 名：IsFile
	'作    用：检测文件是否存在
	'参    数：文件相对路径FilePath
	'==============================
	Public Function IsFile(FilePath)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		If (Fso.FileExists(Server.MapPath(FilePath))) Then
			IsFile=True
		Else
			IsFile=False
		End If
		Set Fso=Nothing
	End Function
	
	'==============================
	'函 数 名：IsFolder
	'作    用：检测文件夹是否存在
	'参    数：文件相对路径FolderPath
	'==============================
	Public Function IsFolder(FolderPath)
		If FolderPath<>"" Then
			Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
			If Fso.FolderExists(Server.MapPath(FolderPath)) Then  
				IsFolder=True
			Else
				IsFolder=False
			End If
			Set Fso=Nothing
		End If
	End Function
	
	'==============================
	'函 数 名：CopyFiles
	'作    用：复制文件
	'参    数：文件来源地址SourcePath，文件复制到地址CopyToPath
	'==============================
	Public Function CopyFiles(SourcePath,CopyToPath)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		Fso.CopyFile Server.MapPath(SourcePath),Server.MapPath(CopyToPath)
		Set Fso=nothing
	End Function
	
	'==============================
	'函 数 名：CopyFolder
	'作    用：复制文件夹
	'参    数：源文件夹FolderName，复制到文件夹FolderPath
	'==============================
	Public Function CopyFolder(FolderName,FolderPath)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		If Fso.Folderexists(Server.MapPath(FolderName)) Then
			If Fso.FolderExists(Server.MapPath(FolderPath)) Then
				Fso.CopyFolder Server.MapPath(FolderName),Server.MapPath(FolderPath)
			Else
				Fso.CreateFolder(Server.MapPath(FolderPath))
				Fso.CopyFolder Server.MapPath(FolderName),Server.MapPath(FolderPath)
			End if 
		End If 
		Set Fso=nothing
	End Function 
	
	'==============================
	'函 数 名：ReNameFolder
	'作    用：重命名文件夹
	'参    数：原文件夹名FolderName，新文件夹名NewFolderName
	'==============================
	Public Function ReNameFolder(FolderName,NewFolderName)
		Set Fso=Server.CreateObject("Scri"&"pting.File"&"Sys"&"temObject")
		Fso.MoveFolder Server.MapPath(FolderName),Server.MapPath(NewFolderName)
		Set Fso=nothing
	End Function 
End Class
%>
