<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id fun_common.php 3 2008-08-24 10:34 $
*/
!defined('IN_MUDDER') && exit('Access Denied');

// 增加文章
function article_add($fields) {
    global $db, $dbpre;

    $fields['att'] = intval($fields['att']);
    $content = $fields['content'];
    unset($fields['content']);

    $db->insert_new($dbpre."articles", $fields);
    if($articleid = $db->insert_id()) {
        $db->update("REPLACE INTO {$dbpre}articledata SET articleid='$articleid',content='$content'");
        // 增加记录
        if($articleid && $fields['status']==1) {
            $db->update("UPDATE {$dbpre}articleclass SET articlenum=articlenum+1 WHERE classid='{$fields['classid']}'");
        }
    }
    return $articleid;
}

// 编辑文章
function article_edit($articleid, $fields, $opuid=-1) {
    global $db, $dbpre;
    $article = $db->get_one("SELECT * FROM {$dbpre}articles WHERE articleid='$articleid'");
    if(empty($article)) return false;

    $fields['att'] = intval($fields['att']);
    $content = $fields['content'];
    unset($fields['content']);

    // 更新分类统计
    if($article['status']=='2' && $fields['status']=='1') {
        // 通过审核
        $db->update("UPDATE {$dbpre}articleclass SET articlenum=articlenum+1 WHERE classid='{$fields['classid']}'");
    } elseif($article['status']=='1' && $fields['status']=='2') {
        // 还原为未审核
        $db->update("UPDATE {$dbpre}articleclass SET articlenum=articlenum-1 WHERE classid='{$article['classid']}'");
    } elseif($article['status']=='1' && $fields['status']=='1') {
        if($article['classid'] != $fields['classid']) {
            // 已审核的文章分类变化了，同步统计数量，原来的减少，新的增加
            $db->update("UPDATE {$dbpre}articleclass SET articlenum=articlenum+1 WHERE classid='{$fields['classid']}'");
            $db->update("UPDATE {$dbpre}articleclass SET articlenum=articlenum-1 WHERE classid='{$article['classid']}'");
        }
    }

    $db->update_new($dbpre."articles", "articleid='$articleid'", $fields);
    $db->update("UPDATE {$dbpre}articledata SET content='$content' WHERE articleid='$articleid'");
}

// 审核文章
function article_check($articleids, $checker) {
    global $db, $dbpre;

    if(!is_array($articleids)) return;
    $updata_article = array();
    $articleids = array_unique($articleids);
    $ids = "'".implode("','", $articleids)."'";
    $query = $db->query("SELECT articleid,classid,status FROM {$dbpre}articles WHERE articleid IN ($ids)");
    while($row = $db->fetch_array($query)) {
        if($row['status'] == '2') {
            $updata_article[] = $row['articleid'];
            $db->update("UPDATE {$dbpre}articleclass SET articlenum=articlenum+1 WHERE classid='{$row['classid']}'");
        }
    }
    $db->free_result($query);
    if($updata_article) {
        $ids = "'".implode("','", $updata_article)."'";
        $db->update("UPDATE {$dbpre}articles SET status=1,checker='$checker' WHERE articleid IN ($ids)");
    }
}

// 删除文章
function article_delete($articleids) {
    global $db, $dbpre;

    if(!is_array($articleids)) return;
    $delete_article = array();
    $articleids = array_unique($articleids);
    $ids = "'".implode("','", $articleids)."'";
    $query = $db->query("SELECT articleid,classid,status FROM {$dbpre}articles WHERE articleid IN ($ids)");
    while($row = $db->fetch_array($query)) {
        $delete_article[] = $row['articleid'];
        if($row['status'] == '1') {
            $db->update("UPDATE {$dbpre}articleclass SET articlenum=articlenum-1 WHERE classid='{$row['classid']}'");
        }
    }
    if($delete_article) {
        $ids = "'".implode("','", $delete_article)."'";
        // 删除文章
        $db->query("DELETE FROM {$dbpre}articles WHERE articleid IN($ids)");
        $db->query("DELETE FROM {$dbpre}articledata WHERE articleid IN($ids)");
    }
}

// 文章属性
function article_att($articleids, $att) {
    global $db, $dbpre;

    if(!is_array($articleids)) return;
    $att = intval($att);
    $articleids = array_unique($articleids);
    $ids = "'".implode("','", $articleids)."'";
    $db->update("UPDATE {$dbpre}articles SET att='$att' WHERE articleid IN ($ids)");
}

// 将分类写入缓存
function write_cache_articleclass($return = false) {
    global $db, $dbpre;

    $result = array();
    $query = $db->query("SELECT * FROM {$dbpre}articleclass ORDER BY displayorder");
    while($row = $db->fetch_array($query)) {
        $result[$row['classid']] = $row;
    }
    $db->free_result($query);
    write_cache('articleclass', arrayeval($result), '', 'return');

    if($return) return $result;
}

// 读取文章分类缓存
function read_cache_articleclass() {
    global $db, $dbpre;

    $cachefile = MUDDER_ROOT.'./data/cachefiles/cache_articleclass.php';
    if(check_cache($cachefile)) {
        return read_cache($cachefile);
    }

    return write_cache_articleclass(true);
}
?>