function validateshop(str){
	if(str.length == 0) return -1;
	if(!checkByteLength(str,2,40)) return 1;
	return 0;
}

function validateaddress(str) {
	if(str.length == 0) return -1;
	if(!checkByteLength(str,4,60)) return 1;
	return 0;
}

function checkaddstorefrm() {
	var frm = document.addstorefrm;
	var shopname = frm.shopname.value.trim();
	switch (validateshop(shopname)) {
	case -1:
		alert('请输入商铺名。');
		return false;
	case 1:
		alert('商铺名不能小于2个字符或大于200个字符。');
		return false;
	}
	if (frm.classcode.value.trim() == '') {
		alert('请选择商铺分类。');
		return false;
	}
	if (frm.areacode.value.trim() == '') {
		alert('请选择商铺所在地区。');
		return false;
	}
	var address = frm.address.value.trim();
	switch (validateaddress(address)) {
	case -1:
		alert('请输入商铺地址。');
		return false;
	case 1:
		alert('商铺地址不能小于4个字符或大于250个字符。');
		return false;
	}
	if(frm.content.value.length > 1000) {
		alert('商铺介绍不能大于1000个字符。');
		return false;
	}
	return true;

}

function validateshopid(obj){
	var str = obj.value;
	if(str.length == 0) return -1;
	if(!str>0) {
		alert('无效的商铺。');
		return false;
	}
	return true;
}

function validatesort(form){
	var sorts = form.getElementsByTagName('select');
	for (var i=0; i<sorts.length; i++) {
		sortname = sorts[i].name;
		if(sortname.match(/^sort[1-8]+$/) && sorts[i].value == '') {
			alert('尚未选择评价分数分。');
			sorts[i].focus();
			return false;
		}
	}
	return true;
}

function validateaveprice(obj) {
	var obj_w = document.getElementById('avgprice_w');
	var avg = obj.value.trim();
	avg = tot(avg);
	obj.value=avg;
	//if (avg.length==0){
	//	obj_w.innerHTML = '请输入人均消费额。';
	//	obj_w.style.display = "block";
	//	return false;
	if (is_numeric(avg)&&avg > 999999) {
		obj_w.innerHTML = '金额在1-999999之间。';
		obj_w.style.display = "block";
		obj.focus();
		return false;
	}

	obj_w.style.display = "none";
	return true;
}

function validatecontent(obj) {
	var obj_w = document.getElementById('content_w');
	var str=obj.value.trim();
	if (str.length==0) {
		obj_w.innerHTML = '请输入消费感受。';
		obj_w.style.display = "block";
		return false;
	}
	if(!checkByteLength(str,inputlimit_review_min,inputlimit_review_max)) {
		obj_w.innerHTML = '消费感受请控制在' + inputlimit_review_min + ' - ' + inputlimit_review_max + '个字符以内。';
		obj_w.style.display = "block";
		return false;
	}
	obj_w.style.display = "none";
	return true;
}

function checkaddreviewfrm() {
	var frm = document.addreviewfrm;
	var shopid = frm.shopid;
	var avgprice = frm.avgprice;
	var content = frm.content;
	if (validateshopid(shopid)&&validatesort(frm)&&
		validateaveprice(avgprice)&&validatecontent(content)) {
		frm.submit.disabled = true;
		return true;
	} else {
		return false;
	}
}

/*----------增加商铺----------*/

function searchshop (action) {
	var shopname = document.getElementById('shopname').value.trim();
	if (shopname == '') {
		alert('请输入商铺关键字。');
		return;
	}
	//var param = 'action=checkshop&option=1&shopname='+strcode(shopname);
	var option;
	$.get(siteurl+'ajax.php',{action:"checkshop",option:"1",shopname:shopname}, function(result) {
		if(result.trim() == '') {
			alert('操作无响应，可能网络忙碌，请稍后尝试。');
		} else if(result.match(/<option.+value.*/) || action == 'add') {
			option = '<select name="shop" onclick="selectshop(this);" size="9" style="width:250px">';
			option += result.match(/<option.+value.*/) ? result : '';
			option += '<option value="-1" class="font_2">以上都不是，选择添加新商户</option>';
			option += '</select>';
			$("#searchshop").html(option);
		} else {
			myAlert(result);
		}
	});
}

function selectshop(obj) {
	if (!obj) {
		alert('请先查找相关商铺。');
	}
	var shopid = obj.value;
	if (shopid == '') {
		alert('请选择需要进行点评的商铺。');
	} else if (shopid == '-1') {
		location.href = 'post.php?action=newshop';
	} else if(is_numeric(shopid) && shopid > 0){
		location.href = 'post.php?action=newreview&shopid='+shopid;
	}
}

function show_existshop() {

	var div = document.getElementById("existshop");
	var shopname = document.addstorefrm.shopname.value.trim();
	if (shopname=='') {
		alert('请输入商铺名。');
		return;
	}

	$.get(siteurl+'ajax.php', { action:"checkshop",shopname:shopname } , function(result) {
		myAlert(result);
	});

}

/*--上传图片--*/
function checkImgType(filename){
	var right_type=new Array(".gif",".jpg",".jpeg",".png");
	filename=filename.toLowerCase();
	var postfixLen=filename.length;
	var result=false;
	for (var i=0;i<right_type.length;i++){
		var ext = filename.substring(postfixLen-right_type[i].length,postfixLen);
		if(ext==right_type[i]){ 
			result=true;
			break;
		}
	}
	return result;
}

function imgcheckSize(img,min_w,min_h) {
	if(!img) return false;
	if(img.width>=min_w&&img.height>=min_h){
		return true;
	}else {
		return false;
	}
}

function checkupload () {
	var from = document.uploadfrom;
	var filepath = from.picture.value;
	if(!filepath){
		alert('请选择上传的图片。');
		return false;
	}
	if(filepath.lastIndexOf("\\")>0){
		var filename= filepath.substring(filepath.lastIndexOf("\\")+1,filepath.length);
  }
	if(filename){
		if(!checkImgType(filename)){
			alert('您上传的格式不正确，允许上传的格式有jpeg、jpg、gif、png.');
			return false;
		}
	}
	var r = from.getElementsByTagName('input');
	if(r){
		var checked=false;
		for (var i=0; i<r.length; i++)
			if (r[i].type=='radio'&&r[i].name=='sort'&&r[i].checked)
				checked = true;
		if(!checked){
			alert('请选择图片类型。');
			return false;
		}
	}else{
		alert('表单不完整，请重新刷新本页。');
		return false;
	}
	if(from.title.value.length==0){
		alert('请填写图片标题。');
		return false;
	}else if(from.title.value.length>20){
		alert('图片标题字数不能超过20个。');
		return false;
	}
	from.submitbutton.disabled = true;
	return true;
}