<?php
/**
* RSS聚合
* @author moufer<moufer@163.com>
* @package modoer
* @copyright Moufer Studio(www.modoer.com)
* @version $Id: rss.php 4 2008-01-10 12:35 $
*/

require_once './include/inc_common.php';

$cd = isset($cd) && preg_match("/^[0-9]+$/", $cd) && array_key_exists($cd, $_classcodes) ? $cd : '';
$rss_offset = 25;

if(strlen($cd) == 2) {
    $where = "WHERE b.classcode BETWEEN '{$cd}00' AND '{$cd}9999'";
} elseif(strlen($cd) == 4) {
    $where = "WHERE b.classcode='$cd'";
}

$query = $db->query("SELECT a.rid,a.shopid,a.uid,a.content,a.posttime,b.shopname,
	b.subname,c.username FROM {$dbpre}reviews a LEFT JOIN {$dbpre}shops b ON(a.shopid=b.sid) 
	LEFT JOIN {$dbpre}members c ON(a.uid=c.uid) $where ORDER BY a.posttime DESC LIMIT $rss_offset");

while($review = $db->fetch_array($query)) {
    $review['shopname'] .= $review['subname'] ? "({$review['subname']})" : '';
    $review['content'] = strip_textarea($review['content']);
    $newdata[] = $review;
}

@header("Content-Type: application/xml");
echo xmlRss($newdata, true);

function xmlRss($newdata, $xmlhead = false) {
    global $_config, $timestamp, $charset, $cd, $_modules;
    $link = $_modules['shop']['url'].'rss.php'.($cd ? '?cd='.$cd : ' ');
    $xml = ($xmlhead) ? '<?xml version="1.0" encoding="'.$charset.'"?>'."\r\n" : '';
    $xml.="<rss version=\"2.0\">\r\n";
    $xml.="<channel>\r\n";
    $xml.="<title>{$_config['sitename']}</title>\r\n";
    $xml.="<description>[modoer]{$_config['sitename']} RSS 聚合服务</description>\r\n";
    $xml.="<link>$link</link>\r\n";
    $xml.="<copyright>(C) 2007 - 08 Moufer studio</copyright>\r\n";
    $xml.="<docs>http://backend.userland.com/rss</docs>\r\n";
    if($newdata) foreach($newdata as $data){
        $xml.="<item>\r\n";
        $xml.="<title>{$data['username']}：{$data['shopname']}</title>\r\n";
        $xml.="<link>{$_modules['shop']['url']}shop.php?shopid={$data['shopid']}</link>\r\n";
        $xml.="<author>{$data['username']}</author>\r\n";
        $xml.="<description>\r\n";
        $xml.="<![CDATA[ \r\n";
        $xml.="$data[content]";
        $xml.="]]> \r\n";
        $xml.="</description>\r\n";
        $xml.="<pubDate>".date('Y-m-d H:i:s',$data['posttime'])."</pubDate>\r\n";
        $xml.="</item>\r\n";
    }
    $xml.="</channel>\r\n";
    $xml.="</rss>\r\n";
    return $xml;
}
?>