<?php

/* ========================================================================
 * $Id: site.onez.php 7510 2020-07-05 21:09:50Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onez.cn
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

!defined('IN_ONEZ') && exit('Access Denied');
class onezphp_bs_site extends onezphp{
  var $site=array();
  var $siteId=0;
  function __construct($site){
    $this->site=$site;
    $this->siteId=$site['id'];
    $_REQUEST['siteid']=$site['id'];
  }
  function purl($ptoken,$href){
    global $G;
    $href=str_replace('.php','',$href);
    $href=trim($href,'/');
    return '?_purl='.onez()->strcode("$ptoken\t$href\t{$G['site']['id']}",'ENCODE',onez('bs.plugins')->urlKey);
  }
  function init(){
    global $G;
    $G['bs']=$G['this'];
    $G['this']=$this;
    $this->data_alias='user'.$this->site['userid'];
    $this->token='site'.$this->siteId;
    $this->cname='site'.$this->siteId;
    $G['userid']=0;
    $cookie=onez('cache')->cookie($this->cname);
    if($cookie){
      list($id,$username,$type)=explode("\t",$cookie);
      if($id){
        if($type=='bs'){
          $user=onez('bs')->user($id);
          if($user){
            $G['member_real']=1;
            $user['avatar']=onez('bs')->avatar($id);
            $G['user']=$user;
            $G['userid']=$user['userid'];
          }
        }else{
          $user=$this->user($id,'info');
          if($user){
            $user['avatar']=$this->avatar($id);
            $G['user']=$user;
            $G['userid']=$user['id'];
          }
        }
      }
    }
    $_purl=onez()->gp('_purl');
    if($_purl){
      onez('bs.plugins')->urlParse($_purl);
    }
    return $this;
  }
  #网站公共引用
  function www_app(){
    global $G,$A;
    $this->slot('/run/app');
  }
  #匹配卡槽
  function slot($key,&$data=false){
    global $G;
    if(strpos($key,'./')===false){
      if($this->site['lockPlugin']){
        $this->site['plugins']=array_merge(array(
          array(
            'token'=>$this->site['lockPlugin'],
          ),
        ),$this->site['plugins']);
      }
      if($this->site['plugins']){
        foreach($this->site['plugins'] as $v){
          if($v['token']){
            $ptoken="bs.plugins.$v[token]";
            if(!onez()->exists($ptoken)){
              $ptoken=$v['token'];
            }
            if(onez()->exists($ptoken)){
              $file=onez($ptoken)->path.'/comps'.$key.'.php';
              if($file){
                $plugin=onez($ptoken);
                $this->plugin=$plugin;
                include($file);
              }
            }
          }
        }
      }
    }
  }
  function userdb(){
    return onez('data','user'.$this->site['user'])->noappid();
  }
  function data(){
    return onez('data','data'.$this->site['data'])->noappid();
  }
  #当前应用需要登录
  function login($loginFile=false){
    global $G;
    if(!$G['userid']){
      if($loginFile===false || strpos($loginFile,'./')!==false || !file_exists($loginFile)){
        include_once(dirname(__FILE__).'/www/login/login.php');
      }else{
        include_once($loginFile);
      }
      exit();
    }
  }
  function pc(){
    global $G;
    $action=onez()->gp('action');
    if($action=='logout'){#退出
      onez('cache')->cookie($G['this']->cname,'del');
      onez()->ok('操作成功','reload');
    }
    $G['title']=$this->site['name'];
    onez('vue')->init(dirname(__FILE__).'/www/index.php');
    #onez('vue')->set('tpl','AdminLTE')->tpl();
    $this->slot('/run/pc');
    #是否需要更新
    $siteFile=ONEZ_CACHE_PATH.'/plugins/bs/sites/infos/'.$this->siteId.'.php';
    $buildFile=ONEZ_CACHE_PATH.'/plugins/bs/sites/infos/'.$this->siteId.'.build';
    if(!file_exists($buildFile) || filemtime($buildFile)<filemtime($siteFile)){
      onez('vue')->build();
      @touch($buildFile);
    }
    onez('vue')->pc('index');
  }
  /**
  * 用户资料
  * @param Number $userid
  * @param String $field
  * 
  * @return
  */
  function user($userid,$field=false){
    global $G;
    if(is_array($userid)){
      $user=$userid;
      $userid=$user['id'];
    }
    if(!$this->allUsers[$userid]){
      !$user && $user=$this->userdb()->open('member')->one("id='$userid'");
      if($user){
        $user['grade']=$user['key1'];
        $user['username']=$user['key2'];
        $user['password']=$user['key3'];
        !$user['nickname'] && $user['nickname']=$user['key4'];
        !$user['nickname'] && $user['nickname']=$user['username'];
        $user['createType']=$user['key5'];
      }
      $this->allUsers[$userid]=$user;
    }
    if($field!==false){
      if($field=='info'){
        $user=$this->allUsers[$userid];
        $showInfo=array();
        $showInfo['id']=$showInfo['userid']=$user['id'];
        $showInfo['grade']=$user['key1'];
        $showInfo['username']=$user['key2'];
        #$showInfo['password']=$user['key3'];
        $showInfo['nickname']=$user['key4'];
        !$showInfo['nickname'] && $showInfo['nickname']=$user['key2'];
        $showInfo['createType']=$user['key5'];
        $showInfo['email']=$user['key6'];
        $showInfo['mobile']=$user['key7'];
        $showInfo['ownerUid']=$user['index11'];
        $showInfo['siteId']=$user['index12'];
        $showInfo['avatar']=$this->avatar($user['id']);
        return $showInfo;
      }
      return $this->allUsers[$userid][$field];
    }
    return $this->allUsers[$userid];
  }
  //系统设置
  function setting($key=false){
    global $G;
    if(!$this->_setting){
      $siteId=$G['this']->site['id'];
      $setting=$G['this']->data()->open('setting')->one("index12='$siteId'");
      $this->_setting=$setting;
    }
    if($key!==false){
      return $this->_setting[$key];
    }
    return $this->_setting;
  }
  #增加我的消息
  function addMessage($userid,$content,$linkname='',$linkurl=''){
    global $G;
    $days=(int)$G['this']->setting('days_message');
    if($days>0){
      $G['this']->data()->open('message')->delete("addtime<".(time()-$days*86400));
    }
    $item=array();
    $item['userid']=$userid;
    $item['key1']=$item['content']=$content;
    $item['key2']=$item['linkname']=$linkname;
    $item['key3']=$item['linkurl']=$linkurl;
    $id=$G['this']->data()->open('message')->insert($item);
    return $id;
  }
  //头像
  function avatar($userid){
    global $G;
  	$myid = sprintf("%09d", $userid);
  	$dir1 = substr($myid, 0, 3);
  	$dir2 = substr($myid, 3, 2);
  	$dir3 = substr($myid, 5, 2);
    $avatarFile='/avatars/users/'.$this->site['user'].'/'.$dir1.'/'.$dir2.'/'.$dir3.'/'.substr($myid, -2).'.jpg';
    if(file_exists(ONEZ_CACHE_PATH.$avatarFile)){
      return ONEZ_CACHE_URL.$avatarFile.'?t='.filemtime(ONEZ_CACHE_PATH.$avatarFile);
    }else{
      $avatar=$this->user($userid,'avatar');
      if($avatar){
        $this->avatar_set($userid,$avatar);
        return ONEZ_CACHE_URL.$avatarFile.'?t='.filemtime(ONEZ_CACHE_PATH.$avatarFile);
      }
      return onez('bs')->url.'/images/avatar.png';
    }
  }
  function avatar_set($userid,$url){
    global $G;
    $usertype=$this->usertype();
  	$myid = sprintf("%09d", $userid);
  	$dir1 = substr($myid, 0, 3);
  	$dir2 = substr($myid, 3, 2);
  	$dir3 = substr($myid, 5, 2);
    $avatarFile='/avatars/users/'.$this->site['user'].'/'.$dir1.'/'.$dir2.'/'.$dir3.'/'.substr($myid, -2).'.jpg';
    
    $opts=array(
       'http'=>array(
         'method'=>'GET',
         'timeout'=>3,
       )
    );
    $context = stream_context_create($opts);
    $data=@file_get_contents($url,false,$context);
    if($data){
      onez()->write(ONEZ_CACHE_PATH.$avatarFile,$data);
    }
    return $this;
  }
  function weixin_info($key){
    global $G;
    return $G['this']->myoption('weixin_'.$key);
  }
}