<?php

/* ========================================================================
 * $Id: datatable.php 5427 2020-06-16 05:16:10Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onez.cn
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

!defined('IN_ONEZ') && exit('Access Denied');
class onezphp_vue_plugin_datatable extends onezphp{
  var $cols=array();
  var $colBtns=array();
  function __construct(){
    
  }
  function add($col,$field=false,$opt=false){
    if(is_string($col) && is_string($field)){
      !is_array($opt) && $opt=array();
      $opt['field']=$field;
      $opt['title']=$col;
      $this->cols[]=$opt;
      return $this;
    }
    /**
    * array(
      'field'=>'id',#字段
      'title'=>'标题',#标题
      'sortable'=>false,#是否支持排序
      'width'=>100,#宽度
      'type'=>'number',#数据类型
      'textAlign'=>'center',#对齐方式
      'autoHide'=>false,#自动隐藏
    )
    * 
    */
    $this->cols[]=$col;
    return $this;
  }
  function addBtn($btn){
    $this->colBtns[]=$btn;
    return $this;
  }
  function output(&$data,$option=array()){
    global $G;
    
    $kw=onez()->gp('kw');
    
    $data['kw']=$kw;
    $data['cols']=$this->cols;
    
    $colBtns=$this->colBtns;
    if($edit=$this->get('edit')){
      !is_array($edit) && $edit=array();
      $colBtns[]=onez('vue')->array_merge(array(
        'name'=>'编辑',
        'skin'=>'success',
        'event'=>array(
          'token'=>'page',
          'option'=>array(
            'title'=>'编辑',
            'width'=>960,
            'height'=>600,
          ),
          'action'=>'./edit.php?id=${id}',
        ),
      ),$edit);
    }
    if($del=$this->get('del')){
      !is_array($del) && $del=array();
      $colBtns[]=onez('vue')->array_merge(array(
        'name'=>'删除',
        'skin'=>'danger',
        'event'=>array(
          'token'=>'remote',
          'confirm'=>'您确定要删除这条记录吗？',
          'postdata'=>array(
            'action'=>'data',
            'ac'=>'del',
            'id'=>'${id}',
          ),
        ),
      ),$del);
    }
    if($colBtns){
      $btnsOption=$this->get('btns.option');
      !$btnsOption && $btnsOption=array();
      $data['cols'][]=array_merge(array(
        'title'=>'操作',
        'btns'=>$colBtns,
        'width'=>$this->get('width'),
      ),$btnsOption);
    }
    $data['record']=array();
    $pagesize=onez()->gp('perpage');
    !$pagesize && $pagesize=(int)$option['pagesize'];
    !$pagesize && $pagesize=20;
    $page=max(1,(int)onez()->gp('page'));
    
    !$option['where'] && $option['where']='1';
    
    $db=$option['db'];
    if(!$db){
      if($option['type']=='real'){
        $db=onez('db');
      }else{
        $db=$G['this']->data();
      }
    }
    $fields=$this->get('fields');
    $fields && is_string($fields) && $fields=explode(',',$fields);
    
    $data['caption']=''.$option['caption'];
    $data['noContent']=''.$option['noContent'];
    $data['pageSize']=$pagesize;
    if($option['query']){
      $DB=$db->open($option['table'])->db;
      $result=$DB->query(str_replace(' * ',' count(*) as id ',$option['query']));
      $r=$DB->fetch_array($result);
      $data['total']=$r['id'];
    }else{
      $data['total']=(int)$db->open($option['table'])->rows($option['where']);
    }
    
    $data['pageCount']=max(1,ceil($data['total']/$pagesize));
    if($page>$data['pageCount']){
      $page=$data['pageCount'];
    }
    $pagelimit=' limit '.(($page-1)*$pagesize).','.$pagesize;
    $data['page']=$page;
    $data['pages']=array();
    if(!$option['noPage']){
      $begin=1;
      $end=$data['pageCount'];
      if($data['pageCount']>7){
        $begin=max(1,$data['page']-3);
        $end=min($begin+6,$data['pageCount']);
      }
      if($data['page']>1){
        $data['pages'][]=array('name'=>'首页','page'=>1,);
        $data['pages'][]=array('name'=>'上一页','page'=>$data['page']-1,);
      }
      for($i=$begin;$i<=$end;$i++){
        $data['pages'][]=array('name'=>"$i",'page'=>$i,);
      }
      if($data['page']<$data['pageCount']){
        $data['pages'][]=array('name'=>'下一页','page'=>$data['page']+1,);
        $data['pages'][]=array('name'=>'尾页','page'=>$data['pageCount'],);
      }
    }
    
    if($option['query']){
      $DB=$db->open($option['table'])->db;
      $result=$DB->query($option['query'].$pagelimit);
      $record = Array();
      while($onez=$DB->fetch_array($result)){
        $record[]=onez('data')->parse($onez);
      }
      $T=$record;
    }else{
      $T=$db->open($option['table'])->record("$option[where]$pagelimit");
    }
    $colFunc=$this->get('colFunc');
    foreach($T as $rs){
      $item=array();
      if($colFunc){
        $colFunc($rs,$fields);
      }
      foreach($this->cols as $col){
        if($col['icon']){
          $fields[]=$col['icon'];
        }
        if($col['function']){
          $item[$col['field']]=$col['function']($rs);
          continue;
        }
        if($col['type']=='time'){#时间
          $rs[$col['field']]=date($col['format']?$col['format']:'Y-m-d H:i:s',$rs[$col['field']]);
        }elseif($col['type']=='number'){
          $rs[$col['field']]=''.intval($rs[$col['field']]);
        }elseif($col['type']=='user'){
          $rs[$col['field']]='<img src="'.onez('bs')->avatar($rs[$col['field']]).'" style="width:16px;height:16px;" /> '.onez('bs')->user($rs[$col['field']],'nickname');
        }
        $item[$col['field']]=$rs[$col['field']];
      }
      if($fields){
        foreach($fields as $v){
          $item[$v]=$rs[$v];
        }
      }
      $data['record'][]=$item;
    }
    
  }
}