<?php
if(!defined('InEmpireBak'))
{
	@include_once('../../../ebma.php');
	if(!defined('EbakFourCheck'))
	{
		exit();
	}
	if(EbakFourCheck==''||EbakFourCheck=='EbakFourCheck')
	{
		exit();
	}
	if(EbakFourCheck<>'dg'.$_COOKIE['qebak_efourcheck'])
	{
		exit();
	}
}
if(!defined('InEmpireApi'))
{
	exit();
}
?><?php
/* vim: set expandtab sw=4 ts=4 sts=4: */
/**
 * @package PhpMyAdmin-Engines
 */

if (! defined('PHPMYADMIN')) {
    exit;
}

/**
 *
 * @package PhpMyAdmin-Engines
 */
class PMA_StorageEngine_innodb extends PMA_StorageEngine
{
    /**
     * @return  array
     */
    function getVariables()
    {
        return array(
            'innodb_data_home_dir' => array(
                'title' => __('Data home directory'),
                'desc'  => __('The common part of the directory path for all InnoDB data files.'),
            ),
            'innodb_data_file_path' => array(
                'title' => __('Data files'),
            ),
            'innodb_autoextend_increment' => array(
                'title' => __('Autoextend increment'),
                'desc'  => __('The increment size for extending the size of an autoextending tablespace when it becomes full.'),
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_buffer_pool_size' => array(
                'title' => __('Buffer pool size'),
                'desc'  => __('The size of the memory buffer InnoDB uses to cache data and indexes of its tables.'),
                'type'  => PMA_ENGINE_DETAILS_TYPE_SIZE,
            ),
            'innodb_additional_mem_pool_size' => array(
                'title' => 'innodb_additional_mem_pool_size',
                'type'  => PMA_ENGINE_DETAILS_TYPE_SIZE,
            ),
            'innodb_buffer_pool_awe_mem_mb' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_SIZE,
            ),
            'innodb_checksums' => array(
            ),
            'innodb_commit_concurrency' => array(
            ),
            'innodb_concurrency_tickets' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_doublewrite' => array(
            ),
            'innodb_fast_shutdown' => array(
            ),
            'innodb_file_io_threads' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_file_per_table' => array(
            ),
            'innodb_flush_log_at_trx_commit' => array(
            ),
            'innodb_flush_method' => array(
            ),
            'innodb_force_recovery' => array(
            ),
            'innodb_lock_wait_timeout' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_locks_unsafe_for_binlog' => array(
            ),
            'innodb_log_arch_dir' => array(
            ),
            'innodb_log_archive' => array(
            ),
            'innodb_log_buffer_size' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_SIZE,
            ),
            'innodb_log_file_size' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_SIZE,
            ),
            'innodb_log_files_in_group' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_log_group_home_dir' => array(
            ),
            'innodb_max_dirty_pages_pct' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_max_purge_lag' => array(
            ),
            'innodb_mirrored_log_groups' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_open_files' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_support_xa' => array(
            ),
            'innodb_sync_spin_loops' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_table_locks' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_BOOLEAN,
            ),
            'innodb_thread_concurrency' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
            'innodb_thread_sleep_delay' => array(
                'type'  => PMA_ENGINE_DETAILS_TYPE_NUMERIC,
            ),
         );
    }

    /**
     * @return  string  SQL query LIKE pattern
     */
    function getVariablesLikePattern()
    {
        return 'innodb\\_%';
    }

    /**
     * @return  array   detail pages
     */
    function getInfoPages()
    {
        if ($this->support < PMA_ENGINE_SUPPORT_YES) {
            return array();
        }
        $pages = array();
        $pages['Bufferpool'] = __('Buffer Pool');
        $pages['Status'] = __('InnoDB Status');
        return $pages;
    }

    /**
     * returns html tables with stats over inno db buffer pool
     *
     * @return  string  html table with stats
     */
    function getPageBufferpool()
    {
        // The following query is only possible because we know
        // that we are on MySQL 5 here (checked above)!
        // side note: I love MySQL 5 for this. :-)
        $sql = '
             SHOW STATUS
            WHERE Variable_name LIKE \'Innodb\\_buffer\\_pool\\_%\'
               OR Variable_name = \'Innodb_page_size\';';
        $status = PMA_DBI_fetch_result($sql, 0, 1);

        $output = '<table class="data" id="table_innodb_bufferpool_usage">' . "\n"
                . '    <caption class="tblHeaders">' . "\n"
                . '        ' . __('Buffer Pool Usage') . "\n"
                . '    </caption>' . "\n"
                . '    <tfoot>' . "\n"
                . '        <tr>' . "\n"
                . '            <th colspan="2">' . "\n"
                . '                ' . __('Total') . "\n"
                . '                : ' . PMA_formatNumber(
                        $status['Innodb_buffer_pool_pages_total'], 0)
                . '&nbsp;' . __('pages')
                . ' / '
                . join('&nbsp;',
                    PMA_formatByteDown($status['Innodb_buffer_pool_pages_total'] * $status['Innodb_page_size'])) . "\n"
                . '            </th>' . "\n"
                . '        </tr>' . "\n"
                . '    </tfoot>' . "\n"
                . '    <tbody>' . "\n"
                . '        <tr class="odd">' . "\n"
                . '            <th>' . __('Free pages') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_pages_free'], 0)
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="even">' . "\n"
                . '            <th>' . __('Dirty pages') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_pages_dirty'], 0)
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="odd">' . "\n"
                . '            <th>' . __('Pages containing data') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_pages_data'], 0) . "\n"
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="even">' . "\n"
                . '            <th>' . __('Pages to be flushed') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_pages_flushed'], 0) . "\n"
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="odd">' . "\n"
                . '            <th>' . __('Busy pages') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_pages_misc'], 0) . "\n"
                . '</td>' . "\n"
                . '        </tr>';

            // not present at least since MySQL 5.1.40
            if (isset($status['Innodb_buffer_pool_pages_latched'])) {
                $output .= '        <tr class="even">'
                . '            <th>' . __('Latched pages') . '</th>'
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_pages_latched'], 0)
                . '</td>'
                . '        </tr>';
            }

            $output .= '    </tbody>' . "\n"
                . '</table>' . "\n\n"
                . '<table class="data" id="table_innodb_bufferpool_activity">' . "\n"
                . '    <caption class="tblHeaders">' . "\n"
                . '        ' . __('Buffer Pool Activity') . "\n"
                . '    </caption>' . "\n"
                . '    <tbody>' . "\n"
                . '        <tr class="odd">' . "\n"
                . '            <th>' . __('Read requests') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_read_requests'], 0) . "\n"
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="even">' . "\n"
                . '            <th>' . __('Write requests') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_write_requests'], 0) . "\n"
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="odd">' . "\n"
                . '            <th>' . __('Read misses') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_reads'], 0) . "\n"
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="even">' . "\n"
                . '            <th>' . __('Write waits') . '</th>' . "\n"
                . '            <td class="value">'
                . PMA_formatNumber($status['Innodb_buffer_pool_wait_free'], 0) . "\n"
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="odd">' . "\n"
                . '            <th>' . __('Read misses in %') . '</th>' . "\n"
                . '            <td class="value">'
                . ($status['Innodb_buffer_pool_read_requests'] == 0
                    ? '---'
                    : htmlspecialchars(PMA_formatNumber($status['Innodb_buffer_pool_reads'] * 100 / $status['Innodb_buffer_pool_read_requests'], 3, 2)) . ' %') . "\n"
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '        <tr class="even">' . "\n"
                . '            <th>' . __('Write waits in %') . '</th>' . "\n"
                . '            <td class="value">'
                . ($status['Innodb_buffer_pool_write_requests'] == 0
                    ? '---'
                    : htmlspecialchars(PMA_formatNumber($status['Innodb_buffer_pool_wait_free'] * 100 / $status['Innodb_buffer_pool_write_requests'], 3, 2)) . ' %') . "\n"
                . '</td>' . "\n"
                . '        </tr>' . "\n"
                . '    </tbody>' . "\n"
                . '</table>' . "\n";
        return $output;
    }

    /**
     * returns InnoDB status
     *
     * @return  string  result of SHOW INNODB STATUS inside pre tags
     */
    function getPageStatus()
    {
        return '<pre id="pre_innodb_status">' . "\n"
            . htmlspecialchars(PMA_DBI_fetch_value('SHOW INNODB STATUS;', 0, 'Status')) . "\n"
            . '</pre>' . "\n";
    }

    /**
     * returns content for page $id
     *
     * @param   string  $id page id
     * @return  string  html output
     */
    function getPage($id)
    {
        if (! array_key_exists($id, $this->getInfoPages())) {
            return false;
        }

        $id = 'getPage' . $id;

        return $this->$id();
    }

    /**
     * returns string with filename for the MySQL helppage
     * about this storage engne
     *
     * @return  string  mysql helppage filename
     */
    function getMysqlHelpPage()
    {
        return 'innodb';
    }

    /**
     *  
     * Gets the InnoDB plugin version number 
     * http://www.innodb.com/products/innodb_plugin 
     * (do not confuse this with phpMyAdmin's storage engine plugins!)
     *
     * @return string the version number, or empty if not running as a plugin 
     */
    function getInnodbPluginVersion()
    {
        return PMA_DBI_fetch_value('SELECT @@innodb_version;');
    }

    /**
     *  
     * Gets the InnoDB file format 
     * (works only for the InnoDB plugin)
     * http://www.innodb.com/products/innodb_plugin 
     * (do not confuse this with phpMyAdmin's storage engine plugins!)
     *
     * @return string the InnoDB file format 
     */
    function getInnodbFileFormat()
    {
        return PMA_DBI_fetch_value("SHOW GLOBAL VARIABLES LIKE 'innodb_file_format';", 0, 1);
    }

    /**
     *  
     * Verifies if this server supports the innodb_file_per_table feature 
     * (works only for the InnoDB plugin)
     * http://www.innodb.com/products/innodb_plugin 
     * (do not confuse this with phpMyAdmin's storage engine plugins!)
     *
     * @return boolean whether this feature is supported or not 
     */
    function supportsFilePerTable()
    {
        $innodb_file_per_table = PMA_DBI_fetch_value("SHOW GLOBAL VARIABLES LIKE 'innodb_file_per_table';", 0, 1);
        if ($innodb_file_per_table == 'ON') {
            return true;
        } else {
            return false;
        }

    }
}

?>
