SET NAMES 'utf8';
SET CHARACTER_SET_CLIENT=utf8;
SET CHARACTER_SET_RESULTS=utf8;


DROP TABLE IF EXISTS `#@__admin`;
CREATE TABLE `#@__admin` (
  `aid` int(11) NOT NULL auto_increment,
  `id` text,
  `pw` text,
  `level` int(11) default NULL,
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#@__config`;
CREATE TABLE `#@__config` (
  `id` int(11) NOT NULL default '0',
  `title` text,
  `value` text,
  `info` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@__minimun`;
CREATE TABLE `#@__minimun` (
  `sid` int(11) NOT NULL DEFAULT '0',
  `value` text,
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#@__module`;
CREATE TABLE `#@__module` (
  `id` int(11) NOT NULL auto_increment,
  `name` text,
  `active` int(11) default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `#@__order`;
CREATE TABLE `#@__order` (
  `oid` int(11) NOT NULL auto_increment,
  `uid` int(11) default NULL,
  `express` text,
  `esn` text,
  `dsn` text,
  `rname` text,
  `rmob` text,
  `radd` text,
  `rtel` text,
  `rcode` text,
  `note` text,
  `datetime` datetime NOT NULL,
  `delete` int(11) NOT NULL,
  `situation` int(11) NOT NULL,
  `payment` text NOT NULL,
  `paid` int(11) NOT NULL default '0',
  `express_time` datetime NOT NULL,
  `score` text,
  `price` text,
  `refund` text,
  `remail` text,
  PRIMARY KEY  (`oid`),
  UNIQUE KEY `oid` (`oid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `#@__order_item`;
CREATE TABLE `#@__order_item` (
  `iid` int(11) NOT NULL auto_increment,
  `uid` int(11) default NULL,
  `oid` int(11) default NULL,
  `sid` int(11) default NULL,
  `amount` text,
  `price` text,
  `item` text NOT NULL,
  PRIMARY KEY  (`iid`),
  UNIQUE KEY `iid` (`iid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#@__paypal`;
CREATE TABLE `#@__paypal` (
  `pid` int(11) NOT NULL AUTO_INCREMENT,
  `item_name` text,
  `payment_status` text,
  `payment_amount` text,
  `payer_id` text,
  `payment_currency` text,
  `mc_fee` text,
  `txn_id` text,
  `receiver_email` text,
  `payer_email` text,
  `datetime` datetime DEFAULT NULL,
  `address_city` text,
  `address_country` text,
  `address_country_code` text,
  `address_name` text,
  `address_state` text,
  `address_street` text,
  `address_zip` text,
  `first_name` text,
  `last_name` text,
  `payer_business_name` text,
  `payer_status` text,
  `residence_country` text,
  `paidtime` datetime DEFAULT NULL,
  `custom` text,
  PRIMARY KEY (`pid`),
  UNIQUE KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#@__restock`;
CREATE TABLE `#@__restock` (
  `sid` int(11) NOT NULL DEFAULT '0',
  `value` text,
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#@__save`;
CREATE TABLE `#@__save` (
  `id` int(11) NOT NULL auto_increment,
  `value` text,
  `datetime` datetime default NULL,
  `ip` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `#@__session`;
CREATE TABLE `#@__session` (
  `sid` int(11) NOT NULL auto_increment,
  `uid` int(11) NOT NULL,
  `v` varchar(255) NOT NULL,
  `v2` int(30) default NULL,
  `v3` int(30) default NULL,
  `type` int(11) default NULL,
  PRIMARY KEY  (`sid`),
  UNIQUE KEY `sid` (`sid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `#@__stock`;
CREATE TABLE `#@__stock` (
  `sid` int(11) NOT NULL auto_increment,
  `name` text,
  `tid` int(11) default NULL,
  `cid` int(11) default NULL,
  `delete` int(11) default '0',
  `pricemodel` int(11) default NULL,
  `onsale` int(11) default '1',
  `other_shop_id` int(11) default NULL,
  PRIMARY KEY  (`sid`),
  UNIQUE KEY `sid` (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `#@__stock_attachment`;
CREATE TABLE `#@__stock_attachment` (
  `aid` int(11) NOT NULL auto_increment,
  `type` text,
  `sid` int(11) default NULL,
  `value1` text,
  `value2` text,
  PRIMARY KEY  (`aid`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `#@__stock_item`;
CREATE TABLE `#@__stock_item` (
  `iid` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) DEFAULT NULL,
  `name` text,
  `quality1` text,
  `quality2` text,
  `quality3` text,
  `quantity` text,
  `price` decimal(15,6) DEFAULT NULL,
  `model` text,
  `sale` int(11) DEFAULT NULL,
  `joindate` datetime DEFAULT NULL,
  `lastdate` datetime DEFAULT NULL,
  `unit` text,
  `stock` text,
  `otherquality` text,
  `batch` text,
  PRIMARY KEY (`iid`),
  UNIQUE KEY `iid` (`iid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `#@__stock_type`;
CREATE TABLE `#@__stock_type` (
  `tid` int(11) NOT NULL auto_increment,
  `name` text,
  `rank` int(11) default NULL,
  `father` int(11) default NULL,
  `other_shop_id` int(11) default NULL,
  PRIMARY KEY  (`tid`),
  UNIQUE KEY `tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `#@__to_categories`;
CREATE TABLE `#@__to_categories` (
  `products_id` int(11) NOT NULL default '0',
  `categories_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`products_id`,`categories_id`),
  KEY `idx_cat_prod_id_zen` (`categories_id`,`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `#@__user`;
CREATE TABLE `#@__user` (
  `uid` int(11) NOT NULL auto_increment,
  `id` text,
  `password` text,
  `name` text,
  `level` int(11) default NULL,
  `salesvolume` text,
  `ordercount` text,
  `advance` int(11) default NULL,
  `score` text,
  `website` text NOT NULL,
  `qq` text,
  `add` text,
  `email` text,
  `tel` text,
  `delete` int(11) default NULL,
  `jointime` datetime NOT NULL,
  `lasttime` datetime NOT NULL,
  `mob` text,
  `zipcode` text,
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `#@__vip`;
CREATE TABLE `#@__vip` (
  `vid` int(11) NOT NULL auto_increment,
  `level` text,
  `discount` text,
  `scores` text,
  `scores_limit` text NOT NULL,
  PRIMARY KEY  (`vid`),
  UNIQUE KEY `vid` (`vid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


