<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

use Doctrine\DBAL\Driver\PDOMySql\Driver as PDOMySqlDriver;

return [
    'translator'    => [
        'locale' => 'zh_CN',
        'translation_file_patterns' => [
            [
                'type' => 'phpArray',
                'base_dir' => \Admin\Validator\Resources::getBasePath(),
                'pattern'  => \Admin\Validator\Resources::getPatternForValidator()
            ],
            [
                'type' => 'phpArray',
                'base_dir' => \Admin\Validator\Resources::getBasePath(),
                'pattern'  => \Admin\Validator\Resources::getPatternForCaptcha()
            ],
        ]
    ],

    'doctrine' => [
        'connection' => [
            'orm_default' => [
                'driverClass' => PDOMySqlDriver::class,
                //'driverClass' => Doctrine\DBAL\Driver\PDOPgSql\Driver::class,
                'params' => require 'data/shopDatabase.php'
            ],
            'orm_read_default' => [
                'driverClass' => PDOMySqlDriver::class,
                'params' => require 'data/shopDatabase.php'
            ],
        ],
        'configuration' => [
            'orm_default' => [
                'proxy_dir' => 'data/cache/Doctrine/DoctrineORMModule/Proxy'
            ]
        ],
        'entitymanager' => [
            'orm_read_default' => [
                'connection' => 'orm_read_default'
            ]
        ]
    ],
];
