<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

$baseFramework = [
    'Laminas\Paginator',
    'Laminas\Serializer',
    'Laminas\InputFilter',
    'Laminas\Filter',
    'Laminas\Hydrator',
    'Laminas\ServiceManager\Di',
    'Laminas\Session',
    'Laminas\Mvc\Plugin\Prg',
    'Laminas\Mvc\Plugin\Identity',
    'Laminas\Mvc\Plugin\FlashMessenger',
    'Laminas\Mvc\Plugin\FilePrg',
    'Laminas\Mvc\I18n',
    'Laminas\I18n',
    'Laminas\Mvc\Console',
    'Laminas\Log',
    'Laminas\Form',
    'Laminas\Db',
    'Laminas\Cache',
    'Laminas\Router',
    'Laminas\Validator',

    'DoctrineModule',
    'DoctrineORMModule',

    'ZfcTwig',
];

$shopModule = ['Install'];
if (file_exists('data/install.lock')) {
    $shopModule = [
        'Admin',    //系统
        'Analysis', //统计
        'Cms',      //文章
        'Extend',   //扩展
        'Goods',    //商品
        'Operation',//运营
        'Sales',    //销售
        'User',     //客户
        'Shop',     //前台
        'Install',  //安装
    ];

    //插件
    if (file_exists('data/moduleData/Plugin/plugin.module.php')) {
        $pluginModule = require 'data/moduleData/Plugin/plugin.module.php';
        if (!empty($pluginModule)) $shopModule = array_merge($shopModule, $pluginModule);
    }
}

return array_merge($baseFramework, $shopModule);
