<?php
return [
    'paymentName' => [
        'title' => '支付方式名称',
        'content' => 'PayPal国际支付',
        'nameId' => 'paymentName',
        'inputType' => 'text',
        'class' => 'form-control',
        'width' => 'col-sm-6',
    ],
    'paymentLogo' => [
        'title' => '支付方式Logo',
        'content' => 'upload/payment/paypal.jpg',
        'nameId' => 'paymentLogo',
        'inputType' => 'image',
    ],
    'paymentType' => [
        'title' => 'PayPal账户类型',
        'content' => [
            'option1' => [
                'name' => 'sandbox测试账户',
                'value' => 'sandbox',
            ],
            'option2' => [
                'name' => 'PayPal真实账户',
                'value' => 'live',
            ],
        ],
        'nameId' => 'paymentType',
        'inputType' => 'select',
        'class' => 'form-control',
        'width' => 'col-sm-2',
        'selected' => 'live',
    ],
    'clientId' => [
        'title' => 'Client ID',
        'content' => '',
        'nameId' => 'clientId',
        'inputType' => 'text',
        'class' => 'form-control',
        'width' => 'col-sm-6',
    ],
    'clientSecret' => [
        'title' => 'Client Secret',
        'content' => '',
        'nameId' => 'clientSecret',
        'inputType' => 'text',
        'class' => 'form-control',
        'width' => 'col-sm-6',
    ],
    'paymentShow' => [
        'title' => '显示设置',
        'content' => [
            'content1' => [
                'name' => '电脑端显示',
                'value' => 'pc',
            ],
            'content2' => [
                'name' => '手机端显示',
                'value' => 'phone',
            ],
        ],
        'nameId' => 'paymentShow',
        'inputType' => 'checkbox',
        'checked' => [
            0 => 'pc',
            1 => 'phone',
        ],
    ],
    'paymentCurrency' => [
        'title' => '可用货币',
        'content' => [
            'content1' => [
                'name' => '美元',
                'value' => 'USD',
            ],
            'content2' => [
                'name' => '加拿大元',
                'value' => 'CAD',
            ],
            'content3' => [
                'name' => '欧元',
                'value' => 'EUR',
            ],
            'content4' => [
                'name' => '英镑',
                'value' => 'GBP',
            ],
            'content5' => [
                'name' => '日元',
                'value' => 'JPY',
            ],
            'content6' => [
                'name' => '澳元',
                'value' => 'AUD',
            ],
            'content7' => [
                'name' => '新西兰元',
                'value' => 'NZD',
            ],
            'content8' => [
                'name' => '瑞士法郎',
                'value' => 'CHF',
            ],
            'content9' => [
                'name' => '港币',
                'value' => 'HKD',
            ],
            'content10' => [
                'name' => '新加坡元',
                'value' => 'SGD',
            ],
            'content11' => [
                'name' => '福林',
                'value' => 'HUF',
            ],
        ],
        'nameId' => 'paymentCurrency',
        'inputType' => 'checkbox',
        'class' => 'form-control',
        'width' => 'col-sm-10',
        'checked' => [
            0 => 'CAD',
            1 => 'EUR',
            2 => 'GBP',
            3 => 'JPY',
            4 => 'AUD',
            5 => 'HKD',
        ],
    ],
    'paymentState' => [
        'title' => '支付状态',
        'content' => [
            'radio1' => [
                'name' => '启用',
                'value' => '1',
            ],
            'radio2' => [
                'name' => '禁用',
                'value' => '0',
            ],
        ],
        'nameId' => 'paymentState',
        'inputType' => 'radio',
        'checked' => '0',
    ],
    'paymentSort' => [
        'title' => '支付排序',
        'content' => '255',
        'nameId' => 'paymentSort',
        'inputType' => 'number',
        'class' => 'form-control',
        'width' => 'col-sm-2',
    ],
    'onlinePayment' => [
        'nameId' => 'onlinePayment',
        'inputType' => 'hidden',
        'content' => 'true',
    ],
    'noticeMode' => 'returnNotice',
    'editAction' => 'PayPal',
];
