<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Admin;

use Admin\Controller\AdminController;
use Admin\Controller\AdminGroupController;
use Admin\Controller\CurrencyController;
use Admin\Controller\CustomerSetController;
use Admin\Controller\DeliveryController;
use Admin\Controller\DeliverySetController;
use Admin\Controller\EditorController;
use Admin\Controller\Factory\AdminControllerFactory;
use Admin\Controller\Factory\AdminGroupControllerFactory;
use Admin\Controller\Factory\CurrencyControllerFactory;
use Admin\Controller\Factory\CustomerSetControllerFactory;
use Admin\Controller\Factory\DeliveryControllerFactory;
use Admin\Controller\Factory\DeliverySetControllerFactory;
use Admin\Controller\Factory\EditorControllerFactory;
use Admin\Controller\Factory\HomeControllerFactory;
use Admin\Controller\Factory\IndexControllerFactory;
use Admin\Controller\Factory\MessageNotificationControllerFactory;
use Admin\Controller\Factory\OperLogControllerFactory;
use Admin\Controller\Factory\PaymentControllerFactory;
use Admin\Controller\Factory\PhoneAreaCodeControllerFactory;
use Admin\Controller\Factory\RegionControllerFactory;
use Admin\Controller\Factory\SelfLocationControllerFactory;
use Admin\Controller\Factory\ServiceBindControllerFactory;
use Admin\Controller\Factory\SystemControllerFactory;
use Admin\Controller\Factory\TemplateControllerFactory;
use Admin\Controller\Factory\UpdateControllerFactory;
use Admin\Controller\Factory\UploadSetControllerFactory;
use Admin\Controller\HomeController;
use Admin\Controller\IndexController;
use Admin\Controller\MessageNotificationController;
use Admin\Controller\OperLogController;
use Admin\Controller\PaymentController;
use Admin\Controller\PhoneAreaCodeController;
use Admin\Controller\RegionController;
use Admin\Controller\SelfLocationController;
use Admin\Controller\ServiceBindController;
use Admin\Controller\SystemController;
use Admin\Controller\TemplateController;
use Admin\Controller\UpdateController;
use Admin\Controller\UploadSetController;
use Admin\Data\Config;
use Admin\Event\AdminListener;
use Admin\Event\EmailListener;
use Admin\Event\Factory\AdminListenerFactory;
use Admin\Event\Factory\EmailListenerFactory;
use Admin\Event\Factory\LoongdomServiceListenerFactory;
use Admin\Event\Factory\SmsListenerFactory;
use Admin\Event\LoongdomServiceListener;
use Admin\Event\SmsListener;
use Admin\Plugin\AdminCommonPlugin;
use Admin\Plugin\CreateConfigPlugin;
use Admin\Plugin\DeliveryPlugin;
use Admin\Plugin\Factory\AdminCommonPluginFactory;
use Admin\Plugin\Factory\CreateConfigPluginFactory;
use Admin\Plugin\Factory\DeliveryPluginFactory;
use Admin\Service\AdminUserGroupManager;
use Admin\Service\AdminUserManager;
use Admin\Service\AuthAdapter;
use Admin\Service\AuthManager;
use Admin\Service\CurrencyManager;
use Admin\Service\DeliveryIndividuationManager;
use Admin\Service\DeliveryManager;
use Admin\Service\ExpressPushReceiveManager;
use Admin\Service\Factory\AdminUserGroupManagerFactory;
use Admin\Service\Factory\AdminUserManagerFactory;
use Admin\Service\Factory\AuthAdapterFactory;
use Admin\Service\Factory\AuthenticationServiceFactory;
use Admin\Service\Factory\AuthManagerFactory;
use Admin\Service\Factory\CurrencyManagerFactory;
use Admin\Service\Factory\DeliveryIndividuationManagerFactory;
use Admin\Service\Factory\DeliveryManagerFactory;
use Admin\Service\Factory\ExpressPushReceiveManagerFactory;
use Admin\Service\Factory\OperLogManagerFactory;
use Admin\Service\Factory\PhoneAreaCodeManagerFactory;
use Admin\Service\Factory\PluginManagerFactory;
use Admin\Service\Factory\RegionManagerFactory;
use Admin\Service\Factory\SelfLocationManagerFactory;
use Admin\Service\Factory\SystemManagerFactory;
use Admin\Service\Factory\TemplateManagerFactory;
use Admin\Service\OperLogManager;
use Admin\Service\PhoneAreaCodeManager;
use Admin\Service\PluginManager;
use Admin\Service\RegionManager;
use Admin\Service\SelfLocationManager;
use Admin\Service\SystemManager;
use Admin\Service\TemplateManager;
use Admin\View\Helper\AdminHelper;
use Admin\View\Helper\DateFormatHelper;
use Admin\View\Helper\ShopCurrencyFormatHelper;
use Admin\View\Helper\Factory\AdminHelperFactory;
use Admin\View\Helper\Factory\ShopCurrencyFormatHelperFactory;
use Admin\View\Helper\Factory\HelpUrlFactory;
use Admin\View\Helper\HelpUrl;
use Laminas\Authentication\AuthenticationService;
use Laminas\Router\Http\Literal;
use Laminas\Router\Http\Segment;
use Doctrine\ORM\Mapping\Driver\AnnotationDriver;
use Laminas\ServiceManager\Factory\InvokableFactory;

return [
    'router' => [
        'routes' => [
            'login' => [
                'type' => Segment::class,
                'options' => [
                    'route'    => '/' . Config::ADMIN_PATH . '[/]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'logout' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/' . Config::ADMIN_PATH . '/logout',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'     => 'logout',
                    ],
                ],
            ],

            'home' => [
                'type'    => Literal::class,
                'options' => [
                    'route'    => '/' . Config::ADMIN_PATH . '/home',
                    'defaults' => [
                        'controller' => HomeController::class,
                        'action'     => 'index',
                    ]
                ],
                'may_terminate' => true,
                'child_routes' => [
                    'default' => [
                        'type' => Segment::class,
                        'options' => [
                            'route' => '[/:action]',
                            'constraints' => [
                                'action' => '[a-zA-Z][a-zA-Z0-9_-]+'
                            ],
                            'defaults' => [
                                'action' => 'index'
                            ]
                        ]
                    ]
                ]
            ],

            'admin' => [
                'type'      => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/admin[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => AdminController::class,
                        'action'     => 'index',
                    ]
                ]
            ],

            'admin-group' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/admin-group[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => AdminGroupController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'admin-system' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/admin-system[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => SystemController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'region' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/admin-region[/:action[/:id[/:top-id]]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => RegionController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'currency' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/currency[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => CurrencyController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'message-notification' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/message-notification[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => MessageNotificationController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'delivery-set' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/delivery-set[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => DeliverySetController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'self-location' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/self-location[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => SelfLocationController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'delivery' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/delivery[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => DeliveryController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'template' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/template[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => TemplateController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'update' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/update[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => UpdateController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'phone-area' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/phone-area[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => PhoneAreaCodeController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'payment' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/payment[/:action[/:name]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => PaymentController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'customer-set' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/customer-set[/:action]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => CustomerSetController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'upload-set' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/upload-set[/:action]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => UploadSetController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'service-bind' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/service-bind[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => ServiceBindController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'oper-log' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/admin-log[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => OperLogController::class,
                        'action'    => 'index'
                    ],
                ]
            ],

            'editor' => [
                'type'  => Segment::class,
                'options'   => [
                    'route' => '/' . Config::ADMIN_PATH . '/editor[/:action[/:type[/:id]]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                    'defaults' => [
                        'controller' => EditorController::class,
                        'action'    => 'index'
                    ],
                ]
            ]

        ],
    ],
    'controllers' => [
        'factories' => [
            IndexController::class          => IndexControllerFactory::class,
            HomeController::class           => HomeControllerFactory::class,
            AdminController::class          => AdminControllerFactory::class,
            AdminGroupController::class     => AdminGroupControllerFactory::class,
            OperLogController::class        => OperLogControllerFactory::class,
            CurrencyController::class       => CurrencyControllerFactory::class,
            MessageNotificationController::class => MessageNotificationControllerFactory::class,
            DeliverySetController::class    => DeliverySetControllerFactory::class,
            SelfLocationController::class   => SelfLocationControllerFactory::class,
            DeliveryController::class       => DeliveryControllerFactory::class,
            RegionController::class         => RegionControllerFactory::class,
            PaymentController::class        => PaymentControllerFactory::class,
            PhoneAreaCodeController::class  => PhoneAreaCodeControllerFactory::class,
            UploadSetController::class      => UploadSetControllerFactory::class,
            SystemController::class         => SystemControllerFactory::class,
            TemplateController::class       => TemplateControllerFactory::class,
            CustomerSetController::class    => CustomerSetControllerFactory::class,
            ServiceBindController::class    => ServiceBindControllerFactory::class,
            UpdateController::class         => UpdateControllerFactory::class,
            EditorController::class         => EditorControllerFactory::class
        ],
    ],

    'service_manager' => [
        'abstract_factories' => [

        ],
        'factories' => [
            AdminUserManager::class             => AdminUserManagerFactory::class,
            AuthenticationService::class        => AuthenticationServiceFactory::class,
            AuthManager::class                  => AuthManagerFactory::class,
            AuthAdapter::class                  => AuthAdapterFactory::class,
            AdminUserGroupManager::class        => AdminUserGroupManagerFactory::class,
            OperLogManager::class               => OperLogManagerFactory::class,
            RegionManager::class                => RegionManagerFactory::class,
            SystemManager::class                => SystemManagerFactory::class,
            CurrencyManager::class              => CurrencyManagerFactory::class,
            PhoneAreaCodeManager::class         => PhoneAreaCodeManagerFactory::class,
            SelfLocationManager::class          => SelfLocationManagerFactory::class,
            DeliveryManager::class              => DeliveryManagerFactory::class,
            DeliveryIndividuationManager::class => DeliveryIndividuationManagerFactory::class,
            TemplateManager::class              => TemplateManagerFactory::class,
            PluginManager::class                => PluginManagerFactory::class,
            ExpressPushReceiveManager::class    => ExpressPushReceiveManagerFactory::class,

            AdminListener::class    => AdminListenerFactory::class,
            EmailListener::class    => EmailListenerFactory::class,
            SmsListener::class      => SmsListenerFactory::class,
            LoongdomServiceListener::class  => LoongdomServiceListenerFactory::class
        ],
        'aliases' => [
            
        ]
    ],

    'listeners' => [
        AdminListener::class,
        EmailListener::class,
        SmsListener::class,
        LoongdomServiceListener::class
    ],

    'permission_filter' => include __DIR__ . '/permission.php',

    'controller_plugins' => [
        'factories' => [
            AdminCommonPlugin::class    => AdminCommonPluginFactory::class,
            DeliveryPlugin::class       => DeliveryPluginFactory::class,
            CreateConfigPlugin::class   => CreateConfigPluginFactory::class
        ],
        'aliases' => [
            'adminCommon'   => AdminCommonPlugin::class,
            'deliveryPlugin'=> DeliveryPlugin::class,
            'createConfig'  => CreateConfigPlugin::class

        ]
    ],

    'session_containers' => [
        'I18nSessionContainer'
    ],

    'view_helpers' => [
        'factories' => [
            HelpUrl::class                  => HelpUrlFactory::class,
            ShopCurrencyFormatHelper::class => ShopCurrencyFormatHelperFactory::class,
            AdminHelper::class              => AdminHelperFactory::class,
            DateFormatHelper::class         => InvokableFactory::class
        ],
        'aliases' => [
            'HelpUrl'               => HelpUrl::class,
            'shopCurrencyFormat'    => ShopCurrencyFormatHelper::class,
            'adminHelper'           => AdminHelper::class,
            'shopDateFormat'        => DateFormatHelper::class
        ],
    ],

    'translator' => [
        'translation_file_patterns' => [
            [
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../data/language',
                'pattern' => '%s.mo'
            ]
        ]
    ],

    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions'       => true,
        'doctype'                  => 'HTML5',
        'not_found_template'       => 'error/404',
        'exception_template'       => 'error/index',
        'template_map' => [
            'layout/layout'         => __DIR__ . '/../view/layout/layout.phtml',
            'layout/left'           => __DIR__ . '/../view/layout/left-menu.phtml',
            'layout/header'         => __DIR__ . '/../view/layout/header.phtml',
            'layout/footer'         => __DIR__ . '/../view/layout/footer.phtml',
            'layout/messages'       => __DIR__ . '/../view/partial/messages.phtml',
            'layout/ajaxPage'       => __DIR__ . '/../view/partial/ajaxPaginator.phtml',
            'layout/page'           => __DIR__ . '/../view/partial/paginator.phtml',
            'layout/breadcrumb'     => __DIR__ . '/../view/partial/breadcrumb.phtml',
            'error/404'             => __DIR__ . '/../view/error/404.phtml',
            'error/index'           => __DIR__ . '/../view/error/index.phtml',
            'common/editor'         => __DIR__ . '/../view/partial/editor.phtml'
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ]
    ],

    'doctrine' => [
        'driver' => [
            __NAMESPACE__ . '_driver' => [
                'class' => AnnotationDriver::class,
                'cache' => 'array',
                'paths' => [__DIR__ . '/../src/Entity']
            ],
            'orm_default' => [
                'drivers' => [
                    __NAMESPACE__ . '\Entity' => __NAMESPACE__ . '_driver'
                ]
            ]
        ]
    ],
];
